<?php include "common-header.php"; ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            
            <!-- Proxy Service Status Notification -->
            <div id="proxy-notification-area" class="mb-3">
                <?php 
                // Get smart service status
                $services_status = $this->get_proxy_services_status();
                
                if ($services_status['show_setup_notification']) {
                ?>
                    <div class="card border-warning shadow-sm ams-common-card-fix mb-3">
                        <div class="card-body p-4">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-start">
                                        <div class="me-3">
                                            <div class="bg-warning bg-opacity-10 rounded-circle p-3">
                                                <i class="bi bi-shield-exclamation text-warning fs-3"></i>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="text-warning mb-2 fw-bold">
                                                <i class="bi bi-cloud-arrow-down me-2"></i>
                                                <?php esc_html_e('Proxy Service Required', 'ams-wc-amazon'); ?>
                                            </h5>
                                            <p class="text-muted mb-2">
                                                <?php esc_html_e('For reliable URL-based product importing, we recommend setting up a proxy service to prevent Amazon from blocking your requests.', 'ams-wc-amazon'); ?>
                                            </p>
                                            <div class="d-flex flex-wrap gap-2 mb-2">
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('Decodo Service', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('ScraperAPI Service', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('ScrapingAnt Service', 'ams-wc-amazon'); ?>
                                                </span>
                                            </div>
                                            <small class="text-muted">
                                                <i class="bi bi-info-circle me-1"></i>
                                                <?php esc_html_e('Choose one of the proxy services above for better success rates', 'ams-wc-amazon'); ?>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                    <div class="d-flex flex-column gap-2">
                                        <a href="<?php echo admin_url('admin.php?page=wc-product-setting-page&tab=pills-general-tab'); ?>" 
                                           class="btn btn-warning btn-lg shadow-sm">
                                            <i class="bi bi-gear-fill me-2"></i>
                                            <?php esc_html_e('Configure Proxy', 'ams-wc-amazon'); ?>
                                        </a>
                                        <small class="text-muted text-center">
                                            <?php esc_html_e('Recommended for reliable scraping', 'ams-wc-amazon'); ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php 
                }
                ?>
            </div>

            <!-- Main Import Card -->
            <div class="card shadow-sm ams-common-card-fix">
                <div class="card-header bg-light border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-link text-primary me-2"></i>
                            <?php esc_html_e('Product Import by URL', 'ams-wc-amazon'); ?>
                            <?php 
                            // Get detailed service status for smart badges
                            $services_status = $this->get_proxy_services_status();
                            foreach ($services_status['services'] as $service) {
                                // Create detailed tooltip with symbol explanations
                                $tooltip = $service['title'];
                                if ($service['status'] === 'enabled') {
                                    $tooltip .= ' | Symbols: ';
                                    if (strpos($service['symbols'], '↓') !== false) {
                                        $tooltip .= '↓=Import ';
                                    }
                                    if (strpos($service['symbols'], '↻') !== false) {
                                        $tooltip .= '↻=Update ';
                                    }
                                    if ($service['symbols'] === '○') {
                                        $tooltip .= '○=Configured but no operations';
                                    }
                                } else {
                                    $tooltip .= ' | ✕=Disabled or not configured';
                                }
                            ?>
                                <span class="badge <?php echo esc_attr($service['badge_class']); ?> text-white ms-1" 
                                      title="<?php echo esc_attr($tooltip); ?>"
                                      data-bs-toggle="tooltip" 
                                      data-bs-placement="bottom">
                                    <i class="<?php echo esc_attr($service['icon']); ?> me-1" 
                                       alt="<?php echo esc_attr($service['status'] === 'enabled' ? 'Service enabled' : 'Service disabled'); ?>"></i>
                                    <?php echo esc_html($service['name']); ?>
                                    <small class="ms-1" 
                                           title="<?php 
                                           if ($service['status'] === 'enabled') {
                                               $symbol_tooltip = '';
                                               if (strpos($service['symbols'], '↓') !== false) {
                                                   $symbol_tooltip .= 'Import enabled ';
                                               }
                                               if (strpos($service['symbols'], '↻') !== false) {
                                                   $symbol_tooltip .= 'Update enabled ';
                                               }
                                               if ($service['symbols'] === '○') {
                                                   $symbol_tooltip = 'Configured but no operations enabled';
                                               }
                                               echo esc_attr(trim($symbol_tooltip));
                                           } else {
                                               echo esc_attr('Service disabled or not configured');
                                           }
                                           ?>">
                                        <?php echo esc_html($service['symbols']); ?>
                                    </small>
                                </span>
                            <?php } ?>
                        </h5>
                        <div class="d-flex gap-2 align-items-center">
                            <span class="badge bg-primary" id="url-count">0 URLs</span>
                            <button type="button" class="btn btn-outline-info btn-sm" data-bs-toggle="modal" data-bs-target="#helpModal">
                                <i class="bi bi-question-circle me-1"></i><?php esc_html_e('Help', 'ams-wc-amazon'); ?>
                            </button>
                            <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#sampleModal">
                                <i class="bi bi-eye me-1"></i><?php esc_html_e('Sample URLs', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <!-- Import Form Section -->
                    <div class="p-4 border-bottom bg-light bg-opacity-25">
                        <div class="row">
                            <!-- Left Column: URL Input -->
                            <div class="col-lg-5">
                            <div class="card h-100 shadow-sm border-0">
                                <div class="card-header bg-white border-bottom">
                                    <h6 class="mb-0 fw-semibold text-dark">
                                        <i class="bi bi-pencil text-secondary me-2"></i>
                                        <?php esc_html_e('Product URLs', 'ams-wc-amazon'); ?>
                                    </h6>
                                </div>
                                <div class="card-body d-flex flex-column">
                    <div id="validation-error-message" class="alert alert-danger d-none">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        <span id="error-text"></span>
                    </div>
                    
                    <?php wp_nonce_field('ams_import_product_url'); ?>
                    
                    <div class="mb-3 position-relative flex-grow-1">
                        <div class="input-group">
                            <span class="input-group-text bg-light border-end-0">
                                <i class="bi bi-link text-muted"></i>
                            </span>
                            <textarea 
                                class="form-control border-start-0 h-100" 
                                id="wca-product-all-url" 
                                rows="8" 
                                placeholder="https://www.amazon.com/dp/B01H0EPVBQ&#10;https://www.amazon.com/dp/B07L9ZWPNC&#10;https://www.amazon.com/dp/B08N5WRWNW"
                                style="resize: none;"
                            ></textarea>
                        </div>
                        
                        <!-- URL Processing Status -->
                        <div id="url-status-container" class="mt-3 d-none">
                            <!-- Sticky Progress Header -->
                            <div class="progress-header bg-light border rounded p-3 mb-3 position-sticky" style="top: 10px; z-index: 100;">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <h6 class="mb-0 fw-bold text-dark">
                                        <i class="bi bi-activity me-2 text-primary"></i>
                                        <?php esc_html_e('Import Progress', 'ams-wc-amazon'); ?>
                                    </h6>
                                    <div class="d-flex gap-1">
                                        <span class="badge bg-success">
                                            <i class="bi bi-check-circle me-1"></i>
                                            <span id="success-count-mini">0</span>
                                        </span>
                                        <span class="badge bg-danger">
                                            <i class="bi bi-x-circle me-1"></i>
                                            <span id="error-count-mini">0</span>
                                        </span>
                                        <span class="badge bg-warning text-dark">
                                            <i class="bi bi-clock me-1"></i>
                                            <span id="pending-count-mini">0</span>
                                        </span>
                                    </div>
                                </div>
                                <div class="progress" style="height: 10px;">
                                    <div id="import-progress-bar-mini" class="progress-bar bg-primary" role="progressbar" style="width: 0%"></div>
                                </div>
                            </div>
                            
                            <!-- Collapsible URL Details -->
                            <div class="card">
                                <div class="card-header bg-light py-2">
                                    <button class="btn btn-link btn-sm text-decoration-none p-0 fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#url-details" aria-expanded="false">
                                        <i class="bi bi-chevron-down me-1" id="collapse-icon"></i>
                                        <?php esc_html_e('URL Details', 'ams-wc-amazon'); ?>
                                        <small class="text-muted ms-2"><?php esc_html_e('(Click to expand/collapse)', 'ams-wc-amazon'); ?></small>
                                    </button>
                                </div>
                                <div class="collapse" id="url-details">
                                    <div class="card-body p-0">
                                        <div class="url-status-list" style="max-height: 300px; overflow-y: auto;">
                                            <!-- URLs will be dynamically added here -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer bg-light border-0">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <div class="d-flex gap-2 align-items-center flex-wrap">
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-outline-secondary btn-sm" id="clear-urls">
                                        <i class="bi bi-trash me-1"></i>
                                        <?php esc_html_e('Clear', 'ams-wc-amazon'); ?>
                                    </button>
                                    <button type="button" class="btn btn-outline-info btn-sm" id="validate-urls">
                                        <i class="bi bi-check-circle me-1"></i>
                                        <?php esc_html_e('Validate', 'ams-wc-amazon'); ?>
                                    </button>
                                </div>
                                
                                <div class="btn-group" role="group">
                                    <button type="button" class="btn btn-outline-warning btn-sm" id="test-mode-btn" onclick="toggleTestMode()">
                                        <i class="bi bi-lightning me-1"></i>
                                        <?php esc_html_e('Test Mode', 'ams-wc-amazon'); ?>
                                    </button>
                                </div>
                                
                                <div class="d-flex align-items-center gap-1">
                                    <input type="number" id="test-url-count" class="form-control form-control-sm" style="width: 60px;" value="50" min="1" max="1000" title="<?php esc_attr_e('Number of test URLs to generate (auto-enables test mode)', 'ams-wc-amazon'); ?>">
                                    <button type="button" class="btn btn-success btn-sm" onclick="generateTestUrls()" title="<?php esc_attr_e('Generate test URLs and auto-enable test mode for fast simulation', 'ams-wc-amazon'); ?>">
                                        <i class="bi bi-lightning-fill me-1"></i>
                                        <span class="d-none d-lg-inline"><?php esc_html_e('Quick Test', 'ams-wc-amazon'); ?></span>
                                        <span class="d-lg-none"><?php esc_html_e('Test', 'ams-wc-amazon'); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4 text-end">
                            <div class="d-flex gap-1 align-items-center justify-content-end flex-wrap">
                                <button id="download_log" type="button" class="btn btn-outline-success btn-sm d-none" onclick="downloadLog();">
                                    <i class="bi bi-download me-1"></i>
                                    <span class="d-none d-lg-inline"><?php esc_html_e('Download Log', 'ams-wc-amazon'); ?></span>
                                    <span class="d-lg-none"><?php esc_html_e('Log', 'ams-wc-amazon'); ?></span>
                                </button>
                                <button id="prod_cron" type="button" class="btn btn-primary btn-sm" onclick="product_import();">
                                    <i class="bi bi-file-earmark-arrow-down me-1"></i>
                                    <span class="d-none d-lg-inline"><?php esc_html_e('Import Products', 'ams-wc-amazon'); ?></span>
                                    <span class="d-lg-none"><?php esc_html_e('Import', 'ams-wc-amazon'); ?></span>
                                </button>
                                <button id="pause_import" type="button" class="btn btn-warning btn-sm d-none" onclick="pauseImport();">
                                    <i class="bi bi-pause me-1"></i>
                                    <?php esc_html_e('Pause', 'ams-wc-amazon'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                </div>
            </div>
            
            <!-- Right Column: Import Console -->
            <div class="col-lg-7">
            <div class="card h-100 border-0 shadow-sm">
                <div class="card-header bg-dark text-white border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-terminal me-2 text-warning"></i>
                            <h5 class="mb-0 text-white"><?php esc_html_e('Import Console', 'ams-wc-amazon'); ?></h5>
                        </div>
                        <div class="console-controls">
                            <button type="button" class="btn btn-outline-light btn-sm" id="clear-console">
                                <i class="bi bi-trash me-1"></i>
                                <?php esc_html_e('Clear', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body bg-dark p-0 d-flex flex-column">
                    <div id="console-window" class="text-light p-3 flex-grow-1 tap-console-window" style="height: 300px; overflow-y: auto;">
                        <div id="console-output" class="wca-amazon-product-by-url tap-console-output">
                            <span class="text-muted"><i class="bi bi-info-circle me-2 text-info"></i> <?php esc_html_e('Console ready. Paste URLs and click Import Products to begin.', 'ams-wc-amazon'); ?></span>
                        </div>
                    </div>
                    <div class="bg-dark" style="height: 6px;">
                        <div id="import-progress-bar" class="progress-bar bg-success" role="progressbar" style="width: 0%; transition: width 0.3s ease;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
                <div class="card-footer bg-dark text-light border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-clock me-2 text-muted"></i>
                            <span id="import-status-message"><?php esc_html_e('Ready to import', 'ams-wc-amazon'); ?></span>
                        </div>
                        <div class="import-stats">
                            <span id="import-product-count" class="badge bg-light text-dark">0 / 0 <?php esc_html_e('products', 'ams-wc-amazon'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
    </div>
</div>
</div>

<!-- Help Modal -->
<div class="modal fade" id="helpModal" tabindex="-1" aria-labelledby="helpModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="bi bi-question-circle text-white"></i>
                    </div>
                    <div>
                        <h5 class="modal-title text-white fs-4 mb-1" id="helpModalLabel">
                            <?php esc_html_e('How to Import Products by URL', 'ams-wc-amazon'); ?>
                        </h5>
                        <p class="text-white-50 mb-0 small">
                            <?php esc_html_e('Learn how to properly format and import Amazon product URLs', 'ams-wc-amazon'); ?>
                        </p>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <div class="row">
                    <div class="col-md-6">
                        <div class="help-section mb-4">
                            <h6 class="text-primary fw-bold mb-3">
                                <i class="bi bi-check-circle me-2"></i>
                                <?php esc_html_e('Supported URL Formats', 'ams-wc-amazon'); ?>
                            </h6>
                            <div class="url-examples">
                                <div class="mb-2">
                                    <code class="bg-light text-dark p-2 rounded d-block">https://www.amazon.com/dp/B01H0EPVBQ</code>
                                </div>
                                <div class="mb-2">
                                    <code class="bg-light text-dark p-2 rounded d-block">https://www.amazon.co.uk/dp/B07L9ZWPNC</code>
                                </div>
                                <div class="mb-2">
                                    <code class="bg-light text-dark p-2 rounded d-block">https://www.amazon.de/dp/B08N5WRWNW</code>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="help-section mb-4">
                            <h6 class="text-primary fw-bold mb-3">
                                <i class="bi bi-lightbulb me-2"></i>
                                <?php esc_html_e('Tips & Best Practices', 'ams-wc-amazon'); ?>
                            </h6>
                            <ul class="list-unstyled">
                                <li class="mb-2 text-dark">
                                    <i class="bi bi-arrow-right text-success me-2"></i>
                                    <?php esc_html_e('Paste multiple URLs separated by new lines', 'ams-wc-amazon'); ?>
                                </li>
                                <li class="mb-2 text-dark">
                                    <i class="bi bi-arrow-right text-success me-2"></i>
                                    <?php esc_html_e('URLs are automatically formatted and deduplicated', 'ams-wc-amazon'); ?>
                                </li>
                                <li class="mb-2 text-dark">
                                    <i class="bi bi-arrow-right text-success me-2"></i>
                                    <?php esc_html_e('You can import up to 50 products at once', 'ams-wc-amazon'); ?>
                                </li>
                                <li class="mb-2 text-dark">
                                    <i class="bi bi-arrow-right text-success me-2"></i>
                                    <?php esc_html_e('Use the Validate URLs button to check format', 'ams-wc-amazon'); ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x me-2"></i>
                    <?php esc_html_e('Close', 'ams-wc-amazon'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Sample URLs Modal -->
<div class="modal fade" id="sampleModal" tabindex="-1" aria-labelledby="sampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="bi bi-eye text-white fs-4"></i>
                    </div>
                    <div>
                        <h5 class="modal-title text-white fs-4 mb-1" id="sampleModalLabel">
                            <?php esc_html_e('Sample Amazon URLs', 'ams-wc-amazon'); ?>
                        </h5>
                        <p class="text-white-50 mb-0 small">
                            <?php esc_html_e('Test URLs to try the import functionality', 'ams-wc-amazon'); ?>
                        </p>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4">
                <div class="sample-section">
                    <p class="text-dark mb-3"><?php esc_html_e('Copy these sample URLs to test the import functionality:', 'ams-wc-amazon'); ?></p>
                    <div class="sample-urls-container">
                        <div class="mb-2">
                            <code class="bg-light text-dark p-2 rounded d-block">https://www.amazon.com/dp/B01H0EPVBQ</code>
                        </div>
                        <div class="mb-2">
                            <code class="bg-light text-dark p-2 rounded d-block">https://www.amazon.com/dp/B07L9ZWPNC</code>
                        </div>
                        <div class="mb-2">
                            <code class="bg-light text-dark p-2 rounded d-block">https://www.amazon.com/dp/B08N5WRWNW</code>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x me-2"></i>
                    <?php esc_html_e('Close', 'ams-wc-amazon'); ?>
                </button>
                <button type="button" class="btn btn-primary" id="copy-sample-urls">
                    <i class="bi bi-clipboard me-2"></i>
                    <?php esc_html_e('Copy to Clipboard', 'ams-wc-amazon'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<script>
// Initialize Bootstrap tooltips for proxy service badges
jQuery(document).ready(function($) {
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>

<?php include "common-footer.php"; ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const textarea = document.getElementById('wca-product-all-url');
        const urlCount = document.getElementById('url-count');
        const clearButton = document.getElementById('clear-urls');
        const validateButton = document.getElementById('validate-urls');
        const clearConsoleButton = document.getElementById('clear-console');
        const copySampleButton = document.getElementById('copy-sample-urls');

        // Enhanced URL formatting and validation
        textarea.addEventListener('paste', function(e) {
            e.preventDefault();
            let pastedText = (e.clipboardData || window.clipboardData).getData('text');
            let formattedText = formatUrls(pastedText);
            
            let startPos = this.selectionStart;
            let endPos = this.selectionEnd;
            this.value = this.value.substring(0, startPos) + formattedText + this.value.substring(endPos);
            
            this.selectionStart = this.selectionEnd = startPos + formattedText.length;
            updateUrlCount();
            validateUrls();
        });

        textarea.addEventListener('blur', function() {
            this.value = formatUrls(this.value);
            updateUrlCount();
            validateUrls();
        });

        textarea.addEventListener('input', function() {
            updateUrlCount();
            validateUrls();
        });

        clearButton.addEventListener('click', function() {
            textarea.value = '';
            updateUrlCount();
            hideValidationError();
            hideUrlStatus();
        });

        validateButton.addEventListener('click', function() {
            validateUrls();
        });

        clearConsoleButton.addEventListener('click', function() {
            jQuery('#console-output').empty();
            jQuery('#console-output').html(`
                <div class="text-light">
                    <i class="bi bi-info-circle me-2 text-info"></i>
                    <span class="text-light"><?php esc_html_e('Console cleared.', 'ams-wc-amazon'); ?></span>
                </div>
            `);
        });

        copySampleButton.addEventListener('click', function() {
            const sampleUrls = `https://www.amazon.com/dp/B01H0EPVBQ
https://www.amazon.com/dp/B07L9ZWPNC
https://www.amazon.com/dp/B08N5WRWNW`;
            
            navigator.clipboard.writeText(sampleUrls).then(function() {
                // Show success feedback
                const originalText = copySampleButton.innerHTML;
                copySampleButton.innerHTML = '<i class="bi bi-check me-2"></i><?php esc_html_e('Copied!', 'ams-wc-amazon'); ?>';
                copySampleButton.classList.remove('btn-primary');
                copySampleButton.classList.add('btn-success');
                
                setTimeout(() => {
                    copySampleButton.innerHTML = originalText;
                    copySampleButton.classList.remove('btn-success');
                    copySampleButton.classList.add('btn-primary');
                }, 2000);
            });
        });

        // Handle collapse icon rotation
        const urlDetails = document.getElementById('url-details');
        if (urlDetails) {
            urlDetails.addEventListener('show.bs.collapse', function() {
                const icon = document.getElementById('collapse-icon');
                if (icon) {
                    icon.classList.remove('bi-chevron-down');
                    icon.classList.add('bi-chevron-up');
                }
            });
            
            urlDetails.addEventListener('hide.bs.collapse', function() {
                const icon = document.getElementById('collapse-icon');
                if (icon) {
                    icon.classList.remove('bi-chevron-up');
                    icon.classList.add('bi-chevron-down');
                }
            });
        }

        function formatUrls(text) {
            let urls = text.split(/[\n,\s]+/);
            let uniqueUrls = new Set();
            
            urls.forEach(url => {
                url = url.trim();
                if (url) {
                    let amazonMatch = url.match(/https?:\/\/(www\.)?amazon\.([a-z.]{2,6}).*?\/dp\/([A-Z0-9]{10})/i);
                    if (amazonMatch) {
                        let fullDomain = amazonMatch[2];
                        let asin = amazonMatch[3];
                        uniqueUrls.add(`https://www.amazon.${fullDomain}/dp/${asin}`);
                    } else if (url.startsWith('http')) {
                        uniqueUrls.add(url);
                    }
                }
            });
            return Array.from(uniqueUrls).join('\n');
        }

        function updateUrlCount() {
            let count = textarea.value.split('\n').filter(url => url.trim()).length;
            urlCount.textContent = `${count} URL${count !== 1 ? 's' : ''}`;
            
            // Update button state
            const importButton = document.getElementById('prod_cron');
            if (count > 0) {
                importButton.classList.remove('btn-secondary');
                importButton.classList.add('btn-primary');
            } else {
                importButton.classList.remove('btn-primary');
                importButton.classList.add('btn-secondary');
            }
        }

        function validateUrls() {
            const urls = textarea.value.split('\n').filter(url => url.trim());
            let validUrls = 0;
            let invalidUrls = 0;
            
            urls.forEach(url => {
                if (url.match(/https?:\/\/(www\.)?amazon\.([a-z.]{2,6}).*?\/dp\/([A-Z0-9]{10})/i)) {
                    validUrls++;
                } else {
                    invalidUrls++;
                }
            });
            
            if (invalidUrls > 0) {
                showValidationError(`${invalidUrls} invalid URL${invalidUrls !== 1 ? 's' : ''} detected. Please check the format.`);
            } else if (validUrls > 0) {
                hideValidationError();
                showSuccessMessage(`${validUrls} valid URL${validUrls !== 1 ? 's' : ''} ready for import.`);
            }
        }

        function showValidationError(message) {
            const errorDiv = document.getElementById('validation-error-message');
            const errorText = document.getElementById('error-text');
            if (errorDiv && errorText) {
                errorText.textContent = message;
                errorDiv.classList.remove('d-none');
            }
        }

        function hideValidationError() {
            const errorDiv = document.getElementById('validation-error-message');
            if (errorDiv) {
                errorDiv.classList.add('d-none');
            }
        }

        function showSuccessMessage(message) {
            // You can implement a success message system here
        }

        function hideUrlStatus() {
            const statusContainer = document.getElementById('url-status-container');
            if (statusContainer) {
                statusContainer.classList.add('d-none');
            }
        }

        // Make functions globally accessible
        window.updateUrlCount = updateUrlCount;
        window.validateUrls = validateUrls;

        // Initial URL count update
        updateUrlCount();
    });
</script>

<script type="text/javascript">
    var cronIndex = 0;
    var count = 0;
    var idArr = [];
    var total_products = 0;
    var isImporting = false;
    var isPaused = false;
    var importStartTimes = {};
    var timerIntervals = {};
    var currentUrls = [];
    var currentIndex = 0;
    var isTestMode = false;
    var importLog = [];
    var importStartTime = null;
    var processedUrls = new Set(); // Track which URLs have been processed

    function product_import() {
        const textarea = document.getElementById('wca-product-all-url');
        const urls = textarea.value.split('\n').filter(url => url.trim());
        const totalUrls = urls.length;
        
        if (totalUrls === 0) {
            updateConsole('No URLs to import', 'text-warning');
            return;
        }

        // Smart batch processing for large imports
        if (totalUrls > 1000) {
            updateConsole('Maximum 1000 URLs allowed per import. Please reduce the number of URLs.', 'text-danger');
            return;
        }
        
        if (totalUrls > 100) {
            const estimatedTime = isTestMode ? 
                Math.ceil(totalUrls * 0.7 / 60) : // Test mode: ~0.7 seconds per URL
                Math.ceil(totalUrls * 5 / 60);    // Real mode: ~5 seconds per URL
            
            const modeText = isTestMode ? ' (TEST MODE - simulated)' : '';
            
            if (!confirm(`You are importing ${totalUrls} URLs${modeText}. This will take approximately ${estimatedTime} minutes and will process in small batches to prevent server overload. Continue?`)) {
                return;
            }
            
            const processingText = isTestMode ? 
                `🧪 Large TEST import detected (${totalUrls} URLs). Simulating imports...` :
                `⚠️ Large import detected (${totalUrls} URLs). Processing in safe batches...`;
            updateConsole(processingText, 'text-warning');
        }

        // Initialize import log and tracking
        importLog = [];
        importStartTime = new Date();
        processedUrls = new Set(); // Reset processed URLs tracker
        
        // Add header to log
        importLog.push('='.repeat(80));
        importLog.push(`AMS Amazon Product Import Log`);
        importLog.push(`Started: ${importStartTime.toLocaleString()}`);
        importLog.push(`Mode: ${isTestMode ? 'TEST MODE (Simulated)' : 'LIVE IMPORT'}`);
        importLog.push(`Total URLs: ${totalUrls}`);
        importLog.push('='.repeat(80));
        importLog.push('');

        // Clear the console
        jQuery('#console-output').empty();

        updateConsole('🚀 Initializing import process...', 'text-info');
        jQuery('#prod_cron').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Importing...').prop('disabled', true);
        jQuery('#download_log').addClass('d-none'); // Hide download button during import
        jQuery('#import-status-message').text('Import in progress');
        jQuery('#wca-product-all-url').prop('disabled', true);
        jQuery('#clear-urls').prop('disabled', true).addClass('opacity-50');
        updateProgress(0);
        updateProductCount(0, totalUrls);

        const statusContainer = document.getElementById('url-status-container');
        if (statusContainer) {
            // Reset counters (mini counters only)
            const successCountMini = document.getElementById('success-count-mini');
            const errorCountMini = document.getElementById('error-count-mini');
            const pendingCountMini = document.getElementById('pending-count-mini');
            
            if (successCountMini) successCountMini.textContent = '0';
            if (errorCountMini) errorCountMini.textContent = '0';
            if (pendingCountMini) pendingCountMini.textContent = totalUrls;
            
            // Clear and populate URL list
            const urlList = statusContainer.querySelector('.url-status-list');
            if (urlList) {
                urlList.innerHTML = '';
                urls.forEach((url, index) => {
                    urlList.innerHTML += `
                        <div id="url-status-${index}" class="url-status-item border-bottom p-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center flex-grow-1">
                                    <span class="status-indicator me-2">⚪</span>
                                    <span class="url-text text-truncate flex-grow-1 small">${url}</span>
                                </div>
                                <div class="d-flex align-items-center">
                                    <a href="${url}" target="_blank" class="btn btn-sm btn-outline-secondary me-2" title="Open in new tab">
                                        <i class="bi bi-box-arrow-up-right"></i>
                                    </a>
                                    <span class="import-time text-muted small"></span>
                                </div>
                            </div>
                        </div>
                    `;
                });
            }
            
            statusContainer.classList.remove('d-none');
        }
        
        isImporting = true;
        isPaused = false;
        currentUrls = urls;
        currentIndex = 0;
        
        // Show pause button for large imports
        if (totalUrls > 50) {
            jQuery('#pause_import').removeClass('d-none');
        }
        
        processUrls(urls, 0, totalUrls);
    }

    function updateImportButtonText() {
        const importBtn = document.getElementById('prod_cron');
        if (importBtn) {
            if (isTestMode) {
                importBtn.innerHTML = '<i class="bi bi-lightning-fill me-1"></i><span class="d-none d-lg-inline"><?php esc_html_e('Test Import (Fast)', 'ams-wc-amazon'); ?></span><span class="d-lg-none"><?php esc_html_e('Test', 'ams-wc-amazon'); ?></span>';
                importBtn.classList.remove('btn-primary');
                importBtn.classList.add('btn-warning');
            } else {
                importBtn.innerHTML = '<i class="bi bi-file-earmark-arrow-down me-1"></i><span class="d-none d-lg-inline"><?php esc_html_e('Import Products', 'ams-wc-amazon'); ?></span><span class="d-lg-none"><?php esc_html_e('Import', 'ams-wc-amazon'); ?></span>';
                importBtn.classList.remove('btn-warning');
                importBtn.classList.add('btn-primary');
            }
        }
    }

    function toggleTestMode() {
        isTestMode = !isTestMode;
        const testBtn = document.getElementById('test-mode-btn');
        
        if (isTestMode) {
            testBtn.classList.remove('btn-outline-warning');
            testBtn.classList.add('btn-warning');
            testBtn.innerHTML = '<i class="bi bi-lightning-fill me-2"></i><?php esc_html_e('Test Mode ON', 'ams-wc-amazon'); ?>';
            updateConsole('🧪 Test Mode ENABLED - Imports will be simulated (fast)', 'text-warning fw-bold');
        } else {
            testBtn.classList.remove('btn-warning');
            testBtn.classList.add('btn-outline-warning');
            testBtn.innerHTML = '<i class="bi bi-lightning me-2"></i><?php esc_html_e('Test Mode', 'ams-wc-amazon'); ?>';
            updateConsole('🔄 Test Mode DISABLED - Real imports will be performed', 'text-info');
        }
        updateImportButtonText();
    }

    function generateTestUrls() {
        const countInput = document.getElementById('test-url-count');
        const count = parseInt(countInput?.value || 50);
        
        // Validate count
        if (count < 1 || count > 1000) {
            updateConsole(`❌ Please enter a number between 1 and 1000`, 'text-danger');
            return;
        }
        
        // Automatically enable test mode when generating test URLs
        if (!isTestMode) {
            toggleTestMode();
        }
        
        const testUrls = [];
        for (let i = 1; i <= count; i++) {
            testUrls.push(`https://www.amazon.com/dp/TEST${i.toString().padStart(10, '0')}`);
        }
        document.getElementById('wca-product-all-url').value = testUrls.join('\n');
        updateUrlCount();
        validateUrls();
        updateImportButtonText();
        updateConsole(`📝 Generated ${count} test URLs - Test Mode automatically enabled`, 'text-success');
        updateConsole(`🧪 Ready to import in TEST MODE (simulated, fast processing)`, 'text-warning');
    }

    function pauseImport() {
        isPaused = true;
        updateConsole('⏸️ Import paused by user. Click Resume to continue.', 'text-warning');
        jQuery('#pause_import').html('<i class="bi bi-play me-2"></i><?php esc_html_e('Resume', 'ams-wc-amazon'); ?>').attr('onclick', 'resumeImport()');
        jQuery('#import-status-message').text('Import paused');
    }
    
    function resumeImport() {
        isPaused = false;
        updateConsole('▶️ Import resumed...', 'text-info');
        jQuery('#pause_import').html('<i class="bi bi-pause me-2"></i><?php esc_html_e('Pause', 'ams-wc-amazon'); ?>').attr('onclick', 'pauseImport()');
        jQuery('#import-status-message').text('Import in progress');
        
        // Resume from current index - duplicate prevention will handle already processed URLs
        processUrls(currentUrls, currentIndex, currentUrls.length);
    }

    function processUrls(urls, index, total) {
        currentIndex = index;
        
        if (isPaused) {
            return; // Stop processing if paused
        }
        
        if (index >= total) {
            finishImport();
            return;
        }

        const url = urls[index];
        
        // Skip if this URL has already been processed (prevents duplicates on pause/resume)
        if (processedUrls.has(url)) {
            updateConsole(`⏭️ Skipping already processed URL (${index + 1}/${total}): ${url}`, 'text-info');
            // Move to next URL
            setTimeout(() => {
                if (!isPaused) {
                    processUrls(urls, index + 1, total);
                }
            }, 100);
            return;
        }
        updateConsole(`📦 Processing (${index + 1}/${total}): ${url}`, 'text-warning');
        updateUrlStatus(index, 'processing');
        importStartTimes[index] = Date.now();
        startTimer(index);

        // Calculate delay based on batch size to prevent server overload
        const batchDelay = total > 100 ? 2000 : (total > 50 ? 1000 : 500);
        const shouldDelay = index > 0 && (index % 10 === 0); // Every 10th request
        
        if (shouldDelay && total > 50) {
            updateConsole(`⏸️ Cooling down for ${batchDelay/1000}s to prevent server overload...`, 'text-info');
        }

        const executeRequest = () => {
            if (isTestMode) {
                // Simulate import in test mode (fast)
                const simulateDelay = Math.random() * 1000 + 500; // 0.5-1.5 seconds
                const willSucceed = Math.random() > 0.1; // 90% success rate
                
                setTimeout(() => {
                    stopTimer(index);
                    const importTime = ((Date.now() - importStartTimes[index]) / 1000).toFixed(2);
                    
                    // Mark URL as processed
                    processedUrls.add(url);
                    
                    if (willSucceed) {
                        const testResponse = `Test Product ${index + 1} imported successfully (simulated)`;
                        updateConsole(`✅ Success (${index + 1}/${total}): ${testResponse}`, 'text-success');
                        updateUrlStatus(index, 'success', importTime);
                        updateStatusCounters('success');
                        
                        // Add to log
                        importLog.push(`[${new Date().toLocaleTimeString()}] SUCCESS: ${url}`);
                        importLog.push(`  Response: ${testResponse}`);
                        importLog.push(`  Time: ${importTime}s`);
                        importLog.push(`  Index: ${index + 1}/${total}`);
                        importLog.push('');
                    } else {
                        const errorMsg = 'Simulated error for testing';
                        updateConsole(`❌ Error (${index + 1}/${total}): ${errorMsg}`, 'text-danger');
                        updateUrlStatus(index, 'error', importTime);
                        updateStatusCounters('error');
                        
                        // Add to log
                        importLog.push(`[${new Date().toLocaleTimeString()}] ERROR: ${url}`);
                        importLog.push(`  Error: ${errorMsg}`);
                        importLog.push(`  Time: ${importTime}s`);
                        importLog.push(`  Index: ${index + 1}/${total}`);
                        importLog.push('');
                    }
                    
                    updateProgress(((index + 1) / total) * 100);
                    updateProductCount(index + 1, total);
                    
                    // Realistic delays in test mode (similar to real mode)
                    const nextDelay = total > 200 ? 1500 : (total > 100 ? 1000 : 500);
                    setTimeout(() => {
                        if (!isPaused) {
                            processUrls(urls, index + 1, total);
                        }
                    }, nextDelay);
                }, simulateDelay);
            } else {
                // Real import mode
                jQuery.ajax({
                    url: amsbackend.ajax_url,
                    type: 'POST',
                    timeout: 600000, // 10 minute timeout for complex products
                    data: {
                        action: 'ams_product_import_by_url',
                        product_url: url,
                        nonce: jQuery('#_wpnonce').val()
                    },
                    success: function(response) {
                        stopTimer(index);
                        const importTime = ((Date.now() - importStartTimes[index]) / 1000).toFixed(2);
                        
                        // Mark URL as processed
                        processedUrls.add(url);
                        
                        updateConsole(`✅ Success (${index + 1}/${total}): ${response}`, 'text-success');
                        updateUrlStatus(index, 'success', importTime);
                        updateProgress(((index + 1) / total) * 100);
                        updateProductCount(index + 1, total);
                        updateStatusCounters('success');
                        
                        // Add to log
                        importLog.push(`[${new Date().toLocaleTimeString()}] SUCCESS: ${url}`);
                        importLog.push(`  Response: ${response}`);
                        importLog.push(`  Time: ${importTime}s`);
                        importLog.push(`  Index: ${index + 1}/${total}`);
                        importLog.push('');
                        
                        // Add small delay between requests for large batches
                        const nextDelay = total > 200 ? 1500 : (total > 100 ? 1000 : 500);
                        setTimeout(() => {
                            if (!isPaused) {
                                processUrls(urls, index + 1, total);
                            }
                        }, nextDelay);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        stopTimer(index);
                        const importTime = ((Date.now() - importStartTimes[index]) / 1000).toFixed(2);
                        
                        // Mark URL as processed
                        processedUrls.add(url);
                        
                        updateConsole(`❌ Error (${index + 1}/${total}): ${textStatus}`, 'text-danger');
                        updateUrlStatus(index, 'error', importTime);
                        updateProgress(((index + 1) / total) * 100);
                        updateProductCount(index + 1, total);
                        updateStatusCounters('error');
                        
                        // Add to log
                        importLog.push(`[${new Date().toLocaleTimeString()}] ERROR: ${url}`);
                        importLog.push(`  Error: ${textStatus} - ${errorThrown}`);
                        importLog.push(`  Time: ${importTime}s`);
                        importLog.push(`  Index: ${index + 1}/${total}`);
                        importLog.push('');
                        
                        // Continue with next URL even on error, with delay
                        const nextDelay = total > 200 ? 2000 : (total > 100 ? 1500 : 1000);
                        setTimeout(() => {
                            if (!isPaused) {
                                processUrls(urls, index + 1, total);
                            }
                        }, nextDelay);
                    }
                });
            }
        };

        // Apply delay for large batches
        if (shouldDelay && total > 50) {
            setTimeout(executeRequest, batchDelay);
        } else {
            executeRequest();
        }
    }

    function updateUrlStatus(index, status, importTime = null) {
        const statusItem = document.getElementById(`url-status-${index}`);
        if (statusItem) {
            let indicator, className;
            switch(status) {
                case 'processing':
                    indicator = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>';
                    className = 'border-warning bg-warning bg-opacity-10';
                    break;
                case 'success':
                    indicator = '<i class="bi bi-check-circle text-success"></i>';
                    className = 'border-success bg-success bg-opacity-10';
                    break;
                case 'error':
                    indicator = '<i class="bi bi-x-circle text-danger"></i>';
                    className = 'border-danger bg-danger bg-opacity-10';
                    break;
                default:
                    indicator = '⚪';
                    className = '';
            }
            const statusIndicator = statusItem.querySelector('.status-indicator');
            if (statusIndicator) {
                statusIndicator.innerHTML = indicator;
            }
            statusItem.className = `url-status-item mb-2 p-2 rounded border ${className}`;
            
            if (importTime !== null) {
                const timeElement = statusItem.querySelector('.import-time');
                if (timeElement) {
                    timeElement.textContent = `${importTime}s`;
                }
            }
        }
    }

    function updateStatusCounters(type) {
        const pendingCountMini = document.getElementById('pending-count-mini');
        const successCountMini = document.getElementById('success-count-mini');
        const errorCountMini = document.getElementById('error-count-mini');
        
        if (pendingCountMini && successCountMini && errorCountMini) {
            let pending = parseInt(pendingCountMini.textContent);
            let success = parseInt(successCountMini.textContent);
            let error = parseInt(errorCountMini.textContent);
            
            pending--;
            if (type === 'success') {
                success++;
            } else if (type === 'error') {
                error++;
            }
            
            // Update mini counters
            pendingCountMini.textContent = pending;
            successCountMini.textContent = success;
            errorCountMini.textContent = error;
        }
    }

    function startTimer(index) {
        const statusItem = document.getElementById(`url-status-${index}`);
        if (statusItem) {
            const timeElement = statusItem.querySelector('.import-time');
            if (timeElement) {
                timerIntervals[index] = setInterval(() => {
                    const elapsedTime = ((Date.now() - importStartTimes[index]) / 1000).toFixed(2);
                    timeElement.textContent = `${elapsedTime}s`;
                }, 100);
            }
        }
    }

    function stopTimer(index) {
        if (timerIntervals[index]) {
            clearInterval(timerIntervals[index]);
            delete timerIntervals[index];
        }
    }

    function finishImport() {
        Object.keys(timerIntervals).forEach(index => stopTimer(index));

        // Finalize import log
        const importEndTime = new Date();
        const totalTime = ((importEndTime - importStartTime) / 1000 / 60).toFixed(2);
        
        importLog.push('='.repeat(80));
        importLog.push(`Import Completed: ${importEndTime.toLocaleString()}`);
        importLog.push(`Total Duration: ${totalTime} minutes`);
        
        // Calculate statistics
        const successCountElement = document.getElementById('success-count-mini');
        const errorCountElement = document.getElementById('error-count-mini');
        const successCount = parseInt(successCountElement?.textContent || '0');
        const errorCount = parseInt(errorCountElement?.textContent || '0');
        const totalProcessed = successCount + errorCount;
        
        importLog.push(`Total Processed: ${totalProcessed}`);
        importLog.push(`Successful: ${successCount}`);
        importLog.push(`Failed: ${errorCount}`);
        importLog.push(`Success Rate: ${totalProcessed > 0 ? ((successCount / totalProcessed) * 100).toFixed(1) : 0}%`);
        importLog.push('='.repeat(80));

        updateConsole('🎉 Import completed successfully!', 'text-info fw-bold');
        jQuery('#prod_cron').html('<i class="bi bi-file-earmark-arrow-down me-2"></i><?php esc_html_e('Import Products', 'ams-wc-amazon'); ?>').prop('disabled', false);
        jQuery('#pause_import').addClass('d-none');
        jQuery('#download_log').removeClass('d-none'); // Show download button
        jQuery('#import-status-message').text('Import completed');
        jQuery('#wca-product-all-url').prop('disabled', false);
        jQuery('#clear-urls').prop('disabled', false).removeClass('opacity-50');
        updateProgress(100);
        isImporting = false;
        isPaused = false;
    }

    function downloadLog() {
        if (importLog.length === 0) {
            updateConsole('No log data available to download', 'text-warning');
            return;
        }

        const logContent = importLog.join('\n');
        const timestamp = new Date().toISOString().replace(/[:.]/g, '-').slice(0, -5);
        const filename = `ams-import-log-${timestamp}.txt`;
        
        const blob = new Blob([logContent], { type: 'text/plain' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = filename;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
        
        updateConsole(`📥 Log downloaded: ${filename}`, 'text-success');
    }

    function updateConsole(message, className = '') {
        var timestamp = new Date().toLocaleTimeString();
        jQuery('#console-output').append(`<div class="${className}">[${timestamp}] ${message}</div>`);
        jQuery('#console-window').scrollTop(jQuery('#console-window')[0].scrollHeight);
    }

    function updateProgress(percentage) {
        jQuery('#import-progress-bar').css('width', percentage + '%').attr('aria-valuenow', percentage);
        jQuery('#import-progress-bar-mini').css('width', percentage + '%').attr('aria-valuenow', percentage);
    }

    function updateProductCount(count, total) {
        jQuery('#import-product-count').text(`${count} / ${total} <?php esc_html_e('products', 'ams-wc-amazon'); ?>`);
    }

    // Add event listener for page unload
    window.addEventListener('beforeunload', function (e) {
        if (isImporting) {
            e.preventDefault();
            e.returnValue = '';
        }
    });

    // Initialize stored messages
    jQuery(document).ready(function($) {
        $('.wca-amazon-product-by-url').html(localStorage.getItem('product_url_messages'));
        localStorage.removeItem('product_url_messages');
    });
</script>

<style>
    .import-time {
        color: #0dcaf0 !important;
        font-weight: bold;
        font-size: 1em;
    }
</style>