<?php
$navbar_data = ams_fetch_navbar_data();
$breadcrumbs = ams_generate_breadcrumbs();

$regions = ams_get_amazon_regions();
$ams_amazon_country = get_option('ams_amazon_country');
$ams_default_category = get_option('ams_default_category');

$regions_placeholder = isset($regions[$ams_amazon_country]['RegionName']) ? $regions[$ams_amazon_country]['RegionName'] : $ams_amazon_country;
if (empty($regions_placeholder)) {
    $regions_placeholder = esc_html__('N/A', 'ams-wc-amazon');
}

$category_placeholder = $ams_default_category === '_auto_import_amazon' ? 'Auto Import From Amazon' : $ams_default_category;
if (empty($category_placeholder)) {
    $category_placeholder = esc_html__('N/A', 'ams-wc-amazon');
}
// Try to get the currency from the plugin's settings first
$plugin_currency = get_option('woocommerce_currency');
$store_currency = function_exists('get_woocommerce_currency') ? get_woocommerce_currency() : '';
if (empty($store_currency)) {
    $store_currency = esc_html__('N/A', 'ams-wc-amazon');
}
$currency_code_options = function_exists('get_woocommerce_currencies') ? get_woocommerce_currencies() : [];
$currency_code = function_exists('ams_get_currency_for_region') ? ams_get_currency_for_region($ams_amazon_country) : '';
if (empty($currency_code)) {
    $currency_code = esc_html__('N/A', 'ams-wc-amazon');
}
$currency_placeholder = isset($currency_code_options[$currency_code]) ? $currency_code_options[$currency_code] : $currency_code;

//License section
$ams_activated_status = get_option('ams_activated_status');
$wca_license_class  = $ams_activated_status == 'success' ? 'text-success' : 'text-warning';
$wca_license_status = $ams_activated_status == 'success' ? esc_html__('Activated', 'ams-wc-amazon') : esc_html__('Not Activated', 'ams-wc-amazon');

// formatted HTML (for display)
$wca_license = sprintf('<span class="%s">%s</span>', $wca_license_class, $wca_license_status);
//License section

?>
<input type="hidden" id="wca_license_status" value="<?php echo esc_attr($wca_license_status); ?>">


<!-- jQuery and Bootstrap JS -->
<script src="<?= AMS_PLUGIN_URL ?>assets/vendor/jquery/dist/jquery.min.js"></script>



<!-- Chart.js (keep for dashboard charts) -->
<script src="<?= AMS_PLUGIN_URL ?>assets/vendor/chart.js/dist/Chart.min.js"></script>
<script src="<?= AMS_PLUGIN_URL ?>assets/vendor/chart.js/dist/Chart.extension.js"></script>



<!--top menu-->
<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
  <div class="container-fluid">
    <a class="navbar-brand" href="?page=wc-amazon-affiliate">
      <img src="<?php echo esc_url(AMS_PLUGIN_URL . 'assets/plugin/img/brand/ams.png'); ?>" alt="AMS - WooCommerce Amazon" height="30">
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item">
        <a class="nav-link <?php echo ($_GET['page'] == 'wc-amazon-affiliate') ? 'active text-primary border-bottom border-primary border-2' : ''; ?>" href="?page=wc-amazon-affiliate">
          <i class="bi bi-speedometer2 me-1"></i> <?php esc_html_e('Dashboard', 'ams-wc-amazon'); ?>
        </a>
        </li>

        <li class="nav-item">
          <a class="nav-link <?php echo ($_GET['page'] == 'wc-product-search') ? 'active text-primary border-bottom border-primary border-2' : ''; ?>" href="?page=wc-product-search">
            <i class="bi bi-cloud-upload me-1"></i> <?php esc_html_e('Import By PA-API 5', 'ams-wc-amazon'); ?>
          </a>
        </li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle <?php echo (in_array($_GET['page'], ['product-import-by-url', 'products-search-without-api'])) ? 'active text-primary border-bottom border-primary border-2' : ''; ?>" href="#" id="noApiImportDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
              <i class="bi bi-power me-1"></i> <?php esc_html_e('Import Without API', 'ams-wc-amazon'); ?>
            </a>
            <ul class="dropdown-menu shadow" aria-labelledby="navbarDropdown">
              <li><h6 class="dropdown-header"><?php esc_html_e('Import Options', 'ams-wc-amazon'); ?></h6></li>
              <li>
                <div class="dropdown-item d-flex align-items-center py-2 <?php echo ($_GET['page'] == 'products-search-without-api') ? 'active bg-primary text-white fw-bold' : ''; ?>">
                  <a href="?page=products-search-without-api" class="d-flex align-items-center text-decoration-none <?php echo ($_GET['page'] == 'products-search-without-api') ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                    <i class="bi bi-search-heart me-3"></i>
                    <span class="me-auto"><?php esc_html_e('Import by Search', 'ams-wc-amazon'); ?></span>
                  </a>
                  <a href="?page=products-search-without-api" class="ms-2 <?php echo ($_GET['page'] == 'products-search-without-api') ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                    <i class="bi bi-arrow-up-right <?php echo ($_GET['page'] == 'products-search-without-api') ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                  </a>
                </div>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li>
                <div class="dropdown-item d-flex align-items-center py-2 <?php echo ($_GET['page'] == 'amazon-bestsellers') ? 'active bg-primary text-white fw-bold' : ''; ?>">
                  <a href="?page=amazon-bestsellers" class="d-flex align-items-center text-decoration-none <?php echo ($_GET['page'] == 'amazon-bestsellers') ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                    <i class="bi bi-award me-3"></i>
                    <span class="me-auto"><?php esc_html_e('Amazon Bestsellers', 'ams-wc-amazon'); ?></span>
                  </a>
                  <a href="?page=amazon-bestsellers" class="ms-2 <?php echo ($_GET['page'] == 'amazon-bestsellers') ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                    <i class="bi bi-arrow-up-right <?php echo ($_GET['page'] == 'amazon-bestsellers') ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                  </a>
                </div>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li>
                <div class="dropdown-item d-flex align-items-center py-2 <?php echo ($_GET['page'] == 'product-import-by-url') ? 'active bg-primary text-white fw-bold' : ''; ?>">
                  <a href="?page=product-import-by-url" class="d-flex align-items-center text-decoration-none <?php echo ($_GET['page'] == 'product-import-by-url') ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                    <i class="bi bi-link-45deg me-3"></i>
                    <span class="me-auto"><?php esc_html_e('Import by URL', 'ams-wc-amazon'); ?></span>
                  </a>
                  <a href="?page=product-import-by-url" class="ms-2 <?php echo ($_GET['page'] == 'product-import-by-url') ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                    <i class="bi bi-arrow-up-right <?php echo ($_GET['page'] == 'product-import-by-url') ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                  </a>
                </div>
              </li>
            </ul>
          </li>
        <?php if ('1' == get_option('enable_amazon_review', true)) : ?>
        <li class="nav-item">
          <a class="nav-link <?php echo ($_GET['page'] == 'product-review-import') ? 'active text-primary border-bottom border-primary border-2' : ''; ?>" href="?page=product-review-import">
            <i class="bi bi-chat-dots me-1"></i> <?php esc_html_e('Import Review', 'ams-wc-amazon'); ?>
          </a>
        </li>
        <?php endif; ?>
        <li class="nav-item">
          <a class="nav-link <?php echo (isset($_GET['page']) && ($_GET['page'] == 'automation' || $_GET['page'] == 'automation-logs')) ? 'active text-primary border-bottom border-primary border-2' : ''; ?>" href="?page=automation">
            <i class="bi bi-robot me-1"></i> <?php esc_html_e('Automation', 'ams-wc-amazon'); ?>
          </a>
        </li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page') ? 'active text-primary border-bottom border-primary border-2' : ''; ?>" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-gear me-1"></i> <?php esc_html_e('Settings', 'ams-wc-amazon'); ?>
          </a>
          <ul class="dropdown-menu shadow-sm" aria-labelledby="navbarDropdown">
            <li>
              <div class="dropdown-item d-flex align-items-center py-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-general-tab") ? 'active bg-primary text-white fw-bold' : ''; ?>">
                <a href="?page=wc-product-setting-page&tab=pills-general-tab" class="d-flex align-items-center text-decoration-none <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-general-tab") ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                  <i class="bi bi-sliders me-3"></i>
                  <span class="me-auto"><?php esc_html_e('Configuration', 'ams-wc-amazon'); ?></span>
                </a>
                <a href="?page=wc-product-setting-page&tab=pills-general-tab" class="ms-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-general-tab") ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                  <i class="bi bi-arrow-up-right <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-general-tab") ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                </a>
                <?php if (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-general-tab"): ?>
                  <i class="bi bi-check-lg text-primary ms-2"></i>
                <?php endif; ?>
              </div>
            </li>
            <li>
              <div class="dropdown-item d-flex align-items-center py-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'view-logs') ? 'active bg-primary text-white fw-bold' : ''; ?>">
                <a href="?page=view-logs" class="d-flex align-items-center text-decoration-none <?php echo (isset($_GET['page']) && $_GET['page'] == 'view-logs') ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                  <i class="bi bi-journal-text me-3"></i>
                  <span class="me-auto"><?php esc_html_e('View Logs', 'ams-wc-amazon'); ?></span>
                </a>
                <a href="?page=view-logs" class="ms-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'view-logs') ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                  <i class="bi bi-arrow-up-right <?php echo (isset($_GET['page']) && $_GET['page'] == 'view-logs') ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                </a>
                <?php if (isset($_GET['page']) && $_GET['page'] == 'view-logs'): ?>
                  <i class="bi bi-check-lg text-primary ms-2"></i>
                <?php endif; ?>
              </div>
            </li>
            <li>
              <div class="dropdown-item d-flex align-items-center py-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-settings-tab") ? 'active bg-primary text-white fw-bold' : ''; ?>">
                <a href="?page=wc-product-setting-page&tab=pills-az-settings-tab" class="d-flex align-items-center text-decoration-none <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-settings-tab") ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                  <i class="bi bi-shield-lock me-3"></i>
                  <span class="me-auto"><?php esc_html_e('Amazon API Setting', 'ams-wc-amazon'); ?></span>
                </a>
                <a href="?page=wc-product-setting-page&tab=pills-az-settings-tab" class="ms-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-settings-tab") ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                  <i class="bi bi-arrow-up-right <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-settings-tab") ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                </a>
                <?php if (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-settings-tab"): ?>
                  <i class="bi bi-check-lg text-primary ms-2"></i>
                <?php endif; ?>
              </div>
            </li>
            <li>
              <div class="dropdown-item d-flex align-items-center py-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-products-tab") ? 'active bg-primary text-white fw-bold' : ''; ?>">
                <a href="?page=wc-product-setting-page&tab=pills-az-products-tab" class="d-flex align-items-center text-decoration-none <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-products-tab") ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                  <i class="bi bi-arrow-clockwise me-3"></i>
                  <span class="me-auto"><?php esc_html_e('Auto Products Update', 'ams-wc-amazon'); ?></span>
                </a>
                <a href="?page=wc-product-setting-page&tab=pills-az-products-tab" class="ms-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-products-tab") ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                  <i class="bi bi-arrow-up-right <?php echo (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-products-tab") ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                </a>
                <?php if (isset($_GET['page']) && $_GET['page'] == 'wc-product-setting-page' && isset($_GET['tab']) && $_GET['tab'] == "pills-az-products-tab"): ?>
                  <i class="bi bi-check-lg text-primary ms-2"></i>
                <?php endif; ?>
              </div>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li>
              <div class="dropdown-item d-flex align-items-center py-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'brand-settings') ? 'active bg-primary text-white fw-bold' : ''; ?>">
                <a href="?page=brand-settings" class="d-flex align-items-center text-decoration-none <?php echo (isset($_GET['page']) && $_GET['page'] == 'brand-settings') ? 'text-white' : 'text-reset'; ?> flex-grow-1">
                  <i class="bi bi-bookmark-star me-3"></i>
                  <span class="me-auto"><?php esc_html_e('Brand Settings', 'ams-wc-amazon'); ?></span>
                </a>
                <a href="?page=brand-settings" class="ms-2 <?php echo (isset($_GET['page']) && $_GET['page'] == 'brand-settings') ? 'text-white' : ''; ?>" target="_blank" rel="noopener noreferrer" onclick="event.stopPropagation();">
                  <i class="bi bi-arrow-up-right <?php echo (isset($_GET['page']) && $_GET['page'] == 'brand-settings') ? 'text-white' : 'text-muted'; ?>" style="font-size: 0.75rem;" title="Open in new tab"></i>
                </a>
                <?php if (isset($_GET['page']) && $_GET['page'] == 'brand-settings'): ?>
                  <i class="bi bi-check-lg text-primary ms-2"></i>
                <?php endif; ?>
              </div>
            </li>
          </ul>
        </li>
      </ul>
    </div>
  </div>
</nav>
<!--top menu-->

<!--License Alert All Pages-->
<div class="container-fluid mt-3">
    <div class="alert alert-warning alert-dismissible fade <?php echo ams_plugin_license_status() === false ? 'show' : 'd-none'; ?> border-0 shadow-sm" role="alert" id="license-header-alert">
        <div class="d-flex align-items-start">
            <div class="flex-shrink-0 me-3">
                <div class="bg-warning bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center" style="width: 48px; height: 48px;">
                    <i class="bi bi-shield-exclamation fs-4 text-warning"></i>
                </div>
            </div>
            <div class="flex-grow-1">
                <div class="d-flex align-items-center mb-2">
                    <h6 class="alert-heading mb-0 fw-bold text-dark">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i><?php esc_html_e('License Activation Required', 'ams-wc-amazon'); ?>
                    </h6>
                </div>
                <p class="mb-2 text-dark">
                    <?php esc_html_e('Your', 'ams-wc-amazon'); ?> <strong><?php esc_html_e('AMS - WooCommerce Amazon', 'ams-wc-amazon'); ?></strong> <?php esc_html_e('plugin license needs to be activated to unlock the full functionality.', 'ams-wc-amazon'); ?>
                </p>
                <div class="d-flex gap-2">
                    <a href="?page=wc-amazon-affiliate#license-card" class="btn btn-warning btn-sm">
                        <i class="bi bi-key me-1"></i><?php esc_html_e('Activate License', 'ams-wc-amazon'); ?>
                    </a>
                    <a href="https://codecanyon.net/item/affiliate-management-system-woocommerce-amazon/29955429" target="_blank" class="btn btn-outline-secondary btn-sm">
                        <i class="bi bi-cart me-1"></i><?php esc_html_e('Get License', 'ams-wc-amazon'); ?>
                    </a>
                </div>
            </div>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
</div>
<!--License Alert All Pages-->

<?php if ($_GET['page'] != 'wc-amazon-affiliate'): ?>
<div class="compact-header mb-3">
  <div class="container-fluid">
    <div class="d-flex align-items-center justify-content-between py-2">
      <!-- Left: Breadcrumbs -->
      <div class="d-flex align-items-center">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb mb-0 bg-transparent p-0 small">
            <?php
            $breadcrumbs = ams_generate_breadcrumbs();
            foreach ($breadcrumbs as $index => $crumb): ?>
              <?php if ($index === array_key_last($breadcrumbs)): ?>
                <li class="breadcrumb-item active" aria-current="page">
                  <span class="text-primary fw-semibold">
                    <?php echo wp_kses_post($crumb['title']); ?>
                  </span>
                </li>
              <?php else: ?>
                <li class="breadcrumb-item">
                  <?php if (!empty($crumb['url'])): ?>
                    <a href="<?php echo esc_url($crumb['url']); ?>" class="text-decoration-none text-muted">
                      <?php echo wp_kses_post($crumb['title']); ?>
                    </a>
                  <?php else: ?>
                    <span class="text-muted">
                      <?php echo wp_kses_post($crumb['title']); ?>
                    </span>
                  <?php endif; ?>
                </li>
              <?php endif; ?>
            <?php endforeach; ?>
          </ol>
        </nav>
      </div>
      
      <!-- Right: Compact Settings Info -->
      <div class="d-flex align-items-center gap-3">
        <div class="d-flex align-items-center gap-3 text-muted small">
          <span title="<?php echo esc_attr($regions_placeholder); ?>">
            <i class="bi bi-globe text-primary me-1"></i><?php echo esc_html($regions_placeholder); ?>
          </span>
          <span title="<?php echo esc_attr($category_placeholder); ?>">
            <i class="bi bi-folder text-success me-1"></i><?php echo esc_html($category_placeholder); ?>
          </span>
          <span title="<?php echo esc_attr($currency_placeholder); ?>">
            <span class="text-info me-1 fw-bold"><?php echo esc_html(get_woocommerce_currency_symbol($currency_code)); ?></span><?php echo esc_html($currency_code); ?>
          </span>
        </div>
        <button type="button" data-bs-toggle="modal" data-bs-target="#settingsModel" class="btn btn-outline-primary btn-sm" title="<?php esc_attr_e('Country Settings', 'ams-wc-amazon'); ?>">
          <i class="bi bi-gear"></i>
        </button>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>


<!-- Modal -->
<div class="modal fade" id="settingsModel" tabindex="-1" aria-labelledby="settingsModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content modal-content">
      <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" enctype="multipart/form-data">
        <div class="modal-header modal-header">
          <div class="d-flex align-items-center">
            <div class="d-flex align-items-center justify-content-center bg-primary text-white rounded-circle me-3">
              <i class="bi bi-globe-americas text-white"></i>
            </div>
            <div>
              <h5 class="modal-title text-dark fs-4 mb-1" id="settingsModalLabel">
                <?php esc_html_e('Country Settings', 'ams-wc-amazon'); ?>
              </h5>
              <p class="text-muted mb-0 small">
                <?php esc_html_e('Configure your Amazon region and WooCommerce settings', 'ams-wc-amazon'); ?>
              </p>
            </div>
          </div>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body p-4">
          <input type="hidden" name="action" value="<?php echo esc_attr('ams_wc_product_cat_setting'); ?>">
          <input type="hidden" name="page_redirect" value="<?php echo esc_attr($_GET['page']); ?>">
          
          <div class="mb-4 mb-4">
            <label for="amazon_country" class="form-label fw-bold">
              <i class="bi bi-flag text-primary me-2"></i>
              <?php esc_html_e('Amazon Country', 'ams-wc-amazon'); ?>
            </label>
            <div class="text-muted small mb-2">
              <?php esc_html_e('Select your target Amazon marketplace for product imports', 'ams-wc-amazon'); ?>
            </div>
            <?php
            $noCountry = isset($noCountry) ? $noCountry : 0;
            $regions = ($noCountry == 1) ? $regionsL : $regions;
            ?>
            <select name="ams_amazon_country" id="modal_amazon_country" class="form-select">
              <option value="" disabled <?php echo empty(get_option('ams_amazon_country')) ? 'selected' : ''; ?>><?php echo esc_html($regions_placeholder); ?></option>
              <?php foreach ( $regions as $key => $value ) { ?>
                <option <?php selected(get_option( 'ams_amazon_country' ), $key, true ); ?> value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value['RegionName'] ); ?></option>
              <?php } ?>
            </select>
          </div>
          
          <div class="mb-4 mb-4">
            <label for="modal_ams_default_category" class="form-label fw-bold">
              <i class="bi bi-folder text-success me-2"></i>
              <?php esc_html_e('Default WooCommerce Product Category', 'ams-wc-amazon'); ?>
            </label>
            <div class="text-muted small mb-2">
              <?php esc_html_e('Choose where imported products will be categorized', 'ams-wc-amazon'); ?>
            </div>
            <select name="ams_default_category" id="modal_ams_default_category" class="form-select">
              <option value="_auto_import_amazon" selected="selected"><?php esc_html_e('Auto Import From Amazon', 'ams-wc-amazon'); ?></option>
              <?php foreach (get_wc_terms() as $value) { ?>
                <option value="<?php echo esc_attr( $value['name'] ); ?>" <?php selected(get_option( 'ams_default_category' ), $value['name'] ); ?>><?php echo esc_html( $value['name'] ); ?></option>
              <?php } ?>
            </select>
          </div>
          
          <div class="mb-4 mb-4">
            <label for="woocommerce_currency" class="form-label fw-bold">
              <span id="currency-label-symbol" class="text-info me-2 fw-bold" style="font-size: 1.1em;"><?php echo html_entity_decode(get_woocommerce_currency_symbol($store_currency), ENT_QUOTES, 'UTF-8'); ?></span>
              <?php esc_html_e('WooCommerce Currency Setting', 'ams-wc-amazon'); ?>
            </label>
            <div class="text-muted small mb-2">
              <?php esc_html_e('Set the currency for your WooCommerce store', 'ams-wc-amazon'); ?>
            </div>
            <select name="woocommerce_currency" id="modal_woocommerce_currency" class="form-select">
              <?php foreach ($currency_code_options as $code=>$value) { 
                $symbol = get_woocommerce_currency_symbol($code);
                $display_text = $value . ' (' . $symbol . ') - ' . $code;
              ?>
                <option value="<?php echo esc_attr( $code); ?>" <?php selected( $store_currency, $code ); ?>><?php echo esc_html( $display_text ); ?></option>
              <?php } ?>
            </select>
            <div class="form-text text-muted">
              <i class="bi bi-info-circle me-1"></i>
              <?php esc_html_e('Currency will be automatically set based on the selected Amazon country', 'ams-wc-amazon'); ?>
            </div>
            
            <!-- Currency mismatch notification area -->
            <div id="currency-mismatch-notification" class="alert alert-warning mt-2" style="display: none;">
              <i class="bi bi-exclamation-triangle me-2"></i>
              <strong><?php esc_html_e('Currency Mismatch:', 'ams-wc-amazon'); ?></strong>
              <span id="mismatch-message"></span>
            </div>
          </div>
        </div>
        <div class="modal-footer modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
            <i class="bi bi-x me-2"></i>
            <?php esc_html_e('Cancel', 'ams-wc-amazon'); ?>
          </button>
          <button type="submit" class="btn btn-primary">
            <i class="bi bi-floppy me-2"></i>
            <?php esc_html_e('Save Settings', 'ams-wc-amazon'); ?>
          </button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
// Modal Currency Auto-Completion Logic
document.addEventListener('DOMContentLoaded', function() {
    // Auto-currency selection when country changes in modal
    const modalCountrySelect = document.querySelector('#modal_amazon_country');
    const modalCurrencySelect = document.querySelector('#modal_woocommerce_currency');
    
    if (modalCountrySelect && modalCurrencySelect) {
        // Currency mapping for Amazon regions
        const currencyMap = {
            'com.au': 'AUD', // Australia
            'com.br': 'BRL', // Brazil
            'ca': 'CAD',      // Canada
            'cn': 'CNY',      // China
            'fr': 'EUR',      // France
            'de': 'EUR',      // Germany
            'in': 'INR',      // India
            'it': 'EUR',      // Italy
            'jp': 'JPY',      // Japan
            'mx': 'MXN',      // Mexico
            'nl': 'EUR',      // Netherlands
            'sa': 'SAR',      // Saudi Arabia
            'sg': 'SGD',      // Singapore
            'es': 'EUR',      // Spain
            'com.tr': 'TRY',  // Turkey
            'ae': 'AED',      // United Arab Emirates
            'co.uk': 'GBP',   // United Kingdom
            'com': 'USD',     // United States
            'pl': 'PLN'       // Poland
        };

        // Dynamic currency symbol mapping from WooCommerce
        const currencySymbols = {
            <?php 
            $amazon_currencies = ['AUD', 'BRL', 'CAD', 'CNY', 'EUR', 'INR', 'JPY', 'MXN', 'SAR', 'SGD', 'TRY', 'AED', 'GBP', 'USD', 'PLN'];
            foreach ($amazon_currencies as $currency_code) {
                $symbol = html_entity_decode(get_woocommerce_currency_symbol($currency_code), ENT_QUOTES, 'UTF-8');
                echo "'{$currency_code}': '" . addslashes($symbol) . "', ";
            }
            ?>
        };

        // Track if we've already shown an alert for this country
        let lastSelectedCountry = '';
        
        // Function to update currency based on selected country
        function updateModalCurrency() {
            const selectedCountry = modalCountrySelect.value;
            const targetCurrency = currencyMap[selectedCountry];
            
            if (targetCurrency && selectedCountry !== lastSelectedCountry) {
                // Find and select the matching currency option
                for (let i = 0; i < modalCurrencySelect.options.length; i++) {
                    if (modalCurrencySelect.options[i].value === targetCurrency) {
                        modalCurrencySelect.selectedIndex = i;
                        
                        // Update the currency symbol in the label
                        const currencyLabelSymbol = document.getElementById('currency-label-symbol');
                        if (currencyLabelSymbol && currencySymbols[targetCurrency]) {
                            currencyLabelSymbol.textContent = currencySymbols[targetCurrency];
                        }
                        
                        // Add visual feedback
                        modalCurrencySelect.classList.add('border-success');
                        setTimeout(() => {
                            modalCurrencySelect.classList.remove('border-success');
                        }, 2000);
                        
                        // Remove any existing notifications first
                        const existingNotifications = document.querySelectorAll('.modal-currency-notification');
                        existingNotifications.forEach(notification => notification.remove());
                        
                        // Show notification only once per country change
                        const notification = document.createElement('div');
                        notification.className = 'alert alert-info alert-dismissible fade show mt-2 modal-currency-notification';
                        notification.innerHTML = `
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Currency Updated:</strong> Store currency has been automatically set to ${targetCurrency} for ${modalCountrySelect.options[modalCountrySelect.selectedIndex].text}.
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        `;
                        
                        // Insert notification after the currency field
                        const currencyGroup = modalCurrencySelect.closest('.mb-4');
                        if (currencyGroup) {
                            currencyGroup.parentNode.insertBefore(notification, currencyGroup.nextSibling);
                        }
                        
                        // Update the last selected country
                        lastSelectedCountry = selectedCountry;
                        break;
                    }
                }
            }
        }

        // Add event listener for country change
        modalCountrySelect.addEventListener('change', updateModalCurrency);
        
        // Check for currency mismatch when modal opens
        function checkCurrencyMismatch() {
            const currentCurrency = modalCurrencySelect.value;
            const supportedCurrencies = Object.values(currencyMap);
            const notification = document.getElementById('currency-mismatch-notification');
            const messageSpan = document.getElementById('mismatch-message');
            
            if (!supportedCurrencies.includes(currentCurrency)) {
                // Currency is not supported by any Amazon region
                messageSpan.textContent = `Your current WooCommerce currency (${currentCurrency}) is not supported by Amazon regions. Please select an Amazon country manually or change your WooCommerce currency to a supported one.`;
                notification.style.display = 'block';
            } else {
                notification.style.display = 'none';
            }
        }

        // Also update on modal show if country is already selected
        const modal = document.getElementById('settingsModel');
        if (modal) {
            modal.addEventListener('shown.bs.modal', function() {
                // Check for currency mismatch when modal opens
                checkCurrencyMismatch();
                
                if (modalCountrySelect.value) {
                    // Reset the last selected country when modal opens
                    lastSelectedCountry = '';
                    updateModalCurrency();
                }
            });
        }
    }
});
</script>