<?php include "common-header.php"; ?>

<?php
if ( class_exists( 'WooCommerce' ) ) {
    $currency_symbol = get_woocommerce_currency_symbol();
} else {
    $currency_symbol = '$';
}
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            
            <!-- Proxy Service Status Notification -->
            <div id="proxy-notification-area" class="mb-3">
                <?php 
                // Get smart service status
                $services_status = $this->get_proxy_services_status();
                
                if ($services_status['show_setup_notification']) {
                ?>
                    <div class="card border-warning shadow-sm ams-common-card-fix mb-3">
                        <div class="card-body p-4">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-start">
                                        <div class="me-3">
                                            <div class="bg-warning bg-opacity-10 rounded-circle p-3">
                                                <i class="bi bi-shield-exclamation text-warning fs-3"></i>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="text-warning mb-2 fw-bold">
                                                <i class="bi bi-cloud-arrow-down me-2"></i>
                                                <?php esc_html_e('Proxy Service Required', 'ams-wc-amazon'); ?>
                                            </h5>
                                            <p class="text-muted mb-2">
                                                <?php esc_html_e('For reliable bestseller data importing, we recommend setting up a proxy service to prevent Amazon from blocking your requests.', 'ams-wc-amazon'); ?>
                                            </p>
                                            <div class="d-flex flex-wrap gap-2 mb-2">
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('Decodo Service', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('ScraperAPI Service', 'ams-wc-amazon'); ?>
                                                </span>
                                                <span class="badge bg-light text-dark border">
                                                    <i class="bi bi-circle me-1"></i><?php esc_html_e('ScrapingAnt Service', 'ams-wc-amazon'); ?>
                                                </span>
                                            </div>
                                            <small class="text-muted">
                                                <i class="bi bi-info-circle me-1"></i>
                                                <?php esc_html_e('Choose one of the proxy services above for better success rates', 'ams-wc-amazon'); ?>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                    <div class="d-flex flex-column gap-2">
                                        <a href="<?php echo admin_url('admin.php?page=wc-product-setting-page&tab=pills-general-tab'); ?>" 
                                           class="btn btn-warning btn-lg shadow-sm">
                                            <i class="bi bi-gear-fill me-2"></i>
                                            <?php esc_html_e('Configure Proxy', 'ams-wc-amazon'); ?>
                                        </a>
                                        <small class="text-muted text-center">
                                            <?php esc_html_e('Recommended for reliable scraping', 'ams-wc-amazon'); ?>
                                        </small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php 
                }
                ?>
            </div>

            <!-- Import Progress Indicator -->
            <div id="import-progress-indicator" class="mb-3 d-none">
                <div class="card border-info shadow-sm ams-common-card-fix">
                    <div class="card-body p-3">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <div class="spinner-border text-info" role="status" style="width: 1.5rem; height: 1.5rem;">
                                    <span class="visually-hidden"><?php esc_html_e('Loading...', 'ams-wc-amazon'); ?></span>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1 fw-bold text-info">
                                    <i class="bi bi-cloud-download me-2"></i>
                                    <?php esc_html_e('Import in Progress', 'ams-wc-amazon'); ?>
                                </h6>
                                <div class="d-flex align-items-center">
                                    <small class="text-muted me-3" id="import-status-text">
                                        <?php esc_html_e('Importing products...', 'ams-wc-amazon'); ?>
                                    </small>
                                    <div class="badge bg-info text-white" id="import-counter">
                                        <span id="import-completed">0</span> / <span id="import-total">0</span>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <button type="button" class="btn btn-sm btn-outline-info" id="hide-import-indicator">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                        </div>
                        <div class="progress mt-2" style="height: 4px;">
                            <div class="progress-bar bg-info" role="progressbar" id="import-progress-bar" 
                                 style="width: 0%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main Bestsellers Card -->
            <div class="card shadow-sm ams-common-card-fix">
                <div class="card-header bg-light border-bottom">
                    <div class="d-flex align-items-center justify-content-between">
                        <h5 class="mb-0 fw-bold text-dark">
                            <i class="bi bi-trophy text-primary me-2"></i>
                            <?php esc_html_e('Amazon Bestsellers', 'ams-wc-amazon'); ?>
                            <?php 
                            // Get detailed service status for smart badges
                            $services_status = $this->get_proxy_services_status();
                            foreach ($services_status['services'] as $service) {
                                // Create detailed tooltip with symbol explanations
                                $tooltip = $service['title'];
                                if ($service['status'] === 'enabled') {
                                    $tooltip .= ' | Symbols: ';
                                    if (strpos($service['symbols'], '↓') !== false) {
                                        $tooltip .= '↓=Import ';
                                    }
                                    if (strpos($service['symbols'], '↻') !== false) {
                                        $tooltip .= '↻=Update ';
                                    }
                                    if ($service['symbols'] === '○') {
                                        $tooltip .= '○=Configured but no operations';
                                    }
                                } else {
                                    $tooltip .= ' | ✕=Disabled or not configured';
                                }
                            ?>
                                <span class="badge <?php echo esc_attr($service['badge_class']); ?> text-white ms-1" 
                                      title="<?php echo esc_attr($tooltip); ?>"
                                      data-bs-toggle="tooltip" 
                                      data-bs-placement="bottom">
                                    <i class="<?php echo esc_attr($service['icon']); ?> me-1" 
                                       alt="<?php echo esc_attr($service['status'] === 'enabled' ? 'Service enabled' : 'Service disabled'); ?>"></i>
                                    <?php echo esc_html($service['name']); ?>
                                    <small class="ms-1" 
                                           title="<?php 
                                           if ($service['status'] === 'enabled') {
                                               $symbol_tooltip = '';
                                               if (strpos($service['symbols'], '↓') !== false) {
                                                   $symbol_tooltip .= 'Import enabled ';
                                               }
                                               if (strpos($service['symbols'], '↻') !== false) {
                                                   $symbol_tooltip .= 'Update enabled ';
                                               }
                                               if ($service['symbols'] === '○') {
                                                   $symbol_tooltip = 'Configured but no operations enabled';
                                               }
                                               echo esc_attr(trim($symbol_tooltip));
                                           } else {
                                               echo esc_attr('Service disabled or not configured');
                                           }
                                           ?>">
                                        <?php echo esc_html($service['symbols']); ?>
                                    </small>
                                </span>
                            <?php } ?>
                        </h5>
                        <div class="d-flex gap-2 align-items-center">
                            <span class="badge bg-primary px-3 py-2" id="results-count">0 <?php esc_html_e('products found', 'ams-wc-amazon'); ?></span>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <!-- Search Form Section -->
                    <div class="p-4 border-bottom bg-light bg-opacity-25">
                        <div class="row g-3">
                        <!-- Category Filter -->
                        <div class="col-lg-3 col-md-6">
                            <label for="bestsellers-category" class="form-label fw-medium text-dark mb-2">
                                <i class="bi bi-list me-2 text-primary"></i><?php esc_html_e('Category', 'ams-wc-amazon'); ?>
                                <small class="text-muted ms-1" 
                                       title="<?php esc_attr_e('Smart Mix automatically combines bestsellers from popular categories for better results', 'ams-wc-amazon'); ?>"
                                       data-bs-toggle="tooltip">
                                    <i class="bi bi-info-circle"></i>
                                </small>
                            </label>
                            <select name="bestsellers_category" id="bestsellers-category" class="form-select">
                                <option value=""><?php esc_html_e('All Categories (Smart Mix)', 'ams-wc-amazon'); ?></option>
                                <?php
                                // Get Amazon categories for current country
                                $all_country_cat = ams_amazon_departments();
                                $country = get_option('ams_amazon_country');
                                
                                // Special case for China: use 'com' categories
                                if ($country === 'cn') {
                                    $categories = $all_country_cat['com'];
                                } elseif (isset($all_country_cat[$country])) {
                                    $categories = $all_country_cat[$country];
                                } else {
                                    // Fallback to US categories
                                    $categories = $all_country_cat['com'];
                                }
                                
                                // Skip 'All' category as we already have "All Categories"
                                foreach ($categories as $key => $value) {
                                    if ($key === 'All') continue;
                                    echo '<option value="' . esc_attr($key) . '">' . esc_html($value) . '</option>';
                                }
                                ?>
                            </select>
                        </div>
                        
                        <!-- Price Range Filter -->
                        <div class="col-lg-2 col-md-6">
                            <label for="price-range" class="form-label fw-medium text-dark mb-2">
                                <i class="bi bi-currency-euro me-2 text-primary"></i><?php esc_html_e('Price Range', 'ams-wc-amazon'); ?>
                            </label>
                            <select id="price-range" class="form-select">
                                <option value=""><?php esc_html_e('Any Price', 'ams-wc-amazon'); ?></option>
                                <option value="0-25"><?php esc_html_e('Under €25', 'ams-wc-amazon'); ?></option>
                                <option value="25-50"><?php esc_html_e('€25 - €50', 'ams-wc-amazon'); ?></option>
                                <option value="50-100"><?php esc_html_e('€50 - €100', 'ams-wc-amazon'); ?></option>
                                <option value="100-200"><?php esc_html_e('€100 - €200', 'ams-wc-amazon'); ?></option>
                                <option value="200+"><?php esc_html_e('Over €200', 'ams-wc-amazon'); ?></option>
                            </select>
                        </div>
                        
                        <!-- Rating Filter -->
                        <div class="col-lg-2 col-md-6">
                            <label for="rating-filter" class="form-label fw-medium text-dark mb-2">
                                <i class="bi bi-star me-2 text-primary"></i><?php esc_html_e('Min Rating', 'ams-wc-amazon'); ?>
                            </label>
                            <select id="rating-filter" class="form-select">
                                <option value=""><?php esc_html_e('Any Rating', 'ams-wc-amazon'); ?></option>
                                <option value="4.8"><?php esc_html_e('4.8+ Stars (Excellent)', 'ams-wc-amazon'); ?></option>
                                <option value="4.5"><?php esc_html_e('4.5+ Stars (Very Good)', 'ams-wc-amazon'); ?></option>
                                <option value="4.0"><?php esc_html_e('4.0+ Stars (Good)', 'ams-wc-amazon'); ?></option>
                                <option value="3.5"><?php esc_html_e('3.5+ Stars (Above Average)', 'ams-wc-amazon'); ?></option>
                                <option value="3.0"><?php esc_html_e('3.0+ Stars (Average)', 'ams-wc-amazon'); ?></option>
                            </select>
                        </div>
                        

                        <!-- Results Limit -->
                        <div class="col-lg-2 col-md-6">
                            <label for="bestsellers-limit" class="form-label fw-medium text-dark mb-2">
                                <i class="bi bi-list-ol me-2 text-primary"></i><?php esc_html_e('Results', 'ams-wc-amazon'); ?>
                            </label>
                            <select name="bestsellers_limit" id="bestsellers-limit" class="form-select">
                                <?php 
                                $saved_limit = get_option('ams_bestsellers_limit', '20');
                                $limits = [10, 20, 50, 100];
                                foreach ($limits as $limit) {
                                    $selected = ($limit == $saved_limit) ? 'selected' : '';
                                    echo "<option value=\"$limit\" $selected>$limit</option>";
                                }
                                ?>
                            </select>
                        </div>
                        
                        <!-- Action Button -->
                        <div class="col-lg-3 col-md-12">
                            <label class="form-label fw-medium text-dark mb-2">
                                <i class="bi bi-search me-2 text-primary"></i><?php esc_html_e('Action', 'ams-wc-amazon'); ?>
                            </label>
                            <button type="button" class="btn btn-primary w-100" id="browse-bestsellers-btn">
                                <i class="bi bi-trophy me-2"></i><?php esc_html_e('Browse Bestsellers', 'ams-wc-amazon'); ?>
                            </button>
                        </div>
                        </div>
                    </div>
                    
                    <!-- Results Section -->
                    <div class="p-4">
                        <!-- Loading Indicator -->
                        <div id="bestsellers-loading" class="text-center py-5 d-none">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden"><?php esc_html_e('Loading...', 'ams-wc-amazon'); ?></span>
                            </div>
                            <p class="mt-3 text-muted"><?php esc_html_e('Discovering bestsellers...', 'ams-wc-amazon'); ?></p>
                        </div>

                        <!-- Results Header with Filter -->
                        <div id="results-header" class="d-none mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="mb-0 fw-bold text-dark">
                                        <i class="bi bi-grid me-2 text-primary"></i>
                                        <span id="results-count">0 <?php esc_html_e('products', 'ams-wc-amazon'); ?></span>
                                    </h6>
                                </div>
                                <div class="d-flex align-items-center">
                                    <small class="text-muted me-2"><?php esc_html_e('Show Imported:', 'ams-wc-amazon'); ?></small>
                                    <label class="ams-common-toggle-switch">
                                        <input type="checkbox" id="show-imported-toggle" checked>
                                        <span class="ams-common-toggle-slider"></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Results Container -->
                        <div id="bestsellers-results" class="row d-none">
                            <!-- Results will be populated here -->
                        </div>

                        <!-- No Results Message -->
                        <div id="no-bestsellers-results" class="text-center py-5 d-none">
                            <div class="card border-0 bg-warning bg-opacity-10">
                                <div class="card-body py-4">
                        <i class="bi bi-trophy text-warning fa-3x mb-3"></i>
                        <h4 class="text-dark mb-2"><?php esc_html_e('No bestsellers found', 'ams-wc-amazon'); ?></h4>
                        <p class="text-muted mb-3" id="no-results-message"><?php esc_html_e('Try selecting a different category or adjusting your filters to discover top-selling products.', 'ams-wc-amazon'); ?></p>
                        <div class="d-flex justify-content-center gap-2 flex-wrap">
                            <span class="badge bg-light text-dark border"><?php esc_html_e('💡 Tip: Smart Mix combines popular categories', 'ams-wc-amazon'); ?></span>
                            <span class="badge bg-light text-dark border"><?php esc_html_e('🔄 Try different price ranges', 'ams-wc-amazon'); ?></span>
                        </div>
                        
                        <!-- Pagination -->
                        <div id="bestsellers-pagination" class="d-flex justify-content-center mt-4 d-none">
                            <nav aria-label="Bestsellers pagination">
                                <ul class="pagination">
                                    <li class="page-item" id="prev-page">
                                        <a class="page-link" href="#" aria-label="Previous">
                                            <span aria-hidden="true">&laquo;</span>
                                        </a>
                                    </li>
                                    <li class="page-item active" id="current-page">
                                        <span class="page-link">1</span>
                                    </li>
                                    <li class="page-item" id="next-page">
                                        <a class="page-link" href="#" aria-label="Next">
                                            <span aria-hidden="true">&raquo;</span>
                                        </a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            

        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    let currentPage = 1;
    let importQueue = [];
    let importInProgress = false;
    
    // Ensure pagination is hidden on page load
    $('#bestsellers-pagination').addClass('d-none');
    
    // Restore saved toggle state from localStorage
    const savedToggleState = localStorage.getItem('ams_show_imported_toggle');
    if (savedToggleState !== null) {
        const showImported = savedToggleState === 'true';
        $('#show-imported-toggle').prop('checked', showImported);
    }
    
    // Import filter toggle functionality
    $('#show-imported-toggle').on('change', function() {
        const isChecked = $(this).is(':checked');
        // Save state to localStorage
        localStorage.setItem('ams_show_imported_toggle', isChecked);
        filterImportedProducts();
    });
    
    // Hide import indicator
    $('#hide-import-indicator').on('click', function() {
        $('#import-progress-indicator').addClass('d-none');
    });
    
    // Filter products based on import status
    function filterImportedProducts() {
        const showImported = $('#show-imported-toggle').is(':checked');
        const $productCards = $('#bestsellers-results .col-lg-3');
        let visibleCount = 0;
        
        $productCards.each(function() {
            const $card = $(this);
            const $importBtn = $card.find('.wca-import-bestseller');
            const $importedBtn = $card.find('.btn-success:contains("Already Imported"), .btn-success:contains("Imported")');
            const isImported = $importedBtn.length > 0;
            
            if (showImported || !isImported) {
                $card.show();
                visibleCount++;
            } else {
                $card.hide();
            }
        });
        
        // Update results count
        $('#results-count').text(visibleCount + ' <?php esc_html_e('products', 'ams-wc-amazon'); ?>');
    }
    
    // Import progress management
    function showImportProgress() {
        if (!importInProgress && importQueue.length > 0) {
            importInProgress = true;
            $('#import-progress-indicator').removeClass('d-none');
            updateImportProgress();
        }
    }
    
    function updateImportProgress() {
        const completed = importQueue.filter(item => item.status === 'completed' || item.status === 'failed').length;
        const total = importQueue.length;
        const percentage = total > 0 ? Math.round((completed / total) * 100) : 0;
        
        $('#import-completed').text(completed);
        $('#import-total').text(total);
        $('#import-progress-bar').css('width', percentage + '%').attr('aria-valuenow', percentage);
        
        if (completed === total) {
            // All imports completed
            setTimeout(() => {
                $('#import-progress-indicator').addClass('d-none');
                importInProgress = false;
                importQueue = [];
            }, 2000);
        }
    }
    
    function addToImportQueue(asin, title) {
        // Check if already in queue to avoid duplicates
        const existingItem = importQueue.find(item => item.asin === asin);
        if (!existingItem) {
            importQueue.push({
                asin: asin,
                title: title,
                status: 'pending'
            });
            showImportProgress();
        }
    }
    
    function updateImportStatus(asin, status) {
        const item = importQueue.find(item => item.asin === asin);
        if (item) {
            item.status = status;
            updateImportProgress();
        }
    }
    
    // Browse bestsellers button click
    $('#browse-bestsellers-btn').on('click', function() {
        currentPage = 1;
        browseBestsellers();
    });
    

    
    // Category change auto-browse
    $('#bestsellers-category').on('change', function() {
        if ($(this).val()) {
            currentPage = 1;
            browseBestsellers();
        }
    });
    
    // Price range filter change
    $('#price-range').on('change', function() {
        if ($('#bestsellers-category').val()) {
            currentPage = 1;
            browseBestsellers();
        }
    });
    
    // Rating filter change
    $('#rating-filter').on('change', function() {
        if ($('#bestsellers-category').val()) {
            currentPage = 1;
            browseBestsellers();
        }
    });
    

    
    // Save results limit when changed
    $('#bestsellers-limit').on('change', function() {
        const limit = $(this).val();
        
        $.ajax({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: {
                action: 'save_bestsellers_limit',
                nonce: amsbackend.nonce_ams_without_api,
                limit: limit
            },
            success: function(response) {
                if (response.success) {
                    showToast('<?php esc_html_e('Results limit saved successfully!', 'ams-wc-amazon'); ?>', 'success');
                    // Auto-refresh results with new limit if category is selected
                    if ($('#bestsellers-category').val()) {
                        currentPage = 1;
                        browseBestsellers();
                    }
                } else {
                    showToast('<?php esc_html_e('Failed to save results limit', 'ams-wc-amazon'); ?>', 'error');
                }
            },
            error: function() {
                showToast('<?php esc_html_e('Error saving results limit', 'ams-wc-amazon'); ?>', 'error');
            }
        });
    });
    
    // Pagination clicks
    $(document).on('click', '#prev-page a', function(e) {
        e.preventDefault();
        if (currentPage > 1) {
            currentPage--;
            browseBestsellers();
        }
    });
    
    $(document).on('click', '#next-page a', function(e) {
        e.preventDefault();
        currentPage++;
        browseBestsellers();
    });
    
    function browseBestsellers() {
        const category = $('#bestsellers-category').val();
        const resultsLimit = $('#bestsellers-limit').val();
        const priceRange = $('#price-range').val();
        const minRating = $('#rating-filter').val();
        
        // Update loading message based on category selection
        const loadingMessage = category ? 
            '<?php esc_html_e('Discovering bestsellers...', 'ams-wc-amazon'); ?>' : 
            '<?php esc_html_e('Smart-mixing bestsellers from popular categories...', 'ams-wc-amazon'); ?>';
        $('#bestsellers-loading p').text(loadingMessage);
        
        // Show loading
        $('#bestsellers-loading').removeClass('d-none');
        $('#bestsellers-results').addClass('d-none');
        $('#no-bestsellers-results').addClass('d-none');
        $('#bestsellers-pagination').addClass('d-none');
        
        const ajaxData = {
            action: 'browse_bestsellers',
            nonce: amsbackend.nonce_ams_without_api,
            category: category,
            page: currentPage,
            results_limit: resultsLimit
        };

        
        $.ajax({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: ajaxData,
            success: function(response) {
                $('#bestsellers-loading').addClass('d-none');
                
                if (response.success && response.data && response.data.length > 0) {
                    // Apply client-side filters
                    let filteredProducts = applyClientFilters(response.data, priceRange, minRating);
                    
                    // Check if we have filtered results
                    if (filteredProducts.length > 0) {
                        displayBestsellers(filteredProducts);
                        
                        // Show results header
                        $('#results-header').removeClass('d-none');
                        
                        // Apply import filter after displaying results (respects saved toggle state)
                        setTimeout(() => {
                            filterImportedProducts();
                        }, 100);
                        
                        // Show pagination only if we have results and potentially more pages
                        const resultsLimit = parseInt($('#bestsellers-limit').val());
                        if (response.data.length >= resultsLimit || currentPage > 1) {
                            showPagination();
                        } else {
                            $('#bestsellers-pagination').addClass('d-none');
                        }
                    } else {
                        // No results after filtering - show nice message with filter info
                        showNoResultsMessage(priceRange, minRating);
                        $('#results-header').addClass('d-none');
                        $('#bestsellers-pagination').addClass('d-none');
                        $('#bestsellers-results').addClass('d-none');
                    }
                } else {
                    // Update no-results message based on category selection
                    const category = $('#bestsellers-category').val();
                    const noResultsMsg = category ? 
                        '<?php esc_html_e('No bestsellers found in this category. Try a different category or adjust your filters.', 'ams-wc-amazon'); ?>' :
                        '<?php esc_html_e('Unable to load bestsellers at the moment. Please check your proxy service configuration or try again later.', 'ams-wc-amazon'); ?>';
                    $('#no-results-message').text(noResultsMsg);
                    
                    $('#results-header').addClass('d-none');
                    $('#no-bestsellers-results').removeClass('d-none');
                    $('#bestsellers-pagination').addClass('d-none');
                }
            },
            error: function(xhr, status, error) {
                $('#bestsellers-loading').addClass('d-none');
                $('#results-header').addClass('d-none');
                $('#no-bestsellers-results').removeClass('d-none');
                $('#bestsellers-pagination').addClass('d-none');
                
                showToast('<?php esc_html_e('Error loading bestsellers. Please try again.', 'ams-wc-amazon'); ?>', 'error');
            }
        });
    }
    
    function displayBestsellers(products) {
        let html = '';
        
        products.forEach(function(product, index) {
            
            // Create local placeholder if no image
            const imageUrl = product.ImageURL || 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiBmaWxsPSIjZjhmOWZhIi8+PHRleHQgeD0iNTAlIiB5PSI1MCUiIGZvbnQtZmFtaWx5PSJBcmlhbCIgZm9udC1zaXplPSIxNCIgZmlsbD0iIzZjNzU3ZCIgdGV4dC1hbmNob3I9Im1pZGRsZSIgZHk9Ii4zZW0iPk5vIEltYWdlPC90ZXh0Pjwvc3ZnPg==';
            const rankNumber = index + 1;
            
            // Format rating display
                                    const ratingDisplay = product.Rating && parseFloat(product.Rating) > 0 ? 
                            `<div class="d-flex align-items-center">
                                <span class="text-warning me-1">
                                    <i class="bi bi-star"></i>
                                </span>
                                <small class="text-muted">${parseFloat(product.Rating).toFixed(1)}</small>
                                ${product.ReviewCount && parseInt(product.ReviewCount) > 0 ? 
                                    `<small class="text-muted ms-1">(${parseInt(product.ReviewCount).toLocaleString()})</small>` : 
                                    ''
                                }
                            </div>` : 
                            `<small class="text-muted">No rating</small>`;
            
            html += `
                <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                    <div class="card h-100 shadow-sm product-card">
                        <div class="position-relative">
                            <img src="${imageUrl}" 
                                 class="card-img-top" alt="${product.Title}" style="height: 200px; object-fit: contain;">
                            <div class="position-absolute top-0 start-0 m-2">
                                <span class="badge bg-warning text-dark fw-bold">
                                    <i class="bi bi-trophy me-1"></i>#${rankNumber} Bestseller
                                </span>
                            </div>
                        </div>
                        <div class="card-body d-flex flex-column">
                            <h6 class="card-title text-truncate" title="${product.Title}">${product.Title}</h6>
                            <div class="mt-auto">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span class="fw-bold text-primary">€${product.RegularPrice || 'N/A'}</span>
                                    ${ratingDisplay}
                                </div>
                                <div class="d-grid gap-2">
                                    ${product.IsImported ? 
                                        `<button type="button" class="btn btn-success btn-sm" disabled>
                                            <i class="bi bi-check me-2"></i><?php esc_html_e('Already Imported', 'ams-wc-amazon'); ?>
                                        </button>` :
                                        `<button type="button" class="btn btn-primary btn-sm wca-import-bestseller" 
                                                data-asin="${product.ASIN}" 
                                                data-title="${product.Title}"
                                                data-url="${product.DetailPageURL}">
                                            <i class="bi bi-download me-2"></i><?php esc_html_e('Import Product', 'ams-wc-amazon'); ?>
                                        </button>`
                                    }
                                    <a href="${product.DetailPageURL}" target="_blank" class="btn btn-outline-secondary btn-sm">
                                        <i class="bi bi-box-arrow-up-right me-2"></i><?php esc_html_e('View on Amazon', 'ams-wc-amazon'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        });
        
        $('#bestsellers-results').html(html).removeClass('d-none');
    }
    
    function applyClientFilters(products, priceRange, minRating) {
        let filtered = products;
        
        // Apply price range filter
        if (priceRange) {
            const beforePriceFilter = filtered.length;
            filtered = filtered.filter(function(product) {
                // Handle both string and numeric price formats
                let priceStr = product.RegularPrice || product.SalePrice || '';
                if (typeof priceStr === 'number') {
                    priceStr = priceStr.toString();
                }
                const price = parseFloat(priceStr.toString().replace(/[^\d.]/g, '') || 0);
                

                
                let matches = false;
                switch(priceRange) {
                    case '0-25':
                        matches = price > 0 && price <= 25;
                        break;
                    case '25-50':
                        matches = price > 25 && price <= 50;
                        break;
                    case '50-100':
                        matches = price > 50 && price <= 100;
                        break;
                    case '100-200':
                        matches = price > 100 && price <= 200;
                        break;
                    case '200+':
                        matches = price > 200;
                        break;
                    default:
                        matches = true;
                }
                return matches;
            });
        }
        
        // Apply rating filter
        if (minRating) {
            const beforeRatingFilter = filtered.length;
            const minRatingNum = parseFloat(minRating);
            filtered = filtered.filter(function(product) {
                // Handle both string and numeric rating formats
                let ratingValue = product.Rating || 0;
                if (typeof ratingValue === 'string') {
                    ratingValue = parseFloat(ratingValue) || 0;
                }
                const rating = parseFloat(ratingValue);
                const matches = rating >= minRatingNum;
                return matches;
            });
        }
        

        return filtered;
    }
    
    function showNoResultsMessage(priceRange, minRating) {
        $('#no-bestsellers-results').removeClass('d-none');
        
        // Build dynamic filter info message
        let filterInfo = [];
        if (priceRange) {
            let priceText = '';
            switch(priceRange) {
                case '0-25': priceText = '€0-€25'; break;
                case '25-50': priceText = '€25-€50'; break;
                case '50-100': priceText = '€50-€100'; break;
                case '100-200': priceText = '€100-€200'; break;
                case '200+': priceText = '€200+'; break;
            }
            if (priceText) filterInfo.push(`Price: ${priceText}`);
        }
        if (minRating) {
            filterInfo.push(`Rating: ${minRating}+ stars`);
        }
        
        // Update the message if filters are applied
        if (filterInfo.length > 0) {
            const filterText = filterInfo.join(', ');
            $('#no-bestsellers-results .card-body p').html(
                '<?php esc_html_e('No products match your current filters', 'ams-wc-amazon'); ?> (' + filterText + '). ' +
                '<?php esc_html_e('Try adjusting your filters or selecting a different category.', 'ams-wc-amazon'); ?>'
            );
        } else {
            // Reset to default message
            $('#no-bestsellers-results .card-body p').html('<?php esc_html_e('Try selecting a different category or adjusting your filters to discover top-selling products.', 'ams-wc-amazon'); ?>');
        }
    }
    
    function showPagination() {
        $('#current-page span').text(currentPage);
        
        // Show/hide previous button
        if (currentPage > 1) {
            $('#prev-page').removeClass('disabled');
        } else {
            $('#prev-page').addClass('disabled');
        }
        
        // Always show next button for bestsellers (we don't know total pages)
        $('#next-page').removeClass('disabled');
        
        $('#bestsellers-pagination').removeClass('d-none');
    }
    
    // Handle import button clicks
    $(document).on('click', '.wca-import-bestseller', function() {
        const $btn = $(this);
        const asin = $btn.attr('data-asin');
        const title = $btn.attr('data-title');
        
        // Add to import queue for progress tracking
        addToImportQueue(asin, title);
        
        $btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1" role="status"></span><?php esc_html_e('Importing...', 'ams-wc-amazon'); ?>');
        
        // Use exact same AJAX call as working products-search-without-api page
        $.ajax({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: {
                nonce: amsbackend.nonce_ams_without_api,
                action: 'product_import_without_api',
                title: $btn.attr('data-title'),
                img: $btn.attr('data-img'),
                detail_page_url: $btn.attr('data-detail-page-url'),
                asin: $btn.attr('data-asin'),
                amount: $btn.attr('data-amount'),
            },
            timeout: 300000, // 5 minutes
            success: function (response) {
                // Handle both JSON and HTML/text responses (same as working page)
                let responseText = '';
                
                if (typeof response === 'string') {
                    try {
                        let jsonResponse = JSON.parse(response);
                        if (jsonResponse.success && jsonResponse.data) {
                            responseText = jsonResponse.data;
                        } else if (jsonResponse.data) {
                            responseText = jsonResponse.data;
                        } else {
                            responseText = response.trim();
                        }
                    } catch (e) {
                        responseText = response.trim();
                    }
                } else if (response && response.data) {
                    responseText = response.data;
                } else {
                    responseText = response;
                }

                // Check for success indicators in response
                if (responseText.includes('✅') || responseText.includes('Success') || responseText.includes('successfully')) {
                    showToast('<?php esc_html_e('Product imported successfully!', 'ams-wc-amazon'); ?>', 'success');
                    $btn.removeClass('btn-primary').addClass('btn-success')
                        .html('<i class="bi bi-check me-2"></i><?php esc_html_e('Imported', 'ams-wc-amazon'); ?>');
                    updateImportStatus(asin, 'completed');
                    
                    // Apply filter to hide imported products if toggle is off
                    setTimeout(() => {
                        filterImportedProducts();
                    }, 100);
                } else {
                    // Show the actual error message from server
                    const errorMsg = responseText || '<?php esc_html_e('Import failed. Please try again.', 'ams-wc-amazon'); ?>';
                    showToast(errorMsg, 'error');
                    $btn.prop('disabled', false).html('<i class="bi bi-download me-2"></i><?php esc_html_e('Import Product', 'ams-wc-amazon'); ?>');
                    updateImportStatus(asin, 'failed');
                }
            },
            error: function(xhr, status, error) {
                showToast('<?php esc_html_e('Import failed. Please try again.', 'ams-wc-amazon'); ?>', 'error');
                $btn.prop('disabled', false).html('<i class="bi bi-download me-2"></i><?php esc_html_e('Import Product', 'ams-wc-amazon'); ?>');
                updateImportStatus(asin, 'failed');
            }
        });
    });
});
</script>

<script>
// Initialize Bootstrap tooltips for proxy service badges
jQuery(document).ready(function($) {
    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>

<?php include "common-footer.php"; ?>
