<?php
namespace Amazon\Affiliate\Admin;

/**
 * Plugin admin menu handler Class
 *
 * @package Amazon\Affiliate\Admin
 */
class Menu {
    private $setting;
    private $dashboard;
    private $Productsearch;
    private $product_review_import;
    private $product_import_by_url;
    private $products_search_without_api;
    private $bestsellers_page;
    private $logs_page; // New property for logs page
    private $automation_page; // New property for automation page

    /**
     * Menu constructor.
     *
     * @param $setting
     * @param $Productsearch
     * @param $dashboard
     * @param $products_search_without_api
     * @param $product_import_by_url
     * @param $product_review_import
     * @param $bestsellers_page
     * @param $logs_page
     * @param $automation_page
     */
    function __construct($setting, $Productsearch, $dashboard, $products_search_without_api, $product_import_by_url, $product_review_import, $bestsellers_page, $logs_page, $automation_page) {
        $this->setting = $setting;
        $this->dashboard = $dashboard;
        $this->Productsearch = $Productsearch;
        $this->products_search_without_api = $products_search_without_api;
        $this->product_import_by_url = $product_import_by_url;
        $this->product_review_import = $product_review_import;
        $this->bestsellers_page = $bestsellers_page;
        $this->logs_page = $logs_page; // Initialize logs page
        $this->automation_page = $automation_page; // Initialize automation page

        add_action('admin_menu', array($this, 'admin_menu'));
        add_filter('plugin_action_links_affiliate-management-system-woocommerce-amazon/affiliate-management-system-woocommerce-amazon.php', array($this, 'plugin_setting_link'));
    }

    /**
     * Admin Menu register
     */
    public function admin_menu() {
        $capability = 'manage_options';
        $title = esc_html__('Ams Amazon', 'ams-wc-amazon');
        $setting_page_title = esc_html__('Setting', 'ams-wc-amazon');
        $parent_slug = 'wc-amazon-affiliate';
        add_menu_page($title, $title, $capability, $parent_slug, array($this->dashboard, 'dashboard_page'), 'dashicons-amazon');
        
        // Add all submenus back for functionality, but we'll hide them with CSS
        add_submenu_page($parent_slug, esc_html__('Dashboard', 'ams-wc-amazon'), esc_html__('Dashboard', 'ams-wc-amazon'), $capability, $parent_slug, array($this->dashboard, 'dashboard_page'));
        add_submenu_page($parent_slug, esc_html__('Amazon API Import', 'ams-wc-amazon'), esc_html__('Amazon API Import', 'ams-wc-amazon'), $capability, 'wc-product-search', array($this->Productsearch, 'product_page'));
        add_submenu_page($parent_slug, esc_html__('Amazon Product Import - Without API - By Search [All Countries]', 'ams-wc-amazon'), esc_html__('Amazon Product Import - Without API - By Search [All Countries]', 'ams-wc-amazon'), $capability, 'products-search-without-api', array($this->products_search_without_api, 'products_page'));
        add_submenu_page($parent_slug, esc_html__('Amazon Bestsellers [All Countries]', 'ams-wc-amazon'), esc_html__('Amazon Bestsellers [All Countries]', 'ams-wc-amazon'), $capability, 'amazon-bestsellers', array($this->bestsellers_page, 'bestsellers_page'));
        add_submenu_page($parent_slug, esc_html__('Without API - By URL [All Countries]', 'ams-wc-amazon'), esc_html__('Without API - By URL [All Countries]', 'ams-wc-amazon'), $capability, 'product-import-by-url', array($this->product_import_by_url, 'product_import_page'));
        add_submenu_page($parent_slug, esc_html__('Products Review', 'ams-wc-amazon'), esc_html__('Products Review', 'ams-wc-amazon'), $capability, 'product-review-import', array($this->product_review_import, 'product_review_page'));
        add_submenu_page($parent_slug, $setting_page_title, $setting_page_title, $capability, 'wc-product-setting-page', array($this->setting, 'setting_page'));
        
        // Add new submenu for logs
        add_submenu_page($parent_slug, esc_html__('View Logs', 'ams-wc-amazon'), esc_html__('View Logs', 'ams-wc-amazon'), $capability, 'view-logs', array($this->logs_page, 'render_logs_page'));
        
        // Add automation pages as submenus under the plugin parent to avoid null parent_slug warnings
        add_submenu_page($parent_slug, esc_html__('Automation', 'ams-wc-amazon'), esc_html__('Automation', 'ams-wc-amazon'), $capability, 'automation', array($this->automation_page, 'automation_page'));
        
        // Add automation logs page
        add_submenu_page($parent_slug, esc_html__('Automation Logs', 'ams-wc-amazon'), esc_html__('Automation Logs', 'ams-wc-amazon'), $capability, 'automation-logs', array($this, 'automation_logs_page'));
        
        // Add CSS to hide submenu items visually
        add_action('admin_head', array($this, 'hide_submenu_css'));

    }

    /**
     * Automation logs page
     */
    public function automation_logs_page() {
        include_once plugin_dir_path(__FILE__) . 'views/automation-logs.php';
    }

    /**
     * Hide submenu items with CSS
     */
    public function hide_submenu_css() {
        echo '<style>
        /* Completely hide the entire submenu for AMS Amazon */
        #adminmenu li.menu-top.toplevel_page_wc-amazon-affiliate ul.wp-submenu {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            height: 0 !important;
            width: 0 !important;
            overflow: hidden !important;
            pointer-events: none !important;
        }
        
        /* Prevent hover behavior that shows submenu */
        #adminmenu li.menu-top.toplevel_page_wc-amazon-affiliate:hover ul.wp-submenu {
            display: none !important;
            visibility: hidden !important;
        }
        
        /* Remove submenu arrow indicator */
        #adminmenu li.menu-top.toplevel_page_wc-amazon-affiliate .wp-menu-arrow {
            display: none !important;
        }
        
        /* Force single menu item behavior */
        #adminmenu li.menu-top.toplevel_page_wc-amazon-affiliate {
            position: relative;
        }
        
        /* Ensure proper hover color for single menu */
        #adminmenu li.menu-top.toplevel_page_wc-amazon-affiliate:hover {
            background: #2271b1 !important;
        }
        
        /* Remove any submenu-related classes */
        #adminmenu li.menu-top.toplevel_page_wc-amazon-affiliate a.wp-has-submenu:after {
            display: none !important;
        }
        </style>';
    }

    /**
     * Plugin setting page link
     *
     * @param $link
     * @return mixed
     */
    public function plugin_setting_link($link) {
        $new_link = sprintf("<a href='%s'>%s</a>", "admin.php?page=wc-product-setting-page", esc_html__("Setting", "woo-address-auto-complete"));
        $link[] = $new_link;

        return $link;
    }
}