<?php
namespace Amazon\Affiliate;

/**
 * Backend handler Class Admin
 *
 * @package Amazon\Affiliate
 */
class Admin {
    public function __construct() {
        $setting = new Admin\Setting();
        $Productsearch = new Admin\Productsearch();
        $ImportProducts = new Admin\ImportProducts();
        $dashboard = new Admin\Dashboard();
        $license_activation = new Admin\LicenseActivation();
        $products_search_without_api = new Admin\ProductsSearchWithoutApi();
        $product_import_by_url = new Admin\ProductImportByUrl();
        $product_review_import = new Admin\ProductReviewImport();
        $bestsellers_page = new Admin\BestsellersPage();
        $logs_page = new Admin\LogsPage();
        $automation_page = new Admin\AutomationPage(); // Initialize automation page
        $automation_logs = new Admin\AutomationLogs(); // Initialize automation logs

        new Admin\Menu($setting, $Productsearch, $dashboard, $products_search_without_api, $product_import_by_url, $product_review_import, $bestsellers_page, $logs_page, $automation_page);
        $this->dispatch_actions($setting, $Productsearch, $ImportProducts, $dashboard, $license_activation, $products_search_without_api, $product_import_by_url, $product_review_import, $bestsellers_page, $logs_page, $automation_page);
    }

    public function dispatch_actions($setting, $Productsearch, $ImportProducts, $dashboard, $license_activation, $products_search_without_api, $product_import_by_url, $product_review_import, $bestsellers_page, $logs_page, $automation_page) {
        add_action('admin_post_ams_wc_amazon_general_setting', array($setting, 'general_amazon_setting_handler'));
        add_action('admin_post_ams-wc-general-setting', array($setting, 'general_setting'));
        add_action('admin_post_ams_product_cron', array($setting, 'general_ams_product_cron'));
        add_action('admin_post_ams_wc_product_cat_setting', array($setting, 'product_cat_country_setting'));
        add_action('admin_post_ams-wc-review-settings', array($setting, 'review_settings_handler'));
        add_action('wp_ajax_import_products', array($Productsearch, 'import_products'));
        add_action('wp_ajax_wca_import_process', array($Productsearch, 'wca_import_process'));
        add_action('wp_ajax_search_products', array($Productsearch, 'search_products'));
        add_action('wp_ajax_ams_product_import', array($ImportProducts, 'product_import'));
        add_action('wp_ajax_product_update_request', array($ImportProducts, 'product_update_request'));
        add_action('wp_ajax_ams_dashboard_info', array($dashboard, 'dashboard_info'));
        add_action('wp_ajax_ams_license_activation', array($license_activation, 'license_activation'));
        add_action('wp_ajax_ams_license_deactivated', array($license_activation, 'deactivated_license_plugin'));
        add_action('wp_ajax_ams_test_api', array($setting, 'test_api'));
        add_action('wp_ajax_validate_amazon_api', array($setting, 'validate_api_for_search'));
        add_action('wp_ajax_validate_proxy_services', array($setting, 'validate_proxy_services'));
        add_action('wp_ajax_ams_run_speed_test', array($setting, 'ams_run_speed_test'));
        add_action('wp_ajax_ams_clear_speed_cache', array($setting, 'ams_clear_speed_cache'));
        add_action('wp_ajax_ams_test_api_key', array($setting, 'ams_test_api_key'));
        add_action('wp_ajax_search_products_without_api', array($products_search_without_api, 'get_product_list'));
        add_action('wp_ajax_product_import_without_api', array($products_search_without_api, 'product_import_without_api'));
        add_action('wp_ajax_ams_product_import_by_url', array($product_import_by_url, 'product_import_by_url'));
        add_action('wp_ajax_ams_product_review_import', array($product_review_import, 'product_review_import'));

        

        add_action('wp_ajax_ams_get_automation_settings', array($automation_page, 'get_automation_settings'));
        add_action('wp_ajax_ams_save_automation_settings', array($automation_page, 'save_automation_settings'));

        add_action('wp_ajax_ams_bulk_delete_product_reviews', array($product_review_import, 'bulk_delete_product_reviews'));
        
        // Cron hook is already registered in AutomationPage.php - no need to duplicate
        add_action('wp_ajax_save_results_limit', array($this, 'save_results_limit'));
        add_action('wp_ajax_import_product_without_api', array($products_search_without_api, 'product_import_without_api'));
    }


    
    /**
     * AJAX handler for saving results limit and API settings
     */
    public function save_results_limit() {
        // Handle API settings from search page
        if (isset($_POST['products_per_page'])) {
            // Verify nonce for API settings
            if (!wp_verify_nonce($_POST['_wpnonce'], 'wca_search_product')) {
                wp_send_json_error('Security check failed');
                return;
            }
            
            // Check user permissions
            if (!current_user_can('manage_options')) {
                wp_send_json_error('Insufficient permissions');
                return;
            }
            
            // Validate and sanitize API settings
            $products_per_page = intval($_POST['products_per_page']);
            $auto_load_more = intval($_POST['auto_load_more']);
            $max_pages = intval($_POST['max_pages']);
            
            // Validate products per page (PA-API 5 limit is 10)
            if ($products_per_page < 1 || $products_per_page > 10) {
                wp_send_json_error('Products per page must be between 1 and 10');
                return;
            }
            
            // Validate auto load more
            if (!in_array($auto_load_more, [0, 1])) {
                wp_send_json_error('Invalid auto load more setting');
                return;
            }
            
            // Validate max pages
            if ($max_pages < 1 || $max_pages > 10) {
                wp_send_json_error('Max pages must be between 1 and 10');
                return;
            }
            
            // Save the options
            update_option('ams_product_per_page', $products_per_page);
            update_option('ams_auto_load_more', $auto_load_more);
            update_option('ams_max_pages', $max_pages);
            
            wp_send_json_success(array(
                'message' => 'API settings saved successfully',
                'settings' => array(
                    'products_per_page' => $products_per_page,
                    'auto_load_more' => $auto_load_more,
                    'max_pages' => $max_pages
                )
            ));
            return;
        }
        
        // Handle original results limit functionality
        // Verify nonce
        if (!wp_verify_nonce($_POST['nonce'], 'ams_product_import')) {
            wp_die('Security check failed');
        }
        
        // Check user permissions
        if (!current_user_can('manage_options')) {
            wp_send_json_error('Insufficient permissions');
            return;
        }
        
        // Validate and sanitize the results limit
        $results_limit = intval($_POST['results_limit']);
        $allowed_limits = array(5, 10, 20, 50, 100,200,500);
        
        if (!in_array($results_limit, $allowed_limits)) {
            wp_send_json_error('Invalid results limit');
            return;
        }
        
        // Save the option
        $current_value = get_option('ams_results_limit');
        $updated = update_option('ams_results_limit', $results_limit);
        
        // update_option returns false if the value hasn't changed, so check both cases
        if ($updated !== false || $current_value == $results_limit) {
            wp_send_json_success(array(
                'message' => 'Results limit saved successfully',
                'results_limit' => $results_limit
            ));
        } else {
            wp_send_json_error('Failed to save results limit');
        }
    }
}