(function($) {
    'use strict';
    

    
    $.AjaxQueue = function() {
      this.reqs = [];
      this.requesting = false;
    };
    
    $.AjaxQueue.prototype = {
      add: function(req) {
        this.reqs.push(req);
        this.next();
      },
      next: function() {
        if (this.reqs.length == 0)
          return;

        if (this.requesting == true)
          return;

        var req = this.reqs.splice(0, 1)[0];
        var complete = req.complete;
        var self = this;
        if (req._run)
          req._run(req);
        req.complete = function() {
          if (complete)
            complete.apply(this, arguments);
          self.requesting = false;
          self.next();
        }

        this.requesting = true;
        $.ajax(req);
      }
    };

    var queue = new $.AjaxQueue();

    // here code for product filter
    $( '.wca-search-by' ).on( 'change', function () {
        if ( 'keyword' === $( this ).val() ) {
            $( '.wca-keyword' ).show();
            $( '.wca-asin' ).hide();
        } else {
            $( '.wca-keyword' ).hide();
            $( '.wca-asin' ).show();
        }
    });

    $(document).on( 'submit', '.wca-product-import', function ( event ) {
        event.preventDefault();
   		event.stopPropagation();

        $('.wca-loading-icon').show();
        $('.wca-amazon-product').html('');
        // Clear any existing validation messages (now handled by toasts)
        $.ajax( {

            type: 'POST',
            cache: false,
            url: amsbackend.ajax_url,
            data: new FormData(this),
            contentType: false,
            processData:false,
            success: function ( response ) {
                $( '.wca-loading-icon' ).hide();
                if ( true === response.success ) {
                    const response_json = response.data;
                    
                    // Process CSV ASINs automatically - show product cards
                    console.log('CSV Import Response:', response_json);
                    if (response_json && response_json.length > 0) {
                        console.log('Calling processCSVImportResults with:', response_json);
                        processCSVImportResults(response_json);
                        return; // Skip legacy code when using new functionality
                    }
                    
                    // Legacy code for backward compatibility
                    let newArr = [];
                    for( let i = 0; i < response_json.length; i++ ) {
                        newArr = newArr.concat(response_json[i]);
                    }
                    var asinLists = $("<div />").addClass('col-12 asin-list');
                    for( let j = 0; j < newArr.length; j++) {
                        asinLists.append(
                            `<div class="asin-list-item" data-asin="${newArr[j]}">
                                <span class="asin-list-item-icon"></span>
                                <span class="asin-list-item-title">${newArr[j]}</span>
                                <span class="asin-list-item-message"></span>
                            </div>`
                        ); 
                    }
                    asinLists.appendTo(".wca-amazon-product");

                    $.each(response_json, function( index, asins ) {
                        // Make an ajax call
                        $.each(asins, function( i, asin ) {
                            $("div[data-asin='"+asin+"']").find('.asin-list-item-icon').addClass('spinner');
                        });
                        queue.add( {
                            type: 'POST',
                            url: amsbackend.ajax_url,
                            data: {
                                'nonce': amsbackend.check_nonce,
                                'asin': asins.join(),
                                'action': 'wca_import_process',
                            },
            
                            success: function ( res ) {
                                $.each(res.data.success, function( i, asin ) {
                                    $("div[data-asin='"+asin+"']")
                                        .addClass('success')
                                        .find('.asin-list-item-icon')
                                        .removeClass('spinner')
                                        .addClass('success')
                                        .html('<i class="dashicons dashicons-yes-alt"></i>')
                                        .siblings('.asin-list-item-message')
                                        .html('<p>This SKU has been imported successfully!</p>');
                                });
                                $.each(res.data.failed, function( i, asin ) {
                                    $("div[data-asin='"+asin+"']")
                                        .addClass('failed')
                                        .find('.asin-list-item-icon')
                                        .removeClass('spinner')
                                        .addClass('failed')
                                        .html('<i class="dashicons dashicons-dismiss"></i>')
                                        .siblings('.asin-list-item-message')
                                        .html('<p>This SKU has been failed to import. Maybe SKU is wrong or not available!</p>');
                                });
                                $.each(res.data.imported, function( i, asin ) {
                                    $("div[data-asin='"+asin+"']")
                                        .addClass('imported')
                                        .find('.asin-list-item-icon')
                                        .removeClass('spinner')
                                        .addClass('imported')
                                        .html('<i class="dashicons dashicons-yes-alt"></i>')
                                        .siblings('.asin-list-item-message')
                                        .html('<p>This SKU already imported in the store!</p>');
                                }); 
                                $.each(res.data.cancelled, function( i, asin ) {
                                    $("div[data-asin='"+asin+"']")
                                        .addClass('cancelled')
                                        .find('.asin-list-item-icon')
                                        .removeClass('spinner')
                                        .addClass('cancelled')
                                        .html('<i class="dashicons dashicons-warning"></i>')
                                        .siblings('.asin-list-item-message')
                                        .html('<p>This SKU has been cancelled to import. Please check your configuration settings!</p>');
                                });              
                            }
            
                        } );
                    });
                } else {
                    // Otherwise, handle the errors or the messages that were provided by the server, here.
                    const res = response.data.find((_, index) => !index);
                    
                    $( '.wca-amazon-product' ).html( '' );
                    // Show error message as toast
                    if (typeof showToast === 'function') {
                        showToast($(res.message).text(), 'error');
                    }
    
                }
            },
        } );
    });


    var wca_item_page = 1;
    var wca_loading = false;
    var form_data = '';

    //here code is ajax request for get product list
    $( document ).on( 'submit', '.wca-product-search', function ( event ) {
        event.preventDefault();
   		event.stopPropagation();
        
        if( 'keyword' == $('input[type=radio][name=wca_search_by]:checked').val() ) {
            if( '' == $('select[name=ams_amazon_cat]:selected').val() || '' == $('input[name=keyword]').val() ) {
                if (typeof showToast === 'function') {
                    showToast('Both the keyword and category are required fields.', 'error');
                }
                return false;
            }
        } else if ( 'asin' == $('input[type=radio][name=wca_search_by]:checked').val() ) {
            if( '' == $('input[name=asin_id]').val() ) {
                if (typeof showToast === 'function') {
                    showToast('ASIN Number is required.', 'error');
                }
                return false;
            }      
        }

        wca_loading = true;
        wca_item_page = 1;
        form_data = $( this ).serialize();

        // Show the product cards container when search is initiated
        $('.product_cards').removeClass('d-none');
        
        // Show loading state
        $('.wca-amazon-product').html(`
            <div class="col-12">
                <div class="text-center py-5">
                    <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <h5 class="text-muted">Searching for products...</h5>
                    <p class="text-muted">Please wait while we find the best products for you.</p>
                </div>
            </div>
        `);

        $.ajax( {
            type: 'POST',
            url: amsbackend.ajax_url,
            data: form_data + '&item_page=' + wca_item_page,

            success: function ( html ) {
                $( '.wca-loading-icon' ).hide();
                
                // Check if we have results
                if (html.trim() === '' || html.includes('No products found') || html.includes('No results')) {
                    $('.product_cards').addClass('d-none');
                    $('.wca-amazon-product').html(`
                        <div class="col-12">
                            <div class="alert alert-info" role="alert">
                                <h4 class="alert-heading">No Results Found</h4>
                                <p>We couldn't find any products matching your search criteria. Please try adjusting your search terms or filters.</p>
                                <hr>
                                <p class="mb-0">Tips: 
                                    <ul>
                                        <li>Check your spelling</li>
                                        <li>Try more general keywords</li>
                                        <li>Try a different category</li>
                                        <li>Adjust your sort options</li>
                                    </ul>
                                </p>
                            </div>
                        </div>
                    `);
                    $('.loadmore').hide();
                } else {
                    // Show results
                    $('.wca-amazon-product').html( html );
                    $('.loadmore').show();
                    
                    // Apply saved view mode to new results
                    var isWcProductSearch = $('#products-grid').length > 0 && $('#products-container').length === 0;
                    var storageKey = isWcProductSearch ? 'wcaProductViewMode' : 'ams_view_mode';
                    var savedViewMode = localStorage.getItem(storageKey) || 'grid';
                    if (typeof applyViewMode === 'function') {
                        setTimeout(() => {
                            applyViewMode(savedViewMode);
                        }, 100);
                    }
                }
                
                wca_item_page = wca_item_page + 1;
                wca_loading = false;
            }
        } );



        //These codes are written to automatically load the product when scrolling to the bottom of the product page.

        $(document).find( '.loadmore' ).on( 'click', function (event) {
            let thatBtn = $(this);
            $(this).hide();
            if (!wca_loading) {
                if (($(document).height() - $( window ).height()) - $( document.body ).scrollTop() <= 100 ) {
                    wca_loading = true;
                    $( '.wca-loading-icon' ).show();

                    $.ajax( {
                        type: 'POST',
                        url: amsbackend.ajax_url,
                        data: form_data + '&item_page=' + wca_item_page,
                        success: function ( html ) {
                            $( '.wca-loading-icon' ).hide();
                            $( '.wca-amazon-product' ).append( html );
                            $(thatBtn).show();
                            wca_item_page = wca_item_page + 1;
                            wca_loading = false;
                        }
                    } );
                }
            }
        } );
    });

    // CSV Import Processing Function
    function processCSVImportResults(asinChunks) {
        console.log('processCSVImportResults called with:', asinChunks);
        if (!asinChunks || asinChunks.length === 0) {
            console.log('No ASIN chunks to process');
            return;
        }
        
        console.log('Processing ASIN chunks...');
        // Clear existing results and show results section
        $('.wca-amazon-product').html('');
        $('.wca-amazon-product').show();
        
        // Show the results container (it's hidden by default with d-none)
        $('.product_cards').removeClass('d-none').show();
        console.log('Cleared and showed .wca-amazon-product and made .product_cards visible');
        
        // Show loading state
        const totalAsins = asinChunks.flat().length;
        $('.wca-amazon-product').html(`
            <div class="col-12 text-center py-5">
                <div class="spinner-border text-primary mb-3" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <h5 class="text-muted" id="csv-loading-message">Processing ${totalAsins} ASINs from CSV...</h5>
                <div class="progress mt-3" style="height: 6px;">
                    <div class="progress-bar" role="progressbar" style="width: 0%" id="csv-progress-bar"></div>
                </div>
            </div>
        `);
        
        // Process each chunk sequentially
        processCSVChunks(asinChunks, 0);
    }

    // Process CSV ASIN chunks sequentially
    function processCSVChunks(chunks, chunkIndex) {
        if (chunkIndex >= chunks.length) {
            // All chunks processed - hide loading
            $('.wca-amazon-product .col-12.text-center.py-5').remove();
            return;
        }

        const currentChunk = chunks[chunkIndex];
        const asinString = currentChunk.join(',');
        const progress = ((chunkIndex + 1) / chunks.length) * 100;
        
        // Update loading message and progress
        $('#csv-loading-message').text(`Processing chunk ${chunkIndex + 1} of ${chunks.length}...`);
        $('#csv-progress-bar').css('width', progress + '%');

        // Make AJAX call to get products for this chunk
        console.log('Making AJAX call for chunk:', currentChunk);
        $.ajax({
            url: amsbackend.ajax_url,
            type: 'POST',
            data: {
                action: 'search_products',
                wca_search_by: 'asin',
                asin_id: asinString,
                _wpnonce: $('input[name="_wpnonce"]').val()
            },
            success: function(response) {
                console.log('AJAX Success for chunk:', currentChunk, 'Response:', response);
                if (response) {
                    // Remove loading state if this is the first chunk
                    if (chunkIndex === 0) {
                        $('.wca-amazon-product .col-12.text-center.py-5').remove();
                        console.log('Removed loading state');
                    }
                    
                    // Append products to results
                    $('.wca-amazon-product').append(response);
                    console.log('Appended response to .wca-amazon-product');
                    
                    // Update results count
                    const currentCount = $('.wca-amazon-product .col-xl-3').length;
                    $('#results-count').text(`${currentCount} products found`);
                    
                    // Apply saved view preference to new products
                    var isWcProductSearch = $('#products-grid').length > 0 && $('#products-container').length === 0;
                    var storageKey = isWcProductSearch ? 'wcaProductViewMode' : 'ams_view_mode';
                    const savedViewMode = localStorage.getItem(storageKey) || 'grid';
                    if (typeof applyViewMode === 'function') {
                        setTimeout(() => {
                            applyViewMode(savedViewMode);
                        }, 100);
                    }
                } else {
                    console.log('No response received');
                }
                
                // Process next chunk after a short delay
                setTimeout(() => {
                    processCSVChunks(chunks, chunkIndex + 1);
                }, 500);
            },
            error: function(xhr, status, error) {
                console.error('Error processing ASIN chunk:', currentChunk, 'Status:', status, 'Error:', error);
                console.error('XHR Response:', xhr.responseText);
                // Continue with next chunk even if this one fails
                setTimeout(() => {
                    processCSVChunks(chunks, chunkIndex + 1);
                }, 500);
            }
        });
    }

    $(document).on('click', '.wca-add-to-import', function(){

    	event.preventDefault();

			event.stopPropagation();

       

        $(document).find( this ).prop( 'disabled', true);

        var wca_button = this;

        var data_asin = $( this ).attr( 'data-asin' );

        console.log(data_asin);

        // return false;

        $( wca_button ).html( '<span class="spinner-border spinner-border-sm me-1" role="status"></span>' + amsbackend.ams_t_import );

        queue.add( {

            type: 'POST',

            url: amsbackend.ajax_url,

            beforeSend: function(msg){

		    	$(document).find( this ).prop( 'disabled', true);

		    },

            data: {

                'nonce': amsbackend.check_nonce,

                'asin': data_asin,

                'action': 'ams_product_import',

            },



            success: function ( html ) {
                
                $( '.wca-loading-icon' ).hide();

                $( wca_button ).html( html );

                 $(document).find( '.wca-add-to-import' ).prop( 'disabled', false);

            }

        } );
    });

    //These codes are written for product import
    function wca_product_import() {
    }

    //These codes are written to bring dashboard information
    if ( true == amsbackend.ams_dashboard ) {
        setInterval( function(){
            dashboard_info();
        }, 5000 );

        function dashboard_info() {
            $.ajax({
                type: 'POST',
                url: amsbackend.ajax_url,
                data: {
                    'nonce_ams_dashboard_info': amsbackend.nonce_ams_dashboard_info,
                    'action': 'ams_dashboard_info',
                },
                success: function(data) {
                    $('#wca-products-count').html(data.products_count);
                    $('#wca-total-view-count').html(data.total_view_count);
                    $('#wca-total-product-added-to-cart').html(data.total_product_added_to_cart);
                    $('#wca-total-product-direct-redirected').html(data.total_product_direct_redirected);
                    $('#wca-total-product-search').html(data.products_search_count);
                }
            });
        }

    }

    // Function to update license alert visibility
    function updateLicenseAlert(show) {
        var $headerAlert = $('#license-header-alert');
        
        if (show) {
            // First, remove any old/conflicting license alerts
            $('.alert-warning:contains("license")').not('#license-header-alert').remove();
            $('.alert-danger:contains("license")').not('#license-header-alert').remove();
            
            // Show the header alert
            if ($headerAlert.length > 0) {
                // Remove d-none and ensure it's visible
                $headerAlert.removeClass('d-none').show();
                // Add show class for Bootstrap fade effect
                setTimeout(function() {
                    $headerAlert.addClass('show');
                }, 10);
            }
        } else {
            // Hide the header alert
            if ($headerAlert.length > 0) {
                $headerAlert.removeClass('show').addClass('d-none');
            }
            // Also remove any other license alerts
            $('.alert-warning:contains("license")').not('#license-header-alert').remove();
            $('.alert-danger:contains("license")').not('#license-header-alert').remove();
        }
    }

// Activation function
jQuery(document).on('click', '.wca-activation-btn, .ams-dashboard-license-card .btn-primary', function(event) {
    event.preventDefault();
    event.stopPropagation();
    var wca_purchase_code = $('.wca-purchase-code-input').val() || $('#purchase_code').val();
    if (wca_purchase_code.trim() === '') {
        $('.wca-purchase-massage').html("<p class='wca-error'>Please enter a purchase code.</p>");
        return;
    }
    $('.wca-purchase-massage').html("<p class='success'>Activating...</p>");
    $.ajax({
        type: 'POST',
        url: amsbackend.ajax_url,
        data: {
            'nonce': amsbackend.check_nonce,
            'action': 'ams_license_activation',
            'purchase_code': wca_purchase_code,
        },
        success: function(response) {
            var data;
            try {
                data = JSON.parse(response);
            } catch (e) {
                console.error("Error parsing JSON response:", e);
                $('.wca-purchase-massage').html("<p class='wca-error'>An unexpected error occurred. Please try again.</p>");
                return;
            }
            if (data.status === 'success') {
                // Update license status
                $('#wca_license_activation').html(data.license_status);
                // Update UI to reflect activated state
                $('#license-status-badge')
                    .removeClass('bg-warning text-dark')
                    .addClass('bg-success')
                    .html('<i class="fas fa-check-circle me-1"></i><span id="license-status-text">Active</span>');
                
                $('.wca-purchase-code-input, #purchase_code').prop('disabled', true);
                
                // Replace activation button with deactivation button
                $(this).removeClass('btn-primary wca-activation-btn')
                    .addClass('btn-outline-danger ams-deactivated')
                    .html('<i class="bi bi-power"></i>');
                // Hide license alert
                updateLicenseAlert(false);
                // Hide any error messages
                $('.error').hide();
                // Hide license warning alerts
                $('.alert-warning:contains("license")').fadeOut();
                
                // Trigger custom event for dashboard updates
                $(document).trigger('licenseActivated');
                
                // If we're on the dashboard, refresh after a short delay to show updated data
                if ($('.ams-dashboard-license-card').length) {
                    // Show refresh notification - force green toast
                    console.log('showToast function available:', typeof showToast === 'function');
                    
                    // Create a guaranteed green toast manually
                    var successToast = $('<div class="toast align-items-center text-white bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">')
                        .css({
                            position: 'fixed',
                            top: '50px',
                            right: '20px',
                            zIndex: '999999'
                        })
                        .html('<div class="d-flex"><div class="toast-body"><i class="bi bi-check-circle me-2"></i>License activated! Refreshing dashboard...</div><button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button></div>');
                    
                    $('body').append(successToast);
                    
                    // Initialize Bootstrap toast and show it
                    if (typeof bootstrap !== 'undefined' && bootstrap.Toast) {
                        var bsToast = new bootstrap.Toast(successToast[0]);
                        bsToast.show();
                        
                        // Remove after hiding
                        successToast[0].addEventListener('hidden.bs.toast', function() {
                            successToast.remove();
                        });
                    } else {
                        // Fallback without Bootstrap
                        successToast.fadeIn();
                        setTimeout(function() { 
                            successToast.fadeOut(function() {
                                successToast.remove();
                            });
                        }, 3000);
                    }
                    
                    // Update the license message to show refresh is coming
                    setTimeout(function() {
                        $('.ams-dashboard-license-card .text-muted').last().html(
                            '<span class="text-info"><i class="bi bi-arrow-clockwise me-1"></i>Refreshing dashboard...</span>'
                        );
                    }, 1000);
                    
                    setTimeout(function() {
                        updateLicenseCardAfterActivation();
                    }, 1000); // 1 second delay to show refresh message
                }
                
                // After successful activation, show a styled success alert
                $('.wca-license-success-alert').html('<div class="alert alert-success alert-dismissible fade show" role="alert" style="margin-top:10px;">\
  <i class="fas fa-check-circle me-2"></i> CodeCanyon plugin activation success.\
  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>\
</div>').show();
                // Remove any red alert (danger) after activation
                $('.alert-danger.alert-dismissible').remove();
                setTimeout(function() { $('.wca-license-success-alert').fadeOut(); }, 4000);
            } else {
                // If activation failed, show the error message
                if ($('.wca-purchase-massage').length) {
                    $('.wca-purchase-massage').html("<p class='wca-error'>" + (data.message || "Activation failed. Please try again.") + "</p>");
                }
                
                // Dashboard error handling for invalid license
                if ($('.ams-dashboard-license-card').length) {
                    // Show red error toast for invalid license
                    var errorToast = $('<div class="toast align-items-center text-white bg-danger border-0" role="alert">')
                        .css({
                            position: 'fixed',
                            top: '50px',
                            right: '20px',
                            zIndex: '999999'
                        })
                        .html('<div class="d-flex"><div class="toast-body"><i class="bi bi-exclamation-triangle me-2"></i>' + (data.message || 'Invalid license key. Please check and try again.') + '</div></div>');
                    
                    $('body').append(errorToast);
                    errorToast.fadeIn();
                    setTimeout(function() { 
                        errorToast.fadeOut(function() {
                            errorToast.remove();
                        });
                    }, 5000); // Show error longer (5 seconds)
                    
                    // Update license message to show error
                    $('.ams-dashboard-license-card .text-muted').last().html(
                        '<span class="text-danger"><i class="bi bi-exclamation-triangle me-1"></i>' + (data.message || 'Invalid license key') + '</span>'
                    );
                }
            }
        },
        error: function(xhr, status, error) {
            console.error("Error during activation:", status, error);
            
            if ($('.wca-purchase-massage').length) {
                $('.wca-purchase-massage').html("<p class='wca-error'>An error occurred during activation. Please try again.</p>");
            }
            
            // Dashboard AJAX error handling
            if ($('.ams-dashboard-license-card').length) {
                var errorToast = $('<div class="toast align-items-center text-white bg-danger border-0" role="alert">')
                    .css({
                        position: 'fixed',
                        top: '50px',
                        right: '20px',
                        zIndex: '999999'
                    })
                    .html('<div class="d-flex"><div class="toast-body"><i class="bi bi-exclamation-triangle me-2"></i>Network error. Please check your connection and try again.</div></div>');
                
                $('body').append(errorToast);
                errorToast.fadeIn();
                setTimeout(function() { 
                    errorToast.fadeOut(function() {
                        errorToast.remove();
                    });
                }, 5000);
            }
        }
    });
});

// Function to update license card data after deactivation (moved outside jQuery scope)
function updateLicenseCardAfterDeactivation() {
        // Update license status badge
        $('#license-status-badge')
            .removeClass('status-active')
            .addClass('status-badge status-inactive')
            .css({
                'background-color': '#dc3545',
                'color': 'white',
                'padding': '4px 8px',
                'border-radius': '12px',
                'font-size': '11px',
                'font-weight': '600',
                'text-transform': 'uppercase',
                'letter-spacing': '0.5px'
            });
        $('#license-status-text').text('INACTIVE');
        
        // Update license status info section
        $('#license-status-info').html(
            '<small class="text-muted" id="license-status-subtext">Not activated</small>'
        );
        
        // Update license message below input (the alert structure)
        $('#license-message-container').html(`
            <div class="alert alert-info border-0 py-2 px-3 mb-0" role="alert">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 me-2">
                        <div class="bg-info bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                            <i class="bi bi-key-fill text-info"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="alert-heading mb-0 fw-semibold text-info">
                            License Required
                        </h6>
                        <small class="text-info-emphasis">
                            Enter your CodeCanyon purchase code below to activate the plugin.
                        </small>
                    </div>
                </div>
            </div>
        `);
        
        // Clear license input field
        $('#purchase_code').val('').prop('disabled', false);
        
        // Update button to activation state
        $('.ams-dashboard-license-card .btn-outline-danger')
            .removeClass('btn-outline-danger ams-deactivated')
            .addClass('btn-primary')
            .html('<i class="bi bi-check"></i>');
        
        // Show the license alert in header using the common function
        updateLicenseAlert(true);
        
        // Trigger custom event for any other listeners
        $(document).trigger('licenseDeactivated');
    }

// Function to update license card data after activation (moved outside jQuery scope)
function updateLicenseCardAfterActivation() {
        // Update license status badge
        $('#license-status-badge')
            .removeClass('status-inactive')
            .addClass('status-badge status-active')
            .css({
                'background-color': '#198754',
                'color': 'white',
                'padding': '4px 8px',
                'border-radius': '12px',
                'font-size': '11px',
                'font-weight': '600',
                'text-transform': 'uppercase',
                'letter-spacing': '0.5px'
            });
        $('#license-status-text').text('ACTIVE');
        
        // Update license status info section
        $('#license-status-info').html(
            '<small class="text-success d-block" id="license-status-subtext"><i class="bi bi-check-circle me-1"></i>Licensed</small>' +
            '<small class="text-muted">' + window.location.hostname + '</small>'
        );
        
        // Update license message below input (the alert structure)
        $('#license-message-container').html(`
            <div class="alert alert-success border-0 py-2 px-3 mb-0" role="alert">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 me-2">
                        <div class="bg-success bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center" style="width: 32px; height: 32px;">
                            <i class="bi bi-check-circle-fill text-success"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="alert-heading mb-0 fw-semibold text-success">
                            License Active
                        </h6>
                        <small class="text-success-emphasis">
                            Your license is active. Thank you for your purchase!
                        </small>
                    </div>
                </div>
            </div>
        `);
        
        // Disable license input field
        $('#purchase_code').prop('disabled', true);
        
        // Update button to deactivation state
        $('.ams-dashboard-license-card .btn-primary')
            .removeClass('btn-primary')
            .addClass('btn-outline-danger ams-deactivated')
            .html('<i class="bi bi-power"></i>');
        
        // Hide the existing license alert in header
        var $alertToHide = $('.container-fluid .alert-warning, .alert-warning');
        
        if ($alertToHide.length > 0) {
            // Don't remove from DOM, just hide it so we can show it again later
            $alertToHide.hide().addClass('d-none').removeClass('show');
        }
        
        // Trigger custom event for any other listeners
        $(document).trigger('licenseActivated');
    }

 // Modified deactivation function
jQuery(document).on('click', '.ams-deactivated', function(event) {
    event.preventDefault();
    event.stopPropagation();
    var this_el = this;
    
    // Create a custom confirmation modal
    var confirmModal = $(`
        <div class="modal fade" id="deactivateConfirmModal" tabindex="-1" aria-labelledby="deactivateConfirmModalLabel">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-warning text-dark">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                                <i class="fas fa-exclamation-triangle fs-4"></i>
                            </div>
                            <div>
                                <h5 class="modal-title mb-0" id="deactivateConfirmModalLabel">
                                    Confirm License Deactivation
                                </h5>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex align-items-start">
                            <i class="fas fa-info-circle text-info me-3 mt-1"></i>
                            <div>
                                <p class="mb-2"><strong>Are you sure you want to deactivate your license?</strong></p>
                                <p class="text-muted mb-0 small">
                                    Deactivating your license will:
                                </p>
                                <ul class="text-muted small mt-2 mb-0">
                                    <li>Disable plugin functionality</li>
                                    <li>Show license activation alerts</li>
                                    <li>Require re-activation to use features</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-2"></i>Cancel
                        </button>
                        <button type="button" class="btn btn-warning" id="confirmDeactivate">
                            <i class="fas fa-power-off me-2"></i>Yes, Deactivate License
                        </button>
                    </div>
                </div>
            </div>
        </div>
    `);
    
    // Remove any existing modal
    $('#deactivateConfirmModal').remove();
    
    // Add modal to body
    $('body').append(confirmModal);
    
    // Show modal
    var modal = new bootstrap.Modal(document.getElementById('deactivateConfirmModal'));
    modal.show();
    
    // Handle confirmation
    $('#confirmDeactivate').on('click', function() {
        // Remove focus from the button before hiding modal to prevent accessibility warning
        $(this).blur();
        modal.hide();
        // Continue with deactivation
        performDeactivation(this_el);
    });
    
    // Handle modal close and focus management
    $('#deactivateConfirmModal').on('hide.bs.modal', function() {
        // Remove focus from any focused element inside modal before hiding
        $(this).find(':focus').blur();
    });
    
    $('#deactivateConfirmModal').on('hidden.bs.modal', function() {
        $(this).remove();
    });
    
    // Define the deactivation function
    function performDeactivation(this_el) {
        $(this_el).html("Deactivating...");
        $('.wca-purchase-massage').html("<p class='success'>Deactivating...</p>");
        
        $.ajax({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: {
                'nonce': amsbackend.nonce_ams_de_activated,
                'action': 'ams_license_deactivated',
            },
            success: function(response) {
                var data;
                try {
                    data = JSON.parse(response);
                } catch (e) {
                    console.error("Error parsing JSON response:", e);
                    $('.wca-purchase-massage').html("<p class='wca-error'>An unexpected error occurred. Please try again.</p>");
                    $(this_el).html('<i class="fas fa-power-off"></i>');
                    return;
                }
                
                if (data.status === 'success') {
                    // Handle settings page updates
                    if ($('.wca-purchase-massage').length) {
                        $('.wca-purchase-code-input').prop('disabled', false).val('');
                        $(this_el)
                            .removeClass('btn-outline-danger ams-deactivated')
                            .addClass('btn-primary')
                            .html('<i class="bi bi-check"></i>');
                    }
                    
                    // Handle dashboard updates
                    if ($('.ams-dashboard-license-card').length) {
                        // Show green success toast for deactivation
                        var deactivateToast = $('<div class="toast align-items-center text-white bg-success border-0" role="alert">')
                            .css({
                                position: 'fixed',
                                top: '50px',
                                right: '20px',
                                zIndex: '999999'
                            })
                            .html('<div class="d-flex"><div class="toast-body"><i class="bi bi-check-circle me-2"></i>License deactivated successfully!</div></div>');
                        
                        $('body').append(deactivateToast);
                        deactivateToast.fadeIn();
                        setTimeout(function() { 
                            deactivateToast.fadeOut(function() {
                                deactivateToast.remove();
                            });
                        }, 3000);
                        
                        // Update license card data via AJAX instead of page refresh
                        setTimeout(function() {
                            updateLicenseCardAfterDeactivation();
                        }, 500); // Reduced delay for faster response
                    }
                    
                    // Show deactivation success alert and clear info message
                    $('.wca-license-success-alert').html('<div class="alert alert-success alert-dismissible fade show" role="alert" style="margin-top:10px;">\
                      <i class="fas fa-check-circle me-2"></i> CodeCanyon plugin de-activation success.\
                      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>\
                    </div>').show();
                    $('.wca-purchase-massage').html('');
                    setTimeout(function() {
                      $('.wca-purchase-massage').html('<i class="fas fa-info-circle me-1" id="license-info-icon"></i>Enter your CodeCanyon purchase code to activate.');
                    }, 1500);
                    setTimeout(function() {
                      $('.wca-license-success-alert').fadeOut();
                    }, 4000);

                    // Trigger custom event for dashboard updates
                    $(document).trigger('licenseDeactivated');
                } else {
                    // If deactivation failed, show the error message
                    $('.wca-purchase-massage').html("<p class='wca-error'>" + (data.message || "Deactivation failed. Please try again.") + "</p>");
                    $(this_el).html('<i class="fas fa-power-off"></i>');
                }
            },
            error: function(xhr, status, error) {
                console.error("Error during deactivation:", status, error);
                $('.wca-purchase-massage').html("<p class='wca-error'>An error occurred during deactivation. Please try again.</p>");
                $(this_el).html('<i class="fas fa-power-off"></i>');
            }
        });
    }
});

    // Check license status on page load (optional, if you want to ensure consistency)
    jQuery(document).ready(function($) {
        // Listen for license activation events to update dashboard status
        $(document).on('licenseActivated', function() {
            // Update dashboard license status with proper styling
            $('#license-status-text').text('Active');
            $('#license-status-subtext')
                .removeClass('status-inactive')
                .addClass('status-badge status-active')
                .text('Activated');
            
            // Hide license alert
            updateLicenseAlert(false);
        });
        
    });

// Test Amazon API when the test button is clicked
jQuery(document).ready(function($) {
    // Handle test API button
    $('.ams-test-api-btn').on('click', function(event) {
        event.preventDefault();  // Prevent the default form submit action
        event.stopPropagation(); // Stop the event from propagating up the DOM
        
        // Show loading message in the right column console
        $('#api-test-results').show();
        $('#api-test-output').html(
            '<div class="d-flex align-items-center text-light">' +
            '<div class="spinner-border spinner-border-sm text-success me-2" role="status">' +
            '<span class="visually-hidden">Loading...</span>' +
            '</div>' +
            '<span class="text-success">' + amsbackend.ams_t_testing_api + '</span>' +
            '</div>'
        );
        
        // Scroll to the test results area
        $('#api-status-window').scrollTop($('#api-status-window')[0].scrollHeight);
        
        // Disable the button
        $(this).prop('disabled', true);
        
        // Perform the AJAX POST request
        $.ajax({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: {
                nonce: amsbackend.ams_test_api,
                action: 'ams_test_api',
            },
            success: function(data) {
                // Display the result data in the right column console
                $('#api-test-output').html(data);
                
                // Scroll to show the results
                $('#api-status-window').scrollTop($('#api-status-window')[0].scrollHeight);
                
                // Update status message
                $('#api-status-message').text('API test completed');
            },
            error: function() {
                // Handle errors in the right column console
                $('#api-test-output').html(
                    '<div class="alert alert-danger text-light border border-danger">' +
                    '<i class="fas fa-exclamation-triangle me-2"></i>' +
                    'Error processing API test request.' +
                    '</div>'
                );
                
                // Update status message
                $('#api-status-message').text('API test failed');
                
                // Scroll to show the error
                $('#api-status-window').scrollTop($('#api-status-window')[0].scrollHeight);
            },
            complete: function() {
                // Re-enable the button after the request is complete
                $('.ams-test-api-btn').prop('disabled', false);
            }
        });
    });
});



    //These codes written for plugin accordion
    var wca_acc = document.getElementsByClassName( 'wca-accordion' );
    var i;
    for ( i = 0; i < wca_acc.length; i++ ) {

        wca_acc[ i ].addEventListener( 'click', function () {

            this.classList.toggle( 'wca-active' );


            /* Toggle between hiding and showing the wca-active panel */

            var panel = this.nextElementSibling;

            if ( panel.style.display === 'block' ) {

                panel.style.display = 'none';

            } else {

                panel.style.display = 'block';

            }

        } );
    }
    /**
     * Products search without api
     */


//product-without-api-search//
var searchTimer;
var lastSearchParams = {};

function debounce(func, wait) {
    var timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

function performSearch(formData, forceRefresh = false) {
    if (!forceRefresh && JSON.stringify(formData) === JSON.stringify(lastSearchParams)) {
        return; // Avoid duplicate searches
    }
    
    // Store current brand selection in localStorage before search
    const currentBrand = $('#brand-filter').val() || '';
    if (currentBrand) {
        localStorage.setItem('ams_selected_brand', currentBrand);
    }
    lastSearchParams = formData;

    $('.wca-loading-icon').show();
    
    // Show loading state in the container for real-time filtering
    if ($('.product_cards').hasClass('d-none')) {
        $('.product_cards').removeClass('d-none');
        $('.wca-amazon-product').html(`
            <div class="col-12 d-flex justify-content-center">
                <div class="text-center py-5">
                    <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <h5 class="text-muted mb-2">Searching for products...</h5>
                    <p class="text-muted mb-0">Please wait while we find the best products for you.</p>
                </div>
            </div>
        `);
    } else {
        // Show smaller loading indicator for existing results
        $('.wca-amazon-product').html(`
            <div class="col-12 d-flex justify-content-center">
                <div class="text-center py-4">
                    <div class="spinner-border text-primary mb-2" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="text-muted mb-0">Updating results...</p>
                </div>
            </div>
        `);
    }
    
    // Debug: Log what's being sent via AJAX

    
    $.ajax({
        type: 'POST',
        url: amsbackend.ajax_url,
        data: formData,
        dataType: "json",
        success: function(response) {
            $('.wca-loading-icon').hide();
            if (response.html.trim() === '') {
                // No results found - show the container but hide view controls
                $('.product_cards').removeClass('d-none');
                $('#view-mode-controls').addClass('d-none');
                $('#results-info').addClass('d-none');
                $('.wca-amazon-product').html(`
                    <div class="col-12">
                        <div class="alert alert-info" role="alert">
                            <h4 class="alert-heading">No Results Found</h4>
                            <p>We couldn't find any products matching your search criteria. Please try adjusting your search terms or filters.</p>
                            <hr>
                            <p class="mb-0">Tips: 
                                <ul>
                                    <li>Check your spelling</li>
                                    <li>Try more general keywords</li>
                                    <li>Adjust your price range</li>
                                    <li>Try a different category</li>
                                    <li>Adjust your star rating filter</li>
                                </ul>
                            </p>
                        </div>
                    </div>
                `);
                $('.loadmore').hide();
            } else {
                // Show the product cards container and display results
                $('.product_cards').removeClass('d-none');
                $('.wca-amazon-product').html(response.html);
                $('.loadmore').show();
                
                // Show view mode controls when results are available
                $('#view-mode-controls').removeClass('d-none');
                
                // Apply saved view mode to new results
                var isWcProductSearch = $('#products-grid').length > 0 && $('#products-container').length === 0;
                var storageKey = isWcProductSearch ? 'wcaProductViewMode' : 'ams_view_mode';
                var savedViewMode = localStorage.getItem(storageKey) || 'grid';
                
                applyViewMode(savedViewMode);
                
                // Update and show results count
                updateResultsDisplay(response.product_count || 0, formData);
                
                // Initialize filters for new results
                setTimeout(function() {
                    populateBrandFilter();
                    updateResultsCount();
                }, 100);
            }
            wca_loading = false;
        }
    });
}

var debouncedSearch = debounce(performSearch, 500);

function updateResultsDisplay(productCount, formData) {
    // Show results info section
    $('#results-info').removeClass('d-none');
    
    // Update product count text
    const countText = productCount === 1 ? 
        `Found ${productCount} product` : 
        `Found ${productCount} products`;
    $('#results-count-text').text(countText);
    
    // Build filter status text
    let filterParts = [];
    
    if (formData.ams_amazon_cat && formData.ams_amazon_cat !== '') {
        filterParts.push(`Category: ${formData.ams_amazon_cat}`);
    }
    if (formData.min_price || formData.max_price) {
        let priceFilter = 'Price: ';
        if (formData.min_price && formData.max_price) {
            priceFilter += `${formData.min_price} - ${formData.max_price}`;
        } else if (formData.min_price) {
            priceFilter += `from ${formData.min_price}`;
        } else if (formData.max_price) {
            priceFilter += `up to ${formData.max_price}`;
        }
        filterParts.push(priceFilter);
    }
    if (formData.star_rating && formData.star_rating !== '') {
        filterParts.push(`Min Rating: ${formData.star_rating}+ stars`);
    }
    if (formData.variant_type && formData.variant_type !== '') {
        const variantText = formData.variant_type === 'simple' ? 'Simple Products' : 'Variable Products';
        filterParts.push(`Type: ${variantText}`);
    }
    // Check for active brand filter (client-side)
    const activeBrand = $('#brand-filter').val();
    if (activeBrand && activeBrand !== '') {
        filterParts.push(`Brand: ${activeBrand}`);
    }
    if (formData.sort_by && formData.sort_by !== 'relevance') {
        const sortText = formData.sort_by.replace('-', ' ').replace(/\b\w/g, l => l.toUpperCase());
        filterParts.push(`Sort: ${sortText}`);
    }
    
    const filterStatusText = filterParts.length > 0 ? 
        filterParts.join(' • ') : 
        'No filters applied';
    
    $('#filter-status').text(filterStatusText);
}

function populateBrandFilter() {
    // Extract brands from current results
    const allProductCards = $('.product-card');
    const brands = new Map();
    
    allProductCards.each(function() {
        const brandElement = $(this).find('.brand-section');
        if (brandElement.length > 0) {
            const brand = brandElement.attr('data-brand') || '';
            if (brand && brand !== '') {
                brands.set(brand, (brands.get(brand) || 0) + 1);
            }
        }
    });
    
    // Clear existing options (except "All Brands")
    const brandSelect = $('#brand-filter');
    brandSelect.find('option:not(:first)').remove();
    
    // Sort brands alphabetically and add to dropdown
    const sortedBrands = Array.from(brands.entries()).sort((a, b) => a[0].localeCompare(b[0]));
    
    sortedBrands.forEach(([brand, count]) => {
        const option = $('<option></option>')
            .attr('value', brand)
            .text(`${brand} (${count})`);
        brandSelect.append(option);
    });
}



function getFormData() {
    var $categorySelect = $('select[name=ams_amazon_cat]');
    var selectedCategory = $categorySelect.val();
    var keyword = $('input[name=keyword]').val().trim();

    var selectedBrand = $('#brand-filter').val() || '';

    var formData = {
        action: "search_products_without_api",
        nonce: amsbackend.nonce_ams_without_api,
        ams_keyword: keyword,
        ams_amazon_cat: selectedCategory,
        ams_amazon_page: 1,
        min_price: $('#min_price').val(),
        max_price: $('#max_price').val(),
        title_search: $('#title_search').val(),
        star_rating: $('#star_rating').val() || '',
        variant_type: $('#variant-filter-main').val() || '',
        sort_by: $('#sort_by').val() || 'relevance',
        brand_filter: selectedBrand
    };
    

    
    return formData;
}

jQuery(document).find('.wca-product-without-api-search').on('submit', function(event) {
    event.preventDefault();
    event.stopPropagation();
    
    var $categorySelect = $('select[name=ams_amazon_cat]');
    var selectedCategory = $categorySelect.val();
    var placeholderText = $categorySelect.attr('placeholder-text');
    var firstOptionValue = $categorySelect.find('option:first').val();
    var keyword = $('input[name=keyword]').val().trim();
    
    if (!selectedCategory || selectedCategory === '' || selectedCategory === firstOptionValue || keyword === '') {
        if (typeof showToast === 'function') {
            showToast('Keyword and category fields are mandatory.', 'error');
        }
        return false;
    }
    
    wca_loading = true;
    wca_item_page = 0;
    
    // Show the product cards container when search is initiated
    $('.product_cards').removeClass('d-none');
    
    // Show loading state in the container
    $('.wca-amazon-product').html(`
        <div class="col-12">
            <div class="text-center py-5">
                <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                    <span class="visually-hidden">Loading...</span>
                </div>
                <h5 class="text-muted">Searching for products...</h5>
                <p class="text-muted">Please wait while we find the best products for you.</p>
            </div>
        </div>
    `);
    
    var formData = getFormData();
    performSearch(formData, true); // Force refresh on manual search
    
    // Save recent search if validation passes
    var keyword = $('input[name=keyword]').val().trim();
    var category = $('select[name=ams_amazon_cat]').val();
    if (keyword && category && category !== '') {
        saveRecentSearch(keyword, category);
    }
});



// Event listener for real-time filtering (title, star rating, variant type, and search source)
jQuery('#title_search, #star_rating, #variant-filter-main').on('input change', function() {
    var formData = getFormData();
    debouncedSearch(formData);
});

// Event listener for sort options - only trigger if we have results
jQuery('#sort_by').on('change', function() {
    // Only sort if we have results and the container is visible
    if (!$('.product_cards').hasClass('d-none') && $('.wca-amazon-product').children().length > 0) {
        var formData = getFormData();
        debouncedSearch(formData);
    }
});

// Recent Searches functionality
function saveRecentSearch(keyword, category) {
    var recentSearches = JSON.parse(localStorage.getItem('ams_recent_searches') || '[]');
    
    // Remove if already exists
    recentSearches = recentSearches.filter(function(search) {
        return !(search.keyword === keyword && search.category === category);
    });
    
    // Add to beginning
    recentSearches.unshift({
        keyword: keyword,
        category: category,
        timestamp: new Date().toISOString()
    });
    
    // Keep only last 5 searches
    recentSearches = recentSearches.slice(0, 5);
    
    localStorage.setItem('ams_recent_searches', JSON.stringify(recentSearches));
    displayRecentSearches();
}

function displayRecentSearches() {
    var recentSearches = JSON.parse(localStorage.getItem('ams_recent_searches') || '[]');
    var container = $('#recent-searches-list');
    
    if (recentSearches.length === 0) {
        $('#recent-searches').hide();
        return;
    }
    
    container.empty();
    recentSearches.forEach(function(search) {
        var searchBtn = $('<button>')
            .addClass('btn btn-sm btn-outline-primary me-2 mb-1')
            .text(search.keyword + ' in ' + search.category)
            .on('click', function() {
                $('#keyword').val(search.keyword);
                $('#ams_amazon_cat').val(search.category);
                // Trigger search
                $('.wca-product-without-api-search').submit();
            });
        container.append(searchBtn);
    });
    
    $('#recent-searches').show();
}

function clearRecentSearches() {
    localStorage.removeItem('ams_recent_searches');
    $('#recent-searches').hide();
}

// Initialize recent searches on page load
jQuery(document).ready(function($) {
    displayRecentSearches();
    
    // Clear recent searches button
    $('#clear-recent-searches').on('click', function() {
        clearRecentSearches();
    });
    
    // Initialize view mode
    initializeViewMode();
    
    // Initialize filters and sorting
    initializeFiltersAndSorting();
});

// View Mode functionality
function initializeViewMode() {
    // Check which page we're on and use appropriate localStorage key
    var isWcProductSearch = $('#products-grid').length > 0 && $('#products-container').length === 0;
    var storageKey = isWcProductSearch ? 'wcaProductViewMode' : 'ams_view_mode';
    
    // Load saved view mode preference
    var savedViewMode = localStorage.getItem(storageKey) || 'grid';
    
    // Sync both storage keys to keep them consistent
    if (isWcProductSearch) {
        localStorage.setItem('ams_view_mode', savedViewMode);
    } else {
        localStorage.setItem('wcaProductViewMode', savedViewMode);
    }
    
    // Set the correct button states based on page
    if (isWcProductSearch) {
        // wc-product-search page uses different button structure
        if (savedViewMode === 'list') {
            $('#list-view-btn').addClass('active');
            $('#grid-view-btn').removeClass('active');
        } else {
            $('#grid-view-btn').addClass('active');
            $('#list-view-btn').removeClass('active');
        }
    } else {
        // products-search-without-api page uses radio buttons
        $(`#${savedViewMode}_view`).prop('checked', true);
    }
    
    // Apply view mode immediately
    applyViewMode(savedViewMode);
    
    // Also apply view mode after a delay to catch any existing products
    setTimeout(function() {
        applyViewMode(savedViewMode);
    }, 500);
    
    // Check for existing products and apply view mode
    checkAndApplyViewMode();
    
    // Set up observer to watch for dynamically added products
    setupProductObserver();
    
    // View mode change handler for products-search-without-api page
    $('input[name="view_mode"]').on('change', function() {
        var viewMode = $(this).val();
        localStorage.setItem('ams_view_mode', viewMode);
        localStorage.setItem('wcaProductViewMode', viewMode); // Keep both in sync
        applyViewMode(viewMode);
    });
}

// Function to check for existing products and apply saved view mode
function checkAndApplyViewMode() {
    var isWcProductSearch = $('#products-grid').length > 0 && $('#products-container').length === 0;
    var storageKey = isWcProductSearch ? 'wcaProductViewMode' : 'ams_view_mode';
    var savedViewMode = localStorage.getItem(storageKey) || 'grid';
    
    // Check multiple times with increasing delays to catch dynamically loaded content
    var delays = [100, 300, 500, 1000, 2000];
    
    delays.forEach(function(delay) {
        setTimeout(function() {
            var container = $('#products-container, #products-grid');
            var products = container.find('.col-xl-3, .col-lg-4, .col-md-6, .col-12').filter(function() {
                return $(this).find('.card').length > 0;
            });
            
            if (products.length > 0) {
                applyViewMode(savedViewMode);
            }
        }, delay);
    });
}

// Function to set up observer for dynamically added products
function setupProductObserver() {
    var isWcProductSearch = $('#products-grid').length > 0 && $('#products-container').length === 0;
    var storageKey = isWcProductSearch ? 'wcaProductViewMode' : 'ams_view_mode';
    
    // Create observer to watch for changes in the products container
    var observer = new MutationObserver(function(mutations) {
        var hasNewProducts = false;
        
        mutations.forEach(function(mutation) {
            if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                // Check if any added nodes contain product cards
                for (var i = 0; i < mutation.addedNodes.length; i++) {
                    var node = mutation.addedNodes[i];
                    if (node.nodeType === 1) { // Element node
                        var hasCard = $(node).find('.card').length > 0 || $(node).hasClass('card');
                        if (hasCard) {
                            hasNewProducts = true;
                            break;
                        }
                    }
                }
            }
        });
        
        if (hasNewProducts) {
            // Read the latest view mode at the moment of mutation handling
            var latestViewMode = localStorage.getItem(storageKey) || 'grid';
            setTimeout(function() {
                applyViewMode(latestViewMode);
            }, 100);
        }
    });
    
    // Start observing both containers
    var containers = document.querySelectorAll('#products-container, #products-grid');
    containers.forEach(function(container) {
        if (container) {
            observer.observe(container, {
                childList: true,
                subtree: true
            });
        }
    });
}

function applyViewMode(viewMode) {
    var container = $('#products-container, #products-grid');
    var isWcProductSearch = $('#products-grid').length > 0 && $('#products-container').length === 0;
    
    // Remove all view mode classes
    container.removeClass('grid-view list-view');
    
    switch(viewMode) {
        case 'grid':
            container.addClass('grid-view');
            if (isWcProductSearch && typeof applyGridView !== 'undefined') {
                applyGridView();
            } else if (typeof applyGridView === 'function') {
                applyGridView();
            }
            break;
        case 'list':
            container.addClass('list-view');
            if (isWcProductSearch && typeof applyListView !== 'undefined') {
                applyListView();
            } else if (typeof applyListViewLayout === 'function') {
                applyListViewLayout();
            }
            break;
        default:
            container.addClass('grid-view');
            if (isWcProductSearch && typeof applyGridView !== 'undefined') {
                applyGridView();
            } else if (typeof applyGridView === 'function') {
                applyGridView();
            }
    }
    
    // Update results count display if function exists
    if (typeof updateResultsCount === 'function') {
        updateResultsCount();
    }
    
    // Force a reflow to ensure CSS changes are applied
    if (container.length > 0) {
        container[0].offsetHeight;
    }
}

// Function to apply list view formatting (same as wc-product-search page)
function applyListViewLayout() {
    const $grid = $('#products-container, #products-grid');
    const $gridCols = $grid.find('.col-xl-3, .col-lg-4, .col-md-6, .col-12');
    
    // Switch to list view - make cards full width and horizontal
    $gridCols.removeClass('col-xl-3 col-lg-4 col-md-6').addClass('col-12');
    
    // Make cards horizontal using Bootstrap flex classes
    $grid.find('.card').each(function() {
        const $card = $(this);
        const $imageContainer = $card.find('.position-relative').first();
        const $cardBody = $card.find('.card-body');
        
        // Make card horizontal with proper layout
        $card.addClass('d-flex flex-row align-items-stretch');
        
        // Image container - fixed width and height
        $imageContainer.removeClass('d-flex align-items-center justify-content-center')
                      .addClass('flex-shrink-0 d-flex align-items-center justify-content-center border-end')
                      .css({'height': '140px', 'width': '140px', 'min-width': '140px'});
        
        // Card body - flexible with better spacing
        $cardBody.addClass('flex-fill d-flex flex-column justify-content-between')
                 .css({'min-height': '140px'});
        
        // Reorganize content for horizontal layout
        const $title = $cardBody.find('.card-title');
        const $brand = $cardBody.find('.badge').parent();
        const $rating = $cardBody.find('.d-flex.align-items-center.gap-2').first();
        const $price = $cardBody.find('.fw-bold.text-success').parent();
        const $availability = $cardBody.find('.text-warning, .text-danger').parent();
        const $actions = $cardBody.find('.d-flex.align-items-center.justify-content-between');
        const $importBtn = $cardBody.find('.mt-auto');
        
        // Create horizontal layout structure
        const $leftContent = $('<div class="flex-fill pe-3"></div>');
        const $rightContent = $('<div class="d-flex flex-column justify-content-between" style="min-width: 200px;"></div>');
        
        // Move content to left side
        if ($brand.length) $leftContent.append($brand);
        if ($title.length) $leftContent.append($title);
        if ($rating.length) $leftContent.append($rating);
        if ($availability.length) $leftContent.append($availability);
        
        // Move content to right side
        if ($price.length) $rightContent.append($price);
        if ($actions.length) $rightContent.append($actions);
        if ($importBtn.length) $rightContent.append($importBtn);
        
        // Replace card body content
        $cardBody.empty().append($leftContent).append($rightContent);
    });
}

// Function to restore grid view
function applyGridView() {
    const $grid = $('#products-container, #products-grid');
    const $gridCols = $grid.find('.col-12');
    
    // Switch to grid view - restore original layout
    $gridCols.removeClass('col-12').addClass('col-xl-3 col-lg-4 col-md-6');
    
    // Restore vertical card layout
    $grid.find('.card').each(function() {
        const $card = $(this);
        const $imageContainer = $card.find('.position-relative').first();
        const $cardBody = $card.find('.card-body');
        
        // Remove horizontal layout classes
        $card.removeClass('d-flex flex-row align-items-stretch');
        
        // Restore image container
        $imageContainer.removeClass('flex-shrink-0 border-end')
                      .addClass('d-flex align-items-center justify-content-center')
                      .css({'height': '220px', 'width': '', 'min-width': ''});
        
        // Restore card body
        $cardBody.removeClass('flex-fill d-flex flex-column justify-content-between')
                 .addClass('d-flex flex-column')
                 .css({'min-height': ''});
        
        // If content was reorganized, we need to restore original structure
        // This is complex, so for now we'll just reload the content
        // In a production environment, you'd want to store the original HTML
    });
}

// Enhanced Filters and Sorting functionality
function initializeFiltersAndSorting() {
    // Toggle filters panel
    $('#toggle-filters').on('click', function() {
        var panel = $('#filters-panel');
        var button = $(this);
        
        if (panel.hasClass('d-none')) {
            panel.removeClass('d-none').addClass('show');
            button.html('<i class="fas fa-filter me-1"></i>Hide Filters');
        } else {
            panel.addClass('d-none').removeClass('show');
            button.html('<i class="fas fa-filter me-1"></i>Filters');
        }
    });
    
    // Clear all filters
    $('#clear-filters, #clear-all-filters-btn').on('click', function() {
        clearAllFilters();
    });
    
    // Quick Results Limit Save
    $('#save-results-limit').on('click', function() {
        var $button = $(this);
        var $select = $('#quick-results-limit');
        var newLimit = $select.val();
        
        // Show loading state
        $button.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-1"></i>Saving...');
        
        $.ajax({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: {
                action: 'save_results_limit',
                results_limit: newLimit,
                nonce: amsbackend.check_nonce
            },
            success: function(response) {
                if (response.success) {
                    // Show success toast
                    showToast('Results limit saved successfully!', 'success');
                    
                    // Show success state
                    $button.removeClass('btn-outline-secondary').addClass('btn-success')
                           .html('<i class="fas fa-check me-1"></i>Saved!');
                    
                    // Update the info message
                    $('.alert-info div').text('Search returns up to ' + newLimit + ' results.');
                    
                    // Reset button after 2 seconds
                    setTimeout(function() {
                        $button.prop('disabled', false)
                               .removeClass('btn-success').addClass('btn-outline-secondary')
                               .html('<i class="fas fa-save me-1"></i>Save');
                    }, 2000);
                } else {
                    // Show error toast
                    showToast('Failed to save results limit', 'error');
                    
                    // Show error state
                    $button.removeClass('btn-outline-secondary').addClass('btn-danger')
                           .html('<i class="fas fa-times me-1"></i>Error');
                    
                    setTimeout(function() {
                        $button.prop('disabled', false)
                               .removeClass('btn-danger').addClass('btn-outline-secondary')
                               .html('<i class="fas fa-save me-1"></i>Save');
                    }, 2000);
                }
            },
            error: function() {
                // Show error toast
                showToast('Failed to save results limit', 'error');
                
                $button.removeClass('btn-outline-secondary').addClass('btn-danger')
                       .html('<i class="fas fa-times me-1"></i>Error');
                
                setTimeout(function() {
                    $button.prop('disabled', false)
                           .removeClass('btn-danger').addClass('btn-outline-secondary')
                           .html('<i class="fas fa-save me-1"></i>Save');
                }, 2000);
            }
        });
    });
    
    // Filter change handlers
    $('#min_price, #max_price').on('input', debounce(applyFilters, 300));
    $('#star_rating').on('change', applyFilters);
    $('#prime-filter').on('change', applyFilters);
    
    // Sort change handler
    $('#sort_by').on('change', applySorting);
    
    // Populate brand filter dynamically
    populateBrandFilter();
}

function applyFilters() {
    var products = $('.product-card').parent();
    var visibleCount = 0;
    
    products.each(function() {
        var product = $(this);
        var card = product.find('.product-card');
        var show = true;
        
        // Get product data
        var priceText = card.find('.h5').text().replace(/[^\d.,]/g, '');
        var price = parseFloat(priceText) || 0;
        var rating = parseFloat(card.find('.text-muted').first().text()) || 0;
        var stockStatus = getStockStatus(card);
        var isPrime = card.find('.badge:contains("Prime")').length > 0;
        var hasDiscount = card.find('.badge:contains("%")').length > 0;
        var isBestseller = card.find('.badge:contains("Best")').length > 0 || 
                          card.find('.badge:contains("Choice")').length > 0;
        var brand = card.find('.text-primary.fw-bold').text().toLowerCase();
        
        // Apply filters
        
        // Price range filter
        var minPrice = parseFloat($('#min_price').val()) || 0;
        var maxPrice = parseFloat($('#max_price').val()) || Infinity;
        if (price < minPrice || price > maxPrice) {
            show = false;
        }
        
        // Rating filter
        var minRating = parseFloat($('#star_rating').val()) || 0;
        if (rating < minRating) {
            show = false;
        }
        
        // Special features filters
        if ($('#prime-filter').is(':checked') && !isPrime) {
            show = false;
        }
        


        
        // Show/hide product
        if (show) {
            product.show();
            visibleCount++;
        } else {
            product.hide();
        }
    });
    
    // Update results count
    $('#results-count').text(visibleCount + ' products found');
    
    // Update active filters display
    updateActiveFilters();
}

function applySorting() {
    var sortBy = $('#sort_by').val();
    var container = $('#products-container');
    var products = container.children('.col-12:visible').get();
    
    products.sort(function(a, b) {
        var cardA = $(a).find('.product-card');
        var cardB = $(b).find('.product-card');
        
        switch(sortBy) {
            case 'price-low':
                var priceA = parseFloat(cardA.find('.h5').text().replace(/[^\d.,]/g, '')) || 0;
                var priceB = parseFloat(cardB.find('.h5').text().replace(/[^\d.,]/g, '')) || 0;
                return priceA - priceB;
                
            case 'price-high':
                var priceA = parseFloat(cardA.find('.h5').text().replace(/[^\d.,]/g, '')) || 0;
                var priceB = parseFloat(cardB.find('.h5').text().replace(/[^\d.,]/g, '')) || 0;
                return priceB - priceA;
                
            case 'rating':
                var ratingA = parseFloat(cardA.find('.text-muted').first().text()) || 0;
                var ratingB = parseFloat(cardB.find('.text-muted').first().text()) || 0;
                return ratingB - ratingA;
                
            case 'discount':
                var discountA = getDiscountPercent(cardA);
                var discountB = getDiscountPercent(cardB);
                return discountB - discountA;
                
            case 'newest':
                // For now, maintain original order for newest
                return 0;
                
            default: // relevance
                return 0;
        }
    });
    
    // Re-append sorted products
    $.each(products, function(index, item) {
        container.append(item);
    });
}

function clearAllFilters() {
    // Clear all filter inputs
    $('#min_price, #max_price').val('');
    $('#star_rating, #variant-filter-main').val('');
    $('#brand-filter').val(''); // Clear brand filter
    localStorage.removeItem('ams_selected_brand'); // Clear stored brand

    $('#prime-filter').prop('checked', false);
    $('#sort_by').val('relevance');
    
    // Show all products
    $('.product-card').parent().show();
    
    // Update displays
    updateResultsCount();
    updateActiveFilters();
}

function updateActiveFilters() {
    var activeFilters = [];
    var container = $('#active-filters-list');
    
    // Check each filter type
    var minPrice = $('#price-min').val();
    var maxPrice = $('#price-max').val();
    if (minPrice || maxPrice) {
        var priceText = 'Price: ';
        if (minPrice) priceText += '$' + minPrice;
        if (minPrice && maxPrice) priceText += ' - ';
        if (maxPrice) priceText += '$' + maxPrice;
        activeFilters.push(priceText);
    }
    
    var rating = $('#rating-filter').val();
    if (rating) {
        activeFilters.push(rating + '+ Stars');
    }
    
    var stock = $('#stock-filter').val();
    if (stock) {
        activeFilters.push(stock.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase()));
    }
    
    if ($('#prime-filter').is(':checked')) {
        activeFilters.push('Prime Eligible');
    }
    
    if ($('#discount-filter').is(':checked')) {
        activeFilters.push('On Sale');
    }
    
    if ($('#bestseller-filter').is(':checked')) {
        activeFilters.push('Bestseller');
    }
    
    var brand = $('#brand-filter').val();
    if (brand) {
        activeFilters.push('Brand: ' + brand);
    }
    
    // Display active filters
    container.empty();
    if (activeFilters.length > 0) {
        $('#active-filters').removeClass('d-none');
        activeFilters.forEach(function(filter) {
            container.append(
                '<span class="badge filter-badge me-1" onclick="removeFilter(this)">' +
                filter + ' <i class="fas fa-times ms-1"></i></span>'
            );
        });
    } else {
        $('#active-filters').addClass('d-none');
    }
}



function updateResultsCount() {
    var visibleCount = $('.product-card').parent(':visible').length;
    $('#results-count').text(visibleCount + ' products found');
}

function getStockStatus(card) {
    if (card.find('.text-danger:contains("Out of Stock")').length > 0) {
        return 'out_of_stock';
    } else if (card.find('.text-warning:contains("Limited")').length > 0) {
        return 'limited_stock';
    } else {
        return 'in_stock';
    }
}

function getDiscountPercent(card) {
    var discountBadge = card.find('.badge:contains("%")');
    if (discountBadge.length > 0) {
        var text = discountBadge.text();
        var match = text.match(/(\d+)%/);
        return match ? parseInt(match[1]) : 0;
    }
    return 0;
}

function removeFilter(element) {
    // This would need specific implementation based on which filter to remove
    // For now, just clear all filters
    clearAllFilters();
}

// Utility function for debouncing
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

//product-without-api-search//


    /**
     * Products import without api
     */
    $(document).on('click', '.wca-import-without-api', function(event){
        event.preventDefault();
        event.stopPropagation();
        
        var wca_button = this;
        var $button = $(wca_button);
        
        $button.prop('disabled', true)
               .html('<span class="spinner-border spinner-border-sm me-1" role="status"></span>' + amsbackend.ams_t_import);

        $.ajax({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: {
                nonce: amsbackend.nonce_ams_without_api,
                action: 'product_import_without_api',
                title: $button.attr('data-title'),
                img: $button.attr('data-img'),
                detail_page_url: $button.attr('data-detail-page-url'),
                asin: $button.attr('data-asin'),
                amount: $button.attr('data-amount'),
            },
            timeout: 300000, // 5 minutes
            success: function (response) {
                $('.wca-loading-icon').hide();
                // Handle both JSON and HTML/text responses
                let responseText = '';
                
                // Try to parse as JSON first
                if (typeof response === 'string') {
                    try {
                        let jsonResponse = JSON.parse(response);
                        if (jsonResponse.success && jsonResponse.data) {
                            responseText = jsonResponse.data;
                        } else if (jsonResponse.data) {
                            responseText = jsonResponse.data;
                        } else {
                            // If JSON but no data, use the string as is
                            responseText = response.trim();
                        }
                    } catch (e) {
                        // Not JSON, treat as HTML/text
                        responseText = response.trim();
                    }
                } else if (typeof response === 'object' && response !== null) {
                    // Already parsed JSON object
                    if (response.success && response.data) {
                        responseText = response.data;
                    } else if (response.data) {
                        responseText = response.data;
                    } else {
                        responseText = 'Import complete';
                    }
                } else {
                    responseText = 'Import complete';
                }
                
                if (responseText !== '') {
                    $button.html(responseText);
                } else {
                    $button.html('Import complete');
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                $('.wca-loading-icon').hide();
                console.error('Import failed:', textStatus, errorThrown);
                
                // Handle different types of error responses
                let errorMessage = 'Import failed';
                
                if (textStatus === 'parsererror') {
                    // JSON parse error - response is likely HTML/text
                    if (jqXHR.responseText) {
                        // Extract meaningful error from HTML/text response
                        let cleanText = jqXHR.responseText.replace(/<[^>]*>/g, '').trim();
                        if (cleanText.length > 0 && cleanText.length < 200) {
                            errorMessage = cleanText;
                        } else {
                            errorMessage = 'Server returned invalid response format';
                        }
                    }
                } else {
                    // Try to parse as JSON first
                    try {
                        if (jqXHR.responseJSON && jqXHR.responseJSON.data) {
                            errorMessage = jqXHR.responseJSON.data;
                        } else if (jqXHR.responseText) {
                            // Try to parse as JSON
                            let jsonResponse = JSON.parse(jqXHR.responseText);
                            if (jsonResponse.data) {
                                errorMessage = jsonResponse.data;
                            } else {
                                errorMessage = jqXHR.responseText;
                            }
                        }
                    } catch (e) {
                        // Not JSON, use as text
                        if (jqXHR.responseText) {
                            let cleanText = jqXHR.responseText.replace(/<[^>]*>/g, '').trim();
                            if (cleanText.length > 0 && cleanText.length < 200) {
                                errorMessage = cleanText;
                            }
                        }
                    }
                }
                
                $button.html(errorMessage);
            },
            complete: function () {
                $button.prop('disabled', true);
            }
        });
    });

    function wca_product_import_without_api() {
    }


    $('.ams-buy-action-btn').on('change', function () {
        if ($(this).val() == 'dropship') {
            $('.ams-dropship').show();
        } else {
            $('.ams-dropship').hide();
        }
        
        if (this.value == 'multi_cart' || this.value == 'dropship') {
            $('.ams').addClass('d-none');
            $(this).parent().next().removeClass('d-none');
        } else {
            $('.ams').addClass('d-none');
        }
    });


    $(document).find('.wca-product-import-by-url').on('click', function (event) {
        event.preventDefault();
   		event.stopPropagation();

        $( '.wca-amazon-product' ).show();

        var product_all_url = $( '#wca-product-all-url' ).val();
        var array_url_list = product_all_url.split( ',' );
        var promises = [];

        for ( i = 0; i < array_url_list.length; i++ ) {
            $(document).find( '.wca-loading-icon' ).show();
            $( '.wca-amazon-product-by-url' ).append( '<p class="wca-import-warning"> ' + array_url_list [ i ] + amsbackend.ams_mass_product_importing + '  </p>' );

           var request =  $.ajax( {
                type: 'POST',
                url: amsbackend.ajax_url,
                data: {
                    nonce: amsbackend.nonce_ams_import_product_url,
                    action: 'ams_product_import_by_url',
                    product_url: array_url_list [ i ],
                },

               
                success: function ( html ) {
                    $( '.wca-amazon-product-by-url' ).append( html );
                }

            } );

            promises.push(request);
        }

        $.when.apply(null, promises).done(function() {
            $(document).find( '.wca-loading-icon' ).hide();
        })
    });
    
    
    /**
     *
     *  Product update request
     *
     */
     
    $(document).on('click', '.wca-product-update-request', function(event) {
        event.preventDefault();
        event.stopPropagation();

        var wca_button = this;
        var post_id = $( this ).attr( 'data-post-id' );
        var product_url = $( this ).attr( 'data-url' );
        
        $(document).find( wca_button ).prop( 'disabled', true);
        $( wca_button ).html( '<span class="ams-loading-spinner"></span><span class="ams-btn-text" style="margin-left: 4px; color: #4f46e5;">Updating...</span>' );

        queue.add({
            type: 'POST',
            url: amsbackend.ajax_url,
            data: {
                post_id: post_id,
                product_url: product_url,
                action: 'product_update_request',
                nonce: amsbackend.nonce_product_update_request,
            },
            success: function ( html ) {
                $( '.wca-loading-icon' ).hide();
                
                // Check if update was successful
                if (html.toLowerCase().includes('success') || html.toLowerCase().includes('updated') || html.includes('✓')) {
                    // Keep success state persistent - don't auto-reset
                    $( wca_button ).html( '<span class="ams-btn-icon">✓</span><span class="ams-btn-text">Updated!</span>' );
                    $( wca_button ).addClass('ams-success-btn');
                    $( wca_button ).removeClass('ams-error-btn');
                    $( wca_button ).prop( 'disabled', true);
                    
                    // Force success styles directly
                    $( wca_button ).css({
                        'background': 'linear-gradient(135deg, #10b981 0%, #059669 100%)',
                        'border': '2px solid #10b981',
                        'color': '#ffffff',
                        'box-shadow': '0 2px 4px rgba(16, 185, 129, 0.3)'
                    });
                    
                    // Update the status information in the column
                    var $container = $( wca_button ).closest('.ams-cron-container');
                    var $statusBadge = $container.find('.ams-status-badge');
                    var $dateInfo = $container.find('.ams-date-info');
                    
                    // Update status badge to success
                    $statusBadge.removeClass('ams-status-pending ams-status-failed')
                               .addClass('ams-status-success')
                               .html('<span class="ams-status-icon">✓</span><span class="ams-status-text">Updated</span>');
                    
                    // Update date to current time
                    var now = new Date();
                    var currentTime = now.toLocaleDateString('en-US', { 
                        month: 'short', 
                        day: 'numeric' 
                    }) + ', ' + now.toLocaleTimeString('en-US', { 
                        hour: '2-digit', 
                        minute: '2-digit', 
                        hour12: false 
                    });
                    $dateInfo.text(currentTime);
                    
                } else if (html.includes('error') || html.includes('failed') || html.includes('✗')) {
                    $( wca_button ).html( '<span class="ams-btn-icon">✗</span><span class="ams-btn-text">Failed</span>' );
                    $( wca_button ).addClass('ams-error-btn');
                    $( wca_button ).removeClass('ams-success-btn');
                    $( wca_button ).prop( 'disabled', true);
                    
                    // Update the status information in the column
                    var $container = $( wca_button ).closest('.ams-cron-container');
                    var $statusBadge = $container.find('.ams-status-badge');
                    
                    // Update status badge to failed
                    $statusBadge.removeClass('ams-status-pending ams-status-success')
                               .addClass('ams-status-failed')
                               .html('<span class="ams-status-icon">✗</span><span class="ams-status-text">Failed</span>');
                    
                    // Re-enable button after 5 seconds for retry
                    setTimeout(function() {
                        $( wca_button ).html( '<span class="ams-btn-icon">↻</span><span class="ams-btn-text">Retry</span>' );
                        $( wca_button ).prop( 'disabled', false);
                        $( wca_button ).removeClass('ams-error-btn');
                    }, 5000);
                } else {
                    // Default response - keep button enabled for retry
                    $( wca_button ).html( '<span class="ams-btn-icon">↻</span><span class="ams-btn-text">Update</span>' );
                    $( wca_button ).prop( 'disabled', false);
                }
            },
            error: function() {
                $( wca_button ).html( '<span class="ams-btn-icon">✗</span><span class="ams-btn-text">Error</span>' );
                $( wca_button ).addClass('ams-error-btn');
                $( wca_button ).prop( 'disabled', true);
                
                // Update the status information in the column
                var $container = $( wca_button ).closest('.ams-cron-container');
                var $statusBadge = $container.find('.ams-status-badge');
                
                // Update status badge to failed
                $statusBadge.removeClass('ams-status-pending ams-status-success')
                           .addClass('ams-status-failed')
                           .html('<span class="ams-status-icon">✗</span><span class="ams-status-text">Failed</span>');
                
                // Re-enable button after 5 seconds for retry
                setTimeout(function() {
                    $( wca_button ).html( '<span class="ams-btn-icon">↻</span><span class="ams-btn-text">Retry</span>' );
                    $( wca_button ).prop( 'disabled', false);
                    $( wca_button ).removeClass('ams-error-btn');
                }, 5000);
            }
        });
    });

// LOGS PAGE AJAX FILTER & PAGINATION
$(document).ready(function() {
    if ($('body').find('.ams-logs-page-link').length || $('form[action=""][method="get"]').find('input[name="page"][value="view-logs"]').length) {
        // Enhance filter button
        var $filterBtn = $('form[action=""][method="get"] button[type="submit"]');
        $filterBtn.css({
            'font-weight': '600',
            'box-shadow': '0 2px 8px rgba(44,62,80,0.08)',
            'transition': 'background 0.2s',
            'position': 'relative'
        });
        $filterBtn.append('<span class="spinner-border spinner-border-sm ms-2 d-none" role="status" aria-hidden="true"></span>');
        // Filter form submit
        $('form[action=""][method="get"]').on('submit', function(e) {
            if ($(this).find('input[name="page"]').val() !== 'view-logs') return;
            e.preventDefault();
            var $btn = $(this).find('button[type="submit"]');
            $btn.addClass('active').attr('disabled', true);
            $btn.find('.spinner-border').removeClass('d-none');
            var filter = $(this).find('input[name="filter"]').val();
            $.post(ajaxurl, {
                action: 'ams_logs_pagination',
                filter: filter,
                paged: 1
            }, function(resp) {
                if (resp.success) {
                    $('#log-area').html(resp.data.log_html);
                    $('.ams-logs-pagination').html(resp.data.pagination_html);
                    $('.ams-logs-entries-count').text(resp.data.total_entries);
                }
                $btn.removeClass('active').attr('disabled', false);
                $btn.find('.spinner-border').addClass('d-none');
            });
        });
        // Pagination click
        $(document).on('click', '.ams-logs-page-link', function(e) {
            e.preventDefault();
            var paged = 1;
            var href = $(this).attr('href');
            
            if (href) {
                var match = href.match(/paged=(\d+)/);
                if (match) {
                    paged = parseInt(match[1]);
                }
            } else {
                // Handle current page or text-only links
                var $link = $(this);
                var linkText = $link.text().trim();
                
                if ($link.hasClass('current') || linkText.match(/^\d+$/)) {
                    paged = parseInt(linkText);
                } else if (linkText === '‹' || linkText === '›') {
                    // Handle prev/next arrows
                    var currentPage = $('.ams-logs-page-link.current').text().trim();
                    if (currentPage) {
                        var currentPageNum = parseInt(currentPage);
                        if (linkText === '‹') {
                            paged = Math.max(1, currentPageNum - 1);
                        } else {
                            paged = currentPageNum + 1;
                        }
                    }
                }
            }
            
            var filter = $('form[action=""][method="get"] input[name="filter"]').val();
            
            var $btn = $('form[action=""][method="get"] button[type="submit"]');
            $btn.addClass('active').attr('disabled', true);
            $btn.find('.spinner-border').removeClass('d-none');
            
            $.post(ajaxurl, {
                action: 'ams_logs_pagination',
                filter: filter,
                paged: paged
            }, function(resp) {
                if (resp.success) {
                    $('#log-area').html(resp.data.log_html);
                    $('.ams-logs-pagination').html(resp.data.pagination_html);
                    $('.ams-logs-entries-count').text(resp.data.total_entries);
                }
                $btn.removeClass('active').attr('disabled', false);
                $btn.find('.spinner-border').addClass('d-none');
            });
        });
    }
});

/* Auto-Navigation Section Highlighting */
document.addEventListener('DOMContentLoaded', function() {
    // Check if there's a hash in the URL (anchor navigation)
    if (window.location.hash) {
        const targetElement = document.querySelector(window.location.hash);
        if (targetElement) {
            // Add highlight class after a small delay to ensure smooth scroll completes
            setTimeout(function() {
                targetElement.classList.add('section-highlight');
                // Remove the class after animation completes
                setTimeout(function() {
                    targetElement.classList.remove('section-highlight');
                }, 2000);
            }, 500);
        }
    }
    
    // Listen for hash changes (when users click anchor links)
    window.addEventListener('hashchange', function() {
        const targetElement = document.querySelector(window.location.hash);
        if (targetElement) {
            setTimeout(function() {
                targetElement.classList.add('section-highlight');
                setTimeout(function() {
                    targetElement.classList.remove('section-highlight');
                }, 2000);
            }, 500);
        }
    });
});

/* Settings Page Section Memory & Auto-Navigation */
let settingsNavigationInitialized = false; // Prevent multiple initializations

function initializeSettingsNavigation() {
    // Check if we're on the settings page and prevent multiple initializations
    if (window.location.href.includes('page=wc-product-setting-page') && !settingsNavigationInitialized) {
        settingsNavigationInitialized = true;
        const lastVisitedSection = localStorage.getItem('ams_last_settings_section');
        
        // If we have a remembered section, navigate to it and add blue border
        if (lastVisitedSection && lastVisitedSection !== '#') {
            // Navigate to the remembered section
            let targetElement = null; // Declare outside setTimeout for fallback access
            
            setTimeout(function() {
                // Look within plugin content area
                const pluginContent = document.querySelector('.container-fluid');
                if (pluginContent) {
                    const element = pluginContent.querySelector(lastVisitedSection);
                    // Only use the element if it's not a UI element
                    if (element && !element.classList.contains('offcanvas') && !element.classList.contains('modal') && !element.classList.contains('dropdown') && !element.classList.contains('btn') && !element.classList.contains('nav') && !element.classList.contains('navbar')) {
                        targetElement = element;
                    }
                }
                
                if (targetElement) {
                    targetElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    
                    // Add visual highlight
                    targetElement.classList.add('ams-plugin-temp-highlight');
                    
                    // Add visual styling
                    targetElement.style.setProperty('border', '2px solid #2563eb');
                    targetElement.style.setProperty('box-shadow', '0 0 0 4px rgba(37, 99, 235, 0.1)');
                    targetElement.style.setProperty('z-index', '10', 'important');
                    
                    setTimeout(function() {
                        // Ensure blue border is still there and add it again if needed
                        if (!targetElement.classList.contains('ams-plugin-temp-highlight')) {
                            targetElement.classList.add('ams-plugin-temp-highlight');
                        }
                    }, 1200); // Increased delay to ensure scroll completes
                }
            }, 800); // Increased delay for page load
            
            // Fallback: Try again after a longer delay if element wasn't found
            setTimeout(function() {
                if (!targetElement) {
                    // Try to find the element again
                    const mainContent = document.querySelector('#wpcontent');
                    if (mainContent) {
                        const element = mainContent.querySelector(lastVisitedSection);
                        if (element && !element.classList.contains('offcanvas') && !element.classList.contains('modal') && !element.classList.contains('dropdown') && !element.classList.contains('btn') && !element.classList.contains('nav') && !element.classList.contains('navbar')) {
                            targetElement = element;
                        }
                    }
                    
                    if (!targetElement) {
                        const wrapContent = document.querySelector('.wrap');
                        if (wrapContent) {
                            const element = wrapContent.querySelector(lastVisitedSection);
                            if (element && !element.classList.contains('offcanvas') && !element.classList.contains('modal') && !element.classList.contains('dropdown') && !element.classList.contains('btn') && !element.classList.contains('nav') && !element.classList.contains('navbar')) {
                                targetElement = element;
                            }
                        }
                    }
                    
                    if (targetElement) {
                        targetElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
                        targetElement.classList.add('ams-plugin-temp-highlight');
                        
                        // Force a repaint to ensure CSS is applied
                        targetElement.style.display = 'none';
                        targetElement.offsetHeight; // Trigger reflow
                        targetElement.style.display = '';
                        
                        // Also add inline styles as backup with !important
                        targetElement.style.setProperty('border', '2px solid #2563eb', 'important');
                        targetElement.style.setProperty('box-shadow', '0 0 0 4px rgba(37, 99, 235, 0.1)', 'important');
                        targetElement.style.setProperty('position', 'relative', 'important');
                        targetElement.style.setProperty('z-index', '10', 'important');
                    }
                }
            }, 2000); // Try again after 2 seconds
        }
        
        // Set up scroll-based section memory
        // Scroll memory disabled to prevent WordPress admin conflicts
        // setupScrollMemory();
        
        // Add click listeners to all section links to save navigation and highlight
        const sectionLinks = document.querySelectorAll('a[href*="#"]');
        sectionLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                const href = this.getAttribute('href');
                const hash = href.split('#')[1];
                if (hash) {
                    localStorage.setItem('ams_last_settings_section', '#' + hash);
                    
                    // Add blue border for Fast Navigation links
                    setTimeout(function() {
                        highlightSection('#' + hash);
                    }, 300);
                }
            });
        });
        
        // Also handle hash changes for direct navigation
        window.addEventListener('hashchange', function() {
            const newHash = window.location.hash;
            if (newHash) {
                localStorage.setItem('ams_last_settings_section', newHash);
                setTimeout(function() {
                    highlightSection(newHash);
                }, 300);
            }
        });
    }
}

// Multiple event listeners to ensure it works regardless of timing
document.addEventListener('DOMContentLoaded', initializeSettingsNavigation);
window.addEventListener('load', initializeSettingsNavigation);
document.addEventListener('readystatechange', function() {
    if (document.readyState === 'complete') {
        initializeSettingsNavigation();
    }
});

// Setup scroll-based section memory
function setupScrollMemory() {
    // Get all sections with IDs within our plugin content only (excluding UI elements)
    const pluginContent = document.querySelector('.container-fluid');
    const sections = pluginContent ? pluginContent.querySelectorAll('[id]:not(.offcanvas):not(.modal):not(.dropdown):not(.btn):not(.nav):not(.navbar)') : [];
    
    // Listen for scroll events to update memory
    let scrollTimeout;
    window.addEventListener('scroll', function() {
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(function() {
            // Find the section currently most visible in viewport
            const viewportHeight = window.innerHeight;
            const scrollTop = window.pageYOffset;
            const viewportCenter = scrollTop + (viewportHeight / 2);
            
            let mostVisibleSection = null;
            let maxVisibility = 0;
            
            sections.forEach(section => {
                const rect = section.getBoundingClientRect();
                const sectionTop = rect.top + scrollTop;
                const sectionBottom = sectionTop + rect.height;
                
                // Calculate how much of the section is visible
                const visibleTop = Math.max(sectionTop, scrollTop);
                const visibleBottom = Math.min(sectionBottom, scrollTop + viewportHeight);
                const visibleHeight = Math.max(0, visibleBottom - visibleTop);
                
                // Check if section center is near viewport center
                const sectionCenter = sectionTop + (rect.height / 2);
                const distanceFromCenter = Math.abs(sectionCenter - viewportCenter);
                
                if (visibleHeight > 0 && distanceFromCenter < viewportHeight / 2) {
                    const visibility = visibleHeight / rect.height;
                    if (visibility > maxVisibility) {
                        maxVisibility = visibility;
                        mostVisibleSection = section;
                    }
                }
            });
            
            if (mostVisibleSection && mostVisibleSection.id) {
                localStorage.setItem('ams_last_settings_section', '#' + mostVisibleSection.id);
            }
        }, 200); // Debounce scroll events
    });
}

// Helper function to highlight a section (blue border only, no animation)
function highlightSection(hash) {
    // First, remove any existing highlights from all sections
    document.querySelectorAll('.ams-plugin-temp-highlight').forEach(el => {
        el.classList.remove('ams-plugin-temp-highlight');
    });
    
    // Simpler but safe approach - look in the main content area only
    let targetElement = null;
    
    // Look in the main WordPress content area (excluding UI elements)
    const mainContent = document.querySelector('#wpcontent');
    if (mainContent) {
        const element = mainContent.querySelector(hash);
        // Only use the element if it's not a UI element
        if (element && !element.classList.contains('offcanvas') && !element.classList.contains('modal') && !element.classList.contains('dropdown') && !element.classList.contains('btn') && !element.classList.contains('nav') && !element.classList.contains('navbar')) {
            targetElement = element;
        }
    }
    
    // If not found, try the wrap area (excluding UI elements)
    if (!targetElement) {
        const wrapContent = document.querySelector('.wrap');
        if (wrapContent) {
            const element = wrapContent.querySelector(hash);
                    // Only use the element if it's not a UI element
        if (element && !element.classList.contains('offcanvas') && !element.classList.contains('modal') && !element.classList.contains('dropdown') && !element.classList.contains('btn') && !element.classList.contains('nav') && !element.classList.contains('navbar')) {
            targetElement = element;
        }
        }
    }
    
    if (targetElement) {
        // First, ensure the element is visible by scrolling to it
        targetElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
        
        // Wait for smooth scroll to complete, then add blue border
        setTimeout(function() {
            // Add blue border using plugin-specific class
            targetElement.classList.add('ams-plugin-temp-highlight');
            
            // Force a repaint to ensure CSS is applied
            targetElement.style.display = 'none';
            targetElement.offsetHeight; // Trigger reflow
            targetElement.style.display = '';
            
            // Also add inline styles as backup with !important
            targetElement.style.setProperty('border', '2px solid #2563eb', 'important');
            targetElement.style.setProperty('box-shadow', '0 0 0 4px rgba(37, 99, 235, 0.1)', 'important');
            targetElement.style.setProperty('position', 'relative', 'important');
            targetElement.style.setProperty('z-index', '10', 'important');
        }, 1000); // Increased delay to ensure scroll completes
    }
}

// Test function - run this in console to test blue border
window.testBlueBorder = function() {
    const testElement = document.querySelector('#proxy-settings') || document.querySelector('.card');
    if (testElement) {
        testElement.classList.add('ams-plugin-temp-highlight');
        testElement.style.setProperty('border', '2px solid #2563eb', 'important');
        testElement.style.setProperty('box-shadow', '0 0 0 4px rgba(37, 99, 235, 0.1)', 'important');
        testElement.style.setProperty('position', 'relative', 'important');
        testElement.style.setProperty('z-index', '10', 'important');
        return true;
    } else {
        return false;
    }
};

// Back to Top Button Functionality
    function initializeBackToTop($) {
    // Create the back to top button
    const backToTopButton = $('<button>', {
        id: 'tap-back-to-top',
        class: 'btn btn-secondary position-fixed',
        html: '<i class="bi bi-arrow-up-short"></i>',
        css: {
            bottom: '90px',
            right: '20px',
            zIndex: '990',
            opacity: '0',
            visibility: 'hidden',
            transition: 'all 0.3s ease',
            borderRadius: '8px',
            width: '40px',
            height: '40px',
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            boxShadow: '0 2px 8px rgba(0,0,0,0.1)',
            border: 'none',
            fontSize: '18px',
            fontWeight: 'bold'
        }
    });

    // Append to body
    $('body').append(backToTopButton);

    // Add hover effects
    backToTopButton.hover(
        function() {
            $(this).css({
                'background-color': '#495057',
                'transform': 'translateY(-2px)',
                'box-shadow': '0 4px 12px rgba(0,0,0,0.2)'
            });
        },
        function() {
            $(this).css({
                'background-color': '',
                'transform': 'translateY(0)',
                'box-shadow': '0 2px 8px rgba(0,0,0,0.1)'
            });
        }
    );

    // Show/hide button based on scroll position
    $(window).on('scroll', function() {
        if ($(this).scrollTop() > 300) {
            backToTopButton.css({
                opacity: '1',
                visibility: 'visible'
            });
        } else {
            backToTopButton.css({
                opacity: '0',
                visibility: 'hidden'
            });
        }
    });

    // Smooth scroll to top when clicked
    backToTopButton.on('click', function() {
        $('html, body').animate({
            scrollTop: 0
        }, 800);
    });

    // Hover effects
    backToTopButton.hover(
        function() {
            $(this).css({
                transform: 'translateY(-2px)',
                boxShadow: '0 6px 16px rgba(0,0,0,0.2)'
            });
        },
        function() {
            $(this).css({
                transform: 'translateY(0)',
                boxShadow: '0 4px 12px rgba(0,0,0,0.15)'
            });
        }
    );
}

// Initialize back to top button when document is ready
$(document).ready(function() {
        initializeBackToTop($);
});

})(jQuery);