<?php 
		global $post;
		echo $this->data['nonce']; 
?>	
		<div class="to">
			<ul class="to-form-field-list">
				<li>
					<h5><?php esc_html_e('Shortcode',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('In order to create a new booking system for this location simply copy the shortcode snippet from below and then paste it into the WordPress page or post.',PLUGIN_CBS_DOMAIN); ?></span>
					<div><?php echo '['.PLUGIN_CBS_CONTEXT.'_location location_id="'.$post->ID.'"]'; ?></div>
				</li>
				<li>
					<h5><?php esc_html_e('Displaying content',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Specify how services are displayed. Services, will display all services and will not display packages. Packages, will display packages and related services only. Packages and Services will display both packages and all services.',PLUGIN_CBS_DOMAIN); ?></span>
					<div class="to-radio-button">
<?php
		foreach($this->data['dictionary']['contentType'] as $contentTypeIndex=>$contentTypeData)
		{
?>
						<input type="radio" value="<?php echo esc_attr($contentTypeIndex); ?>" id="<?php CBSHelper::getFormName('content_type_'.$contentTypeIndex); ?>" name="<?php CBSHelper::getFormName('content_type'); ?>" <?php CBSHelper::checkedIf($this->data['meta']['content_type'],$contentTypeIndex); ?>/>
						<label for="<?php CBSHelper::getFormName('content_type_'.$contentTypeIndex); ?>"><?php echo esc_html($contentTypeData[0]); ?></label>							
<?php		
		}
?>
					</div>				
				</li>
				<li>
					<h5><?php esc_html_e('Currency',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Select currency.',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<select name="<?php CBSHelper::getFormName('currency'); ?>" id="<?php CBSHelper::getFormName('currency'); ?>">
<?php
		foreach($this->data['dictionary']['currency'] as $currencyIndex=>$currencyData)
		{
?>
		
							<option value="<?php echo esc_attr($currencyIndex); ?>" <?php CBSHelper::selectedIf($currencyIndex,$this->data['meta']['currency']); ?>><?php echo esc_html($currencyData['name']).' ('.$currencyData['symbol'].')'; ?></option>
<?php		
		}
?>
						</select>	
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Number of slots',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('The number of slots (carwash posts) in which services can be provided.',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<input type="text" maxlength="3" name="<?php CBSHelper::getFormName('slot_number'); ?>" id="<?php CBSHelper::getFormName('slot_number'); ?>" value="<?php echo esc_attr($this->data['meta']['slot_number']); ?>"/>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Number of services to display',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Specify how many services will be shown when the page first loads with "Show More" button at the bottom of the list. Enter "0" to display all services by default.',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<input type="text" maxlength="3" name="<?php CBSHelper::getFormName('service_visible_number'); ?>" id="<?php CBSHelper::getFormName('service_visible_number'); ?>" value="<?php echo esc_attr($this->data['meta']['service_visible_number']); ?>"/>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Number of time slots to display',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Specify how many time slots will be shown in calendar when the page first loads with "Show More" button at the bottom of the list. Enter "0" to display all time slots by default.',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<input type="text" maxlength="3" name="<?php CBSHelper::getFormName('hour_visible_number'); ?>" id="<?php CBSHelper::getFormName('hour_visible_number'); ?>" value="<?php echo esc_attr($this->data['meta']['hour_visible_number']); ?>"/>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Reset form',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Reset (clear) form values after successful submission.',PLUGIN_CBS_DOMAIN); ?>
					</span>
					<div class="to-radio-button">
						<input type="radio" value="1" id="<?php CBSHelper::getFormName('reset_form_enable_1'); ?>" name="<?php CBSHelper::getFormName('reset_form_enable'); ?>" <?php CBSHelper::checkedIf($this->data['meta']['reset_form_enable'],1); ?>/>
						<label for="<?php CBSHelper::getFormName('reset_form_enable_1'); ?>"><?php esc_html_e('Yes',PLUGIN_CBS_DOMAIN); ?></label>							
						<input type="radio" value="0" id="<?php CBSHelper::getFormName('reset_form_enable_0'); ?>" name="<?php CBSHelper::getFormName('reset_form_enable'); ?>" <?php CBSHelper::checkedIf($this->data['meta']['reset_form_enable'],0); ?>/>
						<label for="<?php CBSHelper::getFormName('reset_form_enable_0'); ?>"><?php esc_html_e('No',PLUGIN_CBS_DOMAIN); ?></label>							
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Summary text',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Summary text (displayed above "Submit" button).',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<textarea cols="1" rows="0" name="<?php CBSHelper::getFormName('text_1'); ?>" id="<?php CBSHelper::getFormName('text_1'); ?>" ><?php echo nl2br(esc_html($this->data['meta']['text_1'])); ?></textarea>
					</div>
				</li>				
				
			</ul>
		</div>
		<script type="text/javascript">
			jQuery(document).ready(function($)
			{	
				$('.to').themeOptionElement({init:true});
			});
		</script>
