<?php
		$Date=new CBSDate();
?>
		<div class="to">
			<ul class="to-form-field-list">
				<li>
					<h5><?php esc_html_e('Business hours',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Specify working days / hours (in HH:MM time format).',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<table class="to-table">
							<tr>
								<th style="width:20%">
									<div>
										<?php esc_html_e('Weekday',PLUGIN_CBS_DOMAIN); ?>
										<span class="to-legend">
											<?php esc_html_e('Day of the week.',PLUGIN_CBS_DOMAIN); ?>
										</span>
									</div>
								</th>
								<th style="width:40%">
									<div>
										<?php esc_html_e('Start Time',PLUGIN_CBS_DOMAIN); ?>
										<span class="to-legend">
											<?php esc_html_e('Start time in HH:MM time format.',PLUGIN_CBS_DOMAIN); ?>
										</span>
									</div>
								</th>
								<th style="width:40%">
									<div>
										<?php esc_html_e('End Time',PLUGIN_CBS_DOMAIN); ?>
										<span class="to-legend">
											<?php esc_html_e('End time in HH:MM time format.',PLUGIN_CBS_DOMAIN); ?>
										</span>
									</div>
								</th>
							</tr>
							
<?php
		for($i=1;$i<8;$i++)
		{
?>
							<tr>
								<td>
									<div><?php echo $Date->getDayName($i); ?></div>
								</td>
								<td>
									<div>
										<input type="text" class="to-timepicker" maxlength="5" name="<?php CBSHelper::getFormName('business_hour_'.$i.'_start'); ?>" id="<?php CBSHelper::getFormName('business_hour_'.$i.'_start'); ?>" value="<?php echo esc_attr($this->data['meta']['business_hour'][$i]['start']); ?>" title="<?php esc_attr_e('Enter start time in format HH:MM.',PLUGIN_CBS_DOMAIN); ?>"/>
									</div>
								</td>
								<td>
									<div>								
										<input type="text" class="to-timepicker" maxlength="5" name="<?php CBSHelper::getFormName('business_hour_'.$i.'_stop'); ?>" id="<?php CBSHelper::getFormName('business_hour_'.$i.'_stop'); ?>" value="<?php echo esc_attr($this->data['meta']['business_hour'][$i]['stop']); ?>" title="<?php esc_attr_e('Enter end time in format HH:MM.',PLUGIN_CBS_DOMAIN); ?>"/>
									</div>
								</td>
							</tr>
<?php
		}
?>
						</table>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Exclude dates',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Specify dates not available for booking. Past (or invalid date ranges) will be removed when saving.',PLUGIN_CBS_DOMAIN); ?></span>
					<div>	
						<table class="to-table" id="to-table-date-exclude">
							<tr>
								<th style="width:40%">
									<div>
										<?php esc_html_e('Start Date',PLUGIN_CBS_DOMAIN); ?>
										<span class="to-legend">
											<?php esc_html_e('Start date in DD-MM-YYYY format.',PLUGIN_CBS_DOMAIN); ?>
										</span>
									</div>
								</th>
								<th style="width:40%">
									<div>
										<?php esc_html_e('End Date',PLUGIN_CBS_DOMAIN); ?>
										<span class="to-legend">
											<?php esc_html_e('End date in DD-MM-YYYY format.',PLUGIN_CBS_DOMAIN); ?>
										</span>
									</div>
								</th>
								<th style="width:20%">
									<div>
										<?php esc_html_e('Remove',PLUGIN_CBS_DOMAIN); ?>
										<span class="to-legend">
											<?php esc_html_e('Remove this entry.',PLUGIN_CBS_DOMAIN); ?>
										</span>
									</div>
								</th>
							</tr>
							<tr class="to-hidden">
								<td>
									<div>
										<input type="text" maxlength="10" class="to-datepicker" name="<?php CBSHelper::getFormName('date_exclude_start[]'); ?>" title="<?php esc_attr_e('Enter start date in format DD-MM-YYYY.',PLUGIN_CBS_DOMAIN); ?>"/>
									</div>									
								</td>
								<td>
									<div>
										<input type="text" maxlength="10" class="to-datepicker" name="<?php CBSHelper::getFormName('date_exclude_stop[]'); ?>" title="<?php esc_attr_e('Enter start date in format DD-MM-YYYY.',PLUGIN_CBS_DOMAIN); ?>"/>
									</div>									
								</td>	
								<td>
									<div>
										<a href="#" class="to-table-button-remove"><?php esc_html_e('Remove',PLUGIN_CBS_DOMAIN); ?></a>
									</div>
								</td>
							</tr>
<?php
		if(count($this->data['meta']['date_exclude']))
		{
			foreach($this->data['meta']['date_exclude'] as $dateExcludeIndex=>$dateExcludeValue)
			{
?>
							<tr>
								<td>
									<div>
										<input type="text" maxlength="10" class="to-datepicker" value="<?php echo esc_attr($Date->reverse($dateExcludeValue['start'])); ?>" name="<?php CBSHelper::getFormName('date_exclude_start[]'); ?>" title="<?php esc_attr_e('Enter start date in format DD-MM-YYYY.',PLUGIN_CBS_DOMAIN); ?>"/>
									</div>									
								</td>
								<td>
									<div>
										<input type="text" maxlength="10" class="to-datepicker" value="<?php echo esc_attr($Date->reverse($dateExcludeValue['stop'])); ?>" name="<?php CBSHelper::getFormName('date_exclude_stop[]'); ?>" title="<?php esc_attr_e('Enter start date in format DD-MM-YYYY.',PLUGIN_CBS_DOMAIN); ?>"/>
									</div>									
								</td>	
								<td>
									<div>
										<a href="#" class="to-table-button-remove"><?php esc_html_e('Remove',PLUGIN_CBS_DOMAIN); ?></a>
									</div>
								</td>
							</tr>							
<?php
			}
		}
?>
						</table>
						<div> 
							<a href="#" class="to-table-button-add"><?php esc_html_e('Add',PLUGIN_CBS_DOMAIN); ?></a>
						</div>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Time format',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Select the time format to be displayed in calendar.',PLUGIN_CBS_DOMAIN); ?></span>
					<div class="to-radio-button">
<?php
		foreach($Date->timeFormat as $timeFormatIndex=>$timeFormatData)
		{
?>
						<input type="radio" value="<?php echo esc_attr($timeFormatIndex); ?>" id="<?php CBSHelper::getFormName('booking_time_format_'.$timeFormatIndex); ?>" name="<?php CBSHelper::getFormName('booking_time_format'); ?>" <?php CBSHelper::checkedIf($this->data['meta']['booking_time_format'],$timeFormatIndex); ?>/>
						<label for="<?php CBSHelper::getFormName('booking_time_format_'.$timeFormatIndex); ?>"><?php echo esc_html($timeFormatData[0]); ?></label>							
<?php
		}
?>
					</div>
				</li>	
				<li>
					<h5><?php esc_html_e('Date format',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php echo sprintf(esc_html('Select the date format to be displayed in summary. More info you can find here %s.',PLUGIN_CBS_DOMAIN),'<a href="https://codex.wordpress.org/Formatting_Date_and_Time">Formatting Date and Time</a>'); ?></span>
					<div>
						<input type="text" maxlength="255" name="<?php CBSHelper::getFormName('booking_date_format'); ?>" id="<?php CBSHelper::getFormName('booking_date_format'); ?>" value="<?php echo esc_attr($this->data['meta']['booking_date_format']); ?>"/>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Booking slot size',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Value in minutes, e.g. 30 min slots will show open slots at 8:00, 8:30, 9:00 etc.',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<input type="text" maxlength="3" name="<?php CBSHelper::getFormName('booking_time_interval'); ?>" id="<?php CBSHelper::getFormName('booking_time_interval'); ?>" value="<?php echo esc_attr($this->data['meta']['booking_time_interval']); ?>"/>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Advance booking period',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend"><?php esc_html_e('Allow booking up to this number of days in advance.',PLUGIN_CBS_DOMAIN); ?></span>
					<div>
						<input type="text" maxlength="3" name="<?php CBSHelper::getFormName('booking_day_count'); ?>" id="<?php CBSHelper::getFormName('booking_day_count'); ?>" value="<?php echo esc_attr($this->data['meta']['booking_day_count']); ?>"/>
					</div>
				</li>				
			</ul>
		</div>

		<script type="text/javascript">
			jQuery(document).ready(function($) 
			{
				$('#to-table-date-exclude').table();
			});
		</script>