<?php 
		echo $this->data['nonce']; 
?>
		<div class="to">
			<ul class="to-form-field-list">
				<li>
					<h5><?php esc_html_e('Booking status',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Select booking status.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>
					<div class="to-radio-button">
<?php
		foreach($this->data['dictionary']['bookingStatus'] as $bookingStatusIndex=>$bookingStatusData)
		{
?>
						<input type="radio" value="<?php echo esc_attr($bookingStatusIndex); ?>" id="<?php CBSHelper::getFormName('booking_status_'.$bookingStatusIndex); ?>" name="<?php CBSHelper::getFormName('booking_status'); ?>" <?php CBSHelper::checkedIf($this->data['meta']['booking_status'],$bookingStatusIndex); ?>/>
						<label for="<?php CBSHelper::getFormName('booking_status_'.$bookingStatusIndex); ?>"><?php echo esc_html($bookingStatusData[0]); ?></label>							
<?php		
		}
?>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Duration',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Duration.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>
						<input type="text" name="<?php CBSHelper::getFormName('date_time'); ?>" id="<?php CBSHelper::getFormName('date_time'); ?>" value="<?php echo esc_attr($this->data['other']['bookingDuration']); ?>" disabled="disabled"/>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Price',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Price.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>
						<input type="text" name="<?php CBSHelper::getFormName('price'); ?>" id="<?php CBSHelper::getFormName('date_time'); ?>" value="<?php echo esc_attr($this->data['other']['bookingPrice']); ?>" disabled="disabled"/>
					</div>
				</li>
<?php
		if(array_key_exists('payment_type',$this->data['meta']))
		{
			$PaymentType=new CBSPaymentType();
?>
				<li>
					<h5><?php esc_html_e('Payment type',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Payment type.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>
						<input type="text" name="<?php CBSHelper::getFormName('payment_type'); ?>" id="<?php CBSHelper::getFormName('payment_type'); ?>" value="<?php echo esc_html($PaymentType->getName($this->data['meta']['payment_type'])); ?>" disabled="disabled"/>
					</div>
				</li>			
<?php
			if(array_key_exists('payment',$this->data))
			{
?>				
				<li>
					<h5><?php esc_html_e('Transactions',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('List of registered transactions for this payment.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>	
						<table class="to-table">
							<thead>
								<tr>
									<th style="width:20%">
										<div>
											<?php esc_html_e('Transaction ID',PLUGIN_CBS_DOMAIN); ?>
											<span class="to-legend"><?php esc_html_e('Transaction ID.',PLUGIN_CBS_DOMAIN); ?></span>
										</div>
									</th>
									<th style="width:15%">
										<div>
											<?php esc_html_e('Type',PLUGIN_CBS_DOMAIN); ?>
											<span class="to-legend"><?php esc_html_e('Type',PLUGIN_CBS_DOMAIN); ?></span>
										</div>
									</th>
									<th style="width:20%">
										<div>
											<?php esc_html_e('Date',PLUGIN_CBS_DOMAIN); ?>
											<span class="to-legend"><?php esc_html_e('Date',PLUGIN_CBS_DOMAIN); ?></span>
										</div>
									</th>	
									<th style="width:15%">
										<div>
											<?php esc_html_e('Status',PLUGIN_CBS_DOMAIN); ?>
											<span class="to-legend"><?php esc_html_e('Status',PLUGIN_CBS_DOMAIN); ?></span>
										</div>
									</th>
									<th style="width:20%">
										<div>
											<?php esc_html_e('Amount',PLUGIN_CBS_DOMAIN); ?>
											<span class="to-legend"><?php esc_html_e('Amount',PLUGIN_CBS_DOMAIN); ?></span>
										</div>
									</th>	
									<th style="width:10%">
										<div>
											<?php esc_html_e('Currency',PLUGIN_CBS_DOMAIN); ?>
											<span class="to-legend"><?php esc_html_e('Currency',PLUGIN_CBS_DOMAIN); ?></span>
										</div>
									</th>
								</tr>
							</thead>
							<tbody>
<?php
				foreach($this->data['payment'] as $paymentIndex=>$paymentData)
				{
?>
								<tr>
									<td><div><?php echo esc_html($paymentData->{'txn_id'}); ?></div></td>
									<td><div><?php echo esc_html($paymentData->{'payment_type'}); ?></div></td>
									<td><div><?php echo esc_html($paymentData->{'payment_date'}); ?></div></td>
									<td><div><?php echo esc_html($paymentData->{'payment_status'}); ?></div></td>
									<td><div><?php echo esc_html($paymentData->{'mc_gross'}); ?></div></td>
									<td><div><?php echo esc_html($paymentData->{'mc_currency'}); ?></div></td>
								</tr>
<?php
				}
?>
							</tbody>
						</table>
					</div>
				</li>
<?php				
			}
		}
?>
				<li>
					<h5><?php esc_html_e('Location',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Selected location.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>
						<input type="text" name="<?php CBSHelper::getFormName('location'); ?>" id="<?php CBSHelper::getFormName('location'); ?>" value="<?php echo esc_attr($this->data['meta']['location_name']); ?>" disabled="disabled"/>
						<a href="<?php echo get_edit_post_link($this->data['meta']['location_id']); ?>"><?php esc_html_e('Edit this location',PLUGIN_CBS_DOMAIN); ?></a>
					</div>
				</li>
				<li>
					<h5><?php esc_html_e('Vehicle',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Selected vehicle type.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>
						<input type="text" name="<?php CBSHelper::getFormName('vehicle'); ?>" id="<?php CBSHelper::getFormName('vehicle'); ?>" value="<?php echo esc_attr($this->data['meta']['vehicle_name']); ?>" disabled="disabled"/>
						<a href="<?php echo get_edit_post_link($this->data['meta']['vehicle_id']); ?>"><?php esc_html_e('Edit this vehicle',PLUGIN_CBS_DOMAIN); ?></a>
					</div>
				</li>
<?php
		if((array_key_exists('package_id',$this->data['meta'])) && ($this->data['meta']['package_id']!=0))
		{
?>
				<li>
					<h5><?php esc_html_e('Package',PLUGIN_CBS_DOMAIN); ?></h5>
					<span class="to-legend">
						<?php esc_html_e('Selected package.',PLUGIN_CBS_DOMAIN); ?><br/>
					</span>
					<div>
						<input type="text" name="<?php CBSHelper::getFormName('package'); ?>" id="<?php CBSHelper::getFormName('package'); ?>" value="<?php echo esc_attr($this->data['meta']['package_name']); ?>" disabled="disabled"/>
						<a href="<?php echo get_edit_post_link($this->data['meta']['package_id']); ?>"><?php esc_html_e('Edit this package',PLUGIN_CBS_DOMAIN); ?></a>
					</div>
				</li>				
<?php
		}
?>
			</ul>
		</div>
		<script type="text/javascript">
			jQuery(document).ready(function($)
			{	
				$('.to').themeOptionElement({init:true});
				$().CBSPluginAdmin().closeMetaBox(['booking_client']);
			});
		</script>