<?php 

class rhc_timetable_options {
	var $id;
	function __construct($plugin_id='rhc'){
		$this->id = $plugin_id;
		add_filter("pop-options_{$this->id}",array(&$this,'options'),10,1);	
		add_action('pop_handle_save',array(&$this,'pop_handle_save'),50,1);		
	}
	
	function pop_handle_save(){

	}
	
	function get_pages_for_dropdown(){
		$args = array(
			'post_type'=>'page',
			'post_status'=>array('draft','publish'),
			'orderby'=>'title',
			'order'=>'ASC',
			'nopaging'=>true,
			'numberposts'=>-1
		);
	
		$posts = get_posts($args);
		
		if(is_array($posts) && count($posts)>0){
			$arr = array(''=>__('--default--','rhctimetable'));
			foreach($posts as $r){
				$arr[$r->ID] = sprintf("%s (%s)", $r->post_title, $r->post_status);
			}
			return $arr;
		}else{
			return array(''=>__('No options','rhctimetable'));
		}
	}
		
	function options( $t ){
		$i = count($t);
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhc-timetable'; 
		$t[$i]->label 		= __('Timetable Item','rhctimetable');
		$t[$i]->right_label	= __('Timetable Item Options','rhctimetable');
		$t[$i]->page_title	= __('Timetable Item','rhctimetable');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;		
		$t[$i]->options = array();	

		$t[$i]->options[] = (object)array(
				'type'=>'subtitle',
				'label'=>__('Timetable post type','rhctimetable')
			);

		$t[$i]->options[] =	(object)array(
				'id'			=> 'rhc-timetable-slug',
				'type' 			=> 'text',
				'label'			=> __('Timetable Item Post Type Slug','rhctimetable'),
				'description'	=> __('Max. 20 characters, cannot contain capital letters or spaces','rhctimetable'),
				'save_option'=>true,
				'load_option'=>true
			);			
		
		$pages = $this->get_pages_for_dropdown();	
		
		$t[$i]->options[]=(object)array(
				'id'			=> 'timetable_template_page_id',
				'type' 			=> 'select',
				'label'			=> __('Timetable Page Template (optional)','rhctimetable'),
				'description'	=> sprintf('<p>%s</p><p>%s</p>',
					__('Defaults to the event template.  Select the page you want to use as a template for the timetable event page.','rhctimetable'),
					__('Note:  the page used as template have to be in publish status or the event page will only show to visitors that are logged in to the website; visitors will get an empty page or 404 page', 'rhctimetable')
				),
				'el_properties'=>array('class'=>'widefat'),
				'options'=> $pages,
				'save_option'=>true,
				'load_option'=>true
			);		
		
		$t[$i]->options[] = (object)array(
				'type'=>'subtitle',
				'label'=>__('Timetable Item Access','rhctimetable')
			);

		$t[$i]->options[] =	(object)array(
				'id'			=> 'rhc-timetable-capability',
				'type' 			=> 'select',
				'label'			=> __('Capability required to manage','rhctimetable'),
				'description'	=> __('If you change this option to manage_rhc_timetable, you also need to go to the Feature access tab to specify what roles have this capability.','rhctimetable'),
				'options'		=> array(
					'manage_options' 		=> 'manage_options',
					'manage_rhc_timetable' 	=> 'manage_rhc_timetable'
				),
				'default'		=> 'manage_options',
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[] = (object)array(
				'type'=>'subtitle',
				'label'=>__('Backend Options','rhctimetable')
			);
			
		$t[$i]->options[] = (object)array(
				'id'			=> 'timtetable_backend_defaultview',
				'type' 			=> 'select',
				'label'			=> __('Default view','rhctimetable'),
				'options'		=> apply_filters('rhc_views', array(
					''			=> __('--choose--','rhctimetable'),
					//month, basicWeek, basicDay, agendaWeek, agendaDay
					'month'		=> __('Month','rhctimetable'),
					'basicWeek'	=> __('Week','rhctimetable'),
					'agendaWeek'=> __('Agenda Week','rhctimetable')
				)),
				'description' => __('The options in this tab apply to the calendar metabox that is used in the backend to define an event date.','rhctimetable'),
				'default'	=> 'agendaWeek',
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[] = (object)array(
				'type'=>'subtitle',
				'label'=>__('Other Options','rhctimetable')
			);

		$t[$i]->options[] = (object)array(
				'id'			=> 'tt_no_vscroll',
				'type' 			=> 'yesno',
				'label'			=> __('Remove Vertical Scroll','rhctimetable'),
				'description' => __('By default, vertical scrollbars will be removed from timetables.  Choose No to use scrollbars.','rhctimetable'),
				'default'	=> '1',
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[] = (object)array(
				'id'			=> 'tt_add_author',
				'type' 			=> 'yesno',
				'label'			=> __('Add author to events','rhctimetable'),
				'description' => __('Add author to events ajax.  Used by a template that includes the author.','rhctimetable'),
				'default'	=> '1',
				'save_option'=>true,
				'load_option'=>true
			);
			
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
					
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhctimetable'),
				'class' => 'button-primary'
			);
		
		return $t;
	}
}


?>