<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class plugin_rhc_taxonomy_dropdown {
	function plugin_rhc_taxonomy_dropdown(){
		add_filter('get_calendarize_args_options', array(&$this,'get_calendarize_args_options'), 10, 2);
		add_filter('get_calendarize_args_output', array(&$this,'get_calendarize_args_output'), 10, 1);
	}
	
	function get_calendarize_args_options( $options, $atts ){
		//-------------------------
		$default_taxonomies = array(
			RHC_CALENDAR 	=> __('Calendar','rhc'),
			RHC_ORGANIZER	=> __('Organizer','rhc'),
			RHC_VENUE		=> __('Venues','rhc')
		);
		
		$taxonomies = apply_filters('rhc-taxonomies',$default_taxonomies);
		
		global $rhc_plugin;
		$linked_taxonomies = $rhc_plugin->get_option('taxonomies',false,true);
		if( is_array($linked_taxonomies) && count($linked_taxonomies)>0 ){
			foreach($linked_taxonomies as $taxonomy){
				if( $tax = get_taxonomy( $taxonomy) ){
					$taxonomies[ $taxonomy ] = $tax->label;
				}
			}
		}		
					
		//-------------------------	
		foreach( $options->modes as $mode => $mode_options ){
			foreach($taxonomies as $t => $label){
				$btn = sprintf('btn_tax_%s',
					str_replace('-','',$t)
				);
				$options->modes[$mode]['options']->$btn='btn_tax_dropdown';
				$options->modes[$mode]['options']->buttonText->$btn=$label;
			}
		}	
		return $options;
	}
	function get_calendarize_args_output($out){
		return str_replace('"btn_tax_dropdown"','btn_tax_dropdown',$out);
	}
}
?>