<?php

/**
 *
 *
 * @version $Id$
 * @copyright 2003
 **/

class plugin_panels {
	var $options = array();
	function __construct($args=array()){
		//------------
		$defaults = array(
			'id'					=> 'rhp',
			'plugin_code'			=> 'PW',
			'options_varname'		=> 'rhp_options',
			'options_parameters'	=> array(),
			'options_capability'	=> 'manage_options',
			'options_panel_version'	=> '2.2.0',
			'development'			=> false,
			//'modal_login_shortcode'	=>'social_login_button',
			'page_title'			=> __('Panels Settings','rhp'),
			'menu_title'			=> __('Panels','rhp'),
			'resources_path'		=> 'rhp',
			'own_jquery'			=> false
		);

		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}

		add_action('plugins_loaded',array(&$this,'plugins_loaded'),9);
		add_action('init',array(&$this,'init'));
        add_action('wp', array(&$this, 'rhp_set_data'));

		//-----------
		$this->options = get_option($this->options_varname);
		$this->options = is_array($this->options)?$this->options:array();
		//--------
		add_filter('rhc_post_info_quick_icons',array(&$this,'rhc_post_info_quick_icons'),10,1);
        if( $this->get_option('enable_opengraph','1',true) == '1' ){
        	add_action('wp_head', array(&$this, 'rhp_open_graph'), 5);
        }
	}

    function rhp_open_graph() {
        global $post;

        $output = '';
		if(is_singular()) {
			if(has_post_thumbnail()) {
				$img_src = wp_get_attachment_url( get_post_thumbnail_id() );
			} else {
				$image_id = get_post_meta($post->ID, 'rhc_tooltip_image', true);
				$img_src = wp_get_attachment_url($image_id);
			}

			if($excerpt = get_the_excerpt() ) {
				$excerpt = strip_tags($excerpt);
				$excerpt = str_replace("", "'", $excerpt);
			} else {
				$excerpt = get_bloginfo('description');
			}
			$url = get_permalink();
			if( is_singular() && isset($_REQUEST['event_rdate']) ){
				$arr = explode(',', $_REQUEST['event_rdate'] );
				if( count($arr)==2 && is_numeric($arr[0]) && is_numeric($arr[1]) ){
					$url = shortcode_calendarize::addURLParameter($url, 'event_rdate', $_REQUEST['event_rdate']);
				}
			}
			 $output = '<meta property="og:title" content="' . get_the_title() . '"/>
<meta property="og:description" content="' . $excerpt . '"/>
<meta property="og:type" content="article"/>
<meta property="og:url" content="' . $url . '"/>
<meta property="og:site_name" content="' . get_bloginfo('name'). '"/>
<meta property="og:image" content="' . $img_src . '"/>';

		}
        echo $output;
    }

	function rhc_post_info_quick_icons($arr){
		foreach($arr as $o){
			if($o->id=='share'){
				$o->items[]=new quick_icon_item(array(
					'label'							=> __('Social Panel','rhp'),
					'post_extrainfo_type'			=> 'custom',
					'post_extrainfo_label'			=> '',
					'post_extrainfo_value'			=> '[social_sharing]'
				));
			}
		}
		return $arr;
	}

	function plugins_loaded(){
		$settings = $this->options;
		$enable = isset($settings['enable_sliding_panels']) ? $settings['enable_sliding_panels'] : 0;
		if($enable == 1){
			add_shortcode('sliding_panels', array(&$this,'sliding_panels_shortcode'));
			add_shortcode('social_sharing', array(&$this,'sliding_panels_shortcode'));
		}

		if(is_admin()){
			do_action('rh-php-commons');

			require_once RHP_PATH.'includes/class.rhp_panel_settings.php';
			new rhp_settings($this->id);

			$settings = array(
				'id'					=> $this->id,
				'plugin_id'				=> 'rhc',
				'capability'			=> $this->options_capability,
				'options_varname'		=> $this->options_varname,
				'menu_id'				=> 'rhp-options',
				'page_title'			=> __('Social Sharing Panel','rhp'),
				'menu_text'				=> __('Social Sharing Panel','rhp'),
				'option_menu_parent'	=> 'edit.php?post_type='.RHC_EVENTS,
				'notification'			=> (object)array(
					'plugin_version'=> RHP_VERSION,
					'plugin_code' 	=> $this->plugin_code,
					'message'		=> __('Panel plugin update %s is available! <a href="%s">Please update now</a>','rhp')
				),
				'theme'					=> false,
				'extracss'				=> 'extracss-'.$this->id,
				'fileuploader'			=> true,
				'stylesheet'			=> 'rhp-options',
				'option_show_in_metabox'=> true,
				//'dc_options'			=> $dc_options,
				'pluginurl'				=> RHP_URL,
				'pluginslug'	=> RHP_SLUG,
				'api_url' 		=> "http://plugins.righthere.com",
				'autoupdate'	=> false,
				'path'			=> RHC_PATH.'options-panel/',
				'url'			=> RHC_URL.'options-panel/',
				'layout'		=> 'horizontal'
			);

			new PluginOptionsPanelModule($settings);
		}
	}

	function init(){
		global $rhp_plugin;
		if( $rhp_plugin->get_option('enable_sliding_panels','',true) == '1' ){
			if(!is_admin()){
				wp_enqueue_script('jquery');

				wp_enqueue_style( 'rhp-style', RHP_URL.'css/styles.css');
				wp_enqueue_style( 'rhp-panel-style', RHP_URL.'css/panel.css');


				wp_enqueue_script('fb','https://connect.facebook.net/en_US/sdk.js'); 
				wp_enqueue_script('google', 'https://apis.google.com/js/client.js');
				wp_enqueue_script('linkedin', 'https://platform.linkedin.com/in.js');

			}
		}
	}

	function rhp_set_data(){
		global $rhp_plugin;
		global $post;

		if( $rhp_plugin->get_option('enable_sliding_panels','',true) == '1' ){
			if(!is_admin()){
				$settings = $this->options;

                if(has_post_thumbnail()) {
                    $img_src = wp_get_attachment_url(get_post_thumbnail_id());
                } else {
                    $image_id = get_post_meta($post->ID, 'rhc_tooltip_image', true);
                    $img_src = wp_get_attachment_url($image_id);
                }

                if($excerpt = $post->post_excerpt) {
                    $excerpt = strip_tags($post->post_excerpt);
                    $excerpt = str_replace("", "'", $excerpt);
                } else {
                    $excerpt = get_bloginfo('description');
                }
				$url = get_permalink();
				if( is_singular() && isset($_REQUEST['event_rdate']) ){
					$arr = explode(',', $_REQUEST['event_rdate'] );
					if( count($arr)==2 && is_numeric($arr[0]) && is_numeric($arr[1]) ){
						$url = shortcode_calendarize::addURLParameter($url, 'event_rdate', $_REQUEST['event_rdate']);
					}
				}
				$data = array(
					'shareLink' 			=> $url,
					'shareDescription' 		=> $excerpt,
					'shareRedirectURI' 		=> $url,
					'shareTitle' 			=> $post->post_title,
					'sharePicture' 			=> $img_src,
					'RHP_URL' 				=> RHP_URL,
					'fb_appID' 				=> $settings['rhp_facebook_app_id'],
	 				'panel_style' 			=> $settings['sliding_panels_style'],
	 				// 'sliding_panel_contents' => $settings['sliding_panel_contents'],
	 				'link1' 	=> (isset($settings['custom_link_text1'])) ? $settings['custom_link_text1'] : '',
	 				'url1' 		=> (isset($settings['custom_link_url1'])) ? $settings['custom_link_url1'] : '',
	 				'link2' 	=> (isset($settings['custom_link_text2'])) ? $settings['custom_link_text2'] : '',
	 				'url2' 		=> (isset($settings['custom_link_url2'])) ? $settings['custom_link_url2'] : '',
	 				'link3' 	=> (isset($settings['custom_link_text3'])) ? $settings['custom_link_text3'] : '',
	 				'url3' 		=> (isset($settings['custom_link_url3'])) ? $settings['custom_link_url3'] : '',
	 				'link4' 	=> (isset($settings['custom_link_text4'])) ? $settings['custom_link_text4'] : '',
	 				'url4' 		=> (isset($settings['custom_link_url4'])) ? $settings['custom_link_url4'] : '',
	 				'link5' 	=> (isset($settings['custom_link_text5'])) ? $settings['custom_link_text5'] : '',
	 				'url5' 		=> (isset($settings['custom_link_url5'])) ? $settings['custom_link_url5'] : '',
	 				'link6' 	=> (isset($settings['custom_link_text6'])) ? $settings['custom_link_text6'] : '',
	 				'url6' 		=> (isset($settings['custom_link_url6'])) ? $settings['custom_link_url6'] : '',
	 				'link7' 	=> (isset($settings['custom_link_text7'])) ? $settings['custom_link_text7'] : '',
	 				'url7' 		=> (isset($settings['custom_link_url7'])) ? $settings['custom_link_url7'] : '',
	 				'link8' 	=> (isset($settings['custom_link_text8'])) ? $settings['custom_link_text8'] : '',
	 				'url8' 		=> (isset($settings['custom_link_url8'])) ? $settings['custom_link_url8'] : '',
	 				'link9' 	=> (isset($settings['custom_link_text9'])) ? $settings['custom_link_text9'] : '',
	 				'url9' 		=> (isset($settings['custom_link_url9'])) ? $settings['custom_link_url9'] : '',
	 				'link10' 	=> (isset($settings['custom_link_text10'])) ? $settings['custom_link_text10'] : '',
	 				'url10' 	=> (isset($settings['custom_link_url10'])) ? $settings['custom_link_url10'] : '',
					'rhp_title' => $settings['rhp_title']
				);
				wp_enqueue_script('rhp-classie', RHP_URL . 'js/classie.js');
				wp_enqueue_script('rhp-script', RHP_URL.'js/script.js', array(),'1.0.0', true);
				wp_enqueue_script('rhp-frontend-script', RHP_URL . 'js/frontend.js', array(), '1.0.0', true);
				wp_localize_script('rhp-script', 'rhp_vars', $data);
			}
		}
	}


	function get_option($name,$default='',$default_if_empty=false){
		$value = isset($this->options[$name])?$this->options[$name]:$default;
		if($default_if_empty){
			$value = ''==$value?$default:$value;
		}
		return $value;
	}


	function sliding_panels_shortcode($atts,$content=null,$code=""){
		global $settings,$rhp_plugin,$post;
		if( $rhp_plugin->get_option('enable_sliding_panels','',true) != '1' ){
			return '';
		}

		$settings = get_option('rhp_options');
		
		$post_id = get_the_ID();
		if( !is_object($post) || !property_exists( $post, 'post_title' ) ){
			//self rescue, in case of running an older rhc. issue: title not set on dynamic details on event list.
			$post = get_post( $post_id );
		}
		
		if(has_post_thumbnail()) {
			$img_src = wp_get_attachment_url(get_post_thumbnail_id());
		} else {
			$image_id = get_post_meta( $post_id, 'rhc_tooltip_image', true);
			$img_src = wp_get_attachment_url($image_id);
		}

		if( is_admin() ){
			//if in wp-admin, calling get_the_excerpt creates an infinite loop when using social_sharing inside the custom detail layout tool.
			$excerpt = '';		
		}else{
			if($excerpt = get_the_excerpt() ) {
				$excerpt = strip_tags( $excerpt );
				$excerpt = str_replace("", "'", $excerpt);
			} else {
				$excerpt = get_bloginfo('description');
			}				
		}

		//------------
		$url = get_permalink();
		if( is_singular() && isset($_REQUEST['event_rdate']) ){
			$arr = explode(',', $_REQUEST['event_rdate'] );
			if( count($arr)==2 && is_numeric($arr[0]) && is_numeric($arr[1]) ){
				$url = shortcode_calendarize::addURLParameter($url, 'event_rdate', $_REQUEST['event_rdate']);
			}
		}
		
		//-------------
		$default = array(
			'label'				=> $rhp_plugin->get_option('rhp_btn_label',__('Share','rhp'),true),
			//--------------------
			//'RHP_PATH' => RHP_PATH, //there is no reason for this to be showing in the client.
			'shareLink' 		=> $url, //$settings['facebookLink'],
			'shareDescription' 	=> $excerpt, //$settings['facebookDescription'],
			'shareRedirectURI' 	=> $url,
			'shareTitle' 		=> get_the_title(),
			'sharePicture' 		=> $img_src,
			'RHP_URL' 			=> RHP_URL,
			'fb_appID' 			=> @$settings['rhp_facebook_app_id'],
			// 'facebookShareName' => @$settings['facebookShareName'],
			// 'facebookCaption' 	=> @$settings['facebookCaption'],
			'panel_style' 		=> @$settings['sliding_panels_style'],
			// 'sliding_panel_contents' => @$settings['sliding_panel_contents'],
			'link1' 			=> @$settings['custom_link_text1'],
			'url1' 				=> @$settings['custom_link_url1'],
			'link2' 			=> @$settings['custom_link_text2'],
			'url2' 				=> @$settings['custom_link_url2'],
			'link3' 			=> @$settings['custom_link_text3'],
			'url3' 				=> @$settings['custom_link_url3'],
			'link4' 			=> @$settings['custom_link_text4'],
			'url4' 				=> @$settings['custom_link_url4'],
			'link5' 			=> @$settings['custom_link_text5'],
			'url5' 				=> @$settings['custom_link_url5'],
			'link6' 			=> @$settings['custom_link_text6'],
			'url6' 				=> @$settings['custom_link_url6'],
			'link7' 			=> @$settings['custom_link_text7'],
			'url7' 				=> @$settings['custom_link_url7'],
			'link8' 			=> @$settings['custom_link_text8'],
			'url8' 				=> @$settings['custom_link_url8'],
			'link9' 			=> @$settings['custom_link_text9'],
			'url9' 				=> @$settings['custom_link_url9'],
			'link10' 			=> @$settings['custom_link_text10'],
			'url10' 			=> @$settings['custom_link_url10'],
			'rhp_title' 		=> @$settings['rhp_title'],
			'enable_facebook'	=> $rhp_plugin->get_option('enable_facebook','1',true),
			'enable_twitter'	=> $rhp_plugin->get_option('enable_twitter','1',true),
			'enable_linkedin'	=> $rhp_plugin->get_option('enable_linkedin','1',true),
			'enable_google'		=> $rhp_plugin->get_option('enable_google','1',true)
		 );
		$data = shortcode_atts($default, $atts);
		//------------
		$label = $data['label'];
		$rhp_vars = esc_attr( json_encode( $data ) );
		ob_start();
?>
<div class="rhcalendar">
	<span class="fc-button fc-button-social-panels fc-state-default  fc-corner-left fc-corner-right" data-rhp_vars="<?php echo $rhp_vars?>">
		<span class="fc-button-inner">
			<span class="fc-button-content"><?php echo $label?></span>
			<span class="fc-button-effect"><span></span></span>
		</span>
	</span>
</div>
<?php
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
	}
}
?>
