<?php
/**
Plugin Name: SCO Reddit
Plugin URI: http://calendarize.it
Description: Integration Reddit to the social connection module.
Version: 1.0.0
Author: Maxim Levikov (RightHere LLC)
Author URI: http://calendarize.it
 **/

if( !defined('SPSCOREDDIT_PATH')): //only load the code if not loaded by another plugins addon.

if(defined('RHC_ADDON_PATH')){
	define('SPSCOREDDIT_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("SPSCOREDDIT_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('SPSCOREDDIT_PATH', plugin_dir_path(__FILE__) ); 
	define("SPSCOREDDIT_URL", plugin_dir_url(__FILE__) );
}  

class plugin_sco_reddit {
	var $id;
	var $name;
	var $option;
	function plugin_sco_reddit( $args=array() ){
		//------------
		$defaults = array(
			'id'				=> 'reddit',
			'plugin_id'			=> 'rhsco',
			'name'				=> 'Reddit',
			'option'			=> 'reddit_enable'
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------	
		//filter from social-connection/map_network_names.php
		//description:  this filter tells the main plugin the new network id, name, and the option that enables it.
		add_filter( 'get_sco_installed_networks', array( &$this, 'get_sco_installed_networks' ), 10, 1 );
		//filter from social-connection/class.sco_options.php
		//description:  this filter adds options to the social connection options panel 
		add_filter( 'sco_options', array( &$this, 'sco_options' ), 10, 3 );
		//filter from social-connection/class.sco_ajax.php
		//description, the main plugin loooks for files with the form login_wit_NETWORKID.php,
		//this filter just tells the main plugin the right path to the addon network.
		add_filter( 'sco_social_connect_filename', array( &$this, 'sco_social_connect_filename' ), 10, 2 );
	}
	
	function sco_social_connect_filename( $filename ){
		if( 'login_with_reddit.php'==$filename ){
			return SPSCOREDDIT_PATH.'/'.$filename;
		}
		return $filename;
	}
	
	function sco_options( $t, $i, $o ){
		$i = count($t);

		//-- this network -----------------------	
		$description =  __('For more information on setting up the OAuth API credentials, please visit our <a href="https://righthere.zendesk.com" target="_blank">Help Center</a>.<br><br>
			<b>REDIRECT URI:</b><br>'
			.site_url().'/wp-admin/admin-ajax.php?action=sco_social_connect&network='.$this->id.'&window_close=1', 'rhsco');

		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhcsco-reddit'; 
		$t[$i]->open 		= false; 
		$t[$i]->label 		= __('Reddit','rhsco');
		$t[$i]->right_label	= __('Reddit','rhsco');
		$t[$i]->page_title	= __('Reddit','rhsco');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;		
		$t[$i]->options = array();	
	
		$t[$i]->options[]=(object)array(
				'type'	=> 'subtitle',
				'label'	=> __('Reddit','rhsco')
			);
						
		$t[$i]->options[] =	(object)array(
				'id'			=> 'reddit_enable',
				'label'			=> __('Enable Reddit','rhsco'),
				'type'			=> 'onoff',
				'default'		=> '0',
				'hidegroup'		=> '#reddit_group',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);
		
		$t[$i]->options[]=(object)array(
				'id'	=> 'reddit_group',
				'type'	=> 'div_start'
			);
						
		$t[$i]->options[] =	(object)array(
				'id'			=> 'reddit_app_id',
				'label'			=> __('Web App','rhsco'),
				'description'	=> $description,
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);
						
		$t[$i]->options[] =	(object)array(
				'id'			=> 'reddit_app_secret',
				'label'			=> __('Secret','rhsco'),
				//'description'	=> __('Specify a maximun number of taxonomies that a user can create by default.','rhsco'),
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);	
			
		$t[$i]->options[] =	(object)array(
				'id'			=> 'reddit_login_label',
				'label'			=> __('Login label','rhsco'),
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);	
		
		$t[$i]->options[]=(object)array(
				'type'	=> 'div_end'
			);
		
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
		
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcs'),
				'class' => 'button-primary'
			);		

		return $t;
	}
	
	function get_sco_installed_networks( $sco_installed_networks ){
		$sco_installed_networks[ $this->id ] = (object)array(
			'name' 		=> $this->name,
			'option'	=> $this->option
		);
		return $sco_installed_networks;
	}
} 

new plugin_sco_reddit();

endif;
?>