<?php

if('sco_ajax'==get_class($this)):
	$client_id 		=  $this->get_option('mailru_app_id','',true);
	$client_secret 	=  $this->get_option('mailru_app_secret','',true);
	//-----
	if(!class_exists('http_class'))			require( $path.'oauth-api/http.php');
	if(!class_exists('oauth_client_class'))	require( $path.'oauth-api/oauth_client.php');

	$client = new oauth_client_class;
	$client->debug = false;
	$client->debug_http = true;
	$client->oauth_version = '2.0';
	$client->dialog_url = 'https://connect.mail.ru/oauth/authorize?client_id={CLIENT_ID}&redirect_uri={REDIRECT_URI}&scope={SCOPE}&response_type=code&state={STATE}';
	$client->access_token_url = 'https://connect.mail.ru/oauth/token';
	$client->store_access_token_response = true;
	//--
	$client->redirect_uri	= $redirect_uri;
	$client->client_id 		= $client_id;
	$client->client_secret	= $client_secret;

	if(strlen($client->client_id) == 0
	|| strlen($client->client_secret) == 0)
		$this->error_message( __('Settings error, network api credentials not set.','rhsco') );

	/* API permissions
     */
    $client->scope = '';
    if(($success = $client->Initialize())){
        if(($success = $client->Process())){
            if(strlen($client->authorization_error)){
                $client->error = $client->authorization_error;
                $success = false;
            }
            elseif(strlen($client->access_token))
            {
                /*
                 * Request parameters must be signed for the request to be
                 * accepted
                 *
                 * The current user ID is taken from the x_mailru_vid response
                 * parameters
                 */
                $parameters = array(
                    'method'=>'users.getInfo',
                    'uids'=>$client->access_token_response['x_mailru_vid'],
                    'app_id'=>$client->client_id,
                    'secure'=>'1'
                );
                ksort($parameters);
                $values = '';
                $url = 'http://www.appsmail.ru/platform/api?sig={signature}';
                foreach($parameters as $key => $value)
                {
                    $values .= $key.'='.$value;
                    $url .= '&'.$key.'='.$value;
                }
                $url = str_replace('{signature}', md5($values.$client->client_secret), $url);
                $success = $client->CallAPI(
                    $url,
                    'GET', array(), array('FailOnAccessError'=>true), $user);
            }
        }
        $success = $client->Finalize($success);
    }
	if($client->exit)
		exit;
	if($success){
		$user_short = $user[0];
		$user = (object)array(
			'id'		=> $user_short->uid,
			'username' 	=> substr($user_short->email, 0, strpos($user_short->email, '@')),
			'name'		=> $user_short->first_name.' '.$user_short->last_name,
			'first_name'=> $user_short->first_name,
			'last_name' => $user_short->last_name,
			'email' 	=> $user_short->email,
			'link'		=> $user_short->link
		);

		$SCO_Profile = new SCO_Profile( $network, (array)$user, $this->cb_get_option, true, true );
	}else{
		$this->error_message( sprintf( __('Error authenticating with social network: %s','rhsco'), HtmlSpecialChars($client->error) ) );
	}
else:
	$this->error_message( __('Settings error, cannot link directly to this file.', 'rhsco') );
endif; 
 

?>