<?php

if('sco_ajax'==get_class($this)):
	$client_id 		=  $this->get_option('dribbble_app_id','',true);
	$client_secret 	=  $this->get_option('dribbble_app_secret','',true);
	//-----
	if(!class_exists('http_class'))			require( $path.'oauth-api/http.php');
	if(!class_exists('oauth_client_class'))	require( $path.'oauth-api/oauth_client.php');
	
	$client = new oauth_client_class;
	$client->debug = false;
	$client->debug_http = true;
	$client->dialog_url = 'https://dribbble.com/oauth/authorize?client_id={CLIENT_ID}&redirect_uri={REDIRECT_URI}&scope={SCOPE}&state={STATE}';
	$client->access_token_url = 'https://dribbble.com/oauth/token';
	$client->token_request_method = 'POST';
	//--
	$client->redirect_uri	= $redirect_uri;
	$client->client_id 		= $client_id;
	$client->client_secret	= $client_secret;

	if(strlen($client->client_id) == 0
	|| strlen($client->client_secret) == 0)
		$this->error_message( __('Settings error, network api credentials not set.','rhsco') );

	/**
	 * API permissions
	 */
	if(($success = $client->Initialize())){
		if(($success = $client->Process())){
			if(strlen($client->access_token)){
				$success = $client->CallAPI(
					'https://api.dribbble.com/v1/user', 
					'GET', array(), array('FailOnAccessError'=>true), $user);
			}
		}
		$success = $client->Finalize($success);
	}
	if($client->exit)
		exit;
	if($success){
		extract((array)$user);
		$user = (object)array(
			'id'		=> $id,
			'username' 	=> $username,
			'name'		=> $name,
			'link'		=> $home_url
		);

		$SCO_Profile = new SCO_Profile( $network, (array)$user, $this->cb_get_option, true, true );
	}else{
		$this->error_message( sprintf( __('Error authenticating with social network: %s','rhsco'), HtmlSpecialChars($client->error) ) );
	}
else:
	$this->error_message( __('Settings error, cannot link directly to this file.', 'rhsco') );
endif;

?>