<?php

if('sco_ajax'==get_class($this)):
	$client_id 		=  $this->get_option('disqus_app_key','',true);
	$client_secret 	=  $this->get_option('disqus_app_secret','',true);
	//-----
	if(!class_exists('http_class'))			require( $path.'oauth-api/http.php');
	if(!class_exists('oauth_client_class'))	require( $path.'oauth-api/oauth_client.php');

	$client = new oauth_client_class;
	$client->debug = false;
	$client->debug_http = true;
	$client->oauth_version = '2.0';
	$client->dialog_url = 'https://disqus.com/api/oauth/2.0/authorize/?response_type=code&client_id={CLIENT_ID}&redirect_uri={REDIRECT_URI}&scope={SCOPE}&state={STATE}';
	$client->access_token_url = 'https://disqus.com/api/oauth/2.0/access_token/';
	//--

	$client->redirect_uri	= $redirect_uri;
	$client->client_id 		= $client_id;
	$client->client_secret	= $client_secret;

	if(strlen($client->client_id) == 0
	|| strlen($client->client_secret) == 0)
		$this->error_message( __('Settings error, network api credentials not set.','rhsco') );

	/* API permissions
	 */
	$client->scope = 'read,write';
	if(($success = $client->Initialize())){
		if(($success = $client->Process())){
			if(strlen($client->authorization_error)){
				$client->error = $client->authorization_error;
				$success = false;
			}
			elseif(strlen($client->access_token)){
				$success = $client->CallAPI(
					'https://disqus.com/api/3.0/users/details.json?api_key='.UrlEncode($client->client_id),
					'GET', array(), array('FailOnAccessError'=>true), $user);
			}
		}
		$success = $client->Finalize($success);
	}
	if($client->exit)
		exit;
	if($success){
		$user_short = $user->response;
		$user = (object)array(
			'id'		=> $user_short->id,
			'username' 	=> $user_short->username,
			'name'		=> $user_short->name,
			'first_name'=> (isset($user_short->name)?substr($user_short->name, 0, strpos($user_short->name, ' ')):''),
			'last_name' => (isset($user_short->name)?substr($user_short->name, strpos($user_short->name, ' ')+1):''),
			'link'		=> $user_short->profileUrl
		);

		$SCO_Profile = new SCO_Profile( $network, (array)$user, $this->cb_get_option, true, true );
	}else{
		$this->error_message( sprintf( __('Error authenticating with social network: %s','rhsco'), HtmlSpecialChars($client->error) ) );
	}
else:
	$this->error_message( __('Settings error, cannot link directly to this file.', 'rhsco') );
endif; 
 

?>