<?php
/**
Plugin Name: SCO Disqus
Plugin URI: http://calendarize.it
Description: Integration Disqus to the social connection module.
Version: 1.0.0
Author: Maxim Levikov (RightHere LLC)
Author URI: http://calendarize.it
 **/

if( !defined('SPSCODISQUS_PATH')): //only load the code if not loaded by another plugins addon.

if(defined('RHC_ADDON_PATH')){
	define('SPSCODISQUS_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("SPSCODISQUS_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('SPSCODISQUS_PATH', plugin_dir_path(__FILE__) ); 
	define("SPSCODISQUS_URL", plugin_dir_url(__FILE__) );
}

class plugin_sco_disqus {
	var $id;
	var $name;
	var $option;
	function plugin_sco_disqus( $args=array() ){
		//------------
		$defaults = array(
			'id'				=> 'disqus',
			'plugin_id'			=> 'rhsco',
			'name'				=> 'Disqus',
			'option'			=> 'disqus_enable'
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------	
		//filter from social-connection/map_network_names.php
		//description:  this filter tells the main plugin the new network id, name, and the option that enables it.
		add_filter( 'get_sco_installed_networks', array( &$this, 'get_sco_installed_networks' ), 10, 1 );
		//filter from social-connection/class.sco_options.php
		//description:  this filter adds options to the social connection options panel 
		add_filter( 'sco_options', array( &$this, 'sco_options' ), 10, 3 );
		//filter from social-connection/class.sco_ajax.php
		//description, the main plugin loooks for files with the form login_wit_NETWORKID.php,
		//this filter just tells the main plugin the right path to the addon network.
		add_filter( 'sco_social_connect_filename', array( &$this, 'sco_social_connect_filename' ), 10, 2 );
	}
	
	function sco_social_connect_filename( $filename ){
		if( 'login_with_disqus.php'==$filename ){
			return SPSCODISQUS_PATH.'/'.$filename;
		}
		return $filename;
	}
	
	function sco_options( $t, $i, $o ){
		$i = count($t);

		//-- this network -----------------------	
		$description =  __('For more information on setting up the OAuth API credentials, please visit our <a href="https://righthere.zendesk.com" target="_blank">Help Center</a>.<br><br>
			<b>Callback URL:</b><br>'
			.site_url().'/wp-admin/admin-ajax.php?action=sco_social_connect&network='.$this->id.'&window_close=1', 'rhsco');

		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhcsco-disqus'; 
		$t[$i]->open 		= false; 
		$t[$i]->label 		= __('Disqus','rhsco');
		$t[$i]->right_label	= __('Disqus','rhsco');
		$t[$i]->page_title	= __('Disqus','rhsco');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;		
		$t[$i]->options = array();	
	
		$t[$i]->options[]=(object)array(
				'type'	=> 'subtitle',
				'label'	=> __('Disqus','rhsco')
			);
						
		$t[$i]->options[] =	(object)array(
				'id'			=> 'disqus_enable',
				'label'			=> __('Enable Disqus','rhsco'),
				'type'			=> 'onoff',
				'default'		=> '0',
				'hidegroup'		=> '#disqus_group',
				'el_properties'	=> array(),
				'save_option'	=>true,
				'load_option'	=>true
			);
		
		$t[$i]->options[]=(object)array(
				'id'	=> 'disqus_group',
				'type'	=> 'div_start'
			);
						
		$t[$i]->options[] =	(object)array(
				'id'			=> 'disqus_app_key',
				'label'			=> __('API Key','rhsco'),
				'description'	=> $description,
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);
						
		$t[$i]->options[] =	(object)array(
				'id'			=> 'disqus_app_secret',
				'label'			=> __('API Secret','rhsco'),
				//'description'	=> __('Specify a maximun number of taxonomies that a user can create by default.','rhsco'),
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);	
			
		$t[$i]->options[] =	(object)array(
				'id'			=> 'disqus_login_label',
				'label'			=> __('Login label','rhsco'),
				'type'			=> 'text',
				'el_properties'	=> array('class'=>'widefat'),
				'save_option'	=>true,
				'load_option'	=>true
			);	
		
		$t[$i]->options[]=(object)array(
				'type'	=> 'div_end'
			);
		
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
		
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcs'),
				'class' => 'button-primary'
			);		

		return $t;
	}
	
	function get_sco_installed_networks( $sco_installed_networks ){
		$sco_installed_networks[ $this->id ] = (object)array(
			'name' 		=> $this->name,
			'option'	=> $this->option
		);
		return $sco_installed_networks;
	}
} 

new plugin_sco_disqus();

endif;
?>