<?php

if('sco_ajax'==get_class($this)):
	$client_id 		=  $this->get_option('bitbucket_app_key','',true);
	$client_secret 	=  $this->get_option('bitbucket_app_secret','',true);
	//-----
	if(!class_exists('http_class'))			require( $path.'oauth-api/http.php');
	if(!class_exists('oauth_client_class'))	require( $path.'oauth-api/oauth_client.php');

	$client = new oauth_client_class;
	$client->debug = false;
	$client->debug_http = true;
	$client->oauth_version = '1.0a';
	$client->request_token_url = 'https://bitbucket.org/!api/1.0/oauth/request_token';
	$client->dialog_url = 'https://bitbucket.org/!api/1.0/oauth/authenticate';
	$client->access_token_url = 'https://bitbucket.org/!api/1.0/oauth/access_token';
	$client->url_parameters = false;
	//--
	$client->redirect_uri	= $redirect_uri;
	$client->client_id 		= $client_id;
	$client->client_secret	= $client_secret;

	if(strlen($client->client_id) == 0
	|| strlen($client->client_secret) == 0)
		$this->error_message( __('Settings error, network api credentials not set.','rhsco') );

	/* API permissions
	 */
	if(($success = $client->Initialize())){
		if(($success = $client->Process())){
			if(strlen($client->access_token)){
				$success = $client->CallAPI(
					'https://api.bitbucket.org/1.0/user', 
					'GET', array(), array('FailOnAccessError'=>true), $user);
			}
		}
		$success = $client->Finalize($success);
	}
	if($client->exit)
		exit;
	if($success){
		$user_short = $user->user;
		$user = (object)array(
			'id'		=> $user_short->username,
			'username' 	=> $user_short->username,
			'name'		=> $user_short->display_name,
			'first_name'=> $user_short->first_name,
			'last_name' => $user_short->last_name,
			'link'		=> 'https://bitbucket.org/'.$user_short->username
		);
		
		$SCO_Profile = new SCO_Profile( $network, (array)$user, $this->cb_get_option, true, true );
	}else{
		$this->error_message( sprintf( __('Error authenticating with social network: %s','rhsco'), HtmlSpecialChars($client->error) ) );
	}
else:
	$this->error_message( __('Settings error, cannot link directly to this file.', 'rhsco') );
endif; 
 

?>