<?php

class rhc_rating_settings {
	var $added_rules;
	var $id;
	function __construct($plugin_id='rsvp'){
		$this->id = $plugin_id;
		add_filter("pop-options_{$this->id}",array(&$this,'options'),10,1);
	}

	function options($t){
		global $rsvp_plugin;
		//----
		$i = count($t);
		//-------------------------
		
		
		//--Facebook App settings -----------------------
		
		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 		= 'rsvp-generalt-settings';
		$t[$i]->label 		= __('General Settings','rhcrating');
		$t[$i]->right_label	= __('General Settings','rhcrating');
		$t[$i]->page_title	= __('General Settings','rhcrating');
		$t[$i]->theme_option 	= true;
		$t[$i]->plugin_option 	= true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Ratings and Review Box Settings
','rhcrating')
			),(object)array(
				'id'	=> 'overwritealleventpost',
				'type'	=> 'select',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Overwrite all Ratings to','rhcrating').'</span>',
				'options'=> array(''=>'-Select-','yes'=>'On','no' => 'Off' ),
				'description'=>__('WARNING: Saving this setting will affect all Events in your Calendar. After saving the setting returns to Select.','rhcrating'),
				'el_properties'=>array('class'=>'dropdown2','style'=>'width:100px'),
				'default'=>'',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcrating'),
				'class' => 'button-primary'
			),
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('General Application Settings','rhcrating')
			),(object)array(
				'id'	=> 'rating_icon_type',
				'type'	=> 'select',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Icon type','rhcrating').'</span>',
				'options'=> array('star'=>'Stars','heart'=>'Hearts','faces'=>'Faces','splash'=>'Splash'),
				'description'=>__('Select icon type for rating','rhcrating'),
				'el_properties'=>array('class'=>'dropdown2','style'=>'width:100px'),
				'default'=>'stars',
				'save_option'=>true,
				'load_option'=>true
			),(object)array(
				'id'	=> 'rating_icon_numbers',
				'type'	=> 'select',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Icon count','rhcrating').'</span>',
				'options'=> array('3'=>'3','4'=>'4','5'=>'5','6'=>'6','7'=>'7','8'=>'8','9'=>'9','10'=>'10'),
				'description'=>__('Only works on Stars and Hearts, and Splash','rhcrating'),
				'el_properties'=>array('class'=>'dropdown2','style'=>'width:100px'),
				'default'=>'5',
				'save_option'=>true,
				'load_option'=>true
			),(object)array(
				'id'	=> 'rating_remove_manaul_input',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Remove Manual input','rhcrating').'</span>',
				'description'=>__('If set to ON can user only use social or wp logins system.','rhcrating'),
				'el_properties'=>array('class'=>'dropdown2','style'=>'width:100px'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),(object)array(
				'id'	=> 'rating_accept_inputs',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Approve all reviews','rhcrating').'</span>',
				'description'=>__('If set to ON you will manually have to approve Ratings and Reviews before they are published.','rhcrating'),
				'el_properties'=>array('class'=>'dropdown2','style'=>'width:100px'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),(object)array(
				'id'	=> 'rating_allow_on_wp_users',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Only for wp users','rhcrating').'</span>',
				'description'=>__('Only show the Ratings and Reviews Box for users logged into WordPress.','rhcrating'),
				'el_properties'=>array('class'=>'dropdown2','style'=>'width:100px'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),(object)array(
				'id'	=> 'rating_newpost_on',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Default Ratings Box','rhcrating').'</span>',
				'description'=>__('Turn the Ratings and Review Box ON of OFF by default on all new events','rhcrating'),
				'el_properties'=>array('class'=>'dropdown2','style'=>'width:100px'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'	=> 'rating_attend_show',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Show Ratings List','rhcrating').'</span>',
				'description'=>__('Show Ratings and Reviews list','rhcrating'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'	=> 'rating_show_link',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Enable link on Gravatar','rhcrating').'</span>',
				'description'=>__('Enable link to Facebook and Twitter profile','rhcrating'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array('type'	=> 'clear'),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcrating'),
				'class' => 'button-primary'
			)
		);
		
		//--WP App settings -----------------------
		
		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 		= 'rsvp-wordpress-settings';
		$t[$i]->label 		= __('WordPress Settings','rhcrating');
		$t[$i]->right_label	= __('WordPress Settings','rhcrating');
		$t[$i]->page_title	= __('WordPress Settings','rhcrating');
		$t[$i]->theme_option 	= true;
		$t[$i]->plugin_option 	= true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('WordPress Application Settings','rhcrating')
			),
			(object)array(
				'id'	=> 'rating_wp_show',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Show WordPress button','rhcrating').'</span>',
				'description'=>__('Adds a WordPress button to the Ratings and Reviews Box','rhcrating'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array('type'	=> 'clear'),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcrating'),
				'class' => 'button-primary'
			)
		);
		//-------------------------	
		
		
		//--Twitter App settings -----------------------
		
		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 		= 'rsvp-twitter-settings';
		$t[$i]->label 		= __('Twitter Settings','rhcrating');
		$t[$i]->right_label	= __('Twitter Settings','rhcrating');
		$t[$i]->page_title	= __('Twitter Settings','rhcrating');
		$t[$i]->theme_option 	= true;
		$t[$i]->plugin_option 	= true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Twitter Application Settings','rhcrating')
			),
			(object)array(
				'id'	=> 'rating_twitter_show',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Show Twitter button','rhcrating').'</span>',
				'description'=>__('Adds a Twitter button to the Ratings and Reviews Box','rhcrating'),
				'el_properties'	=> array('OnClick'=>'javascript:yesno_panel(this,\'.rating_twitter_show\');'),
				'hidegroup'	=> '#rating_twitter_show_group',
				'default'=>'1',
				'save_option'=>true,
				'load_option'=>true
			),(object)array(
				'id'	=> 'rating_twitter_show_group',
				'el_properties'=>array('class'=>'hide_group'),
				'type'=>'div_start'
			),(object)array(
				'id'	=> 'rating_twitter_publish',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Publish Rating to Twitter','rhcrating').'</span>',
				'description'=>__('Publish Rating to Twitter','rhcrating'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'rating_public_twitter_text',
				'label'		=> __('Twitter content','rhcrating'),
				'type'		=> 'textarea',
				'default'=>'I just gave [RATING] stars to this event [TITLE]',
				'description'	=> __('Replacement tag<br><br>[LINK] = Link to event<br>[TITLE] = Event Title<br>[STARTDATE] = Start Date<br>[STARTTIME] = Start Time<br>[ICAL_FEED] = iCal feed link<br>[RATING] = Rating', 'rhcrating'),
				'el_properties'	=> array('class'=>'text-width-full'),
				'save_option'	=>true,
				'load_option'	=>true
			),(object)array(
				'id'=>'rating_twitter_show_group',
				'type'=>'div_end'
			),
			(object)array('type'	=> 'clear'),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcrating'),
				'class' => 'button-primary'
			)
		);
		
		//-------------------------	
		
		
		//--Google+ App settings -----------------------
		
		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 		= 'rsvp-googleplus-settings';
		$t[$i]->label 		= __('Google+ Settings','rhcrating');
		$t[$i]->right_label	= __('Google+ Settings','rhcrating');
		$t[$i]->page_title	= __('Google+ Settings','rhcrating');
		$t[$i]->theme_option 	= true;
		$t[$i]->plugin_option 	= true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Google+ Application Settings','rhcrating')
			),
			(object)array(
				'id'	=> 'rating_googleplus_show',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Show Google+ button','rhcrating').'</span>',
				'description'=>__('Adds a Google+ button to the Ratings and Reviews Box','rhcrating'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array('type'	=> 'clear'),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcrating'),
				'class' => 'button-primary'
			)
		);

//-------------------------	
		
		
		//--Google+ App settings -----------------------
		
		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 		= 'rsvp-linkedin-settings';
		$t[$i]->label 		= __('LinkedIn Settings','rhcrating');
		$t[$i]->right_label	= __('LinkedIn Settings','rhcrating');
		$t[$i]->page_title	= __('LinkedIn Settings','rhcrating');
		$t[$i]->theme_option 	= true;
		$t[$i]->plugin_option 	= true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('LinkedIn Application Settings','rhcrating')
			),
			(object)array(
				'id'	=> 'rating_linkedin_show',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Show LinkedIn button','rhcrating').'</span>',
				'description'=>__('Adds a LinkedIn button to the Ratings and Reviews Box','rhcrating'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array('type'	=> 'clear'),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcrating'),
				'class' => 'button-primary'
			)
		);
		
				
		//--Facebook App settings -----------------------

		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 		= 'rsvp-facebook-settings';
		$t[$i]->label 		= __('Facebook Settings','rhcrating');
		$t[$i]->right_label	= __('Facebook Settings','rhcrating');
		$t[$i]->page_title	= __('Facebook Settings','rhcrating');
		$t[$i]->theme_option 	= true;
		$t[$i]->plugin_option 	= true;
		$t[$i]->options = array(
			(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Facebook Application Settings','rhcrating')
			),
			(object)array(
				'id'	=> 'rating_facebook_show',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Show Facebook button','rhcrating').'</span>',
				'description'=>__('Adds a Facebook button to the Ratings and Reviews Box','rhcrating'),
				'default'=>'1',
				'el_properties'	=> array('OnClick'=>'javascript:yesno_panel(this,\'.rating_facebook_show\');'),
				'hidegroup'	=> '#rating_facebook_show_group',
				'save_option'=>true,
				'load_option'=>true
			),(object)array(
				'id'	=> 'rating_facebook_show_group',
				'el_properties'=>array('class'=>'hide_group'),
				'type'=>'div_start'
			),(object)array(
				'id'	=> 'rating_facebook_publish',
				'type'	=> 'onoff',
				'label'	=> '<span style="display: block; float: left; min-width: 160px;">'.__('Publish Rating to Facebook','rhcrating').'</span>',
				'description'=>__('Publish Rating to Facebook','rhcrating'),
				'default'=>'0',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'		=> 'rating_public_facebook_title',
				'label'		=> __('Facebook title','rhcrating'),
				'type'		=> 'text',
				'default'	=>'I just gave [RATING] stars to this event [TITLE]',
				'description'	=> __('Replacement tag<br><br>[LINK] = Link to event<br>[TITLE] = Event Title<br>[STARTDATE] = Start Date<br>[STARTTIME] = Start Time<br>[EXCERPT] = excerpt<br>[ICAL_FEED] = iCal feed link<br>[RATING] = Rating', 'rhcrating'),
				'el_properties'	=> array('class'=>'text-width-full'),
				'save_option'	=>true,
				'load_option'	=>true
			),
			(object)array(
				'id'		=> 'rating_public_facebook_subtitle',
				'label'		=> __('Facebook subtitle','rhcrating'),
				'type'		=> 'text',
				'default'	=>'[STARTDATE] @ [STARTTIME]',
				'el_properties'	=> array('class'=>'text-width-full'),
				'save_option'	=>true,
				'load_option'	=>true
			),
			(object)array(
				'id'		=> 'rating_public_facebook_text',
				'label'		=> __('Facebook content','rhcrating'),
				'type'		=> 'textarea',
				'default'=>'[EXCERPT]',
				'el_properties'	=> array('class'=>'text-width-full'),
				'save_option'	=>true,
				'load_option'	=>true
			),
			(object)array(
				'id'=>'rating_facebook_show_group',
				'type'=>'div_end'
			),
			(object)array('type'	=> 'clear'),
			(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcrating'),
				'class' => 'button-primary'
			)
		);
		
		
		//------------------------------ Featur Access
		
		$excluded_roles = array();
		$roles = get_editable_roles();
		if( is_array($roles) && count($roles)>0){
			foreach($roles as $role => $r){
				if(isset($r['capabilities']) && isset($r['capabilities']['manage_options']) && '1'==$r['capabilities']['manage_options'] ){
					$excluded_roles[]=$role;
				}
			}		
		}

		$capabilities = array(
			'rating_read_list'			=> __('Read List', 'rhc'),
			'rating_delete_ratings'		=> __('Delete Rating', 'rhc'),
			'rating_approvel'			=> __('Approve Rating ', 'rhc'),
		);	
		
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rating-cap'; 
		$t[$i]->label 		= __('Feature Access','rhc');
		$t[$i]->right_label	= __('Set permissions by user role. ','rhc');
		$t[$i]->page_title	= __('Feature Access','rhc');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;		
		$t[$i]->options = array(
			(object)array(
				'id'			=> 'rating_caps',
				'label'			=> '',
				'type'			=> 'rolemanager',
				'capabilities'	=> $capabilities,
				'excluded_roles' => $excluded_roles,
				'el_properties'	=> array()
			),(object)array(
				'type'=>'clear'
			),(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhcs'),
				'class' => 'button-primary'
			)
		);	

		return $t;
	}
}

?>
