<?php
class plugin_rhc_czpf_rules_rewrite {
	
	var $post_type_groups = '';
	var $post_type_members = '';
	
	function __construct(){
		global $czpf_plugin;
		

		
		if(empty($czpf_plugin->czpf_advancede['use_smart_permalink'])){
			if(!empty($czpf_plugin->czpf_advancede['groupsteams_page'])){
				$page_data = get_page($czpf_plugin->czpf_advancede['groupsteams_page']);
				if(!empty($page_data) && $page_data->post_status == 'publish' && !empty($czpf_plugin->permalink_structur)){
					$this->post_type_groups = $page_data->post_name;
				}
			}
			
			if(!empty($czpf_plugin->czpf_advancede['post_type_type'])){
				$page_data = get_page($czpf_plugin->czpf_advancede['post_type_type']);
				
				if(!empty($page_data) && $page_data->post_status == 'publish' && !empty($czpf_plugin->permalink_structur)){
					$this->post_type_members = $page_data->post_name;
				}
			}
			
			

			
			if((!empty($this->post_type_members) || !empty($this->post_type_groups))){
				add_action( 'init', array(&$this,'init'),1,100 );
				add_action( 'wp_loaded',array(&$this,'my_flush_rules') );
				
				if(!is_admin()){
					add_filter( 'query_vars', array(&$this,'filter_query_vars'),1,100);
					add_filter('request', array(&$this,'rewrite_request'),1,100);
				}
			}
		}
	}
	
	function init($test){
		if(!empty($this->post_type_members)){
			add_rewrite_rule( $this->post_type_members.'/([^/]*)?', 'index.php?pagename='.$this->post_type_members.'/$matches[1]&mbprofil_1=czpf_member&mbprofil_2=$matches[1]', 'top' );
		}
		if(!empty($this->post_type_groups)){
			add_rewrite_rule( $this->post_type_groups.'/([^/]*)?', 'index.php?pagename='.$this->post_type_groups.'/$matches[1]&mbprofil_1=czpf_groups&mbprofil_2=$matches[1]', 'top' );
		}
	}
	
	function my_flush_rules(){
		$rules = get_option( 'rewrite_rules' );
	
	
		if ( ! isset( $rules[$this->post_type_members.'/([^/]*)?'] ) && !empty($this->post_type_members) ) {
			global $wp_rewrite;
		   	$wp_rewrite->flush_rules();
		}
		
		if ( ! isset( $rules[$this->post_type_groups.'/([^/]*)?'] ) && !empty($this->post_type_groups) ) {
			global $wp_rewrite;
		   	$wp_rewrite->flush_rules();
		}			
	}
	

	function body_class( $classes ) {
		// add 'class-name' to the $classes array
		$classes[] = 'remover_post_title_header';
		// return the $classes array
		return $classes;
	}
    
    function filter_query_vars( $query_vars ) {
	    $query_vars[] = 'mbprofil_1';
	    $query_vars[] = 'mbprofil_2';
	    return $query_vars;
    }
    
    function rewrite_request($maindata) { 
		global $wpdb,$czpf_plugin;

    	if(!empty($maindata['pagename']) && $maindata['pagename'] == $this->post_type_members && empty($maindata['mbprofil_2'])){
			require_once(RHCCZPF_PATH.'inc/class.object_controler.php');	
			$czpf_class_object_controler = new czpf_class_object_controler(RHCCZPF_URL);
	   		$user_id = get_current_user_id();
	   		if(!empty($user_id)){
		   		wp_redirect($czpf_class_object_controler->generate_link_to_id($user_id));
		   		die();
	   		}
			
    	}
    
		if(!empty($maindata['mbprofil_1']) && !empty($maindata['mbprofil_2'])){
			if($maindata['mbprofil_1'] == 'czpf_member' || $maindata['mbprofil_1'] == 'czpf_groups'){
				if(is_numeric($maindata['mbprofil_2'])){
					if($maindata['mbprofil_1'] == 'czpf_member'){
						add_filter( 'body_class', array(&$this,'body_class') );
						$tmp = get_userdata( $maindata['mbprofil_2'] );
						if(!empty($tmp)){
							$_GET['ID'] = $maindata['mbprofil_2'];
							$_REQUEST['ID'] = $maindata['mbprofil_2'];
						}
					} else {
						add_filter( 'body_class', array(&$this,'body_class') );
						$tmp = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE ID = '".$maindata['mbprofil_2']."' LIMIT 1");
						if(!empty($tmp)){
							$_GET['ID'] = $maindata['mbprofil_2'];
							$_REQUEST['ID'] = $maindata['mbprofil_2'];
						}
					}	
				} else {
				
					if($maindata['mbprofil_1'] == 'czpf_member'){
						$componets = explode('-', $maindata['mbprofil_2']);
						$count = 0;
						if(!empty($componets) and count($componets) > 0){
							add_filter( 'body_class', array(&$this,'body_class') );
							if(is_numeric($componets[count($componets)-1])){
								$count = $componets[count($componets)-1];
							}
							
							$str = implode(' ', $componets);
							$str = urldecode($str);
							$tmp = $wpdb->get_results( "SELECT ID FROM $wpdb->users WHERE display_name = '".$str."'" );
							
							if(empty($tmp)){
								if(is_numeric($componets[count($componets)-1])){
									unset($componets[count($componets)-1]);
									$str = implode(' ', $componets);
									$str = urldecode($str);
									$tmp = $wpdb->get_results( "SELECT ID FROM $wpdb->users WHERE display_name = '".$str."'" );
								}
							} else {
								$count = 0;
							}
		
							if(!empty($tmp)){
								if(!empty($tmp[$count])){
									$_GET['ID'] = (int)$tmp[$count]->ID;
								}
							}
						}
					} else if($maindata['mbprofil_1'] == 'czpf_groups' && !empty($maindata['mbprofil_2'])){
						add_filter( 'body_class', array(&$this,'body_class') );
						$tmp = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '".$maindata['mbprofil_2']."' LIMIT 1");
						if(!empty($tmp)){
							$_GET['ID'] = (int)$tmp;
							$_REQUEST['ID'] = (int)$tmp;
						}
					}
				}
				
				
				if(!empty($maindata['mbprofil_1']) && $maindata['mbprofil_1'] == 'czpf_member' && (empty($_REQUEST['ID']) && empty($_GET['ID']))){
					require_once(RHCCZPF_PATH.'inc/class.object_controler.php');	
					$czpf_class_object_controler = new czpf_class_object_controler(RHCCZPF_URL);
			   		$user_id = get_current_user_id();
			   		if(!empty($user_id)){
				   		wp_redirect($czpf_class_object_controler->generate_link_to_id($user_id));
				   		die();
			   		}
				}
				
				if($maindata['mbprofil_1'] == 'czpf_member'){
					$maindata['pagename'] = $this->post_type_members;
				} else {
					$maindata['pagename'] = $this->post_type_groups;
				}
				
			}
		}
    	return $maindata;	
    }
}