<?php
/**
 * Plugin Name: Member Profile add-on for Calendarize it!
 * Plugin URI: http://calendarize.it/add-ons/member-profile/
 * Description: Member Profile add-on for Calendarize it! is a add-on that create a profile for each user on your WordPress website. The Member Profile will show Past Events, Upcoming Events, Ratings and Reviews, Comments and Posts as well as Friends. And it connects each profile to Facebook, Twitter, Google+ and LinkedIn.
 * Version: 1.1.3.82868
 * Author: RightHere LLC
 *Author URI: http://plugins.righthere.com
 */

if ( defined( 'RHCCZPF_PATH' ) ) {
	throw new Exception( __( 'A duplicate of this add-on/plugin is already active.', 'rhc' ) );
}

define( 'RHCCZPF_VERSION', '1.1.3' );
define( 'RHCCZPF_SLUG', plugin_basename( __FILE__ ) );

if ( defined( 'RHC_ADDON_PATH' ) && isset( $addon ) && ! strpos( __FILE__, 'plugins' ) ) {
	define( 'RHCCZPF_PATH', trailingslashit( RHC_ADDON_PATH . dirname( $addon ) ) );
	define( 'RHCCZPF_URL', trailingslashit( RHC_ADDON_URL . dirname( $addon ) ) );
} else {
	define( 'RHCCZPF_PATH', plugin_dir_path( __FILE__ ) );
	define( 'RHCCZPF_URL', plugin_dir_url( __FILE__ ) );
}

require_once( RHCCZPF_PATH . 'inc/shorcode_members.php' );
require_once( RHCCZPF_PATH . 'inc/rulse_rewrite.php' );

class plugin_rhc_czpf {
	public $post_type = 'events';
	public $post_id = 'profile';
	public $czpf_advancede = array();
	public $permalink_structur = '';
	public $api_keys = '';

	function __construct() {	
		global $rhc_plugin;

		add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );
		add_action( 'after_setup_theme', array( $this, 'after_setup_theme'), 20 );
		add_action( 'init', array( $this, 'init' ) );

		$this->czpf_advancede = get_option( 'czpf_advancede', '' ); 
		$this->permalink_structur = get_option( 'permalink_structure', '' );

		if ( is_admin() ) {
            add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		}

		if ( ! empty( $rhc_plugin ) ) {
			rh_register_php( 'social-connection', RHCCZPF_PATH . 'social_connection/class.SocialConnection.php', '1.0.1' );
		}
	} 
	
	function plugins_loaded() {
		$settings_tmp = get_option('czpf_advancede');
		
		require_once( RHCCZPF_PATH . 'inc/uh_social/social_connection.php' );

		if ( ! is_admin() ) {
			add_action( 'wp_enqueue_scripts', array( $this, 'script' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'stylesheet' ) );

			$this->intercept_data();
		} else {
			$this->install();
		}
	}
	
	function after_setup_theme(){
		global $rhc_plugin;
		if(!empty($rhc_plugin) && class_exists('SocialConnection')){
			do_action('rh-php-commons');
	
			$settings = array(
				'options_capability' => $rhc_plugin->options_capability,
				'option_menu_parent' => 'edit.php?post_type=' . RHC_EVENTS,
				'stylesheet'         => 'rhc-options',
				'path'               => RHCCZPF_PATH . 'social_connection/',
				'url'                => RHCCZPF_URL . 'social_connection/',
				'pop_path'           => RHC_PATH . 'options-panel/',
				'pop_url'            => RHC_URL . 'options-panel/',
				'layout'             => 'horizontal',
				'networks'           => array( 'googleplus', 'facebook', 'linkedin', 'microsoft', 'twitter' ),
			);
			$sco = new SocialConnection( $settings );
			$this->api_keys = $sco->get_social_connection_settings();
		}
	}
		
	// create post types
	function init() {
		// create defualt post type
		register_post_type( 'groupsteams',
			array(
				'labels' => array(
					'name' => __( 'Groups & Teams','rhc' ),
					'singular_name' => __( 'Groups & Teams','rhc' )
				),
		    'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
			'public' => false,
			'has_archive' => false,
			'supports' => array( 'title', 'editor', 'thumbnail', 'author')
			)
		);
		
		if(!is_admin()){
			//add_filter( 'the_content', array(&$this,"the_content_filter") );
		}	
	}
	
	function the_content_filter($content) {
		$return_data = '';
		if(!empty($content)){
			$return_data = '<br>'.$content ;
		}
		
		if(!empty($this->czpf_advancede['post_type_type']) && $this->czpf_advancede['post_type_type'] == $GLOBALS['post']->ID && is_page()){
			$return_data = '[rhc_profile]'.$return_data;
			return $return_data;
		}
		
		
		if(!empty($this->czpf_advancede['members_page']) && $this->czpf_advancede['members_page'] == $GLOBALS['post']->ID && is_page()){
			$return_data = '[rhc_members]'.$return_data;
			return $return_data;
		}	  
		
		if(!empty($this->czpf_advancede['groupsteams_page']) && $this->czpf_advancede['groupsteams_page'] == $GLOBALS['post']->ID && is_page()){
			$return_data = '[rhc_groups]'.$return_data;
			return $return_data;
		}
		
		// otherwise returns the database content
		return $content;
	}
			
    // show admin menues 
	function admin_menu(){       
    	$tmp = add_submenu_page('edit.php?post_type=events',__("Member Profile",'rhc'), __("Member Profile",'rhc'), 'manage_options','rhc-czpf', array(&$this,'form_options') ); 
    	add_action( 'admin_head-'.$tmp, array(&$this,'admin_script') );	
	}
	

	
	// -----------------------------------------------------------------------------------------	
	// Front End -----------------------------------------------------------------------------
	// -----------------------------------------------------------------------------------------
	
    function script() {
    	global $post;
    	
		if($this->check_if_on_page()){
			wp_enqueue_script( 'jquery');
	    	wp_enqueue_script( 'czpf_frontend', RHCCZPF_URL . 'js/frontend.js' );
			wp_localize_script( 'czpf_frontend', 'CZPF', array( 
				'ajaxurl' => untrailingslashit( site_url('/') )
			));				
	    	wp_enqueue_script( 'czpf_fileuploader', RHCCZPF_URL . 'js/jquery.uploadfile.min.js' );
	    	
	    	   wp_enqueue_script( 'jquery-ui-datepicker' );
	    	  wp_enqueue_script( 'jquery-ui-autocomplete');
	   	}  

    }
    
    function stylesheet() {
		if($this->check_if_on_page()){
        	wp_register_style( 'bootstrap-czpf', RHCCZPF_URL.'css/bootstrap/css/bootstrap.namespaced.css','','3.0.1' );
			wp_enqueue_style( 'bootstrap-czpf' );	    
        
			wp_register_style( 'flat-ui-czpf', RHCCZPF_URL.'css/flat-ui/css/flat-ui.namespaced.css','','1.2.2' );
			wp_enqueue_style( 'flat-ui-czpf' );	        
        
			wp_register_style( 'frontendczpf_box', RHCCZPF_URL.'css/frontend.min.css','','4.0.1'  );
			wp_enqueue_style( 'frontendczpf_box' );
			
			wp_register_script( 'animateNumber', RHCCZPF_URL . 'js/jquery.animateNumber.js','','0.1' );
	        wp_enqueue_script( 'animateNumber' );
			
			if(defined('RHCRATING_URL')){
		        wp_register_style( 'frontendrating_box', RHCRATING_URL.'css/frontend.css' );
		        wp_enqueue_style( 'frontendrating_box' );
		        
		        wp_register_style( 'bootstrap-rating', RHCRATING_URL.'css/bootstrap/css/bootstrap.css','','3.0.0' );
		        wp_enqueue_style( 'bootstrap-rating' );		
			}
		}
    }
	
	
	// -----------------------------------------------------------------------------------------	
	// Backend End -----------------------------------------------------------------------------
	// -----------------------------------------------------------------------------------------



	function admin_script() {
	    if($this->check_post_type()  and !empty($_GET['page']) and $_GET['page'] =='rhc-czpf'){
	    	wp_enqueue_script( 'jquery');
	    	wp_enqueue_script( 'czpf_admin', RHCCZPF_URL . 'js/backend.js' );  
			wp_localize_script( 'czpf_admin', 'CZPF_ADMIN', array( 
				'ajaxurl' => untrailingslashit( site_url('/') )
			));			
	    	wp_enqueue_script( 'jquery-ui-sortable');
	    	wp_enqueue_script( 'jquery-ui-tabs');	    	
	    	wp_enqueue_script( 'jquery-ui-draggable');
	    	wp_enqueue_script( 'jquery-ui-droppable');
	        wp_register_style( 'bootstrap-czpf', RHCCZPF_URL.'css/bootstrap/css/bootstrap.namespaced.css','','3.0.1' );
	        wp_enqueue_style( 'bootstrap-czpf' );	  
			wp_register_style( 'flat-ui-czpf', RHCCZPF_URL.'css/flat-ui/css/flat-ui.namespaced.css','','1.2.3' );
			wp_enqueue_style( 'flat-ui-czpf' );	  
	    	wp_enqueue_style('czpf_admin', RHCCZPF_URL . 'css/backend.css' );  	
	    	 	  	 	
	    	  
		}
	}		
			
	function form_options(){
		require_once(RHCCZPF_PATH.'inc/uh_formsettings/formsettings.php');
		require_once(RHCCZPF_PATH.'inc/class.object_controler.php');
		require_once(RHCCZPF_PATH.'admin/settings.php');

	}
	
	// -----------------------------------------------------------------------------------------	
	// Intersept ajax data ---------------------------------------------------------------------
	// -----------------------------------------------------------------------------------------
	
	
	function intercept_data(){
		if(isset($_REQUEST['czpf_data'])){
		
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'groups_register'){
				require_once(RHCCZPF_PATH .'/ajax/groups_register.php');
			}
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'group_add_memeber'){
				require_once(RHCCZPF_PATH .'/ajax/group_add_memeber.php');
			}		
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'group_approved_memeber'){
				require_once(RHCCZPF_PATH .'/ajax/group_approved_memeber.php');
			}		
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'group_remove_memeber'){
				require_once(RHCCZPF_PATH .'/ajax/group_remove_memeber.php');
			}			
			

			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'backend_save'){
				require_once(RHCCZPF_PATH .'/ajax/backend_save.php');
			}
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'backend_welcomeRemove'){
				require_once(RHCCZPF_PATH .'/ajax/backend_welcomeRemove.php');
			}
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'backend_welcomeCreatePage'){
				require_once(RHCCZPF_PATH .'/ajax/backend_welcomeCreatePage.php');
			}		
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'friend_status_change'){
				require_once(RHCCZPF_PATH .'/ajax/friend_status_change.php');
			}
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'get_button_data'){
				require_once(RHCCZPF_PATH .'/ajax/get_button_data.php');
			}	
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'save_tag_info'){
				require_once(RHCCZPF_PATH .'/ajax/save_tag_info.php');
			}		
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'save_group_info'){
				require_once(RHCCZPF_PATH .'/ajax/save_group_info.php');
			}	

			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'upload_images_avatar'){
				require_once(RHCCZPF_PATH .'/ajax/upload_images_avatar.php');
			}	
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'upload_images_group'){
				require_once(RHCCZPF_PATH .'/ajax/upload_images_group.php');
			}		
			
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'remove_social_link'){
				require_once(RHCCZPF_PATH .'/ajax/remove_social_link.php');
			}	
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'save_social_link'){
				require_once(RHCCZPF_PATH .'/ajax/save_social_link.php');
			}		
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'update_list'){
				require_once(RHCCZPF_PATH .'/ajax/update_list.php');
			}		
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'update_list_members'){
				require_once(RHCCZPF_PATH .'/ajax/update_list_members.php');
			}		
			
			if(isset($_REQUEST['czpf_fn']) and $_REQUEST['czpf_fn'] == 'update_list_groups'){
				require_once(RHCCZPF_PATH .'/ajax/update_list_groups.php');
			}	
		}
	}
	
	// -----------------------------------------------------------------------------------------	
	// Other function --------------------------------------------------------------------------
	// -----------------------------------------------------------------------------------------

	function get_profil_url(){
		$tmp_check = true;
		if(!empty($this->czpf_advancede['post_type_type'])){
			$page_data = get_page($this->czpf_advancede['post_type_type']);
			if($page_data->post_status == 'publish'){
				$tmp_check = false;
			}
		}
		
		if($tmp_check){
			return get_post_type_archive_link( $this->post_type.'-'.$this->post_id );
		} else {
			return get_permalink( $this->czpf_advancede['post_type_type'] );
		}
	}
	
	function get_group_url(){
		$tmp_check = true;
		if(!empty($this->czpf_advancede['groupsteams_page'])){
			$page_data = get_page($this->czpf_advancede['groupsteams_page']);
			if($page_data->post_status == 'publish'){
				$tmp_check = false;
			}
		}
		
		if(!$tmp_check){
			return get_permalink( $this->czpf_advancede['groupsteams_page'] );
		} else {
			return '';
		}
	}
	
	function send_error_die($msg){
		die(json_encode(array('R'=>'ERR','MSG'=>$msg)));
	}	
	
	function send_success_die($tmp_data){
		die(json_encode($tmp_data));
	}
	
	
	function check_if_on_page() {
		global $post;

		$tmp_check_memberpage = false;
		if(!empty($this->czpf_advancede['members_page'])){
			$page_data = get_page($this->czpf_advancede['members_page']);
			if($page_data->post_status == 'publish'){
				$tmp_check_memberpage = true;
			}
			
			if($tmp_check_memberpage){
				if(!empty($this->czpf_advancede['members_page']) && !empty($post->ID) && $post->ID == $this->czpf_advancede['members_page']){
					return true;
				}
			}
		}
		
		$tmp_check_group = false;
		if(!empty($this->czpf_advancede['groupsteams_page'])){
			$page_data = get_page($this->czpf_advancede['groupsteams_page']);
			if($page_data->post_status == 'publish'){
				$tmp_check_group = true;
			}
			
			if($tmp_check_group){
				if(!empty($this->czpf_advancede['groupsteams_page']) && !empty($post->ID) && $post->ID == $this->czpf_advancede['groupsteams_page']){
					return true;
				}
			}
		}		
		
		if(empty($post->ID) || empty($this->czpf_advancede['post_type_type']) ){
			return 0;
		}
		
		return $post->ID == $this->czpf_advancede['post_type_type'];
	}
	
	
	function check_post_type() {
		global $post, $current_screen;
		
		$check_type =  ($this->post_type.'-'.$this->post_id);
		
		if(is_admin()){
			$check_type = $this->post_type;
		}
		
		if(!empty($post) && !empty($post->post_type) && $post->post_type == $check_type){
			return true;
		} else if(!empty($current_screen) && !empty($current_screen->post_type) && $current_screen->post_type == $check_type ){
			return true;	
		} else if(!empty($_REQUEST['post_type']) && $_REQUEST['post_type'] == $check_type ){
			return true;
		} else {
			return false;
		}
		
	}
	
	function wp_exist_post_by_title($title_str,$post_type = 'groupsteams') {
		global $wpdb;
		return $wpdb->get_var("SELECT ID FROM {$wpdb->prefix}posts WHERE post_type = '".$post_type."' and post_title = '" . $title_str . "'");
	}
	
	
	// -----------------------------------------------------------------------------------------	
	// install ---------------------------------------------------------------------------------
	// -----------------------------------------------------------------------------------------
	
	function install(){
	    global $wpdb;

		$installed = get_option('RHC_czpf_INSTALL','');
		if (version_compare($installed, '1.0.0','<')) {
	 
			$czpf_container = get_option('czpf_container', '');
			$czpf_advancede = get_option('czpf_advancede', '');
			$czpf_order_array = get_option('czpf_sort_order', '');
						
			if(empty($czpf_order_array)){
				update_option('czpf_sort_order', array('show_friends','show_pastevents','show_upcoming','show_rating','show_postevents'));
			
			}
			
			if(empty($czpf_container)){
				update_option('czpf_advancede', array('post_type' => 'rhc_profil',
											    'post_type_type' => '',
											    'show_friends' => true,
											    'show_comment' => true,
											    'show_post' => true,
											    'show_pastevents' => true,
											    'show_upcoming' => true,
											    'show_rating' => true));
											    
			}
			
			if(empty($installed) or version_compare($installed, '1.0.0','<')) {
		    	$queries[] =  "CREATE TABLE IF NOT EXISTS `#__rhc_groups_teams` (
		  		`id` int(11) NOT NULL auto_increment,
		  		`postID` int(11) NOT NULL,
		  		`userID` int(11) NOT NULL,
		  		`status` int(5) NOT NULL,
		  		`cDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
		  		PRIMARY KEY  (`id`)
				) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
		
			}
			
			if(!empty($queries)){
				foreach($queries as $query){
					$query = str_replace('#__', $wpdb->prefix, $query);
		        	$wpdb->query($query);
				}
			}
											    
			if(empty($czpf_container)){
				update_option('czpf_container', '%7B%22rowobject_5_1%22%3A%7B%22single_3_2%22%3A%7B%22object_3%22%3A%7B%22round_object%22%3A%221%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22avatar%22%7D%7D%2C%22single_8_4%22%3A%7B%22rowobject_0_5%22%3A%7B%22single_12_6%22%3A%7B%22object_7%22%3A%7B%22object_icon%22%3A%22no-icon%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22full_name%22%7D%7D%7D%2C%22rowobject_3_8%22%3A%7B%22single_6_9%22%3A%7B%22object_10%22%3A%7B%22object_icon%22%3A%22czpficon-uniE5B2%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22address%22%7D%2C%22object_11%22%3A%7B%22object_icon%22%3A%22czpficon-uniE3B4%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22city%22%7D%2C%22rowobject_3_12%22%3A%7B%22single_6_13%22%3A%7B%22object_14%22%3A%7B%22object_icon%22%3A%22czpficon-uniE398%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22zip%22%7D%7D%2C%22single_6_15%22%3A%7B%22object_16%22%3A%7B%22object_icon%22%3A%22czpficon-uniE39D%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22state%22%7D%7D%7D%2C%22object_17%22%3A%7B%22object_icon%22%3A%22czpficon-uniE4E1%22%2C%22public%22%3A%221%22%2C%22id%22%3A%22groupsteams%22%7D%7D%2C%22single_6_18%22%3A%7B%22object_19%22%3A%7B%22object_icon%22%3A%22czpficon-uniE117%22%2C%22public%22%3A%22-%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22email%22%7D%2C%22object_20%22%3A%7B%22object_icon%22%3A%22czpficon-uniE3BC%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22contry%22%7D%2C%22object_21%22%3A%7B%22object_icon%22%3A%22czpficon-uniE0E0%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22lang%22%7D%2C%22object_22%22%3A%7B%22object_icon%22%3A%22czpficon-uniE02B%22%2C%22id%22%3A%22status_show%22%7D%7D%7D%7D%2C%22single_1_23%22%3A%7B%22object_24%22%3A%7B%22public%22%3A%221%22%2C%22id%22%3A%22facebook%22%7D%2C%22object_25%22%3A%7B%22public%22%3A%221%22%2C%22id%22%3A%22twitter%22%7D%2C%22object_26%22%3A%7B%22public%22%3A%221%22%2C%22id%22%3A%22googleplus%22%7D%2C%22object_27%22%3A%7B%22public%22%3A%221%22%2C%22id%22%3A%22linkedin%22%7D%7D%7D%2C%22rowobject_0_28%22%3A%7B%22single_12_29%22%3A%7B%22object_30%22%3A%7B%22value%22%3A%22Please%20write%20a%20title%22%2C%22object_icon%22%3A%22no-icon%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22title%22%7D%2C%22object_31%22%3A%7B%22value%22%3A%22Please%20write%20a%20description%22%2C%22object_icon%22%3A%22no-icon%22%2C%22public%22%3A%221%22%2C%22editable%22%3A%221%22%2C%22id%22%3A%22description%22%7D%7D%7D%7D');  
			}
			update_option('RHC_czpf_INSTALL',RHCCZPF_VERSION);
			wp_redirect( admin_url( 'edit.php?post_type=events&page=rhc-czpf&first_time=true'));	
			
		}
		
		update_option('RHC_czpf_INSTALL',RHCCZPF_VERSION);
	}	
}

global $czpf_plugin,$plugin_rhc_czpf_rules_rewrite;

$czpf_plugin = new plugin_rhc_czpf();
$plugin_rhc_czpf_rules_rewrite = new plugin_rhc_czpf_rules_rewrite();