<?php

class RHC_Import_Options {
	public $id;
	public $open;
	public $capability;

	public function __construct( $plugin_id = 'rhc', $capability = 'manage_options', $open = false ) {
		if ( ! current_user_can( $capability ) ) {
			return false;
		}

		$this->id = $plugin_id;
		$this->capability = $capability;
		$this->open = $open;

		add_filter( "pop-options_{$this->id}", array( $this, 'options' ), 9999, 1 );
	}

	public function options( $t ) {
		$i = count( $t );
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhci-settings'; 
		$t[ $i ]->open          = $this->open;
		$t[ $i ]->label         = __( 'Settings', 'rhci' );
		$t[ $i ]->right_label   = __( 'Settings', 'rhci' );
		$t[ $i ]->page_title    = __( 'Settings', 'rhci' );
		$t[ $i ]->theme_option  = true;
		$t[ $i ]->priority      = 98;
		$t[ $i ]->plugin_option = true;
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'type'        => 'subtitle',
			'label'       => __( 'CSV Import Extra Columns', 'rhci' ),
			'description' => __( 'Enable columns what your CSV file contains. For adding images to Events include the URL in your CSV file (This URL should be to images in your Media Library)' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_post_status',
			'type'          => 'onoff',
			'label'         => __( 'Events Status', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_post_author',
			'type'          => 'onoff',
			'label'         => __( 'Events Author', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_fc_color',
			'type'          => 'onoff',
			'label'         => __( 'Events Color', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_fc_text_color',
			'type'          => 'onoff',
			'label'         => __( 'Text Color', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column__thumbnail_id',
			'type'          => 'onoff',
			'label'         => __( 'WordPress Featured Image', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_rhc_top_image',
			'type'          => 'onoff',
			'label'         => __( 'Event Page Top Image', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_rhc_dbox_image',
			'type'          => 'onoff',
			'label'         => __( 'Event Detail Box Image', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_rhc_tooltip_image',
			'type'          => 'onoff',
			'label'         => __( 'Event Featured Image', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhci_extra_column_rhc_month_image',
			'type'          => 'onoff',
			'label'         => __( 'Month View Image', 'rhci' ),
			'default'       => '0',
			'el_properties' => array( '' ),
			'save_option'   => true,
			'load_option'   => true,
		);
		
		$t[ $i ]->options[] = (object) array(
			'type'  => 'submit',
			'label' => __( 'Save', 'rhc' ),
			'class' => 'button-primary'
		);

		$i = count( $t );
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhci-help'; 
		$t[ $i ]->open          = $this->open;
		$t[ $i ]->label         = __( 'Help', 'rhci' );
		$t[ $i ]->right_label   = __( 'Help', 'rhci' );
		$t[ $i ]->page_title    = __( 'Help', 'rhci' );
		$t[ $i ]->theme_option  = true;
		$t[ $i ]->priority      = 99;
		$t[ $i ]->plugin_option = true;
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'type'     => 'callback',
			'callback' => array( $this, 'help_tab' ),
		);

		return $t;
	}

	public function help_tab() {
		return sprintf( '<p>%s</p>',
			sprintf( __( 'For detailed information on how to use the Importer for Calendarize it! add-on, please visit our knowledge base at the %s', 'rhci' ),
				sprintf( '<a href="https://righthere.zendesk.com/">%s</a>.', __( 'Help Center', 'rhci' )
				)
			)
		);
	}

}
