'use strict';

var gulp        = require( 'gulp' );
var browserSync = require( 'browser-sync' ).create();
var sass        = require( 'gulp-sass' );
var uglify      = require( 'gulp-uglify' );
var rename      = require( 'gulp-rename' );

gulp.task( 'sass', function() {
	return gulp.src( "assets/scss/*.scss" )
		.pipe( sass({ outputStyle: 'compressed' }).on( 'error', sass.logError ) )
		.pipe( rename({
			suffix: '.min'
		}))
		.pipe( gulp.dest( "assets/css" ) )
		.pipe( browserSync.stream() );
});

gulp.task( 'js', function() {
	return gulp.src( "assets/js/*.js" )
		.pipe( uglify() )
		.pipe( rename({
			suffix: '.min'
		}))
		.pipe( gulp.dest( "assets/js/dist" ) )
		.pipe( browserSync.stream() );
});

gulp.task( 'serve', [ 'sass', 'js' ], function() {
	browserSync.init({
		proxy: 'wordpress.loc',
		notify: false
	});

	gulp.watch( "assets/scss/*.scss", [ 'sass' ] );
	gulp.watch( "assets/js/*.js", [ 'js' ] );
	gulp.watch( "**/*.php" ).on( 'change', browserSync.reload );
});

gulp.task( 'default', [ 'serve' ] );