<?php
/*
Plugin Name: Importer for Calendarize it!
Plugin URI: http://calendarize.it/add-ons/importer/
Description: Easily import Event data with CSV files
Version: 1.0.5.81966
Author: Maxim Levikov (RightHere LLC)
Author URI: http://calendarize.it/add-ons/importer/
*/

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

if ( defined( 'RHCI_PATH' ) ) {
	throw new Exception ( __( 'A duplicate of this add-on/plugin is already active.', 'rhc' ) );
}

if ( ! function_exists( 'rhc_get_relative_path' ) ) {
	function rhc_get_relative_path( $from, $to ) {
		$from = is_dir( $from ) ? rtrim( $from, '\/' ) . '/' : $from;
		$to = is_dir( $to ) ? rtrim( $to, '\/' ) . '/' : $to;
		$from = str_replace( '\\', '/', $from );
		$to = str_replace( '\\', '/', $to );

		$from = explode( '/', $from );
		$to = explode( '/', $to );
		$rel_path = $to;

		foreach( $from as $depth => $dir ) {
			if ( $dir === $to[ $depth ] ) {
				array_shift( $rel_path );
			} else {
				$remaining = count( $from ) - $depth;
				if ( $remaining > 1) {
					$padLength = ( count( $rel_path ) + $remaining - 1 ) * - 1;
					$rel_path = array_pad( $rel_path, $padLength, '..' );
					break;
				} else {
					$rel_path[0] = './' . $rel_path[0];
				}
			}
		}

		return implode( '/', $rel_path );
	}
}

define( 'RHCI_VERSION', '1.0.5' );

if ( defined( 'RHC_ADDON_PATH' ) && isset( $addon ) && ! strpos( __FILE__, 'plugins' ) ) {
	define( 'RHCI_PATH', trailingslashit( RHC_ADDON_PATH . dirname( $addon ) ) );
	define( 'RHCI_URL', trailingslashit( RHC_ADDON_URL . dirname( $addon ) ) );
	define( 'RHCI_LANGUAGE', rhc_get_relative_path( WP_PLUGIN_DIR, RHCI_PATH ) . 'languages/' );
} else {
	define( 'RHCI_PATH', plugin_dir_path( __FILE__ ) );
	define( 'RHCI_URL', plugin_dir_url( __FILE__ ) );
	define( 'RHCI_LANGUAGE', RHCI_PATH . 'languages/' );
}

class RHC_Import {
	private static $_instance;

	public static function get_instance() {
		if ( ! ( self::$_instance instanceof self ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	protected function __construct( $args = array() ) {
		$defaults = array(
			'id'                 => 'rhci',
			'addon'              => false,
			'options_capability' => 'manage_options',
		);

		foreach ( $defaults as $property => $default ) {
			$this->$property = isset( $args[ $property ] ) ? $args[ $property ] : $default;
		}

		add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ), 9 );
	}

	private function __clone() {
	}

	private function __sleep() {
	}

	private function __wakeup() {
	}

	public function plugins_loaded() {
		global $rhc_plugin;

		load_plugin_textdomain( 'rhci', false, RHCI_LANGUAGE );

		if ( is_admin() ) {
			do_action('rh-php-commons');

			$settings = array(
				'id'                     => $this->id,
				'plugin_id'              => 'rhc',
				'capability'             => $this->options_capability,
				'options_varname'        => $rhc_plugin->options_varname,
				'menu_id'                => 'rhc-importer',
				'page_title'             => __( 'Importer', 'rhci' ),
				'menu_text'              => __( 'Importer','rhci' ),
				'option_menu_parent'     => 'edit.php?post_type=' . RHC_EVENTS,
				'notification'       => (object) array(
					'plugin_version' => RHC_VERSION,
					'plugin_code'    => 'RHC',
					'message'        => __( 'Calendar plugin update %s is available! <a href="%s">Please update now</a>','rhc' )
				),
				'theme'                  => false,
				'stylesheet'		     => 'rhc-options',
				'extracss'               => 'rhci-pop',
				'option_show_in_metabox' => true,
				'path'                   => RHC_PATH . 'options-panel/',
				'url'                    => RHC_URL  . 'options-panel/',
				'pluginslug'             => RHC_SLUG,
				'api_url'                => 'http://plugins.righthere.com',
				'layout'		         => 'horizontal',
			);	
			require_once RHC_PATH . 'options-panel/class.PluginOptionsPanelModule.php';
			new PluginOptionsPanelModule( $settings );

			require_once RHCI_PATH . 'includes/class-rhc-csv-import.php';
			new RHC_CSV_Import( $this->id, $this->options_capability, false );

			require_once RHCI_PATH . 'includes/class-rhc-import-options.php';
			new RHC_Import_Options( $this->id, $this->options_capability, false );
		}

		require_once RHCI_PATH . 'includes/class-rhci-styles-scripts.php';
		new RHCI_Styles_Scripts();
	}
}

global $rhc_import;

if ( ! $rhc_import ) {
	$rhc_import = RHC_Import::get_instance( array( 'addon' => $addon ) );
}
