<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rh_contextual_help {
	var $uid=0;
	var $echelps = array();
	function __construct($args=array()){
		$defaults = array(
			'url'				=> '',
			'path'				=> ''
		);	
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------		
		add_action('in_admin_header',array(&$this,'in_admin_header'));
	}
	
	function in_admin_header(){
		global $hook_suffix;
		$screen = get_current_screen();
		$current_hookname = $this->get_hookname($screen,$hook_suffix);		
		$this->load_echelps($current_hookname);
		$this->add_echelps($screen,$current_hookname);	
	}
	
	function load_echelps($hookname){
		include 'serialized_help.php';
		$data = unserialize(trim($serialized_help));
		$this->echelps = array();
		foreach($data as $d){
			if(in_array($hookname,$d->location)){
				$this->echelps[]=$d;
			}
		}
	}
	
	function add_echelps($screen,$current_hookname){
		if(!empty($this->echelps)){
			foreach($this->echelps as $h){
				if(!empty($h->location)){			

					if(!in_array($current_hookname,$h->location))continue;

					if( '1'==$h->replace_existing_help ){
						$screen->remove_help_tabs();
					}

					//Bug: PUR makes the help content empty.
					global $wp_filter;
					if( isset( $wp_filter['the_content'] ) && isset( $wp_filter['the_content'][10] ) && is_array( $wp_filter['the_content'][10] ) && count($wp_filter['the_content'][10]) > 0 ){
						foreach( $wp_filter['the_content'][10] as $index => $f ){
							if( isset( $f['function'] ) && is_array( $f['function'] ) && isset( $f['function'][0] ) ){
								if( is_object( $f['function'][0] ) ){
									if( 'PUR_Frontend' == get_class( $f['function'][0] ) ){
										unset( $wp_filter['the_content'][10][$index] );
										remove_filter( 'the_content', $f['function'], 10 );
									}
								}						
							}						
						}					
					}
					
					$content = apply_filters('the_content',$h->content);
					$content = strip_tags($content)==$content?"<p>$content</p>":$content;					
					$content = str_replace('{dcurl}',$this->url.'images/',$content);
					if( 'sidebar'==$h->help_type ){
						$screen->set_help_sidebar( $content );
					}else{
						$screen->add_help_tab(array(
							'id'		=> 'echelp-'.$this->uid++,
							'title'		=> $h->title,
							'content'	=> $content
						));					
					}
				}
			}	
			$this->add_wp_pointer_scripts();	
		}		
	}
	
	function add_wp_pointer_scripts(){
	    if ( get_bloginfo( 'version' ) < '3.3' )
	        return;	
	
		$dismissed = explode( ',', (string) get_user_meta( get_current_user_id(), 'dismissed_wp_pointers', true ) );
		if(in_array('rhc_pointer_help',$dismissed))
			return;
			
		wp_enqueue_style('wp-pointer');
		wp_enqueue_script('wp-pointer');
		add_action("admin_footer",array(&$this,"add_js_code"));
	}
	
	function  add_js_code(){
?><script>
jQuery(document).ready( function($) {
	var options = {
		"pointer_id":"rhc_pointer_help",
		"pointerClass":"rhc_pointer",
		"content":"<h3><?php _e('Calendarize it! Help','rhc')?><\/h3><p><?php _e('Click on the Help tab when you are on a Calendarize it! menu and you will be able to access Help.','rhc')?><\/p>",
		"position":{
			"edge":"top",
			"align":"right"
		}
	};

	options = $.extend( options, {
		close: function() {
			$.post( ajaxurl, {
				pointer: 'rhc_pointer_help',
				action: 'dismiss-wp-pointer'
			});
		}
	});
	
	pointer = $('#contextual-help-link').pointer( options ).pointer("open");

	right = parseInt( $('#contextual-help-link').width() / 2 ) ;
	right = 0==right ? 27 : right;
	right = right + 'px';
	$('.rhc_pointer.wp-pointer-top').css('margin-top','8px');
	$('.rhc_pointer.wp-pointer-top .wp-pointer-arrow').css('left','auto');
	$('.rhc_pointer.wp-pointer-top .wp-pointer-arrow').css('right',right);		
});
</script>
	<?php
	}
	
	function get_hookname($screen,$hook_suffix){
		switch($hook_suffix){
			case 'edit.php':
				return $screen->post_type=='post'?'edit.php':sprintf('edit.php?post_type=%s',$screen->post_type);
			case 'post-new.php':
			case 'post.php':
				return $screen->post_type=='post'?'post-new.php':sprintf('post-new.php?post_type=%s',$screen->post_type);
			case 'edit-tags.php':
				return $screen->post_type=='post' || $screen->taxonomy=='link_category' ? sprintf('edit-tags.php?taxonomy=%s',$screen->taxonomy):sprintf('edit-tags.php?taxonomy=%s&post_type=%s',$screen->taxonomy,$screen->post_type);
			case 'media.php':
				return 'media-new.php';
			case 'link.php':
				return 'link-add.php';
			case 'appearance_page_theme_options':
				return 'theme_options';
			case 'appearance_page_custom-background':
				return 'custom-background';
			case 'appearance_page_custom-header':
				return 'custom-header';
			default:
				global $plugin_page;
				if(trim($plugin_page)!='')return $plugin_page;
				return $hook_suffix;
		}
	}
}
?>