(function($){
$.fullCalendar.views.rhc_gmap = MapView;	
function MapView(element, calendar) {
	var t = this;
	var body;
	t.name = 'rhc_gmap';
	t.render = render;
	t.unselect = unselect;
	t.setHeight = setHeight;
	t.setWidth = setWidth;
	t.clearEvents = clearEvents;
	t.renderEvents = renderEvents;
	t.trigger = trigger;
	t.viewChanged = viewChanged;
	t.beforeAnimation = beforeAnimation;
	t.transitionEnded = transitionEnded;
	
	t.element = element;
	t.oldView = null;
	//not part of fc api.
	t.calendar = calendar;//needed for clicking event title.
	
	var trigger = t.trigger;
	
	function viewChanged(oldView){
		if(oldView){
			if( oldView.visStart && oldView.visEnd ){
				t.title = oldView.title;
				t.visStart = oldView.start;
				t.visEnd = oldView.visEnd;
				t.oldView = oldView;

				if( calendar.options.eventList.upcoming && calendar.options.eventList.upcoming=='1' ){
					var _now = new Date();
					t.visStart = t.visStart.getTime() > _now.getTime() ? t.visStart : _now ;
				}		
				
				var months = calendar.options.eventList.monthsahead?calendar.options.eventList.monthsahead:'';
				months = months.replace(' ','')==''?1:parseInt(months);	
				if( months>0 ){
					var _visEnd = new Date( t.visStart );
					_visEnd.setMonth( _visEnd.getMonth() + months );
					t.visEnd = _visEnd;		
				}			
			}	
		}

	}
	
	//not part of fc api.
	function beforeAnimation(oldView){
		
	}
	//not part of fc api.
	function transitionEnded(oldView){
		var container = element.find('.fc-gmap-holder');
		$(container).gmap3({trigger:'resize'});	
	}
	
	function render(date,delta){
		t.start = date;//if not defined, hidden views do not update size on window resize.
		var firstTime = !body;
		if(firstTime){
			$('<div class="fc-gmap-holder">...</div>').appendTo(element);
			body = true;
		}else{
			 
		}
		
		if(t.oldView){
		
		}else{
			t.oldView = new $.fullCalendar.views['month']( $('<div>') ,calendar);
			calendar.gotoDate(date);
		}
		
		if(t.oldView){	
			t.oldView.render(date,delta);
			if( t.oldView.visStart && t.oldView.visEnd ){
				t.title = t.oldView.title;
				t.start = t.oldView.start;
				t.end = t.oldView.end;
				//t.visStart = t.oldView.visStart;
				t.visStart = t.oldView.start;
				t.visEnd = t.oldView.visEnd;
				
			
			}		
		}

		if( calendar.options.eventList.upcoming && calendar.options.eventList.upcoming=='1' ){
			var _now = new Date();
			t.visStart = t.visStart.getTime() > _now.getTime() ? t.visStart : _now ;
		}
		
		var months = calendar.options.eventList.monthsahead?calendar.options.eventList.monthsahead:'';
		months = months.replace(' ','')==''?1:parseInt(months);	

		if( months>0 ){
			var _visEnd = new Date( t.visStart );
			_visEnd.setMonth( _visEnd.getMonth() + months );
			t.visEnd = _visEnd;		
		}
	}
	function unselect(){

	}
	function setHeight(h){
		//element.css('min-height',h);
		element.css('min-height','200px');
		element.css('height','auto');
	}
	function setWidth(){/*console.log('setWidth');*/}
	function clearEvents(){
		//TODO:some procedure to clear markers from map.
	}

	function renderEvents(_events, modifiedEventId){
		var container = element.find('.fc-gmap-holder');
		var _values;
		
		_values = get_events(_events);

		$(container).gmap3({
		    marker:{
			    values: _values,
			    cluster:{
			      radius:100,
			      0: {
			        content: "<div class='rhc-cluster rhc-cluster-1'>CLUSTER_COUNT</div>",
			        width: 53,
			        height: 52
			      },
			      20: {
			        content: "<div class='rhc-cluster rhc-cluster-2'>CLUSTER_COUNT</div>",
			        width: 56,
			        height: 55
			      },
			      50: {
			        content: "<div class='rhc-cluster rhc-cluster-3'>CLUSTER_COUNT</div>",
			        width: 66,
			        height: 65
			      },
			      events: {
			        click: function(cluster) {
			          var map = $(this).gmap3("get");
			          map.setCenter(cluster.main.getPosition());
			          map.setZoom(map.getZoom() + 1);
			        },
					mouseover: function( marker ){
						$( '#' + marker_id ).css( { 'display' : 'block', 'opacity' : 0 } ).stop(true,true).animate( { bottom : '15px', opacity : 1 }, 500 );
					},
					mouseout: function( marker ){
						$( '#' + marker_id ).stop(true,true).animate( { bottom : '50px', opacity : 0 }, 500, function() {
							$(this).css( { 'display' : 'none' } );
						} );
					}	
			      }
			    }
		    },
		    map:{
		      options:{
		        zoom: 1
		      }
		    },
            events:{
              mouseover: function(marker, event, context){
                $(this).gmap3(
                  {clear:"overlay"},
                  {
                  overlay:{
                    latLng: marker.getPosition(),
                    options:{
                      content:  "<div class='infobulle"+"'>" +
                                  "<div class='bg'></div>" +
                                  "<div class='text'>" + context.data.title + " (" + context.gaddress + ")</div>" +
                                "</div>" +
                                "<div class='arrow'></div>",
                      offset: {
                        x:-46,
                        y:-73
                      }
                    }
                  }
                });
              },
              mouseout: function(){
                $(this).gmap3({clear:"overlay"});
              }
            }
				
		});		
		
		$(container).gmap3({action:'autofit'});
	}
	
	function get_events(_events){
		var events = [];
		if(_events.length>0){
			//----- this filters out events that are not in the visualization range
			
			var now = new Date();
			$.each(_events,function(i,ev){	
				if(calendar.options.eventList && calendar.options.eventList.outofrange=='1'){
				
				}else{
					if(ev.start<t.visStart)return;
					if(ev.start>t.visEnd)return;				
				}
				
				var gaddress='';
				if(ev.terms && ev.terms.length>0){
					$.each(ev.terms,function(i,t){		
						if(gaddress!='')return;
						if(t.gaddress){
							gaddress = t.gaddress; 
						}
					});
				}				
				
				if(gaddress=='')return;
				
				events[events.length]={
					address:gaddress,
					data:ev
				};
			});
		}
		return events;
	}
	
	function trigger(name, thisObj) {
		return calendar.trigger.apply(
			calendar,
			[name, thisObj || t].concat(Array.prototype.slice.call(arguments, 2), [t])
		);
	}
}	
})(jQuery);