(function($){
$.fullCalendar.views.rhc_gmap = MapView;	
function MapView(element, calendar) {
	var t = this;
	var body;
	t.name = 'rhc_gmap';
	t.render = render;
	t.unselect = unselect;
	t.setHeight = setHeight;
	t.setWidth = setWidth;
	t.clearEvents = clearEvents;
	t.renderEvents = renderEvents;
	t.trigger = trigger;
	t.viewChanged = viewChanged;
	t.beforeAnimation = beforeAnimation;
	t.transitionEnded = transitionEnded;
	t.beforeHide = beforeHide;
	t.setEventData = setEventData;//fc 1.64
	t.clearEventData = clearEventData;//fc 1.64
	t.triggerEventDestroy = triggerEventDestroy;//fc 1.64
	
	t.element = element;
	t.oldView = null;
	//not part of fc api.
	t.calendar = calendar;//needed for clicking event title.
	
	calendar.options.gmap_view = typeof calendar.options.gmap_view=='undefined' ? {} : calendar.options.gmap_view;
	calendar.options.gmap_view = $.extend({
		zoom:1,
		only_latlng:1,
		cluster:1
	},calendar.options.gmap_view);
	
	var trigger = t.trigger;
	
	var et_active_marker = null;
	var active_venue = null;
	var marker_green = 'https://maps.google.com/mapfiles/marker_green.png';
	var marker_red = 'https://maps.google.com/mapfiles/ms/micons/red-dot.png';
	var id = element.parents('.rhc_holder').attr('id');
	var retina = typeof window.devicePixelRatio!='undefined' && window.devicePixelRatio > 1;
	var venues = [];
	var location;
	location = typeof client_location !='undefined' && client_location.length==2? client_location:[];
	
	var formatDate = calendar.formatDate;
	var location_set = false;
		
	function viewChanged(oldView){

	}
	
	//not part of fc api.
	function beforeAnimation(oldView){
		
	}
	//not part of fc api.
	function transitionEnded(oldView){

	}
	
	function beforeHide(){
		if( $('BODY').hasClass('gmap-fullscreen-active') ){
			$(element).find('.fc-gmap-fullscreen').trigger('click');
		}
	}
	
	function cloneDate(d, dontKeepTime) {
		if (dontKeepTime) {
			return clearTime(new Date(+d));
		}
		return new Date(+d);
	}
	
	function clearTime(d) {
		d.setHours(0);
		d.setMinutes(0);
		d.setSeconds(0); 
		d.setMilliseconds(0);
		return d;
	}
	
	function addMonths(d, n) { 
		if (+d) { // prevent infinite looping on invalid dates
			var m = parseInt(d.getMonth()) + parseInt(n);
			d.setMonth(m);//this is not very precise on edge days, but we dont really need that precision as this is for use on the visEnd
		}
		return d;
	}
	
	function render(date,delta){		
		//t.start = date;//if not defined, hidden views do not update size on window resize.
		if (delta) {
			addMonths(date, delta);
			date.setDate(1);
		}
		
		var months= calendar.options.gmap_view.months || 24;
		months = parseInt(months)<=0?24:months;

		var start = cloneDate(date, true);
		start.setDate(1);
		var end = addMonths(cloneDate(start), months);

		var visStart = cloneDate(start);
		var visEnd = cloneDate(end);
		var title_format = calendar.options.gmap_view.titleformat || calendar.options.titleFormat.month || 'MMMM yyyy';		
		t.title = formatDate(start, title_format);
		t.start = start;
		t.end = end;
		t.visStart = visStart;
		t.visEnd = visEnd;
				
		var firstTime = !body;
		if(firstTime){				
			//--
			$('<div class="fc-gmap-container"></div>')
				.append('<div class="fc-gmap-fullscreen-holder"><div class="fc-gmap-fullscreen"></div></div>')
				.append( '<div class="fc-slider-wrapper"><div class="fc-slider"></div></div>')
				.find('.fc-slider-wrapper').hide().end()
				.append('<div class="fc-gmap-holder"></div>')
				.appendTo(element);
				
			$(element)
				.find('.fc-slider-wrapper')
				.append( '<div class="arrow-cont"></div>' )
				.find('.arrow-cont')
				.append( $('<a href="javascript:void(0);" class="rhc-gmap-prev"></a>').click(function(e){prev_venue(this,e);return false;}) )
				.append( $('<a href="javascript:void(0);" class="rhc-gmap-next"></a>').click(function(e){next_venue(this,e);return false;}) )
				.append( $('<a href="javascript:void(0);" class="rhc-gmap-close"></a>').click(function(e){close_dialog(this,e);return false;}) )
				.end()
				.mouseover(function(e){
					$(this).addClass('hovered-dialog');
				})
				.mouseout(function(e){
					$(this).removeClass('hovered-dialog');
				})				
			;					
			body = true;
			//---
			//watermark
			var wurl = calendar.options.gmap_view.watermark_url || false;
			if(false!==wurl && wurl!=''){
				$('<div class="fc-gmap-watermark"></div>')
					.append('<img src="'+wurl+'" />')
					.appendTo(element.find('.fc-gmap-container'))
				;		
				var wlink = calendar.options.gmap_view.watermark_link || false;	
				if(false!==wlink && wlink!=''){
					element.find('.fc-gmap-watermark img').wrap(
						'<a target="_blank" href="' + wlink + '"></a>'
					);
				}
			}
			//--- when hovering the filter section, close the dialog. filtering with the dialog open does not property
			//--- render the filtered events.
			/*
			$('BODY').mousemove(function(e){
				if( e.pageY < 100 ){
					if( $('.fc-slider-wrapper').is(':visible') ){
						close_dialog();
					}
				}
			});	
			*/						
		}else{
			 
		}
			
		var container = element.find('.fc-gmap-holder');
		init_gmap(container);
	
		if(firstTime){		
		
			var lbl_fullscreen = calendar.options.gmap_view.fullscreen_label || 'Fullscreen';
			var lbl_exit_fullscreen = calendar.options.gmap_view.exit_fullscreen_label || 'Exit fullscreen';
			
			//--- init fullscreen button
			$(element).find('.fc-gmap-fullscreen')
				.data('label',lbl_fullscreen)
				.data('alt-label',lbl_exit_fullscreen)
				.html( lbl_fullscreen )
			;
			$(element).find('.fc-gmap-fullscreen-holder').show();		
			$(element).find('.fc-gmap-fullscreen').unbind('click').click(function(e){
				var map= $(container).gmap3("get");
				center = map.getCenter();

				$('BODY,HTML').toggleClass('gmap-fullscreen-active');				
				$(this).parents('.rhc_holder').toggleClass('gmap-fullscreen');

				google.maps.event.trigger( map, "resize");
				map.setCenter(center);
		
				if( $(this).parents('.rhc_holder').hasClass('gmap-fullscreen') ){
					$(this).html( $(this).data('alt-label') );		
				}else{
					$(this).html( $(this).data('label') );
				}
			});
		
			if( calendar.options.gmap_view && calendar.options.gmap_view.fullscreen && '1'==calendar.options.gmap_view.fullscreen ){
				if( !$('BODY').hasClass('gmap-fullscreen-active') ){
					$(element).find('.fc-gmap-fullscreen').trigger('click');
				}
			}	
			//--- init gmamp fullscreen		
				
		}

	}
	function unselect(){

	}
	function setHeight(h){
		//element.css('min-height',h);
		element.css('min-height','200px');
		element.css('height','auto');
	}
	function setWidth(){/*console.log('setWidth');*/}
	function clearEvents(){
		//TODO:some procedure to clear markers from map.
	}

	function add_markers(container, venues){	
		$.each(venues,function(i,venue){
			var overlay_id = venue.id + '_tooltip';
			var tooltip = '<div id="' + overlay_id + '" class="gmap_tooltip_holder" style="display:none;"><div class="gmap_tooltip">' + venue.data.name + '</div></div>';
	
			overlay_settings = {
				id:overlay_id + '_obj',
			 	options:{
			    	content:  tooltip,
			    	offset:{
			      		y:-105,
			      		x:-94
			    	}
			  	}
			};

			if(venue.latLng){
				overlay_settings.latLng = venue.latLng;
			}else if(venue.address){
				overlay_settings.address = venue.address;
			}
	
			$( container ).gmap3({
				overlay: overlay_settings		
			});	
		});
	
		var marker_settings = {
				values:venues,				
				events : {
					/*mouseover*/
					click: function(marker, event, context){ 															
						select_marker(this,marker,context);
					},
					mouseover: function(marker, event, context){
						var overlay_id = context.id + '_tooltip';
						var map = $(this).gmap3("get");
						var _offset = 55 - $( '#' + overlay_id ).height();
						var pos1 = _offset;
						var pos2 = _offset-50;
						
						$( '#' + overlay_id )
							.css({ 
								'margin-top' : pos2+'px',
								'display' : 'block', 
								'opacity' : 0 
							})
							.stop(true,true).animate( { 'margin-top' : pos1+'px', opacity : 1 }, 500 );		
					},
					mouseout: function(marker, event, context){
						var overlay_id = context.id + '_tooltip';
						var _offset = 55 - $( '#' + overlay_id ).height();
						var pos2 = _offset-50;
						
						$( '#' + overlay_id ).stop(true,true).animate( { 'margin-top' : pos2+'px', opacity : 0 }, 500, function() {
								$(this).css( { 'display' : 'none' } );
						});
					}		
				}
		};
	

	
		if(parseInt(calendar.options.gmap_view.cluster)==1){
			var cluster_settings = {
					radius:100,
					0: {
						content: "<div class='cluster cluster-1'><div class='cluster-1-count'>CLUSTER_COUNT</div></div>",
						width: 53,
						height: 52
					},
					20: {
						content: "<div class='cluster cluster-2'><div class='cluster-2-count'>CLUSTER_COUNT</div></div>",
						width: 56,
						height: 55
					},
					50: {
						content: "<div class='cluster cluster-3'><div class='cluster-3-count'>CLUSTER_COUNT</div></div>",
						width: 66,
						height: 65
					},
					events: {
						click: function(cluster) {
							var map = $(this).gmap3("get");
							map.setCenter(cluster.main.getPosition());
							map.setZoom(map.getZoom() + 1);
						}
					}
				};		
			marker_settings.cluster = cluster_settings;
		}
	
		
		$( container ).gmap3({			
			marker : 	marker_settings		
		});			
	}

	function init_gmap(container){
		var map_options = {
      				//center:[40.714623,-74.006605],
					//center:[9.012674,-79.502405],
      				zoom: calendar.options.gmap_view.zoom? parseInt(calendar.options.gmap_view.zoom):12
    			};

		_default = false;
		_lat = 'undefined' == typeof calendar.options.gmap_view.default_lat ? '' : calendar.options.gmap_view.default_lat;
		_lng = 'undefined' == typeof calendar.options.gmap_view.default_lng ? '' : calendar.options.gmap_view.default_lng;
		_lat = ''===_lat.trim()?false:_lat.trim();
		_lng = ''===_lng.trim()?false:_lng.trim();
		_default = false==_lat || false==_lng ? false : [_lat,_lng];

		var loc = _default;
		
		if(loc.length==2){
			map_options.center = loc;
		}		
		
        $(container).gmap3({
			map:{
    			options: map_options
			}
		});
		
		try {		
			styles = JSON.parse( calendar.options.gmap_view.styles );
			var map= $(container).gmap3("get");
			map.setOptions({styles: styles});
			
			if( 0==parseInt(calendar.options.gmap_view.geolocated) ){
			
			}else{
				set_geolocation( container, map );
			}			
			
		} catch (e) {

		}		
		
		init_slider();
	}
		
	function renderEvents(_events, modifiedEventId){		
		var container = element.find('.fc-gmap-holder');
		var upcoming = parseInt( calendar.options.gmap_view.upcoming );
		if( calendar.options.gmap_view.upcoming && upcoming>0 ){
			var tmp = [];
			var _now = new Date();
					//_now.getTime()
			$.each( _events, function(i,ev){
				if(upcoming==1){
					compare_date = ev.start.getTime();
				}else{
					if( ev.end && ev.end.getTime ){
						compare_date = ev.end.getTime() ;
					}else{
						compare_date = ev.start.getTime() ;
					}
				}
				if( compare_date >= _now.getTime() ){
					tmp.push( ev );
				}
			});
			_events = tmp;
		}


		_events.sort(_sort_events);
		venues = get_venues(_events);						
		et_active_marker = null;
//-------------------------
		//init_gmap(container);
//-------------------------
		$(container).gmap3('clear');
		$.each(venues,function(i,v){
			venues[i].id = id + '_marker' + i;
			venues[i].options = {
				animation: null,
				icon: get_inactive_icon(v),
				optimized: false//needed because events are not triggered when mixing icon with only url and scaled.
			};
			
		});
	
		add_markers(container,venues);		
		
//--- center on the first event
		if(venues.length>0){
			var marker = $(container).gmap3({
				get: {
				id: id+'_marker1'
				}
			}); 
			//at this point marker returns false when it was definied useing address and not latLng
		}
			
		if( active_venue && $('.fc-slider-wrapper').is(':visible') ){
			
			marker = null;
			venue = null;
			$.each(venues,function(i,v){
				if( v.data.slug==active_venue.data.slug ){
					venue =	v;
					marker = $(container).gmap3({
						get: {
						id: id+'_marker' + i
						}
					}); 								
				}
			
			});			
		
			if( marker && venue ){
				active_venue = null;//its a new set of marker
				select_marker(container,marker,venue);	
			}else{
				close_dialog();
			}
	
			

		}
	}
	
	function get_active_icon(venue){
		if(venue.data.marker_active){
			var url = get_retina_icon( venue.data.marker_active );		
			if(venue.data.marker_size && venue.data.marker_size!=''){
				var arr = venue.data.marker_size.split(',');
				if(arr.length==2){			
					return new google.maps.MarkerImage(url, null, null, null, new google.maps.Size( parseFloat(arr[0]), parseFloat(arr[1]) ) );
				}
			}						
			return url;			
		}else{
			return marker_red;
		}
	}
	
	function get_inactive_icon(venue){
		if(venue.data.marker_inactive){
			var url = get_retina_icon( venue.data.marker_inactive );		
			if(venue.data.marker_size && venue.data.marker_size!=''){
				var arr = venue.data.marker_size.split(',');
				if(arr.length==2){				
					return new google.maps.MarkerImage(url, null, null, null, new google.maps.Size( parseFloat(arr[0]), parseFloat(arr[1]) ) );
				}
			}						
			return url;
		}else{
			return marker_green;
		}
	}
	
	function get_retina_icon(src){
		if(retina){
			arr = src.split('.');
			if(arr.length>=2){
				arr[arr.length-2] = arr[arr.length-2] + '@2x';		
				src = arr.join('.');
			}			
		}
		return src;
	}
	
	function close_dialog(el,e){
		element
			.find('.fc-slider-wrapper')
			.fadeOut()
		;
	}
	
	function next_venue(el,e){	
		if(venues.length>1){
			var venue_id = $(el).parents('.fc-slider-wrapper').data('venue_id');
			found=false;
			for(var a=0;a<venues.length;a++){
				if(venue_id==venues[a].id){
					found=venues[a+1]?venues[a+1]:venues[0];
					break;
				}
			}
			found = false===found?venues[0]:found;
			
			var container = element.find('.fc-gmap-holder');
			var marker = $(container).gmap3({
				get:{
					id:found.id
				}
			});
	
			if(marker){
				select_marker(container,marker,found);			
				$(container).gmap3("get").panTo( marker.position );
			}
		}
	}
	
	function prev_venue(el,v,e){
		if(venues.length>1){
			var venue_id = $(el).parents('.fc-slider-wrapper').data('venue_id');
			found=false;
			last=false;
			for(var a=0;a<venues.length;a++){
				if(venue_id==venues[a].id){
					found=last?last:venues[venues.length-1];
					break;
				}
				last = venues[a];
			}
			found = false===found?venues[venues.length-1]:found;
			
			var container = element.find('.fc-gmap-holder');
			var marker = $(container).gmap3({
				get:{
					id:found.id
				}
			});
	
			if(marker){
				select_marker(container,marker,found);			
				$(container).gmap3("get").panTo( marker.position );
			}
		}
	}
	
	function select_marker(el,marker,venue){
		var slider = element.find('.fc-slider-wrapper');
		if(active_venue && venue && active_venue.id==venue.id){
			slider.show();
			return;
		}
		
		if(et_active_marker){	
			et_active_marker.set('optimized',false)//if not the inactive marker does not reacts to hover.
			et_active_marker.setAnimation( null );
			et_active_marker.setIcon( get_inactive_icon(active_venue) );
		}
		active_venue = venue;
		et_active_marker = marker;
		
		marker.set('optimized',false);
		marker.setAnimation( google.maps.Animation.BOUNCE);
		marker.setIcon( get_active_icon(venue) );
//$(el).gmap3("get").panTo( marker.position );
		$(el).gmap3("resize");
		$(el).gmap3({action:'trigger', name:'resize'});

		var map= $(el).gmap3("get");
		google.maps.event.trigger( map, "resize");
		//---------------

		//var description = typeof venue.data.address!='undefined'?venue.data.address:'';
		var description = get_bar_label(venue);
		//description = description==''?venue.data.name:description;
		
		slider
			.hide()
			.data('venue_id',venue.id)
			.find('.fc-slider')
				.empty()
				.append('<div class="slider-venue-title">'+venue.data.name+'</div>')
				.append('<div class="slider-venue-image"></div>')
				.append('<div class="slider-venue-description">'+description+'</div>')
				.append('<div class="slider-venue-events"></div>')

				.end()
			
		;
	
		if(venue.data.image && venue.data.image!=''){
			slider.addClass('has-image');
			$('<img>')
				.attr('src',venue.data.image)
				.appendTo( slider.find('.slider-venue-image') )
			;
		}else{
			slider.removeClass('has-image');
		}
		
		if(venue.data.venue_directory){
			slider
				.find('.slider-venue-events')
				.addClass('venue-directory-description-container')
				.html( '<div class="venue-directory-description">' + venue.data.content + '</div>' )
			;
			
			slider
				.find('.venue-directory-description')
				.append('<a target="' + calendar.options.gmap_view.venue_link_target + '" class="venue-more-info-link" href="' + venue.data.url + '">' + calendar.options.gmap_view.venue_link_label + '</a>')
			;
		}
		
		if( venue.data.events && venue.data.events.length > 0){			
			$.each(venue.data.events,function(i,ev){
				if(ev.venue_directory)return;//do not render venue directory items.
				
				if(venue.data.venue_directory){
					return;
				}
				
				ev.skip_sidelist=true;
				triggerRes = trigger('eventRender', ev, ev, ev);
				ev.skip_sidelist=false;
				if(false===triggerRes){
					return;
				}
							
				var item = $('<div class="slider-item"></div>')
					.append('<div class="fc-start"></div>')
					.append('<div class="slider-item-title"><a class="fc-gmap-title-link"></a></div>')
				;
		
				//--- force tooltip to be page link view to page
				ev.fc_click_link = ev.fc_click_link=='view'?'page':ev.fc_click_link;
				
				if(ev.gcal || ev.url==''){	
					item
						.find('.slider-item-title')
						.empty()
						.append( $('<span></span>').addClass('fc-gmap-list-title').html(ev.title) )
					;
				}else if(ev.direct_link){
					item
						.find('a.fc-gmap-title-link')
							.html(ev.title)
							.attr('href',ev.url)	
					;
				}else{
					item
						.find('a.fc-gmap-title-link')
							.html(ev.title)
							.attr('target','')
							.attr('href','javascript:void(0);')	
							.bind('click',function(e){
								var click_method = calendar.options.eventClick?calendar.options.eventClick:fc_click;
								click_method(ev,e,t);
							})
							.end()	
					;
				}
				
				//--time
				if(ev.allDay){
					//item.find('.fc-time').remove();
					var _start_date_format = calendar.options.eventList.StartDateFormatAllDay||'dddd MMMM d, yyyy.';
				}else{
					item.find('.fc-time').html( $.fullCalendar.formatDate(ev.start,'h:mmtt') );
					var _start_date_format = calendar.options.eventList.StartDateFormat||'dddd MMMM d, yyyy. h:mmtt';
				}
			
				//--start
				if(ev.start){
					item.find('.fc-start').html( $.fullCalendar.formatDate(ev.start,_start_date_format,calendar.options) );
				}else{
					item.find('.fc-start').remove();
				}

				item.appendTo( slider.find('.slider-venue-events') );
				//	
			});
		}
		
		slider.show();
	}
	
	function init_slider(){
		var slider = element.find('.fc-slider-wrapper');
		slider
			.draggable({ containment: "parent" })
			.hide()
		;
	}
	
	function get_venues(_events){		
		var gaddress,latlng;
		var done=[];
		var venues=[];
		if(_events && _events.length>0){		
			$.each(_events,function(i,ev){
				
				if(ev.id=='business-directory'){
					triggerRes = trigger('eventRender', ev, ev, ev);
					if(false===triggerRes){
						return;
					}	
				}else{
					triggerRes = trigger('eventRender', ev, ev, ev);
					if(false===triggerRes){
						return;
					}				
				}
				
				if(ev.terms && ev.terms.length>0){
				
					$.each(ev.terms,function(j,t){				

						gaddress='';
						latlng=false;
						if(t.gaddress){
							gaddress = t.gaddress; 
						}						
						
						if(t.glon && t.glat){
							//latlng = [t.glat,t.glon];	
							latlng = new google.maps.LatLng(t.glat, t.glon);	
						}
	
						if(gaddress!='' || latlng !== false ){
							var id = t.term_id ? t.term_id : ( t.slug ? t.slug : (t.name ? t.name : ( t.gaddress ? t.gaddress : null ) ) ) ;
							t.term_id = id;
							if( -1 == $.inArray( id, done ) ){
								done[done.length]=id;
								k = venues.length;
								venues[k]={};
		
								if( latlng !== false){	
									venues[k].latLng = latlng;
								}else if( gaddress!='' ){
									venues[k].address = gaddress;
								}
						
								if( gaddress!='' ){
									t.description = gaddress;								
								}else{
									t.description = '';
								}
								venues[k].data=t;
								
								venues[k].data.events=[];
							}
						}
					});
				}	
			});
		}
		
		if(venues.length>0){
			if( parseInt(calendar.options.gmap_view.only_latlng)==1 ){
				var filtered_venues = [];
				$.each(venues,function(i,venue){
					if(typeof venue.latLng=='undefined')return;
					filtered_venues[filtered_venues.length]=venue;
				});
				venues = filtered_venues;			
			}
		}
		
		if(venues.length>0){
			
			$.each(venues,function(i,venue){
				$.each(_events,function(j,ev){		
					var add_event_to_this_venue = false;
					$.each(ev.terms,function(k,t){
						if(t.term_id==venue.data.term_id){
							add_event_to_this_venue=true;
						}
					});
					if(add_event_to_this_venue){
						venue.data.events[venue.data.events.length]=ev;
					}
				});
			});
		}

		venues = venues_cleanup( venues );
		
		return venues;
	}
	
	function venues_cleanup( venues ){
		
		if( venues.length > 0 ){
			var tmp = [];
			$.each(venues,function(i,v){
				already_added=false;
				$.each(tmp, function(j,t){
					v_gaddress = v.data.gaddress||'';
					v_glon = v.data.glon||'';
					v_glat = v.data.glat||'';
					
					t_gaddress = t.data.gaddress||'';
					t_glon = t.data.glon||'';
					t_glat = t.data.glat||'';
					
					if( ( v_gaddress!='' && v_gaddress==t_gaddress ) || ( v_glat!='' && v_glat==t_glat && v_glon==t_glon ) ){
						already_added = true;
						return false;
					}
				});
				if( already_added ) return true;
				
				tmp.push(v);
			});
			
			venues = tmp;
		}
		
		return venues;
	}
	
	function location_by_latlng_already_added( arr, latlng ){
		if( arr.length > 0 ){
			var added = false;
			$.each(arr,function(i,v){
				if( v.latlng == latlng ){
					added = true;
					return false;
				}
			});
			return added;
		}
		return false;
	}
	
	function trigger(name, thisObj) {
		return calendar.trigger.apply(
			calendar,
			[name, thisObj || t].concat(Array.prototype.slice.call(arguments, 2), [t])
		);
	}
	
	function _sort_events(o,p){
		if(o.start>p.start){
			return 1;
		}else if(o.start<p.start){
			return -1;
		}else{
			return 0;
		}
	}
	
	function _rsort_events(o,p){
		if(o.start<p.start){
			return 1;
		}else if(o.start>p.start){
			return -1;
		}else{
			return 0;
		}
	}	

	function set_location(){

	}
	
	function set_geolocation( container, map ){	
		//map.setCenter(center);	
		if (navigator.geolocation) {
			if (window.location.protocol == "https:"){
				navigator.geolocation.getCurrentPosition(
					function (position) {						
						$(container).gmap3('get').setCenter( new google.maps.LatLng( 
							position.coords.latitude, 
							position.coords.longitude					
						) );	
					},
					function (error){
						set_geolocation_by_api( container, map )
					}
				);	
				return true;		
			}
		}		
		set_geolocation_by_api( container, map );
	}
	
	function set_geolocation_by_api( container, map ){
		$.ajax({
			type: "POST",
			url: gmap_location_api,
			dataType: 'json',
			async: true,//async false is deprecated.
			success : function(data) {			
				if(data && data.R && data.R=='OK'){				
					$(container).gmap3('get').setCenter( new google.maps.LatLng( data.LOCATION[1], data.LOCATION[2] ) );	
				}
			}
		});
	}
	
	function get_geolocation(_default){
		if (navigator.geolocation) {
			if (window.location.protocol == "https:"){ //getCurrentPosition is only available over https
				navigator.geolocation.getCurrentPosition(function (position) {
					return [position.coords.latitude, position.coords.longitude];
				});			
			}
		}
	
		if(location && location.length==2){
			return location;
		}
	
		var r = false;
		//--sync ajax
		$.ajax({
		    type: "POST",
		    url: gmap_location_api,
		    dataType: 'json',
			async: false,
		    success : function(data) {
				if(data && data.R && data.R=='OK'){
					r = [ data.LOCATION[1],data.LOCATION[2] ];
				}
		    }
		});
			
		if(false!==r){
			return r;
		}
		//--
		
		return _default;
	}
	
	function get_bar_label(venue){
		var arr = [];
		if( typeof venue.data.address!='undefined' ){
			if( venue.data.address!='' )
				arr.push( venue.data.address );
		}
		if( typeof venue.data.city!='undefined' ){
			if( venue.data.city!='' )
				arr.push( venue.data.city );
		}
		
		if( typeof venue.data.zip!='undefined' || typeof venue.data.state!='undefined' ){
			var _val = '';
			var tmp = [];
			if( typeof venue.data.state!='undefined' && venue.data.state!=''){		
				tmp.push( venue.data.state );
			}
			if( typeof venue.data.zip!='undefined' && venue.data.zip!=''){
				tmp.push( venue.data.zip );			
			}		
			if(tmp.length>0){
				arr.push( tmp.join(' ') );
			}	
			if( typeof venue.data.country!='undefined' && venue.data.country!=''){		
				arr.push( venue.data.country );
			}			
		}
		
		return arr.join(', ');
	}
	
	function setEventData(events){//required by fullcalendar 1.64
	
	}
	
	function clearEventData(){
	
	}
	
	function triggerEventDestroy(){
	
	}
}	
})(jQuery);


