<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rhc_gmap_shortcode {
	function __construct(){
		add_filter('get_calendarize_args_options',array(&$this,'get_calendarize_args_options'),10,2);
	}
	
	function get_calendarize_args_options($options,$atts){		
		global $rhc_plugin;
		$option_name = "gmap_button_label";
		$gmap_button_label = isset($atts[$option_name]) && !empty($atts[$option_name]) ? $atts[$option_name] : $rhc_plugin->get_option($option_name,__('map','rhcgmap'),true) ;
		$auto_button = $rhc_plugin->get_option('gmap_auto_button','1',true);
		
		$settings = $this->get_gmap_options(null,$atts);
	
		foreach($options->modes as $type => $mode){
			$options->modes[$type]['options']->gmap_view = $settings;
			//--
			$options->modes[$type]['options']->buttonText->rhc_gmap = $gmap_button_label;
			//--
			if('1'==$auto_button){
				if( $options->modes[$type]['options']->for_widget=='1' || ''==trim($options->modes[$type]['options']->header->right)){
					//note, if empty there is no point in adding the map button.
					//$options->modes[$type]['options']->header->right .= 'rhc_gmap';
				}else{
					$options->modes[$type]['options']->header->right .= ',rhc_gmap';
				}
			}
			
			if(''!=trim($settings->sidelist_label)){				
				@$options->modes[$type]['options']->sidelist->labels->tab = $settings->sidelist_label;
			}
		}

		return $options;
	}
	
	function get_gmap_options($type,$atts){
		global $rhc_plugin;
		$r = (object)array();
		foreach(array(
			'zoom'					=> 1,
			'only_latlng'			=> 1,
			'cluster'				=> 1,
			'fullscreen'			=> 0,
			'fullscreen_label'		=> __('Fullscreen','rhcgmap'),
			'exit_fullscreen_label'	=> __('Exit fullscreen','rhcgmap'),
			'watermark_url'			=> '',
			'watermark_link'		=> '',
			'months'				=> 24,
			'sidelist_label'		=> __('Event list','rhc'),
			'geolocated'			=> 1,
			'default_lat'			=> '',
			'default_lng'			=> '',
			'upcoming'				=> '0',
			'titleformat'			=> 'MMMM yyyy',
			'styleid'				=> '',
			'styles'				=> '[]'
		) as $field => $default){
			$option_name = "gmap_".$field;
			$value = isset($atts[$option_name]) ? $atts[$option_name] : $rhc_plugin->get_option($option_name,$default,true) ;
			$r->$field = $value;
		}
	
		$r->styles = apply_filters( 'rhc_map_styles', $r->styles, $r->styleid, $atts, null, null );
	
		return $r;
	}
}
?>