<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rhc_gmap_ajax {
	var $max_geodata=100;
	function __construct(){
		add_action('wp_loaded', array(&$this,'init'));
	
		if(is_admin()){
			add_action('admin_head', array(&$this,'head'));
		}else{
			add_action('wp_head', array(&$this,'head'));		
		}		
	}
	
	function head(){
		global $rhc_plugin;
		$url = $rhc_plugin->get_option('gmap_location_api', site_url('/?geolocation=1'), true);
		if($url!==''){
?>
<script type="text/javascript">
var client_location = [];
var gmap_location_api='<?php echo $url?>';
jQuery(document).ready(function($){
	var args = {};
	$.post(gmap_location_api,args,function(data){
		if(data && data.R && data.R=='OK'){
			client_location = [ data.LOCATION[1],data.LOCATION[2] ];
			$('BODY').trigger('client_location',data);
		}
	},'json');	
});
</script>
<?php		
		}
	}
	
	function init(){
		if(!isset($_REQUEST['geolocation']))return;
		$this->geolocation();
	}	
	
	function geolocation(){
		$ip = $_SERVER['REMOTE_ADDR'];
		//$ip = '186.188.205.193';
		
		$geodata = get_option('geolocations');
		$geodata = is_array($geodata)?$geodata:array();
		if(!empty($geodata)){
			foreach($geodata as $location){
				if($location[0]==$ip){
					$r = array(
						'R'		=> 'OK',
						'MSG'	=> 'MSG',
						'LOCATION'=> $location,
						'CACHED'=>'1'
					);
					die(json_encode($r));				
				}
			}		
		}
		
		$error_message = '';
		
		// Not cached, query webservice.
		$url = "http://www.geoplugin.net/php.gp?ip=$ip";
		$result = wp_remote_get( $url, array(
			'headers' => array(
				'referer' => site_url()
			) )
		);

		if ( is_wp_error( $result) ) {
			$this->alt_geolocation( $url ); // Try alternate method before giving up.
			die( json_encode( array(
				'R'   => 'ERR',
				'MSG' => $result->get_error_message()
				)
			) );
		}

		if ( $data = unserialize( $result['body'] ) ) {
			if(isset($data['geoplugin_status']) && $data['geoplugin_status']=='200'){
				$location = array($ip,$data['geoplugin_latitude'],$data['geoplugin_longitude']);
				//-- add to cache
				array_unshift($geodata,$location);
				$geodata = array_slice($geodata, 0, $this->max_geodata);
				update_option('geolocations',$geodata);		
				//--
				$r = array(
					'R'			=> 'OK',
					'MSG'		=> 'MSG',
					'LOCATION'	=> $location,
					'CACHED'	=> '0'
				);
				die(json_encode($r));
			}else{
				$error_message = $data['geoplugin_status'];
			}
		}else{
			$error_message = "Could not decode geo data.";
		}
		$this->alt_geolocation( $url );//try alternate method before giving up.
		die(json_encode(array('R'=>'ERR','MSG'=>$error_message)));
	}
	
	function alt_geolocation( $url ){
		$lines_array=file($url);
		$line_string=implode('',$lines_array);
		if($data=unserialize($line_string)){
			if(isset($data['geoplugin_status']) && $data['geoplugin_status']=='200'){
				$location = array($ip,$data['geoplugin_latitude'],$data['geoplugin_longitude']);
				//-- add to cache
				array_unshift($geodata,$location);
				$geodata = array_slice($geodata, 0, $this->max_geodata);
				update_option('geolocations',$geodata);		
				//--
				$r = array(
					'R'			=> 'OK',
					'MSG'		=> 'MSG',
					'LOCATION'	=> $location,
					'CACHED'	=> '0'
				);
				die(json_encode($r));
			}else{
				//$error_message = $data['geoplugin_status'];
			}
		}else{
			//$error_message = "Could not decode geo data.(alt)";
		}
		//die(json_encode(array('R'=>'ERR','MSG'=>$error_message)));
	}
}
?>