<?php

/**
Plugin Name: Google Map View add-on for Calendarize it!
Plugin URI: http://plugins.righthere.com/calendarize-it/
Description: Provides a google map view for Calendarize it!
Version: 1.2.7.78905
Author: Alberto Lau (RightHere LLC)
Author URI: http://plugins.righthere.com
 **/

if(defined('RHCGMAP_PATH')) throw new Exception( __('A duplicate of this addon/plugin is already active.','rhc') );
 
if(defined('RHC_ADDON_PATH')){
	define('RHCGMAP_PATH', trailingslashit(RHC_ADDON_PATH . dirname($addon)) ); 
	define("RHCGMAP_URL", trailingslashit(RHC_ADDON_URL . dirname($addon)) );
}else{
	define('RHCGMAP_PATH', plugin_dir_path(__FILE__) ); 
	define("RHCGMAP_URL", plugin_dir_url(__FILE__) );
} 
 
class plugin_rhc_gmap_view {
	var $in_footer = false;	
	function __construct($args=array()){		
		$defaults = array(
			'options_capability'				=> 'manage_options'
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------			
		
		global $rhc_plugin;
		if('1'==$rhc_plugin->get_option('in_footer',false,true)){
			$this->in_footer = true;
		}		
		//add_filter('rhc_calendar_meta',array(&$this,'rhc_calendar_meta'),10,1);
		//wp_register_script( 'google-api3', 'http://maps.google.com/maps/api/js?sensor=false&libraries=places', array('jquery'),'3.0',$this->in_footer);

		require RHCGMAP_PATH.'includes/class.rhc_gmap_venue_fields.php';
		new rhc_gmap_venue_fields();
		
		require RHCGMAP_PATH.'includes/class.rhc_gmap_ajax.php';
		new rhc_gmap_ajax();
		
		require RHCGMAP_PATH.'includes/class.rhc_gmap_shortcode.php';
		new rhc_gmap_shortcode();
		
		require RHCGMAP_PATH.'includes/class.rhc_venue_map_directory.php';
		new rhc_venue_map_directory();
		
		add_action('plugins_loaded',array(&$this,'plugins_loaded'),9);
		
		add_action('rhc_views', array(&$this,'rhc_views'),10,1);
		
		add_action('rhc_scripts_frontend',array(&$this,'wp_enqueue_scripts'));
		add_action('rhc_scripts_admin',array(&$this,'wp_enqueue_scripts'));
		
		add_action('enqueue_frontend_only', array( &$this, 'enqueue_frontend_only') );
	}	
	
	function enqueue_frontend_only(){
		wp_enqueue_style('gmap3-rhc-view');
		wp_enqueue_script('gmap3-rhc-view');	
	}
	
	function wp_enqueue_scripts(){
		wp_register_style( 'gmap3-rhc-view', RHCGMAP_URL.'css/gmap3_custom_view.css', array(),'1.0.5');
		wp_register_script( 'gmap3', RHCGMAP_URL.'js/gmap3.min.js', array('google-api3'),'6.0.0.2',$this->in_footer);
		wp_register_script( 'gmap3-rhc-view', RHCGMAP_URL.'js/gmap3_fullcalendar_view.js', array('gmap3','calendarize'),'1.0.8.3',$this->in_footer);
		if(is_admin()){
			$screen = get_current_screen();
			if($screen->taxonomy!=RHC_VENUE){
				return;//do not enqueue
			}
		}
		global $rhc_plugin;
		if( is_admin() || '0' == $rhc_plugin->get_option('scripts_on_demand','0',true)){
			do_action('enqueue_frontend_only');		
		}			
	}
	
	function plugins_loaded(){
		if(is_admin()){
			do_action('rh-php-commons');	
			
			require 'includes/class.rhc_gmap_options.php';
			new rhc_gmap_options('rhc',$this->options_capability,false);	
		}		
	}
	
	function rhc_views($options){
		$options['rhc_gmap']=__('Events Map View','rhcgmap');
		return $options;
	}
}

new plugin_rhc_gmap_view();
?>