<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class FlatEventsCalendar_Widget extends WP_Widget {
	function __construct() {
		parent::__construct(
	 		'flat_events_calendar_widget', 
			__('Calendarzie (FLAT UI Calendar)','rhcfui'), 
			array( 'description' => __( 'Events calendar', 'rhc' ), ) 
		);
	}

	function widget( $args, $instance ) {
		extract( $args );
		//----
		foreach(array('hformat','feed', 'title','post_type','venue','organizer','calendar','view','theme','weekend','url','icalendar','dayclick','loading_overlay','google_map','onechardaylabel','autohover','autoclick') as $field ){
			$$field = isset($instance[$field])?$instance[$field]:'';
		}
		
		global $rhc_plugin;
		
		$events_slug = $rhc_plugin->get_option('rhc-events-slug',RHC_EVENTS,true);
		$visual_calendar_slug = $rhc_plugin->get_option('rhc-visualcalendar-slug',RHC_VISUAL_CALENDAR, true);
		
		$post_type = is_array($post_type)&&!empty($post_type)?$post_type:array(RHC_EVENTS);
		
		if(trim($url)==''){
			$widget_link_page_id = $rhc_plugin->get_option('widget_link_template_page_id',false,true);
			$widget_link = false===$widget_link_page_id?'':get_page_link($widget_link_page_id);
			if(''==$widget_link){
	 			if( get_option( 'permalink_structure' ) !== '' ) {
	 				$widget_link = site_url( sprintf("/%s/%s/",$events_slug,$visual_calendar_slug) );    
	 			} else {
	 			    $widget_link = site_url("/?post_type=".RHC_EVENTS."&".RHC_DISPLAY."=".$visual_calendar_slug);
	 			}			
			}
		}else{
			$widget_link = $url;
		}
	
		echo $before_widget;
		//echo trim($title)==''?'':$before_title.$title.$after_title;
		if(trim($title)!=''){
			echo "<div class=\"block-title\"><span>";
			echo $title;
			echo "</span></div>";
		}
		
		echo "<div class=\"widget-calendar-holder\">";
		//-------- this portion is based on the code used on function.generate_calendarize_shortcode.php, TODO: simplify with a function
		$args=array();
		global $rhc_plugin;
		$field_option_map = array(
			"monthnames","monthnamesshort","daynames","daynamesshort","firstday"
		);
		foreach($field_option_map as $field){
			$option = 'cal_'.$field;
			if(isset($params[$field]))continue;
			$value = $rhc_plugin->get_option($option);
			if(trim($value)!=''){
				$params[$field]=$value;
			}
		}
		
		if(isset($params['daynamesshort'])){
			$arr = explode( ',', str_replace( ' ', '', $params['daynamesshort'] ) );
			$brr = array();
			foreach($arr as $sday){
				$v = substr( strtoupper($sday), 0, 1 );
				if( function_exists( 'mb_substr' ) ){
					$brr[] = mb_substr( strtoupper($sday), 0, 1 );
				}else{
					$brr[] = substr( strtoupper($sday), 0, 1 );
				}
				
			}
			$params['daynamesshort'] = implode( ',', $brr );
		}

		//--
		if(is_array($params) && count($params)>0){
			foreach($params as $field => $value){
				foreach(array('['=>'&#91;',']'=>'&#93;') as $replace => $with){
					$value = str_replace($replace,$with,$value);
				}
				$args[$field]=sprintf('%s="%s"',$field,$value);
			}	
		}			
		//--------
		if(''!=trim($feed)){
			$args['feed']='feed="'.$feed.'"';
		}
		
		if(is_array($post_type)&&count($post_type)>0){
			$args[]=sprintf('post_type="%s"', implode(',',$post_type) );
		}
						
		$str = sprintf("[calendarize %s widget_autoclick='%s' widget_autohover='%s' widget_onechardaylabel='%s' widget_google_map='%s' class='%s' loading_overlay='%s' icalendar='%s' weekends='%s' venue='%s' organizer='%s' calendar='%s' %s widget_link='%s' widget_link_view='%s' header_left='prev,next' header_center='' header_right='title' defaultview='month' ignoreposted='1' for_widget='1' %s]",
			//"'<span class=''fuiw-dayname''>'dddd'</span><span>'MMMM'</span><span>'yyyy'</span><span>'d'</span>'",
			( empty($hformat) ? '' : sprintf('widget_hformat="%s"',esc_attr($hformat)) ),
			$autoclick,
			$autohover,
			$onechardaylabel,
			( empty($google_map) ? 'interactive' : $google_map),
			'for-widget flat-ui-cal',//for now hardcoded.
			$loading_overlay,
			$icalendar,
			$weekend,
			$venue,
			$organizer,
			$calendar,
			(empty($dayclick)?'':"widget_dayclick='$dayclick'"),
			$widget_link,
			$view,
			implode(' ',$args)
		);

//echo $str;
		if( current_user_can('manage_options') && isset( $_REQUEST['rhc_debug'] ) ){
			echo $str;
		}
		echo do_shortcode($str);
		
		echo "</div>";//close widget-calendar-holder
		
		echo $after_widget;				
		//-----
		if( $google_map == 'interactive' || $google_map == ''  ){
			add_action('wp_footer', array(&$this,'google_map_footer') );
		}
	}
	
	function google_map_footer(){
		wp_print_scripts('rhc_gmap3');
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = array();
		foreach(array('post_type','hformat','calendar','venue','organizer','title','url','view','theme','weekend','icalendar','dayclick','loading_overlay','google_map','onechardaylabel','autohover','autoclick') as $field){
			$instance[$field] = $new_instance[$field];
		}
		$instance = apply_filters('rhc_widget_upcoming_events_update',$instance,$new_instance,$old_instance);
		return $instance;
	}

	function form( $instance ) {
		$taxmap = array('venue'=>RHC_VENUE,'organizer'=>RHC_ORGANIZER,'calendar'=>RHC_CALENDAR);
		foreach(array('hformat'=>'','title'=>'','view'=>'agendaDay','theme'=>'','weekend'=>1,'url'=>'','icalendar'=>'0','dayclick'=>'','loading_overlay'=>'0','google_map'=>'interactive','onechardaylabel'=>'','autohover'=>'','autoclick'=>'') as $field =>$default){
			$$field = isset( $instance[$field] )?$instance[$field]:$default;		
		}
		//---
		global $rhc_plugin;
		$post_types = $rhc_plugin->get_option('post_types',array(),true);
		array_unshift($post_types,RHC_EVENTS);	
		$checked = isset($instance['post_type'])&&is_array($instance['post_type'])&&count($instance['post_type'])>0?$instance['post_type']:array(RHC_EVENTS);
		//----		
?>
<div>
	<div class="" style="margin-top:10px;">
		<label><?php _e('Title','rhc')?></label>
		<input type="text" id="<?php echo $this->get_field_id('title')?>" class="widefat" name="<?php echo $this->get_field_name('title')?>" value="<?php echo $title?>" />
	</div>

	<div class="" style="margin:10px 0 10px 0;">
		<label><?php _e('Post type','rhc')?></label>
		<div class="widefat" style="border:none;">
			<?php foreach($post_types as $post_type):?>
			<input type="checkbox" <?php echo in_array($post_type,$checked)?'checked="checked"':''?> name="<?php echo $this->get_field_name('post_type')?>[]" value="<?php echo $post_type ?>" />&nbsp;<?php echo $post_type ?><br />
			<?php endforeach;?>		
		</div>
	</div>	

	<label><?php _e('Specific taxonomy:','wlbadds')?></label>
<?php foreach(array('calendar'=>__('Calendar','rhc'),'venue'=>__('Venue','rhc'),'organizer'=>__('Organizer','rhc')) as $field => $label):$$field = isset( $instance[$field] )?$instance[$field]:'';?>
	
	<div class="" style="margin-top:10px;">
	<label for="<?php echo $field ?>"><?php echo $label?></label>
	<?php $this->taxonomy_dropdown($taxmap[$field],$this->get_field_id($field),$this->get_field_name($field),(isset( $instance[$field] )?$instance[$field]:''))?>
	</div>
<?php endforeach;?>
	<div class="" style="margin-top:10px;">
		<?php _e('Day click behavior','rhc')?>
		<select id="<?php echo $this->get_field_id('dayclick')?>" name="<?php echo $this->get_field_name('dayclick')?>" class="widefat">
			<?php foreach( apply_filters('rhc_calendar_widget_dayclick', array(
				'' => __('Link to calendar url(default)','rhc'),
				'calendar_widget_day_click' => __('Show list of events','rhc')
			)) as $value => $label ): ?>
			<option value="<?php echo $value?>" <?php echo $dayclick==$value?'selected="selected"':''?> ><?php echo $label?></option>
			<?php endforeach;?>
		</select>
	</div>	
	<div class="" style="margin-top:10px;">
		<?php _e('Calendar url(optional)','rhc')?>
		<input type="text" id="<?php echo $this->get_field_id('url')?>" name="<?php echo $this->get_field_name('url')?>" class="widefat" value="<?php echo $url?>" />
	</div>
	<div class="" style="margin-top:10px;">
		<?php _e('Link view','rhc')?>
		<select id="<?php echo $this->get_field_id('view')?>" name="<?php echo $this->get_field_name('view')?>" class="widefat">
			<?php foreach(array('agendaDay'=>__('Agenda day','rhc'),'rhc_event'=>__('Event list','rhc'),'agendaWeek'=>__('Agenda week','rhc'),'month'=>__('Month','rhc')) as $value => $label):?>
			<option value="<?php echo $value?>" <?php echo $value==$view?'selected="selected"':''?> ><?php echo $label?></option>
			<?php endforeach;?>
		</select>
	</div>
	<div class="" style="margin-top:10px;display:none;">
		<?php _e('Style','rhc')?>
		<select id="<?php echo $this->get_field_id('theme')?>" name="<?php echo $this->get_field_name('theme')?>" class="widefat">
			<?php foreach( array('default'=>__('Default','rhcfui')) as $value => $label):?>
			<option value="<?php echo $value?>" <?php echo $value==$theme?'selected="selected"':''?> ><?php echo $label?></option>
			<?php endforeach;?>
		</select>
	</div>
	<div class="" style="margin-top:10px;">
		<?php _e('Show weekend','rhc')?>
		<select id="<?php echo $this->get_field_id('weekend')?>" name="<?php echo $this->get_field_name('weekend')?>" class="widefat">
			<option value="1" <?php echo $weekend=='1'?'selected="selected"':''?> ><?php _e('Yes','rhc')?></option>
			<option value="0" <?php echo $weekend=='0'?'selected="selected"':''?> ><?php _e('No','rhc')?></option>
		</select>
	</div>	
	<div class="" style="margin-top:10px;display:none;">
		<?php _e('Show iCal button','rhc')?>
		<select id="<?php echo $this->get_field_id('icalendar')?>" name="<?php echo $this->get_field_name('icalendar')?>" class="widefat">
			<option value="1" <?php echo $icalendar=='1'?'selected="selected"':''?> ><?php _e('Yes','rhc')?></option>
			<option value="0" <?php echo $icalendar=='0'?'selected="selected"':''?> ><?php _e('No','rhc')?></option>
		</select>
	</div>	
	<div class="" style="margin-top:10px;">
		<?php _e('Show loading overlay','rhc')?>
		<select id="<?php echo $this->get_field_id('loading_overlay')?>" name="<?php echo $this->get_field_name('loading_overlay')?>" class="widefat">
			<option value="1" <?php echo $loading_overlay=='1'?'selected="selected"':''?> ><?php _e('Yes','rhc')?></option>
			<option value="0" <?php echo $loading_overlay=='0'?'selected="selected"':''?> ><?php _e('No','rhc')?></option>
		</select>
	</div>	
	<div class="" style="margin-top:10px;">
		<?php _e('Google Map','rhc')?>
		<select id="<?php echo $this->get_field_id('google_map')?>" name="<?php echo $this->get_field_name('google_map')?>" class="widefat">
			<option value="interactive" <?php echo $google_map=='interactive'?'selected="selected"':''?> ><?php _e('Interactive','rhc')?></option>
			<option value="static" <?php echo $google_map=='static'?'selected="selected"':''?> ><?php _e('Static','rhc')?></option>
			<option value="none" <?php echo $google_map=='none'?'selected="selected"':''?> ><?php _e('No map','rhc')?></option>
		</select>
	</div>	
	
	<div class="" style="margin-top:10px;">
		<?php _e('Disable single character day label','rhc')?>
		<select id="<?php echo $this->get_field_id('onechardaylabel')?>" name="<?php echo $this->get_field_name('onechardaylabel')?>" class="widefat">
			<option value="" <?php echo $onechardaylabel==''?'selected="selected"':''?> ><?php _e('No(default)','rhc')?></option>
			<option value="1" <?php echo $onechardaylabel=='1'?'selected="selected"':''?> ><?php _e('Yes','rhc')?></option>
		</select>
	</div>		
	
	<div class="" style="margin-top:10px;">
		<?php _e('Auto Hover','rhc')?>
		<select id="<?php echo $this->get_field_id('autohover')?>" name="<?php echo $this->get_field_name('autohover')?>" class="widefat">
			<option value="" <?php echo $autohover==''?'selected="selected"':''?> ><?php _e('No(default)','rhc')?></option>
			<option value="1" <?php echo $autohover=='1'?'selected="selected"':''?> ><?php _e('Yes','rhc')?></option>
		</select>
	</div>	
	
	<div class="" style="margin-top:10px;">
		<?php _e('Auto Click','rhc')?>
		<select id="<?php echo $this->get_field_id('autoclick')?>" name="<?php echo $this->get_field_name('autoclick')?>" class="widefat">
			<option value="" <?php echo $autoclick==''?'selected="selected"':''?> ><?php _e('No(default)','rhc')?></option>
			<option value="1" <?php echo $autoclick=='1'?'selected="selected"':''?> ><?php _e('Yes','rhc')?></option>
		</select>
	</div>		
	
	<div class="" style="margin-top:10px;">
		<p><?php _e('Auto Hover and Auto Click are only applicable for Show Event List, day click behavior.  Auto click overrides hover.','rhc')?></p>
	</div>
	
	<div class="" style="margin-top:10px;">
		<?php _e('Header format','rhc')?>
		<textarea rows="5" id="<?php echo $this->get_field_id('hformat')?>" name="<?php echo $this->get_field_name('hformat')?>" class="widefat"><?php echo esc_textarea( $hformat )?></textarea>
	</div>		
	<?php do_action('rhc_widget_upcoming_events_form',$this,$instance)?>
</div>
<?php
	}
	
	function taxonomy_dropdown($taxonomy,$id,$name,$posted_value){
		$terms = get_terms($taxonomy);
?>
<select id="<?php echo $id?>" name="<?php echo $name?>" class="widefat upcoming-<?php echo $taxonomy?>">
<?php if(is_array($terms)&&count($terms)>0):?>
<option value=""><?php _e('--any--','rhc')?></option>
<?php foreach($terms as $t):?>
<option value="<?php echo $t->slug?>" <?php echo $posted_value==$t->slug?'selected="selected"':''?> ><?php echo $t->name?></option>
<?php endforeach;?>
<?php else: ?>
<option value=""><?php _e('--no options--','rhc')?></option>
<?php endif;?>
</select>
<?php		
	}
}
?>