<?php

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

class ModuleOverlay extends \module_righthere_css {
	public function __construct( $args = array() ) {
		parent::__construct( $args );
	}

	public function options( $t = array() ) {
		
		wp_enqueue_script( 'eyv-css-editor' );
		
		// Date Header
		$i = count( $t );
		$selector = 'body .eyv-overlay .fc-day-content-date';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_overlay_date'; 
		$t[ $i ]->label   = __( 'Date Header', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_overlay_date_font',
			'selector' => $selector,
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhceyv_overlay_date_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => $selector,
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'           => 'rhceyv_overlay_date_line_height',
			'type'         => 'css',
			'label'        => __( 'Line height', 'rhc' ),
			'input_type'   => 'number',
			'unit'         => 'px',
			'class'        => 'input-mini',
			'holder_class' => '',
			'selector'     => $selector,
			'property'     => 'line-height',
			'real_time'    => true
		);

		// Time
		$i = count( $t );
		$selector = 'body .eyv-overlay .fc-day-content-event-time';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_overlay_time'; 
		$t[ $i ]->label   = __( 'Time', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_overlay_time_font',
			'selector' => $selector,
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhceyv_overlay_time_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => $selector,
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		// Event Title
		$i = count( $t );
		$selector = 'body .eyv-overlay .fc-day-content-event-title';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_overlay_event_title'; 
		$t[ $i ]->label   = __( 'Event Title', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_overlay_event_title_font',
			'selector' => $selector,
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhceyv_overlay_event_title_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => $selector,
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'           => 'rhceyv_overlay_event_title_line_height',
			'type'         => 'css',
			'label'        => __( 'Line height', 'rhc' ),
			'input_type'   => 'number',
			'unit'         => 'px',
			'class'        => 'input-mini',
			'holder_class' => '',
			'selector'     => $selector,
			'property'     => 'line-height',
			'real_time'    => true
		);

		// Taxonomies
		$i = count( $t );
		$selector = 'body .eyv-overlay .fc-day-content-event-taxonomy';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_overlay_taxonomies'; 
		$t[ $i ]->label   = __( 'Taxonomies', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_overlay_taxonomies_font',
			'selector' => $selector,
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhceyv_overlay_taxonomies_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => $selector,
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'           => 'rhceyv_overlay_taxonomies_line_height',
			'type'         => 'css',
			'label'        => __( 'Line height', 'rhc' ),
			'input_type'   => 'number',
			'unit'         => 'px',
			'class'        => 'input-mini',
			'holder_class' => '',
			'selector'     => $selector,
			'property'     => 'line-height',
			'real_time'    => true
		);

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_overlay_taxonomies_padding',
			'selector' => $selector,
		) );

		// Templates
		$i = count( $t );
		$t[ $i ] = (object) array();
		$t[ $i ]->id      = 'rh-saved-list'; 
		$t[ $i ]->label   = __( 'Templates', 'rhc' );
		$t[ $i ]->options = array( (object) array(
			'id'         => 'rh_saved_settings',
			'input_type' => 'backup_list'
		) );

		return $t;
	}
}