<?php

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

class ModuleCalendar extends \module_righthere_css {
	public function __construct( $args = array() ) {
		parent::__construct( $args );
	}

	public function options( $t = array() ) {
		// Months Box
		$i = count( $t );
		$selector = 'body .rhcalendar .rhc-year-view div.rhc-month';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_months_box'; 
		$t[ $i ]->label   = __( 'Months Box', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_backgroud_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_box_background',
			'selector' => $selector,
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_box_border',
			'selector' => $selector,
		) );

		$t[ $i ]->options = $this->add_border_radius_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_box_border_radius',
			'selector' => $selector,
		) );

		$t[ $i ]->options = $this->add_margin_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_box_margin',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_box_padding',
			'selector' => $selector
		) );

		// Months Title
		$i = count( $t );
		$selector = 'body .rhcalendar .rhc-year-view h3.month-title';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_months_title'; 
		$t[ $i ]->label   = __( 'Months Title', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_title_font',
			'selector' => $selector
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhcyev_months_title_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => $selector,
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_title_border_top',
			'selector' => $selector,
			'label'    => array(
				'color' => __( 'Top Border Color', 'rhc' ),
				'style' => __( 'Top Border Style', 'rhc' ),
				'size'  => __( 'Top Border Width', 'rhc' )
			),
			'property' => array(
				'color' => 'border-top-color',
				'style' => 'border-top-style',
				'size'  => 'border-top-width'
			)
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_title_border_right',
			'selector' => $selector,
			'label'    => array(
				'color' => __( 'Right Border Color', 'rhc' ),
				'style' => __( 'Right Border Style', 'rhc' ),
				'size' => __( 'Right Border Width', 'rhc' )
			),
			'property' => array(
				'color' => 'border-top-color',
				'style' => 'border-top-style',
				'size'  => 'border-top-width'
			)
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_title_border_bottom',
			'selector' => $selector,
			'label'      => array(
				'color' => __( 'Bottom Border Color', 'rhc' ),
				'style' => __( 'Bottom Border Style', 'rhc' ),
				'size'  => __( 'Bottom Border Width', 'rhc' )
			),
			'property' => array(
				'color'    => 'border-bottom-color',
				'style'    => 'border-bottom-style',
				'size'     => 'border-bottom-width'
			)
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_title_border_left',
			'selector' => $selector,
			'label'    => array(
				'color' => __( 'Left Border Color', 'rhc' ),
				'style' => __( 'Left Border Style', 'rhc' ),
				'size'  => __( 'Left Border Width', 'rhc' )
			),
			'property' => array(
				'color' => 'border-left-color',
				'style' => 'border-left-style',
				'size'  => 'border-left-width'
			)
		) );

		$t[ $i ]->options = $this->add_backgroud_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_title_background',
			'selector' => $selector,
			'label'    => __( 'Background', 'rhc' )
		) );

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcyev_months_title_padding',
			'selector' => $selector
		) );

		// Week Days Name
		$i = count( $t );
		$selector = 'body .rhcalendar .rhc-year-view .rhc-month table.fc-border-separate th.fc-day-header';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_week_days_name'; 
		$t[ $i ]->label   = __( 'Week Days Name', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_week_days_name_font',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_backgroud_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_week_days_name_background',
			'selector' => $selector,
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_week_days_name_border',
			'selector' => $selector,
		) );

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_week_days_name_padding',
			'selector' => $selector
		) );

		// Month Days Number
		$i = count( $t );
		$selector = 'body .rhcalendar .rhc-year-view .rhc-month table.fc-border-separate td.fc-day';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_month_days_number'; 
		$t[ $i ]->label   = __( 'Month Days Number', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_month_days_number_font',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_backgroud_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_month_days_number_background',
			'selector' => $selector,
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_month_days_number_border',
			'selector' => $selector,
		) );

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_month_days_number_padding',
			'selector' => $selector
		) );

		// Current Day Circle
		$i = count( $t );
		$selector = 'body .rhcalendar .rhc-year-view.rhc-month-wrap .rhc-month td.fc-today div.fc-day-number';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_current_day_circle'; 
		$t[ $i ]->label   = __( 'Current Day Circle', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options[] =(object) array(
			'input_type' => 'grid_start'
		);

		$t[ $i ]->options[] = (object) array(
			'id'           => 'rhceyv_current_day_circle_width',
			'type'         => 'css',
			'label'        => __( 'Width', 'rhc' ),
			'input_type'   => 'number',
			'unit'         => 'px',
			'class'        => 'input-mini',
			'holder_class' => 'span6',
			'selector'     => $selector,
			'property'     => 'width',
			'real_time'    => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'           => 'rhceyv_current_day_circle_height',
			'type'         => 'css',
			'label'        => __( 'Height', 'rhc' ),
			'input_type'   => 'number',
			'unit'         => 'px',
			'class'        => 'input-mini',
			'holder_class' => 'span6',
			'selector'     => $selector,
			'property'     => 'height',
			'real_time'    => true
		);

		$t[ $i ]->options[] =(object) array(
			'input_type' => 'grid_end'
		);

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_current_day_circle_font',
			'selector' => $selector
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhceyv_current_day_circle_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => $selector,
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		$t[ $i ]->options = $this->add_backgroud_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_current_day_circle_background',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_current_day_circle_border',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_border_radius_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_current_day_circle_border_radius',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_current_day_circle_padding',
			'selector' => $selector
		) );

		// Event Days Circle
		$i = count( $t );
		$selector = 'body .rhcalendar .rhc-year-view.rhc-month-wrap .rhc-month td.fc-have-event div.fc-day-number,';
		$selector .= 'body .rhcalendar .rhc-year-view.rhc-month-wrap .rhc-month td.fc-have-event div.fc-day-number a';
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhceyv_event_days_circle'; 
		$t[ $i ]->label   = __( 'Event Days Circle', 'rhcyev' );
		$t[ $i ]->options = array();

		$t[ $i ]->options[] =(object) array(
			'input_type' => 'grid_start'
		);

		$t[ $i ]->options[] = (object) array(
			'id'           => 'rhceyv_event_days_circle_width',
			'type'         => 'css',
			'label'        => __( 'Width', 'rhc' ),
			'input_type'   => 'number',
			'unit'         => 'px',
			'class'        => 'input-mini',
			'holder_class' => 'span6',
			'selector'     => $selector,
			'property'     => 'width',
			'real_time'    => true
		);

		$t[ $i ]->options[] = (object) array(
			'id'           => 'rhceyv_event_days_circle_height',
			'type'         => 'css',
			'label'        => __( 'Height', 'rhc' ),
			'input_type'   => 'number',
			'unit'         => 'px',
			'class'        => 'input-mini',
			'holder_class' => 'span6',
			'selector'     => $selector,
			'property'     => 'height',
			'real_time'    => true
		);

		$t[ $i ]->options[] =(object) array(
			'input_type' => 'grid_end'
		);

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_event_days_circle_font',
			'selector' => $selector
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhceyv_event_days_circle_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => $selector,
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		$t[ $i ]->options = $this->add_backgroud_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_event_days_circle_background',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_border_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_event_days_circle_border',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_border_radius_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_event_days_circle_border_radius',
			'selector' => $selector
		) );

		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => 'rhceyv_event_days_circle_padding',
			'selector' => $selector
		) );

		// Templates
		$i = count( $t );
		$t[ $i ] = (object) array();
		$t[ $i ]->id      = 'rh-saved-list'; 
		$t[ $i ]->label   = __( 'Templates', 'rhc' );
		$t[ $i ]->options = array( (object) array(
			'id'         => 'rh_saved_settings',
			'input_type' => 'backup_list'
		) );

		return $t;
	}
}