<?php

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

if ( ! class_exists( 'rhc_css_options' ) ) {
	require_once( RHCE_PATH . 'includes/class.rhc_css_options.php' );
}

class CSSEditorOptions extends \rhc_css_options {
	public function __construct() {
		add_filter( 'rhce_options_urls', array( $this, 'options' ) );
		add_filter( 'rhce_admin_bar_editor_access', array( $this, 'menu_links' ) );
	}

	public function options( $options ) {
		$options[] = (object) array(
			'id'            => 'rhce-year-view-url',
			'type'          => 'text',
			'label'         => __( 'Events Year View URL', 'rhceyv' ),
			'description'   => __( 'Specify the url of a page where the calendarizeit shortcode have been implemented with the rhc_year view attribute. If left blank the editor will try to determine it automatically.', 'rhceyv' ),
			'default'       => $this->get_year_view_url(),
			'el_properties' => array( 'class' => 'widefat' ),
			'save_option'   => true,
			'load_option'   => true
		);

		$options[] = (object) array(
			'type' => 'clear'
		);

		return $options;
	}

	public function menu_links( $args ) {
		global $rhc_plugin;

		$args['nodes'][] = array(
			'id'     => 'calendarize-it-year-view', 
			'title'  => __( 'Year View', 'rhceyv' ), 
			'parent' => 'calendarize-it',
			'href'   => '#',
			'meta'   => array( 'onclick' => 'javascript:jQuery(this).parent().toggleClass("hover");' ),
		);

		$url = $this->addURLParameter( $this->get_year_view_url(), 'defaultview', 'rhc_year' );

		$args['nodes'][] = array(
			'id'     => 'calendarize-it-year-view-calendar', 
			'title'  => __( 'Calendar', 'rhceyv' ),
			'parent' => 'calendarize-it-year-view',
			'href'   => $this->addURLParameter( $url, 'rhc_edit', 'rhc_year_view_calendar' )
		);

		if ( 'overlay' === $rhc_plugin->get_option( 'eyv_click_action', Defaults::$options['click_action'], true ) ) {
			$args['nodes'][] = array(
				'id'     => 'calendarize-it-year-view-overlay', 
				'title'  => __( 'Overlay', 'rhceyv' ),
				'parent' => 'calendarize-it-year-view',
				'href'   => $this->addURLParameter( $url, 'rhc_edit', 'rhc_year_view_overlay' )
			);
		}

		return $args;
	}

	private function get_year_view_url() {
		global $rhc_plugin;

		$url = $rhc_plugin->get_option( 'rhce-year-view-url', '', true );

		return $url ? $url : $this->get_calendar_url();
	}
}

return new CSSEditorOptions();