<?php
/**
 * Plugin Name: Events Year View for Calendarize it!
 * Plugin URI: http://calendarize.it/add-ons/events-year-view/
 * Description: Add a beautiful minimalistic Events Year View to Calendarize it!
 * Version: 1.0.5.82689
 * Author: Maxim Levikov (RightHere LLC)
 * Author URI: http://righthere.com/
 */

namespace RHC\EventsYearView;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

class Plugin {
	public $version = '1.0.5';
	private static $_instance;

	public static function get_instance( $args ) {
		if ( ! ( self::$_instance instanceof self ) ) {
			self::$_instance = new self( $args );
		}

		return self::$_instance;
	}

	protected function __construct( $args = array() ) {
		$this->set_arguments( $args );
		$this->define_constants();
		$this->includes();
		$this->init_hooks();

		do_action( 'rhc_events_year_view_loaded' );
	}

	private function __clone() {
	}

	private function __sleep() {
	}

	private function __wakeup() {
	}

	private function set_arguments( $args ) {
		$defaults = array(
			'addon' => true
		);

		foreach ( $defaults as $property => $default ) {
			$this->$property = isset( $args[ $property ] ) ? $args[ $property ] : $default;
		}
	}

	private function define_constants() {
		if ( defined( 'RHC_ADDON_PATH' ) && $this->addon && ! strpos( __FILE__, 'plugins' ) ) {
			$path      = trailingslashit( RHC_ADDON_PATH . dirname( $this->addon ) );
			$url       = trailingslashit( RHC_ADDON_URL . dirname( $this->addon ) );
			$languages = \plugin_righthere_calendar::get_relative_path( WP_PLUGIN_DIR, $path );
		} else {
			$path      = plugin_dir_path( __FILE__ );
			$url       = plugin_dir_url( __FILE__ );
			$languages = $path;
		}

		$this->define( 'PATH', $path );
		$this->define( 'URL', $url );
		$this->define( 'LANGUAGES', $languages . 'languages/' );
		$this->define( 'SLUG', plugin_basename( __FILE__ ) );
		$this->define( 'VERSION', $this->version );
	}

	private function define( $name, $value ) {
		if ( ! defined( $name ) ) {
			define( 'RHCEYV_' . $name, $value );
		}
	}

	private function includes() {
		$this->require_classes( $this->get_includes_classes() );

		if ( is_admin() ) {
			do_action( 'rh-php-commons' );

			$this->require_classes( $this->get_includes_classes( 'admin' ) );
		}
	}

	private function includes_css_editor() {
		global $rhc_plugin;

		if ( defined( 'RHCE_PATH' ) ) {
			if ( ! class_exists( 'module_righthere_css' ) ) {
				require_once( RHCE_PATH . 'righthere-css/class.module_righthere_css.php' );
			}

			$this->require_classes( $this->get_includes_classes( 'css-editor' ) );

			$settings = array(
				'url'                     => RHCE_URL . 'righthere-css/',
				'path'                    => RHCE_PATH . 'righthere-css/',
				'plugin_id'               => 'rhc',
				'id'                      => 'rhc',
				'capability'              => $rhc_plugin->options_capability,
				'options_varname'         => $rhc_plugin->options_varname,
				'cb_get_option'           => array( $rhc_plugin, 'get_option' ),
				'resources_path'          => 'calendarize-it',
				'trigger_var'             => 'rhc_edit',
				'detect_selector'         => '.rhcalendar.not-widget',
				'file_queue_options_name' => 'rhc_queue',
				'upload_limit_per_index'  => 20,
				'debug'                   => '1' === $rhc_plugin->get_option( 'enable_css_editor_debug', '', true ) ? true : false,
				'bootstrap_in_footer'     => '1' === $rhc_plugin->get_option( 'bootstrap_in_footer', '', true ) ? true : false,
				'bootstrap_disable'       => '1' === $rhc_plugin->get_option( 'disable_bootstrap', '', true ) ? true : false,
				'alternate_accordion'     => '1' === $rhc_plugin->get_option( 'alternate_accordion', '', true ) ? true : false
			);

			$settings['section']     = 'rhc_year_view_calendar';
			$settings['trigger_val'] = 'rhc_year_view_calendar';

			new ModuleCalendar( $settings );

			if ( 'overlay' === $rhc_plugin->get_option( 'yev_click_action', Defaults::$options['click_action'], true ) ) {
				$settings['section']     = 'rhc_year_view_overlay';
				$settings['trigger_val'] = 'rhc_year_view_overlay';

				new ModuleOverlay( $settings );
			}
		}
	}

	private function get_includes_classes( $subdirs = '' ) {
		return glob( RHCEYV_PATH . preg_replace( '~/+~', '/', 'includes/' . $subdirs . '/' ) . 'class-*.php' );
	}

	private function require_classes( $classes ) {
		if ( $classes ) {
			foreach ( $classes as $class ) {
				require_once( $class );
			}
		}
	}

	private function init_hooks() {
		add_action( 'init', array( $this, 'init' ), 0 );
	}

	public function init() {
		global $rhc_plugin;

		$this->includes_css_editor();

		do_action( 'before_rhc_events_year_view_init' );
		
		load_plugin_textdomain( 'rhceyv', false, RHCEYV_LANGUAGES );

		do_action( 'after_rhc_events_year_view_init' );
	}
}

global $rhc_events_year_view;

if ( ! $rhc_events_year_view ) {
	$rhc_events_year_view = Plugin::get_instance( array( 'addon' => $addon ) );
}