<?php

class rhcelt_events_link_to_metabox {
	var $uid = 0;
	var $post_type;
	var $debug = false;

	function __construct( $post_type = RHC_EVENTS, $debug = false ) {
		$this->debug = $debug;

		if ( ! class_exists( 'post_meta_boxes' ) )
			require_once( RHC_PATH . 'includes/class.post_meta_boxes.php' );		
		
		$this->post_type = $post_type;

		$this->post_meta_boxes = new post_meta_boxes( array(
			'post_type'           => $post_type,
			'options'             => $this->metaboxes(),
			'styles'              => array( 'rhc-admin' ),
			'scripts'             => array( 'rhc-admin' ),
			'metabox_meta_fields' => 'elt_meta_fields',
			'pluginpath'          => RHC_PATH
		));

		//elt: Events Link To
		$this->post_meta_boxes->save_fields = apply_filters( 'elt_fields', array(
			'rhcelt_events_link_onoff',
			'rhcelt_events_link_url',
		));	
	}
	
	function metaboxes( $t = array() ) {
		global $rhc_plugin;

		$i = count( $t );
		//------------------------------
		$i++;
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhcelt_events_link_to'; 
		$t[ $i ]->label         = __( 'Events Link To', 'rhcelt' );
		$t[ $i ]->theme_option  = true;
		$t[ $i ]->plugin_option = true;
		$t[ $i ]->context       = 'normal';
		$t[ $i ]->priority      = 'low';
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcelt_events_link_onoff',
			'label'	        => __( '​Redirect Event link to different URL', 'rhcelt' ),
			'type'          => 'onoff',
			'default'       => '0',
			'el_properties' => array(),
			'hidegroup'     => '#rhcelt_events_link_group_url',
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'   => 'rhcelt_events_link_group_url',
			'type' => 'div_start',
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcelt_events_link_url',
			'label'	        => __( 'Enter your custom URL below', 'rhcelt' ),
			'type'          => 'text',
			'el_properties' => array( 'class' => 'widefat' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'type' => 'div_end',
		);
		
		$t = apply_filters( 'rhcelt_metaboxes', $t );
		
		return $t;
	}		
}

?>