<?php
/*
Plugin Name: Events Link To
Plugin URI: http://calendarize.it/add-ons/calendarize-it-events-link-to/
Description: Point an Event to a URL of your choice. Lets you make an Event (custom post type) link to an external URL of your choice, instead of the default WordPress URL.
Version: 1.0.1.71548
Author: Maxim Levikov (RightHere LLC)
Author URI: http://calendarize.it/add-ons/calendarize-it-events-link-to/
*/

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Dinah!' );
}

define( 'RHCELT_VERSION', '1.0.1' );

if ( defined( 'RHC_ADDON_PATH' ) && isset( $addon ) && ! strpos( __FILE__, 'plugins' ) ) {
	// For addon version.
	define( 'RHCELT_PATH', trailingslashit( RHC_ADDON_PATH . dirname( $addon ) ) ); 
	define( 'RHCELT_URL', trailingslashit( RHC_ADDON_URL . dirname( $addon ) ) );	
} else {
	// For plugin version.
	define( 'RHCELT_PATH', plugin_dir_path( __FILE__ ) );
	define( 'RHCELT_URL', plugin_dir_url( __FILE__ ) );
}

/**
 * The core plugin class.
 */
require_once RHCELT_PATH . 'includes/class-plugin-events-link-to.php';

// Begins execution of the plugin.
$plugin_events_link_to = new Plugin_Events_Link_To();

?>