(function( $ ) {
	$( window ).load(function() {
		var $mapViewOverlay,
			timerDuration;

		$mapViewOverlay = $( '.mvc-container' );
		timerDuration = $mapViewOverlay.data( 'timer' ) * 1000;
		timerAnimationIn = $mapViewOverlay.data( 'appear' );
		timerAnimationOut = $mapViewOverlay.data( 'disappear' );

		alignMapViewCounter();
		showMapViewCounter();
		setTimeout( hideMapViewCounter, timerDuration );

		function showMapViewCounter() {
			$mapViewOverlay.addClass( timerAnimationIn + ' visible' );
		}

		function hideMapViewCounter() {
			$mapViewOverlay.removeClass( timerAnimationIn ).addClass( timerAnimationOut );
		}

		function alignMapViewCounter() {
			var height = $mapViewOverlay.outerHeight();
			$mapViewOverlay.css( 'margin-top', '-' + height / 2 + 'px' );
		}
	});

	$( document ).ready( function() {
		var $counterContainer, $tips;

		$counterContainer = $( '.rhcetc-counter-container' );
		$tips = $( '.rhc-tip-custom' );

		// Init a tooltip
		$tips.tooltipster({
			trigger: 'custom',
			offsetY: -10
		});

		 $counterContainer.hover(
		 	function() {	 	
		 		$( this ).find( '.rhc-tip-custom' ).tooltipster('show');
		 	},
		 	function() {
		 		$( this ).find( '.rhc-tip-custom' ).tooltipster('hide');
		 	}
		 );
	});
})( jQuery );