<?php
/**
 * rhcetc_options Plugin Options Class
 * 
 * @package Event_Taxnonomy_Counter
 * @subpackage Event_Taxnonomy_Counter/includes
 * @since 1.0.0
 */

class rhcetc_options {

	function rhcetc_options ( $plugin_id = 'rhc', $capability = 'manage_options', $open = false ) {
		if ( current_user_can( $capability ) ) {
			$this->id = $plugin_id;
			$this->open = $open;

			// This is to load the options in their respective tabs.
			add_filter( "pop-options_{$this->id}", array( $this, 'options' ), 9999, 1 );	
		}
	}
	
	function options( $t ) {
		global $rhc_plugin, $rhcetc_framework;

		$taxonomies_list = get_object_taxonomies( RHC_EVENTS );
		$calendar_terms = get_terms( RHC_CALENDAR );
		$venue_terms = get_terms( RHC_VENUE );
		$organizer_terms = get_terms( RHC_ORGANIZER );

		// Help
		// ------------------------------
		$i                      = count( $t );
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhcetc-help'; 
		$t[ $i ]->open          = $this->open;
		$t[ $i ]->label         = __( 'Help', 'rhcetc' );
		$t[ $i ]->right_label   = __( 'Help', 'rhcetc' );
		$t[ $i ]->page_title    = __( 'Taxonomy Counter Help', 'rhcetc' );
		$t[ $i ]->theme_option  = true;
		$t[ $i ]->priority      = 10;
		$t[ $i ]->plugin_option = true;
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'type'     => 'callback',
			'callback' => array( $this, 'rhcetc_help_tab' ),
		);

		// Dashboard Widget
		// ------------------------------
		$i                      = count( $t );
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhcetc-dashboard'; 
		$t[ $i ]->open          = $this->open;
		$t[ $i ]->label         = __( 'Dashboard Widget', 'rhcetc' );
		$t[ $i ]->right_label   = __( 'Dashboard Widget', 'rhcetc' );
		$t[ $i ]->page_title    = __( 'Dashboard Widget', 'rhcetc' );
		$t[ $i ]->theme_option  = true;
		$t[ $i ]->priority      = 10;
		$t[ $i ]->plugin_option = true;
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Widget Settings', 'rhcetc' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcetc-dashboard-widget-title',
			'type'          => 'text',
			'label'         => __( 'Title', 'rhcetc' ),
			'el_properties' => array( 'class' => 'widefat' ),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcetc-d_widget-icons',
			'label'         => __( 'Icons', 'rhcetc' ),
			'default'       => '0',
			'type'          => 'onoff',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Visible in Widget', 'rhcetc' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcetc-dashboard-widget-' . RHC_EVENTS . '-onoff',
			'label'         => __( 'Events', 'rhcetc' ),
			'default'       => '1',
			'type'          => 'onoff',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		if ( $taxonomies_list ) {
			foreach ( $taxonomies_list as $taxonomy_name ) {
				$taxonomy = get_taxonomy( $taxonomy_name );

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcetc-dashboard-widget-' . $taxonomy_name . '-onoff',
					'label'         => $taxonomy->labels->name,
					'default'       => '1',
					'type'          => 'onoff',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);
			}
		}

		$t[ $i ]->options[] = (object) array(
			'type' => 'clear',
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'submit',
			'label' => __( 'Save', 'rhcs' ),
			'class' => 'button-primary'
		);

		// Map View Counter
		// ------------------------------
		$i                      = count( $t );
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhcmvc-mapview'; 
		$t[ $i ]->open          = $this->open;
		$t[ $i ]->label         = __( 'Map View Counter', 'rhcetc' );
		$t[ $i ]->right_label   = __( 'Map View Counter', 'rhcetc' );
		$t[ $i ]->page_title    = __( 'Map View Counter', 'rhcetc' );
		$t[ $i ]->theme_option  = true;
		$t[ $i ]->priority      = 10;
		$t[ $i ]->plugin_option = true;
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Timer', 'rhcetc' ),
		);

		$t[$i]->options[] = (object) array(
			'id'          => 'rhcmvc-timer-duration',
			'type'        => 'range',
			'label'       => __( 'Duration', 'rhcetc' ),
			'description' => __( 'Set the duration in seconds of the Event Map Counter before it disappears.', 'rhcetc' ),
			'min'         => 0,
			'max'         => 120,
			'step'        => 1,
			'default'     => 15,
			'save_option' => true,
			'load_option' => true,
		);

		$t[ $i ]->options[] = (object) array(
			'type' => 'clear',
		);

		$t[ $i ]->options[] = (object) array(
			'type'        => 'subtitle',
			'label'       => __( 'Animation', 'rhcetc' ),
		);

		$t[$i]->options[] = (object) array(
			'id'          => 'rhcmvc-timer-animation-in',
			'label'       => __( 'Appear', 'rhcetc' ),
			'type'        => 'select',
			'options'     => array(
				'rhcetc-bounce' => 'bounce',
				'rhcetc-flash' => 'flash',
				'rhcetc-pulse' => 'pulse',
				'rhcetc-rubberBand' => 'rubberBand',
				'rhcetc-shake' => 'shake',
				'rhcetc-headShake' => 'headShake',
				'rhcetc-swing' => 'swing',
				'rhcetc-tada' => 'tada',
				'rhcetc-wobble' => 'wobble',
				'rhcetc-jello' => 'jello',
				'rhcetc-bounceIn' => 'bounceIn',
				'rhcetc-bounceInDown' => 'bounceInDown',
				'rhcetc-bounceInLeft' => 'bounceInLeft',
				'rhcetc-bounceInRight' => 'bounceInRight',
				'rhcetc-bounceInUp' => 'bounceInUp',
				'rhcetc-fadeIn' => 'fadeIn',
				'rhcetc-fadeInDown' => 'fadeInDown',
				'rhcetc-fadeInDownBig' => 'fadeInDownBig',
				'rhcetc-fadeInLeft' => 'fadeInLeft',
				'rhcetc-fadeInLeftBig' => 'fadeInLeftBig',
				'rhcetc-fadeInRight' => 'fadeInRight',
				'rhcetc-fadeInRightBig' => 'fadeInRightBig',
				'rhcetc-fadeInUp' => 'fadeInUp',
				'rhcetc-fadeInUpBig' => 'fadeInUpBig',
				'rhcetc-flipInX' => 'flipInX',
				'rhcetc-flipInY' => 'flipInY',
				'rhcetc-lightSpeedIn' => 'lightSpeedIn',
				'rhcetc-rotateIn' => 'rotateIn',
				'rhcetc-rotateInDownLeft' => 'rotateInDownLeft',
				'rhcetc-rotateInDownRight' => 'rotateInDownRight',
				'rhcetc-rotateInUpLeft' => 'rotateInUpLeft',
				'rhcetc-rotateInUpRight' => 'rotateInUpRight',
				'rhcetc-rollIn' => 'rollIn',
				'rhcetc-zoomIn' => 'zoomIn',
				'rhcetc-zoomInDown' => 'zoomInDown',
				'rhcetc-zoomInLeft' => 'zoomInLeft',
				'rhcetc-zoomInRight' => 'zoomInRight',
				'rhcetc-zoomInUp' => 'zoomInUp',
				'rhcetc-slideInDown' => 'slideInDown',
				'rhcetc-slideInLeft' => 'slideInLeft',
				'rhcetc-slideInRight' => 'slideInRight',
				'rhcetc-slideInUp' => 'slideInUp',
				),
			'default'     => 'rhcetc-fadeIn',
			'save_option' => true,
			'load_option' => true,
		);

		$t[$i]->options[] = (object) array(
			'id'          => 'rhcmvc-timer-animation-out',
			'label'       => __( 'Disappear', 'rhcetc' ),
			'type'        => 'select',
			'options'     => array(
				'rhcetc-bounceOut' => 'bounceOut',
				'rhcetc-bounceOutDown' => 'bounceOutDown',
				'rhcetc-bounceOutLeft' => 'bounceOutLeft',
				'rhcetc-bounceOutRight' => 'bounceOutRight',
				'rhcetc-bounceOutUp' => 'bounceOutUp',
				'rhcetc-fadeOut' => 'fadeOut',
				'rhcetc-fadeOutDown' => 'fadeOutDown',
				'rhcetc-fadeOutDownBig' => 'fadeOutDownBig',
				'rhcetc-fadeOutLeft' => 'fadeOutLeft',
				'rhcetc-fadeOutLeftBig' => 'fadeOutLeftBig',
				'rhcetc-fadeOutRight' => 'fadeOutRight',
				'rhcetc-fadeOutRightBig' => 'fadeOutRightBig',
				'rhcetc-fadeOutUp' => 'fadeOutUp',
				'rhcetc-fadeOutUpBig' => 'fadeOutUpBig',
				'rhcetc-flipOutX' => 'flipOutX',
				'rhcetc-flipOutY' => 'flipOutY',
				'rhcetc-lightSpeedOut' => 'lightSpeedOut',
				'rhcetc-rotateOut' => 'rotateOut',
				'rhcetc-rotateOutDownLeft' => 'rotateOutDownLeft',
				'rhcetc-rotateOutDownRight' => 'rotateOutDownRight',
				'rhcetc-rotateOutUpLeft' => 'rotateOutUpLeft',
				'rhcetc-rotateOutUpRight' => 'rotateOutUpRight',
				'rhcetc-hinge' => 'hinge',
				'rhcetc-rollOut' => 'rollOut',
				'rhcetc-zoomOut' => 'zoomOut',
				'rhcetc-zoomOutDown' => 'zoomOutDown',
				'rhcetc-zoomOutLeft' => 'zoomOutLeft',
				'rhcetc-zoomOutRight' => 'zoomOutRight',
				'rhcetc-zoomOutUp' => 'zoomOutUp',
				'rhcetc-slideOutDown' => 'slideOutDown',
				'rhcetc-slideOutLeft' => 'slideOutLeft',
				'rhcetc-slideOutRight' => 'slideOutRight',
				'rhcetc-slideOutUp' => 'slideOutUp',
				),
			'default'     => 'rhcetc-fadeOut',
			'save_option' => true,
			'load_option' => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcmvc-disappear-disable',
			'label'         => __( 'Disappear Effect', 'rhcetc' ),
			'description'   => __( 'When styling the Map View Counter it is helpful to turn off the disappear effect', 'rhcetc' ),
			'default'       => '0',
			'type'          => 'onoff',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'type' => 'clear',
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Mobile', 'rhcetc' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcmvc-mobile-display',
			'label'         => __( 'Show on mobile devices', 'rhcetc' ),
			'default'       => '1',
			'type'          => 'onoff',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'callback',
			'callback' => array( $this, 'mvc_help_box' ),
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'submit',
			'label' => __( 'Save', 'rhcs' ),
			'class' => 'button-primary'
		);

		// Organizer Terms
		// ------------------------------
		if ( $organizer_terms ) {
			$i                      = count( $t );
			$t[ $i ]                = (object) array();
			$t[ $i ]->id            = 'rhcotc-organizer'; 
			$t[ $i ]->open          = $this->open;
			$t[ $i ]->label         = __( 'Organizer Terms', 'rhcetc' );
			$t[ $i ]->right_label   = __( 'Organizer Terms', 'rhcetc' );
			$t[ $i ]->page_title    = __( 'Organizer Terms', 'rhcetc' );
			$t[ $i ]->theme_option  = true;
			$t[ $i ]->priority      = 10;
			$t[ $i ]->plugin_option = true;
			$t[ $i ]->options       = array();

			foreach ( $organizer_terms as $term ) {
				$t[ $i ]->options[] = (object) array(
					'type'  => 'subtitle',
					'label' => $term->name,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcotc-' . $term->slug . '-color',
					'label'         => __( 'Background color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcotc-' . $term->slug . '-text-color',
					'label'         => __( 'Text color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				// $t[ $i ]->options[] = (object) array(
				// 	'id'            => 'rhcotc-' . $term->slug . '-onoff',
				// 	'label'         => __( 'Visible in Widget', 'rhcetc' ),
				// 	'default'		=> '1',
				// 	'type'			=> 'onoff',
				// 	'el_properties'	=> array(),
				// 	'save_option'	=> true,
				// 	'load_option'	=> true,
				// );

				$t[ $i ]->options[] = (object) array(
					'type' => 'clear',
				);
			}

			$t[ $i ]->options[] = (object) array(
				'type' => 'clear',
			);

			$t[ $i ]->options[] = (object) array(
				'type'  => 'submit',
				'label' => __( 'Save', 'rhcs' ),
				'class' => 'button-primary'
			);
		}

		// Venue Terms
		// ------------------------------
		if ( $venue_terms ) {
			$i                      = count( $t );
			$t[ $i ]                = (object) array();
			$t[ $i ]->id            = 'rhcvtc-venue'; 
			$t[ $i ]->open          = $this->open;
			$t[ $i ]->label         = __( 'Venue Terms', 'rhcetc' );
			$t[ $i ]->right_label   = __( 'Venue Terms', 'rhcetc' );
			$t[ $i ]->page_title    = __( 'Venue Terms', 'rhcetc' );
			$t[ $i ]->theme_option  = true;
			$t[ $i ]->priority      = 10;
			$t[ $i ]->plugin_option = true;
			$t[ $i ]->options       = array();

			foreach ( $venue_terms as $term ) {
				$t[ $i ]->options[] = (object) array(
					'type'  => 'subtitle',
					'label' => $term->name,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcvtc-' . $term->slug . '-color',
					'label'         => __( 'Background color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcvtc-' . $term->slug . '-text-color',
					'label'         => __( 'Text color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				// $t[ $i ]->options[] = (object) array(
				// 	'id'            => 'rhcvtc-' . $term->slug . '-onoff',
				// 	'label'         => __( 'Visible in Widget', 'rhcetc' ),
				// 	'default'		=> '1',
				// 	'type'			=> 'onoff',
				// 	'el_properties'	=> array(),
				// 	'save_option'	=> true,
				// 	'load_option'	=> true,
				// );

				$t[ $i ]->options[] = (object) array(
					'type' => 'clear',
				);
			}

			$t[ $i ]->options[] = (object) array(
				'type' => 'clear',
			);

			$t[ $i ]->options[] = (object) array(
				'type'  => 'submit',
				'label' => __( 'Save', 'rhcs' ),
				'class' => 'button-primary'
			);
		}

		// Calendar Terms
		// ------------------------------
		if ( $calendar_terms ) {
			$i                      = count( $t );
			$t[ $i ]                = (object) array();
			$t[ $i ]->id            = 'rhcctc-calendar'; 
			$t[ $i ]->open          = $this->open;
			$t[ $i ]->label         = __( 'Calendar Terms', 'rhcetc' );
			$t[ $i ]->right_label   = __( 'Calendar Terms', 'rhcetc' );
			$t[ $i ]->page_title    = __( 'Calendar Terms', 'rhcetc' );
			$t[ $i ]->theme_option  = true;
			$t[ $i ]->priority      = 10;
			$t[ $i ]->plugin_option = true;
			$t[ $i ]->options       = array();

			$t[ $i ]->options[] = (object) array(
				'type'        => 'subtitle',
				'description' => __( 'Set the visibility of the Term by switching it ON or OFF. If it is switched ON it will show in the widget by default.<br><br><b>Notice:</b> If you want to insert multiple versions of the widgets turn OFF the terms, and then control the visibility of each term directly in the widget.', 'rhcetc' ),
			);

			foreach ( $calendar_terms as $term ) {
				$t[ $i ]->options[] = (object) array(
					'type'  => 'subtitle',
					'label' => $term->name,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcctc-' . $term->slug . '-color',
					'label'         => __( 'Background color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcctc-' . $term->slug . '-text-color',
					'label'         => __( 'Text color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcctc-' . $term->slug . '-onoff',
					'label'         => __( 'Visible in Widget', 'rhcetc' ),
					'default'		=> '1',
					'type'			=> 'onoff',
					'el_properties'	=> array(),
					'save_option'	=> true,
					'load_option'	=> true,
				);

				$t[ $i ]->options[] = (object) array(
					'type' => 'clear',
				);
			}

			$t[ $i ]->options[] = (object) array(
				'type' => 'clear',
			);

			$t[ $i ]->options[] = (object) array(
				'type'  => 'submit',
				'label' => __( 'Save', 'rhcs' ),
				'class' => 'button-primary'
			);
		}

		// All Taxonomies
		// ------------------------------
		$i                      = count( $t );
		$t[ $i ]                = (object) array();
		$t[ $i ]->id            = 'rhcetc-taxonomies'; 
		$t[ $i ]->open          = $this->open;
		$t[ $i ]->label         = __( 'All Taxonomies', 'rhcetc' );
		$t[ $i ]->right_label   = __( 'All Taxonomies', 'rhcetc' );
		$t[ $i ]->page_title    = __( 'All Taxonomies', 'rhcetc' );
		$t[ $i ]->theme_option  = true;
		$t[ $i ]->priority      = 9;
		$t[ $i ]->plugin_option = true;
		$t[ $i ]->options       = array();

		$t[ $i ]->options[] = (object) array(
			'type'  => 'subtitle',
			'label' => __( 'Events', 'rhcetc' ),
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcetc-' . RHC_EVENTS . '-color',
			'label'         => __( 'Background color', 'rhcetc' ),
			'type'          => 'farbtastic',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcetc-' . RHC_EVENTS . '-text-color',
			'label'         => __( 'Text color', 'rhcetc'),
			'type'          => 'farbtastic',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcetc-' . RHC_EVENTS . '-icon',
			'label'			=> __( 'Icon', 'rhcetc' ),
			'default'       => '1',
			'type'          => 'onoff',
			'hidegroup'     => '#rhcetc-' . RHC_EVENTS . 'icon-group',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] =	(object) array(
			'id'   => 'rhcetc-' . RHC_EVENTS . 'icon-group',
			'type' => 'div_start',
		);

		$t[ $i ]->options[] = (object) array(
			'id'            => 'rhcetc-' . RHC_EVENTS . '-icon-color',
			'label'         => __( 'Icon color', 'rhcetc' ),
			'type'          => 'farbtastic',
			'el_properties' => array(),
			'save_option'   => true,
			'load_option'   => true,
		);

		$t[ $i ]->options[] = (object) array(
			'type' => 'div_end'
		);

		if ( $taxonomies_list ) {
			foreach ( $taxonomies_list as $taxonomy_name ) {
				$taxonomy = get_taxonomy( $taxonomy_name );
				$iconed = $rhcetc_framework->get_taxonomies_with_icons();

				$t[ $i ]->options[] = (object) array(
					'type'  => 'subtitle',
					'label' => $taxonomy->labels->name,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcetc-' . $taxonomy_name . '-color',
					'label'         => __( 'Background color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				$t[ $i ]->options[] = (object) array(
					'id'            => 'rhcetc-' . $taxonomy_name . '-text-color',
					'label'         => __( 'Text color', 'rhcetc' ),
					'type'          => 'farbtastic',
					'el_properties' => array(),
					'save_option'   => true,
					'load_option'   => true,
				);

				if ( in_array( $taxonomy_name, $iconed ) ) {
					$t[ $i ]->options[] = (object) array(
						'id'            => 'rhcetc-' . $taxonomy_name . '-icon',
						'label'         => __( 'Icon', 'rhcetc' ),
						'default'       => '0',
						'type'          => 'onoff',
						'hidegroup'     => '#rhcetc-' . $taxonomy_name . 'icon-group',
						'el_properties' => array(),
						'save_option'   => true,
						'load_option'   => true,
					);

					$t[ $i ]->options[] =	(object) array(
						'id'   => 'rhcetc-' . $taxonomy_name . 'icon-group',
						'type' => 'div_start',
					);

					$t[ $i ]->options[] = (object) array(
						'id'            => 'rhcetc-' . $taxonomy_name . '-icon-color',
						'label'         => __( 'Icon color', 'rhcetc' ),
						'type'          => 'farbtastic',
						'el_properties' => array(),
						'save_option'   => true,
						'load_option'   => true,
					);

					$t[ $i ]->options[] = (object) array(
						'type' => 'div_end'
					);
				}
			}
		}

		$t[ $i ]->options[] = (object) array(
			'type' => 'clear',
		);

		$t[ $i ]->options[] = (object) array(
			'type'  => 'submit',
			'label' => __( 'Save', 'rhcs' ),
			'class' => 'button-primary'
		);

		return $t;
	}

	function rhcetc_help_tab() {
		$message = __( 'For detailed information on how to use the Taxonomy Counter, please visit our knowledge base at the <a href="https://righthere.zendesk.com/">Help Center</a>.<br><br>', 'rhcetc' );

		return $message;
	}
}

?>