<?php
/**
 * rhcetc_framework Plugin Framework Class
 * 
 * @package Event_Taxnonomy_Counter
 * @subpackage Event_Taxnonomy_Counter/includes
 * @since 1.0.3
 */

class rhcetc_framework {
	function get_featured_content_html( $label, $name = '', $icon = '' ) {
		global $rhc_plugin;

		$iconed = $this->get_taxonomies_with_icons();

		if ( in_array( $name, $iconed ) ) {
			$icon = $rhc_plugin->get_option( 'rhcetc-' . $name . '-icon' );
		}

		if ( $icon && in_array( $name, $iconed ) ) {
			$html = '<div class="icon"><i class="icon-' . $name . '"></i></div>';
		} else {
			$html = '<div class="label">' . $label . '</div>';
		}

		return $html;
	}

	function get_counter_container_html( $content, $counter, $modifier, $title = '', $class = 'taxonomy-counter-container' ) {
		$has_icon = preg_match( '/(class=).+(icon)/', $content );

		if ( ! empty( $has_icon ) ) {
			$tooltip_title = 'title="' . $title . '"';
			$tooltip_class = 'rhc-tip-custom';
		} else {
			$tooltip_title = '';
			$tooltip_class = '';
		}

		$container_content = ''; 
		$container_content .= sprintf( '<div %s class="featured column %s">%s</div>', $tooltip_title, $tooltip_class, $content );
		$container_content .= sprintf( '<div class="number column">%s</div>', $counter );
		
		return sprintf( '<div class="rhcetc-counter-container %s %s">%s</div>', $class, $modifier, $container_content );
	}

	function get_counter_box_html( $content, $wrapper, $modifier ) {
		$counter_box = '<div class="rhcetc-counter-box fe-extrainfo-container ' . $modifier . '">' . $content . '</div>';
		$html = '<div class="' . $wrapper . '">' . $counter_box . '</div>';

		return $html;
	}

	function count_terms_relation( $rhc_taxonomy, $rhc_term, $taxonomy, $term ) {
		$posts = get_posts( array(
			'post_type'      => RHC_EVENTS,
			'posts_per_page' => -1,
			'tax_query' => array(
				'relation' => 'AND',
				array(
					'taxonomy' => $rhc_taxonomy,
					'field'    => 'slug',
					'terms'    => $rhc_term,
				),
				array(
					'taxonomy' => $taxonomy,
					'field'    => 'slug',
					'terms'    => $term,
				)
			)
		));

		wp_reset_postdata();
		$terms_count = count( $posts );

		return $terms_count;
	}

	function get_featured_content_label( $object, $counter ) {
		$object_label = ( $counter > 1 ) ? $object->labels->name : $object->labels->singular_name;

		return $object_label;
	}

	function get_taxonomy_prefix( $taxonomy ) {
		switch ( $taxonomy ) {
			case 'calendar' :
				$prefix = 'ctc';
				break;
			case 'venue' :
				$prefix = 'vtc';
				break;
			case 'organizer' :
				$prefix = 'otc';
				break;
			default:
				return;
		}

		return $prefix;
	}

	function get_taxonomies_with_icons() {
		return array( 'events', 'calendar', 'organizer', 'state', 'country', 'city', 'venue', 'ticket_type', 'ticket_topic' );
	}
}

?>