<?php
/**
 * Event_Taxonomy_Counter_Widget class, extended for creating widgets
 *
 * @package Event_Taxnonomy_Counter
 * @subpackage Event_Taxnonomy_Counter/includes
 * @since 1.0.0
 */
class Event_Taxonomy_Counter_Widget extends WP_Widget {
	/**
	 * Sets up the widget name.
	 *
	 * @since 1.0.0
	 */
	public function __construct()
	{
		parent::__construct(
			'event-taxonomy-counter',
			__( 'Calendarize it! Counter', 'rhcetc' ),
			array( 'description' => __( 'Event Taxonomy Counter', 'rhcetc' ) )
		);
	}

	/**
	 * Outputs the content of the widget.
	 *
	 * @since 1.0.0
	 * 
	 * @see WP_Widget::widget()
 	 *
	 * @param array $args Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance )
	{
		global $rhc_plugin, $rhcetc_framework;

		$html = '';
		$content = '';

		//--- post type
		$posts_count = wp_count_posts( RHC_EVENTS );

		if ( ! empty( $instance[ RHC_EVENTS ] ) && $posts_count->publish ) {
			$post_type_obj = get_post_type_object( RHC_EVENTS );
			$post_type_label = $rhcetc_framework->get_featured_content_label( $post_type_obj, $posts_count->publish );
			$has_icon = (int) $rhc_plugin->get_option( 'rhcetc-' . RHC_EVENTS . '-icon', '0', true );

			$featured_content = $rhcetc_framework->get_featured_content_html( $post_type_label, RHC_EVENTS, $has_icon );

			$title_attr = sprintf( __( '%s', 'rhcetc' ) , $post_type_label );
			$content .= $rhcetc_framework->get_counter_container_html( $featured_content, $posts_count->publish, RHC_EVENTS, $title_attr );
		}

		//--- taxonomies
		$taxonomies_list = get_object_taxonomies( RHC_EVENTS );

		if ( is_array( $taxonomies_list ) && count( $taxonomies_list ) > 0 ) {
			foreach ( $taxonomies_list as $taxonomy_name ) {
				$terms_count = (int) wp_count_terms( $taxonomy_name );

				if ( ! empty( $instance[ $taxonomy_name ] ) && $terms_count > 0 ) {
					$taxonomy_obj = get_taxonomy( $taxonomy_name );
					$taxonomy_label = $rhcetc_framework->get_featured_content_label( $taxonomy_obj, $terms_count );
					$has_icon = (int) $rhc_plugin->get_option( 'rhcetc-' . $taxonomy_name . '-icon', '0', true );

					$featured_content = $rhcetc_framework->get_featured_content_html( $taxonomy_label, $taxonomy_name, $has_icon );

					$title_attr = sprintf( __( '%s', 'rhcetc' ) , $taxonomy_label );
					$content .= $rhcetc_framework->get_counter_container_html( $featured_content, $terms_count, $taxonomy_name, $title_attr );
				}
			}
		}

		//--- widget html
		$html .= $args['before_widget'];
		$html .= $args['before_title'] . $instance['title'] . $args['after_title'];
		$html .= $rhcetc_framework->get_counter_box_html( $content, 'widget_event-taxonomy-counter', 'etc-counter' );
		$html .= $args['after_widget'];

		//--- styles
		if ( ! did_action( 'event_taxonomy_styles' ) ) {	
			do_action( 'event_taxonomy_styles' );
		}

		//--- widget output
		wp_enqueue_style( 'tooltipster' );
		wp_enqueue_style( 'rhc-etc-style' );

		wp_enqueue_script( 'tooltipster' );
		wp_enqueue_script( 'rhc-etc-script' );

		echo $html;
	}

	/**
	 * Back-end widget form.
	 *
	 * @since 1.0.0
	 * 
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance )
	{
		$form_html = '';
		$taxonomies = array();
		$title = ( isset( $instance['title'] ) ) ? strip_tags( $instance['title'] ) : '';
		$events = ( isset( $instance[ RHC_EVENTS ] ) ) ? 'checked="checked"' : '';
		$taxonomies_list = get_object_taxonomies( RHC_EVENTS );

		$form_html .= '<p>';
		$form_html .= '<label for="' . $this->get_field_id( 'title' ) . '">' . __( 'Title:', 'rhcetc' ) . '</label>';
		$form_html .= '<input class="widefat" id="' . $this->get_field_id( 'title' ) . '" name="' . $this->get_field_name( 'title' ) . '" type="text" value="' . esc_attr( $title ) . '">';
		$form_html .= '</p>';

		$form_html .= '<p>';
		$form_html .= '<input class="checkbox" type="checkbox"' . $events . ' id="' . $this->get_field_id( RHC_EVENTS ) . '" name="' . $this->get_field_name( RHC_EVENTS ) . '">';
		$form_html .= '<label for="' . $this->get_field_id( RHC_EVENTS ) . '">' . ucfirst( RHC_EVENTS ) . '</label><br>';

		foreach ( $taxonomies_list as $taxonomy ) {
			$taxonomy_obj = get_taxonomy( $taxonomy );
			$taxonomies[ $taxonomy ] = ( ! empty( $instance[ $taxonomy ] ) ) ? 'checked="checked"' : '';

			$form_html .= '<input class="checkbox" type="checkbox"' . $taxonomies[ $taxonomy ] . ' id="' . $this->get_field_id( $taxonomy ) . '" name="' . $this->get_field_name( $taxonomy ) . '">';
			$form_html .= '<label for="' . $this->get_field_id( $taxonomy ) . '">' . $taxonomy_obj->labels->name . '</label><br>';
		}

		$form_html .= '</p>';
		
		echo $form_html;
	}

	/**
	 * Sanitize widget form values as they are saved.
	 * 
	 * @since 1.0.0
	 * 
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance )
	{
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$taxonomies_list = get_object_taxonomies( RHC_EVENTS );
		$instance[ RHC_EVENTS ] = ( $new_instance[ RHC_EVENTS ] ) ? 1 : 0;
		
		foreach ( $taxonomies_list as $taxonomy ) {
			$instance[ $taxonomy ] = $new_instance[ $taxonomy ] ? 1 : 0;
		}

		return $instance;
	}
}

?>