<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rhg_shortcodes {
	var $id=0;
	function __construct(){
		add_shortcode('google_grid_gallery', array(&$this,'handle_grid_gallery'));
		add_shortcode('poster_grid_gallery', array(&$this,'handle_grid_gallery'));
		add_filter('grid_gallery_image', array(&$this,'filter_grid_gallery_image'), 10, 3);
		add_filter('default_grid_gallery', array(&$this,'default_grid_gallery'), 10, 1 );
	}
	
	function filter_grid_gallery_image( $out='', $post_ID=0, $size='full'){		
		$post_ID = ( 0==$post_ID ) ? get_the_ID() : $post_ID ;
		$out = get_the_post_thumbnail( $post_ID, $size ) ;
		return  $out;
	}
	
	function default_grid_gallery( $default ){
		global $rhg_plugin;
		foreach($default as $field => $value){
			$default[$field]=$rhg_plugin->get_option( 'grid_gallery_'.$field, $value, true);
		}	
		return $default;
	}	
	
	function handle_grid_gallery($atts,$content=null,$code=""){
		$this->id++;
		
		$default = apply_filters('default_grid_gallery', array(
			'class'				=> '',
			'taxonomy'			=> '',
			'term'				=> '',
			'post_type'			=> '',
			'numberposts'		=> '9',
			'label_empty'		=> __('There are no items in gallery.','rhg'),
			'animonscroll'		=> 'effect-2',
			'autoload'			=> '1',
			'link_target'		=> '_blank',
			'classes'			=> '',
			'direct_link'		=> '0'
		));
	
		extract(shortcode_atts($default, $atts));
		
		if( is_string($classes) ){
			$classes =  ''==trim($classes) ? array() : explode(',', str_replace(' ','',$classes));
		}
		
		if(count($classes)>0){
			$tmp = array();
			foreach($classes as $value){
				if(empty($value))continue;
				$tmp[]=$value;
			}
			$classes = $tmp;
		}
		
		$settings = (object)array(
			'numberposts'	=> $numberposts,
			'source' 		=> '',
			'autoload'		=> ('1'==$autoload),
			'classes'		=> $classes,
			'link_target'	=> $link_target,
			'direct_link'	=> intval($direct_link)
		);

		if( isset($atts['post_type']) && ( !isset($atts['taxonomy']) || empty( $atts['taxonomy'] ) ) ){
			$taxonomy = '';
		}
		
		if( empty($taxonomy) && empty($post_type) ){
			$post_type = 'post';
		}
		
		if(!empty($taxonomy) && !empty($term)){	
			$term_link = get_term_link( $term, $taxonomy );
			if( is_wp_error($term_link) ){
				return $label_empty;
			}
			$settings->source = $this->add_url_parameter( $term_link, 'rhg', '1' );
		}else if(!empty($post_type)){
	
			if( $post_type_link = get_post_type_archive_link( $post_type ) ){
				$settings->source = $this->add_url_parameter( $post_type_link, 'rhg', '1' );
			}else{
				$settings->source = $this->add_url_parameter( site_url("?post_type=$post_type"), 'rhg', '1' );	
			}
		}
		
		if(isset($_REQUEST['rhg_debug'])){
			echo "<pre>";
			print_r($atts);
			print_r($settings);
			echo "</pre>";
		}
		
		return sprintf('<div class="rh_grid rhg-default grid-gallery %s" data-options="%s">%s%s</div>',
			$class,
			htmlspecialchars($this->get_grid_gallery_args($settings,$atts)),
			$this->get_grid_html((object)array(
				'animonscroll'=>$animonscroll
			)),
			$this->get_slideshow_html()
		);
	}
	
	function get_grid_html($settings){
		return sprintf(
			'<section class="grid-wrap"><ul id="rhg_grid_%s" class="rhg_grid %s"><li class="grid-sizer"></li></ul></section>',
			$this->id,
			$settings->animonscroll
		);
	}
	
	function get_slideshow_html(){
		ob_start();
?>
<section class="rhg_slideshow slideshow">
	<ul class="rhg_slideshow_items"></ul>
	<nav>
		<span class="icon rhg-nav-prev"></span>
		<span class="icon rhg-nav-next"></span>
		<span class="icon rhg-nav-close"></span>
	</nav>	
</section>
<?php
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
	}
	
	function get_grid_gallery_args($options,$atts){
		$options = apply_filters('get_grid_gallery_args_options',$options,$atts);
		$out = json_encode($options); 
		$out = apply_filters('get_grid_gallery_args_output',$out);
		/*
		foreach(array('fc_select','fc_click','no_link','fc_mouseover') as $method_name){
			$out = str_replace('"'.$method_name.'"',$method_name,$out);
		}
		*/
		return $out;
	}	
	
	function add_url_parameter($url, $paramName, $paramValue) {
	     $url_data = parse_url($url);
	     if(!isset($url_data["query"])){
		 	$url_data["query"]="";
		 }
	     $params = array();
	     parse_str($url_data['query'], $params);
	     $params[$paramName] = $paramValue;
	     $url_data['query'] = http_build_query($params);
	     return $this->build_url($url_data);
	}
		
	function build_url($url_data) {
	    $url="";
	    if(isset($url_data['host']))
	    {
	        $url .= $url_data['scheme'] . '://';
	        if (isset($url_data['user'])) {
	            $url .= $url_data['user'];
	                if (isset($url_data['pass'])) {
	                    $url .= ':' . $url_data['pass'];
	                }
	            $url .= '@';
	        }
	        $url .= $url_data['host'];
	        if (isset($url_data['port'])) {
	            $url .= ':' . $url_data['port'];
	        }
	    }
	    $url .= $url_data['path'];
	    if (isset($url_data['query'])) {
	        $url .= '?' . $url_data['query'];
	    }
	    if (isset($url_data['fragment'])) {
	        $url .= '#' . $url_data['fragment'];
	    }
	    return $url;
	}	
}
?>