<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rhg_options {
	function __construct( $plugin_id='rhg' ){
		$this->id = $plugin_id;
		add_filter("pop-options_{$this->id}",array(&$this,'options'),10,1);		
	}
	
	function options( $t ){
		//-------------------------	
		$i = count($t);
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhg-grid-gallery'; 
		$t[$i]->label 		= __('Grid Gallery Shortcode','rhg');
		$t[$i]->right_label	= __('Default settings','rhg');
		$t[$i]->page_title	= __('Grid gallery shortcode default settings','rhg');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->options = array();		

		$t[$i]->options[] =	(object)array(
				'id'		=> 'grid_gallery_shortcode',
				'label'		=> __('Taxonomy','rhg'),
				'type'		=> 'callback',
				'callback'	=> array(&$this,'pop_show_grid_gallery_sc'),
				'description' => __('Insert this shortcode [poster_grid_gallery] to render the grid gallery using the options on this tab.  Observe that either taxonomy/term pair, or post_type is required.  If none are specified, the grid gallery will not render.','rhg'),
				'save_option'=>false,
				'load_option'=>false
			);		
		
		$taxonomies = get_taxonomies( array(
		  'public'   => true
		), 'objects' );

		$taxonomy_options = array();
		$term_options = array();

		if( is_array($taxonomies) && count($taxonomies) > 0 ){
			$taxonomy_options = array( ''=> __('--choose--','rhg') );
			$term_options['']= (object)array(
				'label' 	=> __('--choose--','rhg'),
				'meta_key'	=> 'parent',
				'meta_value'=> ''
			);		
		
			$taxonomy_slugs = array_keys($taxonomies);
			
			$terms = get_terms( $taxonomy_slugs, array('hide_empty'=>false) );

			foreach($taxonomies as $taxonomy => $tax){
				$taxonomy_options[$taxonomy] = $tax->labels->name;
			}
			
			foreach($terms as $term){
				$term_options[ $term->slug ]= (object)array(
					'label' 	=> ( isset( $_REQUEST['rhg_debug'] ) ? sprintf("%s (%s)",$term->name, $term->taxonomy) : $term->name ),
					'meta_key'	=> 'parent',
					'meta_value'=> $term->taxonomy
				);
			}
		}else{
			$taxonomy_options = array( ''=> __('--no options--','rhg') );
			$term_options['']= (object)array(
				'label' 	=> __('--no options--','rhg'),
				'meta_key'	=> 'parent',
				'meta_value'=> ''
			);
		}
		
		$t[$i]->options[] =	(object)array(
				'id'			=> 'grid_gallery_taxonomy',
				'label'			=> __('Taxonomy','rhg'),
				'type'			=> 'select_parent',
				'child'			=> '#grid_gallery_term',
				'options'		=> $taxonomy_options,
				'default'		=> '',
				'description'	=> sprintf("<p>%s</p><p>%s</p>",
					__('Use taxonomy/term or post type.  If both are set, Taxonomy/term will be used.','rhg'),
					sprintf('<b>%s</b> taxonomy, term, post_type', __('Shortcode arguments:','rhg'))
				),				
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);
		
		$t[$i]->options[] =	(object)array(
				'id'		=> 'grid_gallery_term',
				'label'		=> __('Term','rhg'),
				'type'		=> 'select',
				'options'	=> $term_options,
				'default'	=> '',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);
		
		$post_types = get_post_types( array(
		   'public'   => true,
		   'publicly_queryable' => true
		), 'objects' ); 
		
		$post_type_options = array();
		if( is_array($post_types) && count($post_types)>0){
			$post_type_options = array( ''=> __('--choose--','rhg') );
			foreach( $post_types as $post_type => $p ){
				$post_type_options[$post_type] = $p->labels->name;
			}
		}else{
			$post_type_options = array( ''=> __('--no options--','rhg') );
		}

		$t[$i]->options[] =	(object)array(
				'id'		=> 'grid_gallery_post_type',
				'label'		=> __('Post type','rhg'),
				'type'		=> 'select',
				'options'	=> $post_type_options,
				'default'	=> '',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);
		
		$t[$i]->options[]=(object)array(
				'id'	=> 'grid_gallery_numberposts',
				'type'	=> 'range',
				'label'	=> __('Items per load','rhg'),	
				'description'	=> sprintf("<p>%s</p><p>%s</p>",
					__('Determines the number of items loaded per ajax call','rhg'),
					sprintf('<b>%s</b> numberposts', __('Shortcode argument:','rhg'))
				),						
				'min'	=> 1,
				'max'	=> 99,
				'step'	=> 1,
				'default'=> 30,
				'save_option'=>true,
				'load_option'=>true
			);	
			
		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_gallery_animonscroll',
					'label'			=> __('Scrolling animation','rhg'),
					'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
						__('Choose an effect for the scrolling animation.','rhg'),
						sprintf('<b>%s</b> animonscroll', __('Shortcode argument:','rhg')),
						sprintf('<b>%s</b> effect-1, effect-2, effect-3, effect-4, effect-5, effect-6, effect-7, effect-8', __('Posible values:', 'rhg'))
					),
					'type'			=> 'select',
					'default'		=> '',
					'options'		=> array(
						'effect-1'			=> __('Effect 1','rhg'),
						'effect-2'			=> __('Effect 2','rhg'),
						'effect-3'			=> __('Effect 3','rhg'),
						'effect-4'			=> __('Effect 4','rhg'),
						'effect-5'			=> __('Effect 5','rhg'),
						'effect-6'			=> __('Effect 6','rhg'),
						'effect-7'			=> __('Effect 7','rhg'),
						'effect-8'			=> __('Effect 8','rhg')
					),
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);	

		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_gallery_link_target',
					'label'			=> __('Link target','rhg'),
					'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
						__('Choose how the link will open, same window or new frame.','rhg'),
						sprintf('<b>%s</b> link_target', __('Shortcode argument:','rhg')),
						sprintf('<b>%s</b> _self, _blank', __('Posible values:', 'rhg'))
					),
					'type'			=> 'select',
					'default'		=> '_blank',
					'options'		=> array(
						'_self'			=> __('Same window (_self)','rhg'),
						'_blank'			=> __('New tab/window (_blank)','rhg')
					),
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);					
				
		$t[$i]->options[] =	(object)array(
				'id'		=> 'grid_gallery_label_empty',
				'label'		=> __('No result label','rhg'),
				'type'		=> 'text',
				'description'	=> sprintf("<p>%s</p><p>%s</p>",
					__('Text to display when there are no items.','rhg'),
					sprintf('<b>%s</b> label_empty', __('Shortcode argument:','rhg'))
				),
				'default'	=> '',
				'el_properties'	=> array( 'placeholder'=> __('There are no items in gallery.','rhg') , 'class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			);				
				
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhg'),
				'class' => 'button-primary'
			);	

		//-------------------------	
		$i = count($t);
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhg-grid-gallery-layout'; 
		$t[$i]->label 		= __('Grid Gallery Layout','rhg');
		$t[$i]->right_label	= __('Layout settings','rhg');
		$t[$i]->page_title	= __('Grid Gallery Layout settings','rhg');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->options = array();												

		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Grid Box Layout Settings','rhg'),
				'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p><p>%s</p>",
					__('Check elements that you would like to hide.','rhg'),
					sprintf('<b>%s</b> classes', __('Shortcode argument:','rhg')),
					sprintf('<b>%s</b> %s', __('Posible values:', 'rhg'), 'hide_grid_title hide_grid_description hide_grid_start hide_grid_image hide_slide_title hide_slide_description hide_slide_start hide_slide_end hide_slide_venue hide_slide_image'),
					__('You can choose multiple values separated by a space.  Example:  class="hide_grid_description hide_grid_start"','rhg')
				)
			);				

		$fields = array(
			'hide_grid_title' 			=> __('Title','rhg'),
			'hide_grid_description'		=> __('Description','rhg'),
			'hide_grid_image'			=> __('Image','rhg'),
			'hide_grid_colored_bar'		=> __('Colored bar','rhg')
		);
		
		foreach($fields as $field => $label ){

			$t[$i]->options[]=(object)array(
					'id'			=> $field,
					'name'			=> 'grid_gallery_classes[]',
					'label'			=> $label,
					'type' 			=> 'onoff',
					'options'		=> array(
						""			    => __('On','rhg'),
						"$field"		=> __('Off','rhg')
					),
					'option_value'	=> $field,
					'el_properties' => array( ),
					'save_option'=>true,
					'load_option'=>true
				);					
		}			

		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Slideshow Layout Settings','rhg')
			);	
		
		$fields = array(
			'hide_slide_title' 			=> __('Title','rhg'),
			'hide_slide_description'	=> __('Description','rhg'),
			'hide_slide_image'			=> __('Image','rhg'),
			'hide_slide_colored_bar'	=> __('Colored bar','rhg')
		);
		
		foreach($fields as $field => $label ){
			/*
			$t[$i]->options[]=(object)array(
					'id'			=> $field,
					'name'			=> 'grid_gallery_classes[]',
					'label'			=> $label,
					'type' 			=> 'checkbox',
					'option_value'	=> $field,
					'el_properties' => array( ),
					'save_option'=>true,
					'load_option'=>true
				);	
			*/	
			$t[$i]->options[]=(object)array(
					'id'			=> $field,
					'name'			=> 'grid_gallery_classes[]',
					'label'			=> $label,
					'type' 			=> 'onoff',
					'options'		=> array(
						""				=> __('On','rhg'),
						"$field"		=> __('Off','rhg')
					),
					'option_value'	=> $field,
					'el_properties' => array( ),
					'save_option'=>true,
					'load_option'=>true
				);	
		}		
		
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhg'),
				'class' => 'button-primary'
			);	

		//--- Troubleshooting
		if(current_user_can('manage_options')){
			$i = count($t);
			$t[$i]=(object)array();
			$t[$i]->id 			= 'troubleshooting'; 
			$t[$i]->label 		= __('Troubleshooting','rhg');
			$t[$i]->right_label	= __('Troubleshooting','rhg');
			$t[$i]->page_title	= __('Troubleshooting','rhg');
			$t[$i]->theme_option = true;
			$t[$i]->plugin_option = true;
			$t[$i]->options = array();
			
			$t[$i]->options[] =	(object)array(
					'id'		=> 'enable_debug',
					'label'		=> __('Enable debug','rhg'),
					'type'		=> 'yesno',
					'description'=> __('Choose yes to display a debug menu.  This provide technical information that support can use to troubleshoot problems.','rhg'),
					'default'	=> '0',
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);
			/* breaking with rhc.	
			$t[$i]->options[] =	(object)array(
					'id'		=> 'in_footer',
					'label'		=> __('Scripts in footer','rhg'),
					'type'		=> 'yesno',
					'description'=> sprintf('<p>%s</p>',
						__('Choose yes if you want this plugin scripts loaded in the footer.','rhg')
					),
					'default'	=> '0',
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);					
			*/
			$t[$i]->options[]=(object)array(
					'type'=>'clear'
				);
			$t[$i]->options[]=(object)array(
					'type'	=> 'submit',
					'label'	=> __('Save','rhg'),
					'class' => 'button-primary'
				);
		}				
				
					
		return $t;
	}
	
	function pop_show_grid_gallery_sc(){
		//from class.rhg_shortcodes:
		$default = apply_filters('default_grid_gallery', array(
			//'class'				=> '',
			'taxonomy'			=> '',
			'term'				=> '',
			'post_type'			=> '',
			'numberposts'		=> '',
			'label_empty'		=> '',
			'animonscroll'		=> '',
			//'autoload'			=> '',
			'link_target'		=> ''
			//'classes'			=> ''
		));
		
		$str = "[poster_grid_gallery";
		foreach($default as $field => $value){
			//if(!empty($value)){
				$str.=" $field=\"$value\"";
			//}
		}
		$str.="]";
		echo sprintf("<div class=\"pt-option pt-option-sample-sc\"><p>%s</p>%s</div>",
			__('Sample shortcode with custom arguments','rhg'),
			$str
		);		
		
	}
}
?>