<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rhg_media_gallery_shortcode {
	function __construct(){
		add_filter('post_gallery',array(&$this,'post_gallery'),10,2);
	}
	
	function post_gallery( $value, $atts ){
		if(!isset($atts['rhg_effect'])||empty($atts['rhg_effect']))return $value;
		/*
		echo "<pre>";
		print_r($atts);
		echo "</pre>";
		
		add_filter('use_default_gallery_style', create_function('','return false;'));
		*/	
		return $this->gallery_shortcode( $atts );
	}
	
	//based on the original gallery_shortcode at wp-includes/media.php
	function gallery_shortcode( $attr ) {
		$post = get_post();
	
		static $instance = 0;
		$instance++;
	
		if ( ! empty( $attr['ids'] ) ) {
			// 'ids' is explicitly ordered, unless you specify otherwise.
			if ( empty( $attr['orderby'] ) )
				$attr['orderby'] = 'post__in';
			$attr['include'] = $attr['ids'];
		}
	
		// We're trusting author input, so let's at least make sure it looks like a valid orderby statement
		if ( isset( $attr['orderby'] ) ) {
			$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
			if ( !$attr['orderby'] )
				unset( $attr['orderby'] );
		}
	
		$html5 = current_theme_supports( 'html5', 'gallery' );
		extract(shortcode_atts(array(
			'order'      => 'ASC',
			'orderby'    => 'menu_order ID',
			'id'         => $post ? $post->ID : 0,
			'itemtag'    => $html5 ? 'figure'     : 'dl',
			'icontag'    => $html5 ? 'div'        : 'dt',
			'captiontag' => $html5 ? 'figcaption' : 'dd',
			'columns'    => 3,
			'size'       => 'thumbnail',
			'include'    => '',
			'exclude'    => '',
			'link'       => ''
		), $attr, 'gallery'));
	
		$id = intval($id);
		if ( 'RAND' == $order )
			$orderby = 'none';
	
		if ( !empty($include) ) {
			$_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	
			$attachments = array();
			foreach ( $_attachments as $key => $val ) {
				$attachments[$val->ID] = $_attachments[$key];
			}
		} elseif ( !empty($exclude) ) {
			$attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
		} else {
			$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
		}
	
		if ( empty($attachments) )
			return '';
	
		if ( is_feed() ) {
			$output = "\n";
			foreach ( $attachments as $att_id => $attachment )
				$output .= wp_get_attachment_link($att_id, $size, true) . "\n";
			return $output;
		}
	
		$size_class = sanitize_html_class( $size );

		$items = array();
		$i = 0;
		foreach ( $attachments as $id => $attachment ) {
			$attachment->image_small = wp_get_attachment_image( $id, $size, false );
	
			if ( ! empty( $link ) && 'file' === $link )
				$attachment->image_output = wp_get_attachment_link( $id, 'full', false, false );
			elseif ( ! empty( $link ) && 'none' === $link )
				$attachment->image_output = wp_get_attachment_image( $id, 'full', false );
			else
				$attachment->image_output = wp_get_attachment_link( $id, 'full', true, false );
	
			$image_meta  = wp_get_attachment_metadata( $id );
			$attachment->image_meta = $image_meta;
	
			$attachment->orientation = '';
			if ( isset( $image_meta['height'], $image_meta['width'] ) )
				$attachment->orientation = ( $image_meta['height'] > $image_meta['width'] ) ? 'portrait' : 'landscape';
			
			$items[]=$attachment;
		}
/*
echo "<pre>";
print_r($items);
//print_r($items);
echo "</pre>";
*/
		ob_start();
?>
<div class="rh_grid rhg-default grid-gallery image-gallery" data-options="<?php echo $this->get_options( $attr )?>">	
	<section class="grid-wrap">
		<ul id="rhg_grid_<?php echo $instance?>" class="rhg_grid <?php echo $attr['rhg_effect']?>">
			<li class="grid-sizer"></li>
			<?php foreach($items as $item):?>
			<li>
				<figure>
					<?php echo $item->image_small?>
					<figcaption><h3><?php echo wptexturize($item->post_title)?></h3><p><?php echo wptexturize($item->post_content)?></p></figcaption>
				</figure>
			</li>
			<?php endforeach; ?>
		</ul>
	</section>
	<section class="rhg_slideshow slideshow">
		<ul class="rhg_slideshow_items">
			<?php foreach($items as $item):?>
			<li>
				<figure>
					<?php echo $item->image_output?>
					<figcaption><h3><?php echo wptexturize($item->post_title)?></h3><p><?php echo wptexturize($item->post_content)?></p></figcaption>
				</figure>
			</li>
			<?php endforeach; ?>
		</ul>
		<nav>
			<span class="icon rhg-nav-prev"></span>
			<span class="icon rhg-nav-next"></span>
			<span class="icon rhg-nav-close"></span>
		</nav>	
	</section>	
</div>
<?php

		$output = ob_get_contents();
		ob_end_clean();
	
		return $output;
	}
	
	function get_options( $atts ){
		$options=(object)array(
			'prerender'=>1,
			'source'=>''
		);
		return htmlspecialchars(json_encode($options)); 
	}
}
?>