<?php

/**
 * 
 * Description: Creates the options in the WordPress Insert Gallery modal, and inserts the parameter to the shortcode.
 * @version $Id$
 * @copyright 2003 
 **/

class rhg_custom_media_settings {
	function __construct(){
		add_action('admin_init', array(&$this,'admin_init'));
	}
	
	function admin_init(){
		add_action( 'print_media_templates', array( &$this, 'print_media_templates' ) );	
	}
	
	function print_media_templates(){
        $options = apply_filters('rhg_effects',array(
			''		   => __('None'),
			'effect-1' => __('Effect 1'),
			'effect-2' => __('Effect 2'),
			'effect-3' => __('Effect 3'),
			'effect-4' => __('Effect 4'),
			'effect-5' => __('Effect 5'),
			'effect-6' => __('Effect 6'),
			'effect-7' => __('Effect 7'),
			'effect-8' => __('Effect 8')
		));
		?>
        <script type="text/html" id="tmpl-gallery-settings-rhg">
            <label class="setting rhg_effect_cont">
                <span><?php _e('Google Grid Gallery','rhg')?></span>
				<select data-setting="rhg_effect" class="rhg_effect">
				<?php foreach($options as $value => $label):?>
				<option value="<?php echo $value?>"><?php echo $label?></option>
				<?php endforeach; ?>
				</select>
            </label>
			
			<label>
				<span><?php _e('Size','rhg')?></span>
				<?php $image_sizes = get_intermediate_image_sizes(); ?>
				<select data-setting="size">
				  <?php foreach ($image_sizes as $size): ?>
				    <option value="<?php echo $size ?>"><?php echo $size ?></option>
				  <?php endforeach; ?>
				</select>				
			</label>
		
        </script>
        <?php			
	}
}
?>