<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rhg_ajax {
	var $is_archive=false;
	var $is_rhg=false;
	function __construct( $args=array() ){
		//------------
		$defaults = array(
			'template_archive'		=> RHG_PATH.'includes/templates/content-archive.php',
			'items_per_page'		=> 3
		);
		foreach($defaults as $property => $default){
			$this->$property = isset($args[$property])?$args[$property]:$default;
		}
		//-----------	
		$this->is_rhg 			= isset($_REQUEST['rhg'])? true : false;
		if( $this->is_rhg ){
			$this->items_per_page 	= isset($_REQUEST['numberposts']) && $_REQUEST['numberposts']>0 ? intval($_REQUEST['numberposts']) : $this->items_per_page; 
			//--
			add_filter('pre_get_posts', array(&$this,'number_of_posts_on_rh_feed'), 999999 );
			add_action('template_redirect', array(&$this,'template_redirect'));		
			add_filter('next_posts', array(&$this,'next_posts'), 10, 1);
		}

		//--	
	}

	function next_posts( $url='' ){
		return next_posts( $this->max_num_pages, false );
	}
	
	function template_redirect(){
		global $wp_query;
		$this->max_num_pages = $wp_query->max_num_pages;
		$this->is_archive = is_archive();//we test it here, because of rhc, wich changes its taxonomies to page type for template.
		
		remove_all_filters('template_include');
		remove_all_filters('archive_template');
		remove_all_filters('taxonomy_template');
		remove_all_filters('page_template');
		
		add_filter('template_include', array(&$this,'template_include'), 999999, 1);			
		
	}
	
	function number_of_posts_on_rh_feed( $query ){	
		if(!is_admin() && $query->get("page_id") == get_option("page_on_front")) {
			//when frontpage is set to a page id, post_type query is not returning archive, but just that page.
			$query->set("page_id", "");
			if(isset($_REQUEST['post_type'])){
				$query->set("post_type", $_REQUEST['post_type']);
			}
		}		
		$query->set('posts_per_page', intval($this->items_per_page) );
	    return $query;
	}
	
	function template_include($template){
		return apply_filters('rhg_template', $this->template_archive );//  $template;
	}

}
?>