<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

class rhc_grid_integration {
	var $options_id = 'rhc';
	function __construct( $path ){
		$this->path = $path;
		add_filter('get_calendarize_args_options',array(&$this,'get_calendarize_args_options'),10,2);
		add_action('wp_ajax_rhg_rhc_template', array(&$this,'get_template') );
		add_action('wp_ajax_nopriv_rhg_rhc_template', array(&$this,'get_template') );
		
		add_filter('grid_gallery_image', array(&$this,'filter_grid_gallery_image'), 20, 3);
		
		add_action('admin_init', array(&$this,'admin_init'));		
	
		add_filter('rhc_get_events_set', array( &$this, 'rhc_get_events_set'), 10, 3);
		//add the item to the post_info metabox.
		add_filter('postinfo_boxes', array( &$this, 'postinfo_boxes'), 10, 1);
		
		add_filter('pop_post_info_boxes', array( &$this, 'pop_post_info_boxes'), 10, 1);
		
		
	}
	
	function pop_post_info_boxes( $boxes ){
		$boxes['gridviewbox'] = __('Apply default Grid View Details','rhc');
		$boxes['slideviewbox'] = __('Apply default Grid View Slideshow Details','rhc');
		return $boxes;
	}
	
	function postinfo_boxes( $postinfo_boxes ){
		$postinfo_boxes['gridviewbox'] = (object)array(
			'id'		=> 'gridviewbox',
			'label'		=> __('Grid View Details','rhc'),
			'holder_class' => 'grid-custom-details',
			'enable_meta' => false,
			'type'		=> 'server'
		);
		$postinfo_boxes['slideviewbox'] = (object)array(
			'id'		=> 'slideviewbox',
			'label'		=> __('Grid View Slideshow Details','rhc'),
			'holder_class' => 'slide-custom-details',
			'enable_meta' => false,
			'type'		=> 'server'
		);
		
		return $postinfo_boxes;
	}
	
	function rhc_get_events_set( $events, $args, $request=false ){
		$request = false===$request ? $_REQUEST : $request ;
	
		if(isset($request['view']) && 'rhc_grid'==$request['view'] ){
			if( is_array($events) && count($events)>0 ){
				global $rhc_plugin, $rhg_plugin;			
				foreach($events as $i => $ev){
					if( !isset($ev['local_id']) )continue;					
					//---
					global $post;
					$bak_post = $post;
					$post = (object)array(
						'ID' => $ev['local_id']
					);
					
					$events[$i]['gridviewbox'] = do_shortcode('[rhc_post_info id="gridviewbox" frontend="1"]');
					$events[$i]['slideviewbox'] = do_shortcode('[rhc_post_info id="slideviewbox" frontend="1"]');
				}
			}
		}
		return $events;
	}
	
	function filter_grid_gallery_image( $out, $post_ID, $size){
		if( RHC_EVENTS == get_post_type( $post_ID ) ){
			//---
			$attachment_id = get_post_meta($post_ID,'rhc_tooltip_image',true);
			$image = wp_get_attachment_image( $attachment_id, $size );
			if(false===$image){
				//fallback to default
			}else{
				return $image;
			}
		}
		return $out;
	}
	
	function get_template(){
		$file = apply_filters('rhg_rhc_template', $this->path.'templates/rhc_item.php' );
		include $file;
		die();
	}
	
	function get_calendarize_args_options( $options, $atts ){
		global $rhc_plugin;
		$option_name = "grid_button_label";
		$button_label = isset($atts[$option_name]) && !empty($atts[$option_name]) ? $atts[$option_name] : $rhc_plugin->get_option($option_name,__('grid','rhcgmap'),true) ;
		
		$settings = $this->get_grid_options(null,$atts);
	
		foreach($options->modes as $type => $mode){
			$options->modes[$type]['options']->rhc_grid = $settings;
			$options->modes[$type]['options']->buttonText->rhc_grid = $button_label;
		}

		return $options;
	}
	
	function get_grid_options($type,$atts){
		global $rhc_plugin,$rhg_plugin;
		$r = (object)array();
		foreach(array(
			'animonscroll'					=> 'effect-2',
			'enableslideshow'				=> '1',
			'template'						=> admin_url('/admin-ajax.php?action=rhg_rhc_template'),
			'nolink'						=> '',
			'link_target'					=> '_blank',
			'delta'							=> 30,
			'date_format_start'				=> 'MMMM d, yyyy hh:mm tt',
			'date_format_start_allday'		=> 'MMMM d, yyyy',
			'date_format_end'				=> 'MMMM d, yyyy hh:mm tt',
			'date_format_end_allday'		=> 'MMMM d, yyyy',
			'date_format'					=> 'MMMM d, yyyy',
			'time_format'					=> 'hh:mm tt',
			'classes'						=> '',
			'showongoing'					=> '1',
			'autoload'						=> '1',
			'trigger_size'					=> '0',
			'norepeat'						=> '0',
			'sameheight'				=> '0'
		) as $field => $default){
			$option_name = "grid_".$field;
			$value = isset($atts[$option_name]) ? $atts[$option_name] : $rhc_plugin->get_option($option_name,$default,true) ;
			$r->$field = $value;
		}

		return $r;
	}
	/* admin scripts */
	function admin_init(){
		add_filter("pop-options_{$this->options_id}",array(&$this,'options'),10,1);
	}
	
	function options( $t ){
		
		//--
		$i = count($t);
		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhc-grid_view'; 
		$t[$i]->label 		= __('Event Grid View','rhg');
		$t[$i]->right_label	= __('Default settings','rhg');
		$t[$i]->page_title	= __('Event Grid View','rhg');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;
		$t[$i]->options = array();

		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_animonscroll',
					'label'			=> __('Scrolling animation','rhg'),
					'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
						__('Choose an effect for the scrolling animation.','rhg'),
						sprintf('<b>%s</b> grid_animonscroll', __('Shortcode argument:','rhg')),
						sprintf('<b>%s</b> effect-1, effect-2, effect-3, effect-4, effect-5, effect-6, effect-7, effect-8', __('Posible values:', 'rhg'))
					),
					'type'			=> 'select',
					'default'		=> '',
					'options'		=> array(
						'effect-1'			=> __('Effect 1','rhg'),
						'effect-2'			=> __('Effect 2','rhg'),
						'effect-3'			=> __('Effect 3','rhg'),
						'effect-4'			=> __('Effect 4','rhg'),
						'effect-5'			=> __('Effect 5','rhg'),
						'effect-6'			=> __('Effect 6','rhg'),
						'effect-7'			=> __('Effect 7','rhg'),
						'effect-8'			=> __('Effect 8','rhg')
					),
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);	
				
		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_button_label',
					'label'			=> __('Grid View Button Label','rhg'),
					'description'	=> sprintf("<p>%s</p>",
						__('Type a label for the grid view button.  No shortcode argument.','rhg')
					),
					'type'			=> 'text',
					'default'		=> __('grid','rhg'),
					'el_properties'	=> array('class'=>'widefat'),
					'save_option'=>true,
					'load_option'=>true
				);
									
		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_autoload',
					'label'			=> __('Auto Load','rhg'),
					'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
						__('Automatically load more events.','rhg'),
						sprintf('<b>%s</b> grid_autoload', __('Shortcode argument:','rhg') ),
						sprintf('<b>%s</b> 1, 0', __('Posible values:', 'rhg') )
					),					
					'type'			=> 'onoff',
					'default'		=> '1',
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);	
				
		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_enableslideshow',
					'label'			=> __('Enable Slideshow','rhg'),
					'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
						__('Turn off this option if you dont want to show the slideshow when clicking on a grid item.','rhg'),
						sprintf('<b>%s</b> grid_enableslideshow', __('Shortcode argument:','rhg') ),
						sprintf('<b>%s</b> 1, 0', __('Posible values:', 'rhg') )
					),					
					'type'			=> 'onoff',
					'default'		=> '1',
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);					
				
		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_nolink',
					'label'			=> __('Enable link','rhg'),
					'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
						__('Choose yes to disable linking to the event page.','rhg'),
						sprintf('<b>%s</b> grid_nolink', __('Shortcode argument:','rhg') ),
						sprintf('<b>%s</b> 1, 0', __('Posible values:', 'rhg') )
					),
					'type'			=> 'onoff',
					'default'		=> '1',
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);	

		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_showongoing',
					'label'			=> __('Show Ongoing Events','rhg'),
					'description'	=> sprintf("<p>%s</p>",
						__('Choose On to show ongoing events.  Example: Option ON, an event that have started yesterday and ends tomorrow will show.  Option OFF, the event will NOT show.','rhg')
					),					
					'type'			=> 'onoff',
					'default'		=> '1',
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);					
				
		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_link_target',
					'label'			=> __('Link target','rhg'),
					'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
						__('Choose how the link will open, same window or new frame.','rhg'),
						sprintf('<b>%s</b> grid_link_target', __('Shortcode argument:','rhg')),
						sprintf('<b>%s</b> _self, _blank', __('Posible values:', 'rhg'))
					),
					'type'			=> 'select',
					'default'		=> '_blank',
					'options'		=> array(
						'_self'			=> __('Same window (_self)','rhg'),
						'_blank'			=> __('New tab/window (_blank)','rhg')
					),
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);	

		$t[$i]->options[]=(object)array(
				'id'	=> 'grid_delta',
				'type'	=> 'range',
				'label'	=> __('Window range in days','rhc'),
				'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
					__('This option specifies how many days worth of events to bring per ajax load.  Adjust this depending on how dense events are in your site.  Sites with a lot of events will use a lesser value to avoid long waits.','rhg'),
					sprintf('<b>%s</b> grid_delta', __('Shortcode argument:','rhg')),
					sprintf('<b>%s</b> %s', __('Posible values:', 'rhg'), __('A positive whole number (integer).','rhg'))
				),				
				'min'	=> 1,
				'max'	=> 365,
				'step'	=> 1,
				'default'=> 30,
				'save_option'=>true,
				'load_option'=>true
			);	

		$t[$i]->options[]=(object)array(
				'id'	=> 'grid_trigger_size',
				'type'	=> 'range',
				'label'	=> __('Minimun window width for Slideshow','rhc'),
				'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
					__('Zero will disable this feature.  Mininum width that the content needs to be to display the slideshow.','rhg'),
					__('If the window is not wide enough, clicking on a grid item will open the event instead of the slideshow','rhg'),
					__('Use case:  Desktop users clicking the grid item will see the slideshow, but mobile users while get directly linked to the event page.', 'rhg')
				),				
				'min'	=> 0,
				'max'	=> 4096,
				'step'	=> 1,
				'default'=> 0,
				'save_option'=>true,
				'load_option'=>true
			);	

		$t[$i]->options[] = (object)array(
					'id'			=> 'grid_sameheight',
					'label'			=> __('Same height events','rhg'),
					'description'	=> sprintf("<p>%s</p>",
						__('Forces events in the same row to be the same height.','rhg')
					),					
					'type'			=> 'onoff',
					'default'		=> '0',
					'el_properties'	=> array(),
					'save_option'=>true,
					'load_option'=>true
				);

		$t[$i]->options[] = (object) array(
			'id'            => 'grid_disable_modernizr',
			'label'         => __( 'Disable Modernizr', 'rhg' ),
			'type'          => 'onoff',
			'default'		=> '0',
			'el_properties'	=> array(),
			'save_option'   => true,
			'load_option'   => true
		);
		
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
/* will use custom fields date format instead.				
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Date formats','rhg')				
				
			);		
			
			
		$t[$i]->options[]=(object)array(
				'id'			=> 'grid_date_format_start',
				'type' 			=> 'text',
				'label'			=> __('Date start (with time)','rhg'),
				'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p>",
					__('The date formats in this section apply to the Grid View only.','rhg'),
					sprintf('<b>%s</b> grid_date_format_start, grid_date_format_start_allday, grid_date_format_end, grid_date_format_end_allday', __('Shortcode argument:','rhg')),
					sprintf('<b>%s</b> %s', __('Posible values:', 'rhg'), __('A valid Calendarize It! date format.','rhg'))
				),					
				'el_properties' => array(
					'class'=>'widefat rhc_dateformat',
					'rel'=> __('MMMM d, yyyy hh:mm tt','rhg')
				),
				'save_option'=>true,
				'load_option'=>true
			);	
			
		$t[$i]->options[]=(object)array(
				'id'			=> 'grid_date_format_start_allday',
				'type' 			=> 'text',
				'label'			=> __('Date start All day (not time)','rhg'),
				'el_properties' => array(
					'class'=>'widefat rhc_dateformat',
					'rel'=> __('MMMM d, yyyy','rhg')
				),
				'save_option'=>true,
				'load_option'=>true
			);	
			
		$t[$i]->options[]=(object)array(
				'id'			=> 'grid_date_format_end',
				'type' 			=> 'text',
				'label'			=> __('Date end (with time)','rhg'),
				'el_properties' => array(
					'class'=>'widefat rhc_dateformat',
					'rel'=> __('MMMM d, yyyy hh:mm tt','rhg')
				),
				'save_option'=>true,
				'load_option'=>true
			);	
						
		$t[$i]->options[]=(object)array(
				'id'			=> 'grid_date_format_end_allday',
				'type' 			=> 'text',
				'label'			=> __('Date end All day (not time)','rhg'),
				'el_properties' => array(
					'class'=>'widefat rhc_dateformat',
					'rel'=> __('MMMM d, yyyy','rhg')
				),
				'save_option'=>true,
				'load_option'=>true
			);											
*/
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Grid Box Layout Settings','rhg'),
				'description'	=> sprintf("<p>%s</p><p>%s</p><p>%s</p><p>%s</p>",
					__('Check elements that you would like to hide.','rhg'),
					sprintf('<b>%s</b> grid_classes', __('Shortcode argument:','rhg')),
					sprintf('<b>%s</b> %s', __('Posible values:', 'rhg'), 'hide_grid_title hide_grid_description hide_grid_gridviewbox hide_grid_image hide_slide_title hide_slide_description hide_slide_gridviewbox hide_slide_image'),
					__('You can choose multiple values separated by a space.  Example:  class="hide_grid_description hide_grid_title"','rhg')
				)
			);				
			
		$fields = array(
			'hide_grid_title' 			=> __('Title','rhg'),
			'hide_grid_description'		=> __('Description','rhg'),
			//'hide_grid_start'			=> __('Date start','rhg'),
			'hide_grid_gridviewbox'		=> __('Grid View Details','rhg'),
			'hide_grid_image'			=> __('Image','rhg'),
			'hide_grid_colored_bar'		=> __('Colored bar','rhg')
		);

		foreach($fields as $field => $label ){				
			$t[$i]->options[]=(object)array(
					'id'			=> $field,
					'name'			=> 'grid_classes[]',
					'label'			=> $label,
					'type' 			=> 'onoff',
					'options'		=> array(
						""			    => __('On','rhg'),
						"$field"		=> __('Off','rhg')
					),
					'option_value'	=> $field,
					'el_properties' => array( ),
					'save_option'=>true,
					'load_option'=>true
				);					
		}		
	
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Slideshow Layout Settings','rhg')
			);	
		
		$fields = array(
			'hide_slide_title' 			=> __('Title','rhg'),
			'hide_slide_description'	=> __('Description','rhg'),
			//'hide_slide_start'			=> __('Date start','rhg'),
			//'hide_slide_end'			=> __('Date end','rhg'),
			'hide_slide_gridviewbox'	=> __('Grid View Details','rhg'),
			'hide_slide_image'			=> __('Image','rhg'),
			'hide_slide_colored_bar'	=> __('Colored bar','rhg')
		);
		
		foreach($fields as $field => $label ){				
			$t[$i]->options[]=(object)array(
					'id'			=> $field,
					'name'			=> 'grid_classes[]',
					'label'			=> $label,
					'type' 			=> 'onoff',
					'options'		=> array(
						""			    => __('On','rhg'),
						"$field"		=> __('Off','rhg')
					),
					'option_value'	=> $field,
					'el_properties' => array( ),
					'save_option'=>true,
					'load_option'=>true
				);					
		}			

		/* will use post info boxes instead.
		if( defined('RHC_VERSION') ){
			global $rhc_plugin;
			$max_custom_fields = intval( $rhc_plugin->get_option('max_custom_fields',0,true) );
			if( $max_custom_fields > 0 ){
				$t[$i]->options[]=(object)array(
					'type' 			=> 'subtitle',
					'label'			=> __('Calendarize It! Grid View Item Layout Settings','rhg')
				);	
				for($a=0;$a<$max_custom_fields;$a++){
					$label = $rhc_plugin->get_option( 'custom_label_'.$a, '', true );
					$field = $rhc_plugin->get_option( 'custom_field_'.$a, '', true );
					
					$t[$i]->options[]=(object)array(
							'id'			=> $field,
							'name'			=> 'grid_item_meta_field[]',
							'label'			=> $label,
							'type' 			=> 'onoff',
							'options'		=> array(
								""				=> __('On','rhg'),
								"$field"		=> __('Off','rhg')
							),
							'option_value'	=> $field,
							'el_properties' => array( ),
							'save_option'=>true,
							'load_option'=>true
						);						
					
				}
				
				$t[$i]->options[]=(object)array(
					'type' 			=> 'subtitle',
					'label'			=> __('Calendarize It! Grid View Slide Layout Settings','rhg')
				);	
				for($a=0;$a<$max_custom_fields;$a++){
					$label = $rhc_plugin->get_option( 'custom_label_'.$a, '', true );
					$field = $rhc_plugin->get_option( 'custom_field_'.$a, '', true );
						
					$t[$i]->options[]=(object)array(
							'id'			=> $field,
							'name'			=> 'grid_slide_meta_field[]',
							'label'			=> $label,
							'type' 			=> 'onoff',
							'options'		=> array(
								""				=> __('On','rhg'),
								"$field"		=> __('Off','rhg')
							),
							'option_value'	=> $field,
							'el_properties' => array( ),
							'save_option'=>true,
							'load_option'=>true
						);						
					
				}													
			}		
		}
		*/

					
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhc'),
				'class' => 'button-primary'
			);			
		//--
		return $t;
	}
}
?>