<?php
/**
 * rhcss_map_view_counter class, extended for module_righthere_css
 * 
 * @package Calendarize_It_Editor
 * @subpackage Calendarize_It_Editor/includes
 * @since 1.6.0
 */

class rhcss_map_view_counter extends module_righthere_css {
	function __construct( $args = array() ) {
		$args['cb_init'] = array( $this, 'cb_init' );
		return parent::__construct($args);
	}
	
	function cb_init() {
		//called on the head when editor is active.
	}

	function options( $t = array() ) {
		$i = count( $t );

		//-- Font Labels -----------------------
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhcmvc_labels_font'; 
		$t[ $i ]->label   = __( 'Font (Labels)', 'rhcetc' );
		$t[ $i ]->options = array();

		$t[$i]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcmvc_label_default_font',
			'selector' => 'body .map-view-counter-content .label',
			'labels'   => (object) array(
				'family'    => __( 'Default font', 'rhc' ),
				'size'      => __( 'Size', 'rhc' ),
				'color'     => __( 'Color', 'rhc' )				
			)
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhcmvc_label_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => 'body .map-view-counter-content .label',
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		//-- Font Numbers -----------------------
		$i++;
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rhcmvc_numbers_font'; 
		$t[ $i ]->label   = __( 'Font (Numbers)', 'rhcetc' );
		$t[ $i ]->options = array();

		$t[ $i ]->options = $this->add_font_options( $t[ $i ]->options, array(
			'prefix'   => 'rhcmvc_counter_default_font',
			'selector' => 'body .map-view-counter-content .number',
			'labels'   => (object) array(
				'family'    => __( 'Default font', 'rhc' ),
				'size'      => __( 'Size', 'rhc' ),
				'color'     => __( 'Color', 'rhc' )				
			)
		) );

		$t[ $i ]->options[] = (object) array(
			'id'         => 'rhcmvc_counter_font_shadow',
			'type'       => 'css',
			'label'      => __( 'Shadow', 'rhc' ),
			'input_type' => 'textshadow',
			'opacity'    => true,
			'selector'   => 'body .map-view-counter-content .number',
			'property'   => 'text-shadow',
			'real_time'  => true,
			'btn_clear'  => true
		);

		//-- Back Container -----------------------
		$i++;
		$box_prefix = 'rhcmvc_container';
		$box_selector = '.mvc-container';
		$with_image = true;

		$label = ( isset( $label ) ) ? $label : array(); // Background bar

		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = $box_prefix . '-outer'; 
		$t[ $i ]->label   = ( isset( $label['outer'] ) ) ? $label['outer'] : __( 'Back Container', 'rhc' );
		$t[ $i ]->options = array();

		$t[ $i ]->options[] = (object) array(
			'id'            => $box_prefix . '_back_width',
			'type'          => 'css',
			'label'         => ( isset( $label['image_width'] ) ) ? $label['image_width'] : __( 'Width', 'rhc' ),
			'input_type'    => 'number',
			'class'         => 'input-mini',
			'unit'          => 'px',
			'min'           => 0,
			'step'          => 1,
			'holder_class'  => '',
			'selector'      => ".fe-extrainfo-container$box_selector",
			'property'      => 'width',
			'other_options' => array(
				'transparent'    => 'transparent'
			),
			'real_time'     => true
		);
		
		$t[ $i ]->options = $this->add_padding_options( $t[ $i ]->options, array(
			'prefix'   => $box_prefix . '_outer_pad',
			'selector' => ".fe-extrainfo-container$box_selector"
		));

		$t[ $i ]->options = $this->add_border_options($t[ $i ]->options, array(
			'prefix'   => $box_prefix . '_outer_border',
			'selector' => ".fe-extrainfo-container$box_selector",
		));		
				
		$t[$i]->options = $this->add_border_radius_options($t[$i]->options, array(
			'prefix'   => $box_prefix . '_outer_radius',
			'selector' => ".fe-extrainfo-container$box_selector"
		));

		//-- Back Container Background -----------------------
		$i++;
		$t[$i]=(object)array();
		$t[$i]->id 			= $box_prefix.'-outer-bg'; 
		$t[$i]->label 		= isset($label['outer-bg'])?$label['outer-bg']:__('Back Container background','rhc');
		$t[$i]->options = array();		
		$t[$i]->options = $this->add_backgroud_options( $t[$i]->options, array(
			'label'		=> __('Back background','rhc'),
			'prefix'	=> $box_prefix.'_outer_bg',
			'selector'	=> ".fe-extrainfo-container$box_selector"			
		));

		//-- Saved and DC -----------------------	
		$i                = count( $t );
		$t[ $i ]          = (object) array();
		$t[ $i ]->id      = 'rh-saved-list'; 
		$t[ $i ]->label   = __( 'Templates', 'rhc' );
		$t[ $i ]->options = array(
			(object) array(
				'id'         => 'rh_saved_settings',
				'input_type' => 'backup_list'
			)			
		);

		return $t;
	}
}


?>