<?php

/**
 * 
 *
 * @version $Id$
 * @copyright 2003 
 **/

if('rhc_addon_backend_options'==get_class($this)){
		global $rhc_plugin;
		
		$i = count($t);
		//--  -----------------------		
		//$i++;

		$t[$i]=(object)array();
		$t[$i]->id 			= 'rhc-bop'; 
		$t[$i]->open 			= $this->open; 
		$t[$i]->label 		= __('Backend Options','rhcbop');
		$t[$i]->right_label	= __('Backend Options','rhcbop');
		$t[$i]->page_title	= __('Backend Options','rhcbop');
		$t[$i]->theme_option = true;
		$t[$i]->plugin_option = true;		
		$t[$i]->options = array(
			(object)array(
				'id'			=> 'bop_defaultview',
				'type' 			=> 'select',
				'label'			=> __('Default view','rhc'),
				'options'		=> apply_filters('rhc_views', array(
					''			=> __('--choose--','rhc'),
					//month, basicWeek, basicDay, agendaWeek, agendaDay
					'month'		=> __('Month','rhc'),
					'basicWeek'	=> __('Week','rhc'),
					'agendaWeek'=> __('Agenda Week','rhc')
				)),
				'description' => __('The options in this tab apply to the calendar metabox that is used in the backend to define an event date.','rhcbop'),
				'default'	=> 'month',
				'save_option'=>true,
				'load_option'=>true
			),		
			(object)array(
				'id'			=> 'bop_header_left',
				'type' 			=> 'text',
				'label'			=> __('Left header','rhc'),
				'default'		=> 'prevYear,prev,next,nextYear today ',
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'			=> 'bop_header_center',
				'type' 			=> 'text',
				'label'			=> __('Center header','rhc'),
				'el_properties' => array('class'=>'widefat'),
				'default'		=> 'title',
				'save_option'=>true,
				'load_option'=>true
			),
			(object)array(
				'id'			=> 'bop_header_right',
				'type' 			=> 'text',
				'label'			=> __('Right header','rhc'),
				'default'		=> 'month,agendaWeek,agendaDay',
				'description'	=> __('Defaults to: <b>month,agendaWeek,agendaDay</b>. Also available: basicWeek','rhc'),
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			)
		);	


		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Disable months','rhc')
			);

		$weekdays = array(
			0 => __('Sunday','rhc'),
			1 => __('Monday','rhc'),
			2 => __('Tuesday','rhc'),
			3 => __('Wednesday','rhc'),
			4 => __('Thursday','rhc'),
			5 => __('Friday','rhc'),
			6 => __('Saturday','rhc')
		);		
		//the values are meant for javascript so jan is 0 while december is 11.
		
		$months = array(
					'0'	=> __('January','rhc'),
					'1'	=> __('February','rhc'),
					'2'	=> __('March','rhc'),
					'3'	=> __('April','rhc'),
					'4' => __('May','rhc'),
					'5'	=> __('June','rhc'),
					'6'	=> __('July','rhc'),
					'7'	=> __('August','rhc'),
					'8'	=> __('September','rhc'),
					'9'	=> __('October','rhc'),
					'10'=> __('November','rhc'),
					'11'=> __('December','rhc')
				);		
				
		$j = 0;	
		foreach($months as $value => $label){
			$tmp=(object)array(
				'id'	=> 'bop_skipmonths_'.$value,
				'name'	=> 'bop_skipmonths[]',
				'type'	=> 'checkbox',
				'option_value'=>$value,
				//'default'	=> $rhc_plugin->get_option('skipmonths_'.$value,'month',true),
				'default'	=> '',
				'label'	=> $label,
				'el_properties' => array(),
				'save_option'=>true,
				'load_option'=>true
			);
			if($j==0){
				$tmp->description = __("Check months that you do NOT want to show. Pressing prev or next button in calendar will skip to the next available month.",'rhc');
				$tmp->description_rowspan = count($weekdays);
			}
			$t[$i]->options[]=$tmp;
			$j++;
		}
		
		$weekdays = array(
					'0'	=> __('Sunday','rhc'),
					'1'	=> __('Monday','rhc'),
					'2'	=> __('Tuesday','rhc'),
					'3'	=> __('Wednesday','rhc'),
					'4' => __('Thursday','rhc'),
					'5'	=> __('Friday','rhc'),
					'6'	=> __('Saturday','rhc')
				);
			
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Hide days from view','rhc')
			);
		$j = 0;	
		foreach($weekdays as $value => $label){
			$tmp=(object)array(
				'id'	=> 'hiddendays_'.$value,
				'name'	=> 'bop_hiddendays[]',
				'type'	=> 'checkbox',
				'option_value'=>$value,
				'default'	=> $rhc_plugin->get_option('hiddendays_'.$value,'',true),
				'label'	=> $label,
				'el_properties' => array(),
				'save_option'=>true,
				'load_option'=>true
			);
			if($j==0){
				$tmp->description = __("Check days that you do NOT want to show.",'rhc');
				$tmp->description_rowspan = count($weekdays);
			}
			$t[$i]->options[]=$tmp;
			$j++;
		}
		
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_weekends',
				'type' 			=> 'yesno',
				'label'			=> __('Show weekends','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_weekends','',true),
				'save_option'=>true,
				'load_option'=>true
			);
			
		$t[$i]->options[]=(object)array(
				'type' 			=> 'clear'
			);
								
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_firstday',
				'type' 			=> 'select',
				'label'			=> __('Calendar First Day','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_firstday','',true),
				'options'		=> $weekdays,
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_week_numbers',
				'type' 			=> 'yesno',
				'label'			=> __('Enable week numbers','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_week_numbers','',true),
				'description'	=> sprintf("<p>%s</p><p>%s</p>",
					__('Enables displaying week numbers on the calendar views.','rhc'),
					__('<b>Week number label</b>: By default it is "W", this is the label shown on the week column in month view.  In agenda views it is shown in the top left corner.','rhc')
				),
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_week_numbers_title',
				'type' 			=> 'text',
				'label'			=> __('Week number label','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_week_numbers_title','',true),
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Calendar labels','rhc'),
				'description'	=> sprintf('<p>%s</p><p>%s</p><p><b>%s</b> %s</p><p><b>%s</b> %s</p><p><b>%s</b> %s</p><p><b>%s</b> %s</p>',
					__('Only use this options if you want to use diferent labels from the localized ones, or if the plugin is not providing localization at all.','rhc'),
					__('Write <b>comma separated</b> and <b>no space</b> labels on each setting in this section','rhc'),
					__('Default month names:','rhc'),
					__('January, February, March, April, May, June, July, August, September, October, November, December','rhc'),
					__('Default short month names:','rhc'),
					__('Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec','rhc'),
					__('Default day names:','rhc'),
					__('Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday','rhc'),
					__('Default short day names:','rhc'),
					__('Sun, Mon, Tue, Wed, Thu, Fri, Sat','rhc')
				)
			);
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_monthnames',
				'type' 			=> 'text',
				'label'			=> __('Month names','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_monthnames','',true),
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_monthnamesshort',
				'type' 			=> 'text',
				'label'			=> __('Short month names','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_monthnamesshort','',true),
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_daynames',
				'type' 			=> 'text',
				'label'			=> __('Day names','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_daynames','',true),
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_daynamesshort',
				'type' 			=> 'text',
				'label'			=> __('Short day names','rhc'),
				'default'		=> $rhc_plugin->get_option('cal_daynamesshort','',true),
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[]=(object)array(
				'type' 			=> 'clear'
			);
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Month view','rhc')
			);
		$t[$i]->options[]=(object)array(
				'id'		=> 'bop_week_mode',
				'label'		=> __('Week mode','rhc'),
				'type'		=> 'select',
				'default'	=> $rhc_plugin->get_option('cal_week_mode','fixed',true),
				'options'	=> array(
					'fixed'		=> __('Fixed','rhc'),
					'liquid'	=> __('Liquid','rhc'),
					'variable'	=> __('Variable','rhc')
				),
				'description'	=> __('Determines the number of weeks displayed in the calendar.','rhc'),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);

		/*				
		$t[$i]->options[]=(object)array(
				'type' 			=> 'clear'
			)	;
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('Agenda view (week and day view)','rhc')
			);
		$t[$i]->options[]=(object)array(
				'id'		=> 'bop_alldayslot',
				'label'		=> __('Show all-day slot','rhc'),
				'type'		=> 'yesno',
				'default'	=> '1',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'			=> 'bop_alldaytext',
				'type' 			=> 'text',
				'label'			=> __('all-day label','rhc'),
				'el_properties' => array('class'=>'widefat'),
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'	=> 'bop_firsthour',
				'type'	=> 'range',
				'label'	=> __('First hour','rhc'),
				'min'	=> 0,
				'max'	=> 24,
				'step'	=> 1,
				'default'=> 6,
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'	=> 'bop_slotminutes',
				'type'	=> 'range',
				'label'	=> __('Slot minutes','rhc'),
				'min'	=> 5,
				'max'	=> 60,
				'step'	=> 1,
				'default'=> 30,
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'	=> 'bop_mintime',
				'type'	=> 'range',
				'label'	=> __('Minimun displayed time','rhc'),
				'min'	=> 0,
				'max'	=> 24,
				'step'	=> 1,
				'default'=> 0,
				'save_option'=>true,
				'load_option'=>true
			);
		$t[$i]->options[]=(object)array(
				'id'	=> 'bop_maxtime',
				'type'	=> 'range',
				'label'	=> __('Maximun displayed time','rhc'),
				'min'	=> 0,
				'max'	=> 24,
				'step'	=> 1,
				'default'=> 24,
				'save_option'=>true,
				'load_option'=>true
			);
		*/
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
			
		$t[$i]->options[]=(object)array(
				'type' 			=> 'subtitle',
				'label'			=> __('New events','rhc'),
				'description'	=> __('The following options are the default values for fields in the dialog when assigning a date to a new event.','rhc')
			);

		$t[$i]->options[]=(object)array(
				'id'		=> 'bop_fc_color',
				'label'		=> __('Event color','rhc'),
				'type'		=> 'farbtastic',
				'default'	=> '',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);			

		$t[$i]->options[]=(object)array(
				'id'		=> 'bop_fc_text_color',
				'label'		=> __('Text color','rhc'),
				'type'		=> 'farbtastic',
				'default'	=> '',
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);			
			
		$t[$i]->options[]=(object)array(
				'id'		=> 'bop_fc_click_link',
				'label'		=> __('Click links to','rhc'),
				'type'		=> 'select',
				'default'	=> 'view',
				'options'	=> array(
					'view'		=> __('Tooltip','rhc'),				
					'page'		=> __('Page','rhc'),				
					'none'		=> __('No link','rhc')
				),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);

		$t[$i]->options[]=(object)array(
				'id'		=> 'bop_fc_click_target',
				'label'		=> __('Link target','rhc'),
				'type'		=> 'select',
				'default'	=> '_self',
				'options'	=> array(
					'_self'		=> '_self',				
					'_blank'	=> '_blank'
				),
				'el_properties'	=> array(),
				'save_option'=>true,
				'load_option'=>true
			);
		
		$t[$i]->options[]=(object)array(
				'type'=>'clear'
			);
			 			
		$t[$i]->options[]=(object)array(
				'type'	=> 'submit',
				'label'	=> __('Save','rhc'),
				'class' => 'button-primary'
			);	
}
?>