



jQuery(document).ready(function($){
	function advent_cb_view_display( e, for_widget, calendar, view, element ){
		var data = $(calendar).parents('.rhc_holder').data('Calendarize');
		var fc_options = data.modes[data.mode].options;		
		if( fc_options.advent ){		
			start = new Date( fc_options.advent.start );
			start =   new Date( start.getTime() + ( start.getTimezoneOffset() * 60000 ) );
			start.setHours(0,0,0,0);
			end = new Date( fc_options.advent.end );
			end =   new Date( end.getTime() + ( end.getTimezoneOffset() * 60000 ) );
			end.setHours(0,0,0,0);		
			now = new Date();
			now.setHours(23,59,59,999);

			//- handle images	
			overlay_images = [];		
			images = fc_options.advent.images && fc_options.advent.images.length > 0 ? fc_options.advent.images : false;	
			if( images ){
				arr = images.split(',');
				if( arr.length > 0 ){
					overlay_images = arr;
				}
			}
			
			calendar.find('td.fc-day').each(function(i,el){	
				current_date = new Date( $(el).data('date') );
				current_date =   new Date( current_date.getTime() + ( current_date.getTimezoneOffset() * 60000 ) );
				current_date.setHours(0,0,0,0);
				
				if( current_date.getTime() >= start.getTime() && current_date.getTime() <= end.getTime() ){
					$(el)
						.addClass('advent-holder')
						.addClass('advent-closed')
					;
					
					advent_holder = $('<div></div>')
						.addClass('advent-container')
					;
					
					advent_el = $('<div></div>')
						.append(
							$('<div></div>')
								.addClass('advent-day')
								.html( current_date.getDate() )
						)
						//.html(  current_date.getDate() )
						.addClass('advent-overlay')
						.appendTo(advent_holder)
					;	
					
					close_seconds = fc_options.advent.close_seconds ? fc_options.advent.close_seconds : 0 ;	
					advent_holder.attr('data-close_seconds', close_seconds );	
								
					if( current_date.getTime() > now.getTime() ){
						advent_holder.addClass('advent-blocked');
					}else{
						advent_holder.bind('click',function(e){
							td = $(this)
								.closest('td')
								.toggleClass('advent-closed')
								.toggleClass('advent-opened')
							;
						
							s = parseInt( $(this).data('close_seconds') );
							if( s > 0 ){
								if( td.is('.advent-opened') ){
									setTimeout( function(o){
										td = $(o).closest('td');												
										if( td.is('.advent-opened') ){
											$(o).trigger('click');
										}
									}, s*1000, this);
								}
							}
						});					
					}
					
					//- handle color
					bg_color = fc_options.advent.background_color && fc_options.advent.background_color.length > 1 ? fc_options.advent.background_color : false;	
					if( bg_color ){
						advent_holder
							.find('.advent-overlay')
							.css('background-color', bg_color)
						;
					}
					
					color = fc_options.advent.color && fc_options.advent.color.length > 1 ? fc_options.advent.color : false;	
					if( color ){
						advent_holder
							.find('.advent-overlay')
							.css('color', color)
						;
					}
					
					//-- handle image
					if( overlay_images.length > 0 ){
						advent_holder
							.find('.advent-overlay')
							.css('background-image', 'url("' + overlay_images[0] + '")'  )
						;
						
						if( overlay_images.length > 1 ){
							overlay_images.push( overlay_images.shift() );
						}
					}
					
					
					advent_holder.appendTo(el);
					
					$(el).append( $('<div class="advent-container2"><div class="advent-overlay2"></div></div>') );
				}		
			});
		}
	}
	$('body').bind('cb_view_display', function(e, for_widget, calendar, view, element){
		if( view.name=='month' ){
			try {
				advent_cb_view_display( e, for_widget, calendar, view, element );
			}catch(err){
			
			}
		}
	});
});